/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation;

import de.proveo.idm.core.gui.navigation.TopLevelNavigationChildren;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.Server;
import de.proveo.idm.core.gui.navigation.api.ServerNavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationItemNode;
import de.proveo.idm.core.gui.navigation.filter.TextFilter;
import de.proveo.idm.core.gui.navigation.nodes.NavigationFilterNode;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="NavigationTopComponent", persistenceType=0)
public final class NavigationTopComponent
extends TopComponent
implements ExplorerManager.Provider,
DocumentListener {
    private static NavigationTopComponent instance;
    protected static final String PREFERRED_ID = "NavigationTopComponent";
    private final List<NavigationItem> expandedNodes = new ArrayList<NavigationItem>();
    private final List<NavigationItem> expandedNodesBeforeFilter = new ArrayList<NavigationItem>();
    private final ExplorerManager em = new ExplorerManager();
    private Lookup lookup;
    private TreeView view;
    private Node[] selectedNodes;
    private JPanel controlPanel;
    private JLabel filterLbl;
    private JTextField filterTF;
    private JButton jButton1;
    private JCheckBox jMatchCase;
    private JPanel jSearchPanel;
    private JToggleButton jSettingsBtn;
    private JScrollPane navigationPane;

    public NavigationTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(NavigationTopComponent.class, (String)"CTL_NavigationTopComponent"));
        this.setToolTipText(NbBundle.getMessage(NavigationTopComponent.class, (String)"HINT_NavigationTopComponent"));
        ActionMap aMap = this.getActionMap();
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.em, (ActionMap)aMap);
        this.associateLookup(this.lookup);
        this.em.setRootContext((Node)new NavigationRootNode());
        ((BeanTreeView)this.navigationPane).setRootVisible(false);
        ((BeanTreeView)this.navigationPane).setDragSource(true);
        ((BeanTreeView)this.navigationPane).setDropTarget(true);
        ((BeanTreeView)this.navigationPane).setSelectionMode(1);
        ((BeanTreeView)this.navigationPane).setAllowedDragActions(2);
        ((BeanTreeView)this.navigationPane).setAllowedDropActions(2);
        this.view = (TreeView)this.navigationPane;
        this.jMatchCase.setVisible(false);
        this.view.setQuickSearchAllowed(false);
    }

    private void initComponents() {
        this.navigationPane = new BeanTreeView();
        this.controlPanel = new JPanel();
        this.jSearchPanel = new JPanel();
        this.filterLbl = new JLabel();
        this.filterTF = new JTextField();
        this.jButton1 = new JButton();
        this.jSettingsBtn = new JToggleButton();
        this.jMatchCase = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.add(this.navigationPane, "Center");
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 1));
        Mnemonics.setLocalizedText((JLabel)this.filterLbl, (String)NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.filterLbl.text"));
        this.filterTF.setText(NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.filterTF.text"));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/delFilter.png")));
        this.jButton1.setToolTipText(NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.filter.clear.tooltip"));
        this.jButton1.setMaximumSize(new Dimension(20, 20));
        this.jButton1.setMinimumSize(new Dimension(16, 16));
        this.jButton1.setPreferredSize(new Dimension(20, 20));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigationTopComponent.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSettingsBtn.setIcon(new ImageIcon(this.getClass().getResource("/de/proveo/idm/core/filter.png")));
        this.jSettingsBtn.setToolTipText(NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.filter.settings.tooltip"));
        this.jSettingsBtn.setMaximumSize(new Dimension(20, 20));
        this.jSettingsBtn.setMinimumSize(new Dimension(16, 16));
        this.jSettingsBtn.setPreferredSize(new Dimension(20, 20));
        this.jSettingsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavigationTopComponent.this.jSettingsBtnActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jMatchCase, (String)NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.jMatchCase.text"));
        this.jMatchCase.setMargin(new Insets(2, 0, 2, 2));
        this.jMatchCase.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                NavigationTopComponent.this.jMatchCaseItemStateChanged(evt);
            }
        });
        GroupLayout jSearchPanelLayout = new GroupLayout(this.jSearchPanel);
        this.jSearchPanel.setLayout(jSearchPanelLayout);
        jSearchPanelLayout.setHorizontalGroup(jSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jSearchPanelLayout.createSequentialGroup().addComponent(this.filterLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterTF, -1, 301, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSettingsBtn, -2, -1, -2)).addGroup(jSearchPanelLayout.createSequentialGroup().addComponent(this.jMatchCase).addContainerGap()));
        jSearchPanelLayout.setVerticalGroup(jSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jSearchPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jMatchCase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jSearchPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.filterLbl).addComponent(this.filterTF, -2, -1, -2).addComponent(this.jButton1, -2, -1, -2).addComponent(this.jSettingsBtn, -2, -1, -2))));
        this.controlPanel.add(this.jSearchPanel);
        this.add(this.controlPanel, "South");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.filterTF.setText("");
    }

    private void jSettingsBtnActionPerformed(ActionEvent evt) {
        this.jMatchCase.setVisible(this.jSettingsBtn.isSelected());
    }

    private void jMatchCaseItemStateChanged(ItemEvent evt) {
        this.handleFilterInput();
    }

    public static synchronized NavigationTopComponent getDefault() {
        if (instance == null) {
            instance = new NavigationTopComponent();
        }
        return instance;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx ret = super.getHelpCtx();
        Node[] nodes = this.em.getSelectedNodes();
        if (nodes.length == 1 && (ret = nodes[0].getHelpCtx()) == null) {
            ret = super.getHelpCtx();
        }
        return ret;
    }

    public static synchronized NavigationTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(NavigationTopComponent.class.getName()).warning("Cannot find NavigationTopComponent component. It will not be located properly in the window system.");
            return NavigationTopComponent.getDefault();
        }
        if (win instanceof NavigationTopComponent) {
            return (NavigationTopComponent)win;
        }
        Logger.getLogger(NavigationTopComponent.class.getName()).warning("There seem to be multiple components with the 'NavigationTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return NavigationTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this.filterTF.getDocument().addDocumentListener(this);
    }

    public void componentClosed() {
        this.filterTF.getDocument().removeDocumentListener(this);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        if (instance == null) {
            instance = this;
        }
        instance.readPropertiesImpl(p);
        return instance;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleFilterInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleFilterInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleFilterInput();
    }

    private synchronized void handleFilterInput() {
        String pattern = this.filterTF.getText();
        Node root = this.em.getRootContext();
        if (!pattern.trim().isEmpty()) {
            ((BeanTreeView)this.navigationPane).setRootVisible(true);
            TextFilter filter = new TextFilter(pattern, this.jMatchCase.isSelected());
            if (root instanceof NavigationFilterNode) {
                Node original = ((NavigationFilterNode)root).getOriginal();
                NavigationFilterNode newNode = new NavigationFilterNode(original, filter);
                if (original.isLeaf()) {
                    newNode = new NavigationFilterNode(original);
                }
                this.em.setRootContext((Node)newNode);
            } else {
                this.findExpandedNodes(root, this.expandedNodesBeforeFilter);
                NavigationFilterNode filtered = new NavigationFilterNode(root, filter);
                if (root.isLeaf()) {
                    filtered = new NavigationFilterNode(root);
                }
                this.em.setRootContext((Node)filtered);
            }
            this.view.expandAll();
        } else {
            ((BeanTreeView)this.navigationPane).setRootVisible(false);
            root = this.em.getRootContext();
            if (root instanceof NavigationFilterNode) {
                Node original = ((NavigationFilterNode)root).getOriginal();
                this.em.setRootContext(original);
                this.expandOriginalNodes(original, this.expandedNodesBeforeFilter);
            }
        }
    }

    public <T extends NavigationItem> Collection<T> findNavigationItemsByType(Class<? extends T> type) {
        return this._findNavigationItemsByType(this.em.getRootContext(), type);
    }

    public ServerNavigationItem findServerNavigationItemByServer(Server server) {
        Collection<ServerNavigationItem> serverItems = this.findNavigationItemsByType(ServerNavigationItem.class);
        for (ServerNavigationItem serverItem : serverItems) {
            if (!serverItem.getServerInstance().equals(server)) continue;
            return serverItem;
        }
        return null;
    }

    private <T extends NavigationItem> Collection<T> _findNavigationItemsByType(Node node, Class<? extends T> type) {
        NavigationItemNode navNode;
        NavigationItem nodeNavItem;
        ArrayList<NavigationItem> ret = new ArrayList<NavigationItem>();
        Node originalNode = node;
        if (node instanceof NavigationFilterNode) {
            originalNode = ((NavigationFilterNode)node).getOriginal();
        }
        if (originalNode instanceof NavigationItemNode && (nodeNavItem = (navNode = (NavigationItemNode)originalNode).getNavigationItem()) != null && type.isInstance(nodeNavItem)) {
            ret.add(nodeNavItem);
            return ret;
        }
        if (!originalNode.isLeaf()) {
            for (Node child : node.getChildren().getNodes()) {
                Collection<T> itemNodeList = this._findNavigationItemsByType(child, type);
                if (itemNodeList == null || itemNodeList.isEmpty()) continue;
                ret.addAll(itemNodeList);
            }
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        return null;
    }

    public Node findNodeByNavigationItem(NavigationItem item) {
        return this._findNodeByNavigationItem(this.em.getRootContext(), item);
    }

    private Node _findNodeByNavigationItem(Node node, NavigationItem item) {
        NavigationItemNode navNode;
        NavigationItem nodeNavItem;
        Node originalNode = node;
        if (node instanceof NavigationFilterNode) {
            originalNode = ((NavigationFilterNode)node).getOriginal();
        }
        if (originalNode instanceof NavigationItemNode && (nodeNavItem = (navNode = (NavigationItemNode)originalNode).getNavigationItem()) != null && nodeNavItem.equals(item)) {
            return node;
        }
        if (!node.isLeaf()) {
            for (Node child : node.getChildren().getNodes()) {
                Node itemNode = this._findNodeByNavigationItem(child, item);
                if (itemNode == null) continue;
                return itemNode;
            }
        }
        return null;
    }

    public void findExpandedNodes(Node root) {
        this.findExpandedNodes(root, this.expandedNodes);
    }

    private void findExpandedNodes(Node root, List<NavigationItem> expandedNodes) {
        this.selectedNodes = this.em.getSelectedNodes();
        expandedNodes.clear();
        this._findExpandedNodes(root, expandedNodes);
    }

    private void _findExpandedNodes(Node root, List<NavigationItem> expandedNodes) {
        Node originalNode = root;
        if (root != null && root instanceof NavigationFilterNode) {
            originalNode = ((NavigationFilterNode)root).getOriginal();
        }
        if (root != null && !root.isLeaf() && this.view.isExpanded(root) && originalNode instanceof NavigationItemNode) {
            expandedNodes.add(((NavigationItemNode)originalNode).getNavigationItem());
            for (Node child : root.getChildren().getNodes()) {
                if (!this.view.isExpanded(child)) continue;
                this._findExpandedNodes(child, expandedNodes);
            }
        }
    }

    public void expandOriginalNodes(Node root) {
        this.expandOriginalNodes(root, this.expandedNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandOriginalNodes(Node root, List<NavigationItem> expandedNodes) {
        this._expandOriginalNodes(root, expandedNodes);
        expandedNodes.clear();
        if (this.selectedNodes != null && this.selectedNodes.length > 0) {
            try {
                this.em.setSelectedNodes(this.selectedNodes);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.selectedNodes = null;
            }
        }
    }

    private void _expandOriginalNodes(Node root, List<NavigationItem> expandedNodes) {
        Node originalNode = root;
        if (root != null && root instanceof NavigationFilterNode) {
            originalNode = ((NavigationFilterNode)root).getOriginal();
        }
        if (root != null && !root.isLeaf()) {
            if (originalNode instanceof NavigationItemNode && expandedNodes.contains(((NavigationItemNode)originalNode).getNavigationItem())) {
                this.view.expandNode(root);
            }
            for (Node child : root.getChildren().getNodes()) {
                this._expandOriginalNodes(child, expandedNodes);
            }
        }
    }

    public boolean isNodeExpanded(Node node) throws Exception {
        return this.view.isExpanded(node);
    }

    public void expandNode(Node node) throws Exception {
        this.view.expandNode(node);
    }

    private class NavigationRootNode
    extends AbstractNode {
        public NavigationRootNode() {
            super((Children)new TopLevelNavigationChildren());
        }

        public String getDisplayName() {
            return NbBundle.getMessage(NavigationTopComponent.class, (String)"NavigationTopComponent.rootNode.name");
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"de/proveo/idm/core/filter.png");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }
    }
}

