/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.navigation;

import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationItemNode;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationNodeFactory;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationNodeFactoryManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.openide.nodes.Node;

public class NavigationNodeFactoryManagerImpl
implements NavigationNodeFactoryManager {
    private final Map<Class, NavigationNodeFactory> factories = new HashMap<Class, NavigationNodeFactory>();

    @Override
    public Node createNode(NavigationItem item) {
        if (item == null) {
            return null;
        }
        Class type = item.getClass();
        if (this.factories.containsKey(type)) {
            NavigationNodeFactory factory = this.factories.get(type);
            return factory.createNode(item);
        }
        Class[] superTypes = this.getSuperClasses(type);
        if ((type = this.containedSupertype(superTypes)) != null) {
            NavigationNodeFactory factory = this.factories.get(type);
            return factory.createNode(item);
        }
        return new NavigationItemNode(item);
    }

    private Class containedSupertype(Class[] superTypes) {
        for (Class clazz : superTypes) {
            if (this.factories.containsKey(clazz)) {
                return clazz;
            }
            Class[] superSuperTypes = this.getSuperClasses(clazz);
            Class superClass = this.containedSupertype(superSuperTypes);
            if (superClass == null) continue;
            return superClass;
        }
        return null;
    }

    private Class[] getSuperClasses(Class clazz) {
        Object[] superClasses = clazz.getInterfaces();
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            superClasses = (Class[])ArrayUtils.add((Object[])superClasses, superClass);
        }
        return superClasses;
    }

    @Override
    public synchronized void register(Class type, NavigationNodeFactory factory) {
        this.factories.put(type, factory);
    }

    @Override
    public synchronized void deregister(Class type) {
        this.factories.remove(type);
    }
}

