/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui.menubars.actions;

import de.proveo.idm.core.gui.util.DialogUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.openide.util.NbBundle;

public final class HelpEnvironmentAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        String content = this.getContentString();
        DialogUtil.showInfoDialog(content, NbBundle.getMessage(HelpEnvironmentAction.class, (String)"CTL_HelpEnvironmentAction"));
    }

    private String getContentString() {
        StringBuilder sb = new StringBuilder();
        Properties pr = System.getProperties();
        ArrayList<String> usedKeys = new ArrayList<String>();
        for (Object object : pr.keySet()) {
            if (!((String)object).startsWith("os.") && !((String)object).startsWith("java.vm") && !((String)object).equals("java.runtime.version")) continue;
            usedKeys.add((String)object);
        }
        Collections.sort(usedKeys);
        sb.append("<html>");
        for (String string : usedKeys) {
            if (string.equals("java.runtime.version")) {
                sb.append("<b>");
                sb.append(string);
                sb.append(":</b> ");
                boolean red = this.checkVersion();
                if (red) {
                    sb.append("<font color=\"red\">");
                    sb.append(pr.getProperty(string));
                } else {
                    sb.append(pr.getProperty(string));
                }
                sb.append("<br>");
                if (!red) continue;
                sb.append("(");
                sb.append(NbBundle.getMessage(HelpEnvironmentAction.class, (String)"HelpEnvironmentAction.versionInfo"));
                sb.append(")");
                sb.append("</font>");
                sb.append("<br>");
                continue;
            }
            sb.append("<b>");
            sb.append(string);
            sb.append(":</b> ");
            sb.append(pr.getProperty(string));
            sb.append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    private boolean checkVersion() {
        try {
            String[] parts;
            String check = System.getProperty("java.runtime.version");
            if (check != null && !check.isEmpty() && (parts = check.split("\\.")).length > 1) {
                int versionLevel1 = Integer.parseInt(parts[0]);
                if (versionLevel1 < 1) {
                    return true;
                }
                if (versionLevel1 == 1) {
                    String updateString;
                    int update;
                    String[] buffer;
                    int versionLevel3;
                    int versionLevel2 = Integer.parseInt(parts[1]);
                    if (versionLevel2 < 6) {
                        return true;
                    }
                    if (versionLevel2 == 6 && (versionLevel3 = Integer.parseInt((buffer = parts[2].split("_"))[0])) == 0 && (update = Integer.parseInt(updateString = buffer[1].split("-")[0])) < 14) {
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

