/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import de.proveo.idm.core.gui.util.NotificationMessage;
import de.proveo.idm.core.gui.util.Validatable;
import de.proveo.idm.core.gui.util.ValidationListener;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class LoginPanel
extends JPanel
implements Validatable {
    private static final CellConstraints cc = new CellConstraints();
    private final FormLayout layout = new FormLayout("3dlu, 45dlu, 3dlu, min:grow, 3dlu", "pref, pref, pref, pref, 3dlu, pref");
    private final FormLayout imgPlaceholderPanelLayout = new FormLayout("pref, fill:default:grow, pref", "pref, 5dlu");
    private final FormLayout messagePlaceholderPanelLayout = new FormLayout("fill:default:grow", "pref, 5dlu");
    private final FormLayout usernamePlaceholderPanelLayout = new FormLayout("45dlu, 3dlu, min:grow", "pref, 3dlu");
    protected final List<ValidationListener> listeners = new ArrayList<ValidationListener>();
    private final JLabel imgLeftLbl = new JLabel();
    private final JLabel imgRightLbl = new JLabel();
    private final JLabel messageLbl = new JLabel();
    private final JLabel usernameLbl = new JLabel(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.usernameLbl.text"));
    private final JTextField usernameTxtFld = new JTextField();
    private final JLabel passwordLbl = new JLabel(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.passwordLbl.text"));
    private final JPasswordField passwordFld = new JPasswordField();
    private final JCheckBox storePasswordChkBox = new JCheckBox(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.storePasswordChkBox.text"));
    private JPanel imgPlacehodlerPanel = null;
    private JPanel messagePlacehodlerPanel = null;
    private JPanel usernamePlacehodlerPanel = null;

    public LoginPanel() {
        this.setLayout((LayoutManager)this.layout);
        this.initComponents();
        ValidationChangedNotifier vcn = new ValidationChangedNotifier();
        this.usernameTxtFld.getDocument().addDocumentListener(vcn);
        this.passwordFld.getDocument().addDocumentListener(vcn);
        if (this.isGetLockingKeyStateSupported()) {
            CapsLockChecker clc = new CapsLockChecker();
            this.addKeyListener(clc);
            this.usernameTxtFld.addKeyListener(clc);
            this.passwordFld.addKeyListener(clc);
        }
    }

    private void initComponents() {
        this.imgLeftLbl.setOpaque(false);
        this.imgRightLbl.setOpaque(false);
        this.messageLbl.setOpaque(false);
        this.usernameLbl.setOpaque(false);
        this.passwordLbl.setOpaque(false);
        this.storePasswordChkBox.setOpaque(false);
        this.storePasswordChkBox.setSelected(NbPreferences.forModule(LoginPanel.class).getBoolean("login.storePasswords", false));
        this.add((Component)this.passwordLbl, cc.xy(2, 4, CellConstraints.RIGHT, CellConstraints.CENTER));
        this.add((Component)this.passwordFld, cc.xy(4, 4));
        this.add((Component)this.storePasswordChkBox, cc.xyw(2, 6, 3, CellConstraints.RIGHT, CellConstraints.CENTER));
    }

    private String convertToMultilineText(String text) {
        if (text.contains("\n")) {
            return "<html>" + StringUtils.replace((String)text, (String)"\n", (String)"<br>") + "</html>";
        }
        return text;
    }

    private String ensureMessageLength(String text) {
        return WordUtils.wrap((String)text, (int)60);
    }

    public String getUsername() {
        return this.usernameTxtFld.getText();
    }

    public char[] getPassword() {
        return this.passwordFld.getPassword();
    }

    public boolean isStorePassword() {
        return this.storePasswordChkBox.isSelected();
    }

    public void setImage(Icon leftImage, Icon rightImage) {
        if (leftImage == null && rightImage == null) {
            this.layout.setRowSpec(1, RowSpec.decode((String)"0dlu"));
            if (this.imgPlacehodlerPanel != null) {
                this.remove(this.imgPlacehodlerPanel);
                this.imgPlacehodlerPanel = null;
            }
        } else {
            this.imgLeftLbl.setIcon(leftImage);
            this.imgRightLbl.setIcon(rightImage);
            if (this.imgPlacehodlerPanel == null) {
                this.imgPlacehodlerPanel = this.createImgPlaceholderPanel();
                this.add((Component)this.imgPlacehodlerPanel, cc.xyw(1, 1, 5));
            }
            this.layout.setRowSpec(1, RowSpec.decode((String)"pref"));
        }
        this.repaint();
        this.revalidate();
    }

    public void setMessage(String text) {
        if (text == null) {
            text = "";
        }
        if (text.trim().length() == 0) {
            this.layout.setRowSpec(2, RowSpec.decode((String)"0dlu"));
            if (this.messagePlacehodlerPanel != null) {
                this.remove(this.messagePlacehodlerPanel);
                this.messagePlacehodlerPanel = null;
            }
        } else {
            this.messageLbl.setText(this.convertToMultilineText(this.ensureMessageLength(text)));
            if (this.messagePlacehodlerPanel == null) {
                this.messagePlacehodlerPanel = this.createMessagePlaceholderPanel();
                this.add((Component)this.messagePlacehodlerPanel, cc.xyw(2, 2, 3));
            }
            this.layout.setRowSpec(2, RowSpec.decode((String)"pref"));
        }
        this.repaint();
        this.revalidate();
    }

    public void setPassword(char[] password) {
        if (password == null) {
            password = new char[]{};
        }
        this.passwordFld.setText(new String(password));
    }

    public void setUsername(String username) {
        this.usernameTxtFld.setText(username);
    }

    public void setUsernameFieldEnabled(boolean enabled) {
        if (enabled) {
            this.layout.setRowSpec(3, RowSpec.decode((String)"pref"));
            if (this.usernamePlacehodlerPanel == null) {
                this.usernamePlacehodlerPanel = this.createUsernamePlaceholderPanel();
                this.add((Component)this.usernamePlacehodlerPanel, cc.xyw(2, 3, 3));
            }
        } else {
            if (this.usernamePlacehodlerPanel != null) {
                this.remove(this.usernamePlacehodlerPanel);
                this.usernamePlacehodlerPanel = null;
            }
            this.layout.setRowSpec(3, RowSpec.decode((String)"0dlu"));
        }
        this.repaint();
        this.revalidate();
    }

    @Override
    public boolean checkValidation() {
        String username = this.getUsername().trim();
        char[] password = this.getPassword();
        if (this.usernamePlacehodlerPanel != null && username.length() == 0) {
            return false;
        }
        return password != null && password.length != 0;
    }

    @Override
    public NotificationMessage getNotificationMessage() {
        String username = this.getUsername().trim();
        char[] password = this.getPassword();
        if (this.usernamePlacehodlerPanel != null && username.length() == 0) {
            return new NotificationMessage(0, NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.validationMsg.usernameMissing"));
        }
        if (password == null || password.length == 0) {
            return new NotificationMessage(0, NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.validationMsg.passwordMissing"));
        }
        if (this.isGetLockingKeyStateSupported() && this.isCapsLockActivated()) {
            return new NotificationMessage(2, NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.capsLockWarningLbl.text"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValidationListener(ValidationListener l) {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireNotificationChanged() {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            for (ValidationListener l : this.listeners) {
                l.notificationChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireValidationChanged() {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            for (ValidationListener l : this.listeners) {
                l.validationChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValidationListener(ValidationListener l) {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private JPanel createImgPlaceholderPanel() {
        JPanel ret = new JPanel((LayoutManager)this.imgPlaceholderPanelLayout);
        ret.setOpaque(false);
        ret.add((Component)this.imgLeftLbl, cc.xy(1, 1, CellConstraints.LEFT, CellConstraints.CENTER));
        ret.add((Component)this.imgRightLbl, cc.xy(3, 1, CellConstraints.RIGHT, CellConstraints.CENTER));
        return ret;
    }

    private JPanel createMessagePlaceholderPanel() {
        JPanel ret = new JPanel((LayoutManager)this.messagePlaceholderPanelLayout);
        ret.setOpaque(false);
        ret.add((Component)this.messageLbl, cc.xy(1, 1, CellConstraints.LEFT, CellConstraints.CENTER));
        return ret;
    }

    private JPanel createUsernamePlaceholderPanel() {
        JPanel ret = new JPanel((LayoutManager)this.usernamePlaceholderPanelLayout);
        ret.setOpaque(false);
        ret.add((Component)this.usernameLbl, cc.xy(1, 1, CellConstraints.RIGHT, CellConstraints.CENTER));
        ret.add((Component)this.usernameTxtFld, cc.xy(3, 1));
        return ret;
    }

    private boolean isCapsLockActivated() {
        try {
            return Toolkit.getDefaultToolkit().getLockingKeyState(20);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isGetLockingKeyStateSupported() {
        try {
            Toolkit.getDefaultToolkit().getLockingKeyState(20);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private class ValidationChangedNotifier
    implements DocumentListener {
        private ValidationChangedNotifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            LoginPanel.this.fireValidationChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LoginPanel.this.fireValidationChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LoginPanel.this.fireValidationChanged();
        }
    }

    private class CapsLockChecker
    extends KeyAdapter {
        private CapsLockChecker() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 20) {
                LoginPanel.this.fireValidationChanged();
            }
        }
    }
}

