/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.core;

import de.proveo.idm.core.RootFrame;
import de.proveo.idm.core.gui.navigation.api.AppearancePreferencesProvider;
import de.proveo.idm.core.gui.navigation.api.impl.LocalNavigationManager;
import de.proveo.idm.core.gui.util.DialogUtil;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.openide.modules.ModuleInstall;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class Installer
extends ModuleInstall {
    private static final Logger log = Logger.getLogger(Installer.class.getName());

    public void restored() {
        Preferences prefs = NbPreferences.forModule(AppearancePreferencesProvider.class);
        String langCode = prefs.get("AppearancePreferencesProvider.language", "US-en");
        if (langCode != null && langCode.trim().length() != 0) {
            log.log(Level.INFO, "Default language ({0}) will be switched to: {1}", new Object[]{Locale.getDefault().getDisplayName(), langCode});
            String country = null;
            String language = langCode;
            if (langCode.contains("-")) {
                String[] values = StringUtils.split((String)langCode, (char)'-');
                if (values.length == 2) {
                    country = values[0];
                    language = values[1];
                } else {
                    language = null;
                    log.log(Level.WARNING, "Could not parse given language code: {0}", langCode);
                }
            } else if (langCode.length() != 2) {
                language = null;
                log.log(Level.WARNING, "Could not parse given language code: {0}", langCode);
            }
            if (language != null) {
                Locale locale = country != null ? new Locale(language, country) : new Locale(language);
                Locale.setDefault(locale);
            }
        }
        UIManager.put("NbMainWindow.showCustomBackground", Boolean.TRUE);
        RootFrame.init();
        LocalNavigationManager manager = (LocalNavigationManager)Lookup.getDefault().lookup(LocalNavigationManager.class);
        manager.init();
        this.check();
    }

    private void check() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (Installer.this.checkVersion()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("<html>");
                        sb.append(NbBundle.getMessage(Installer.class, (String)"Installer.validate.info1"));
                        sb.append(" ");
                        sb.append("<b>");
                        sb.append(NbBundle.getMessage(Installer.class, (String)"Installer.validate.info2"));
                        sb.append("</b><br>");
                        sb.append(NbBundle.getMessage(Installer.class, (String)"Installer.validate.info3"));
                        sb.append(" <font color=\"red\">");
                        sb.append(System.getProperty("java.runtime.version"));
                        sb.append("</font>");
                        DialogUtil.showInfoDialog(sb.toString(), "Java version");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread thread = new Thread(run);
        thread.start();
    }

    private boolean checkVersion() {
        try {
            String[] parts;
            String check = System.getProperty("java.runtime.version");
            if (check != null && !check.isEmpty() && (parts = check.split("\\.")).length > 1) {
                int versionLevel1 = Integer.parseInt(parts[0]);
                if (versionLevel1 < 1) {
                    return true;
                }
                if (versionLevel1 == 1) {
                    String updateString;
                    int update;
                    String[] buffer;
                    int versionLevel3;
                    int versionLevel2 = Integer.parseInt(parts[1]);
                    if (versionLevel2 < 6) {
                        return true;
                    }
                    if (versionLevel2 == 6 && (versionLevel3 = Integer.parseInt((buffer = parts[2].split("_"))[0])) == 0 && (update = Integer.parseInt(updateString = buffer[1].split("-")[0])) < 14) {
                        return true;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

