/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.eventbase.codec;

import de.proveo.eventbase.EventPayload;
import de.proveo.eventbase.EventResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class ResponseCodec
extends EventResponse {
    private static final Log log = LogFactory.getLog(ResponseCodec.class);
    private static final int EVENT_RESPONSE_INDEX = 0;
    private static final int VPN_INDEX = 1;
    private static final int USER_ACL_CHANGED_INDEX = 2;
    private static final int GEO_AREAS_CHANGED_INDEX = 3;
    private static final int SOFTWARE_UPDATE_AVAILABLE_INDEX = 4;
    private static final int CONFIGURATION_UPDATE_AVAILABLE_INDEX = 5;
    private static final int RESET_INDEX = 6;
    protected static final String PAYLOAD_HEADER_NAME = "name";
    protected static final String PAYLOAD_HEADER_LENGTH = "length";
    protected static final String PAYLOAD_HEADER_COMPRESSION = "compress";
    protected static final String PAYLOAD_HEADER_COMREPSSION_TYPE = "gzip";
    protected static final String HEADER_PREFIX = "\nHEADER\n";

    ResponseCodec() {
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().getName().equals(ResponseCodec.class.getName())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ResponseCodec that = (ResponseCodec)obj;
        EqualsBuilder eqBuilder = new EqualsBuilder();
        eqBuilder.append(this.flags, that.flags);
        eqBuilder.append((Object)this.payloads, (Object)that.payloads);
        return eqBuilder.isEquals();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("eventResponse", this.isEventResponse());
        toStringBuilder.append("vpn", this.isVPN());
        toStringBuilder.append("userACLchanged", this.isUserACLChanged());
        toStringBuilder.append("geoAreasChanged", this.isGeoAreasChanged());
        toStringBuilder.append("softwareUpdateAvailable", this.isSoftwareUpdateAvailable());
        toStringBuilder.append("configurationUpdateAvailable", this.isConfigurationUpdateAvailable());
        toStringBuilder.append("reset", this.isReset());
        toStringBuilder.append("payloads", (Object)this.getPayloads());
        return toStringBuilder.toString();
    }

    protected void decode(byte[] response) {
        block9: for (int i = 0; i < this.flags.length; ++i) {
            boolean value = (response[0] & 1 << i) == 1 << i;
            switch (i) {
                case 0: {
                    this.setEventResponse(value);
                    continue block9;
                }
                case 1: {
                    this.setVPN(value);
                    continue block9;
                }
                case 2: {
                    this.setUserACLChanged(value);
                    continue block9;
                }
                case 3: {
                    this.setGeoAreasChanged(value);
                    continue block9;
                }
                case 4: {
                    this.setSoftwareUpdateAvailable(value);
                    continue block9;
                }
                case 5: {
                    this.setConfigurationUpdateAvailable(value);
                    continue block9;
                }
                case 6: {
                    this.setReset(value);
                }
            }
        }
        this.payloads.clear();
        if (response.length > 1) {
            this.parsePayloads(response);
        }
    }

    protected byte[] encode() {
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        int flags = 0;
        for (int i = 0; i < this.flags.length; ++i) {
            flags = this.flags[i] ? (int)((byte)(flags | (byte)(1 << i))) : (int)((byte)(flags | (byte)(0 << i)));
        }
        response.write(flags);
        if (!this.isPayloadEmpty()) {
            for (EventPayload payload : this.getPayloads()) {
                try {
                    this.encodePayload(response, payload);
                }
                catch (IOException ex) {
                    log.error((Object)"runs during encode payload into", (Throwable)ex);
                }
            }
        }
        return response.toByteArray();
    }

    protected void encodePayload(ByteArrayOutputStream response, EventPayload payload) throws IOException {
        Properties payloadHeader = new Properties();
        payloadHeader.setProperty(PAYLOAD_HEADER_NAME, payload.getName());
        byte[] transmissionPayload = this.transparentPayloadCompression(payloadHeader, payload.getPayload());
        payloadHeader.setProperty(PAYLOAD_HEADER_LENGTH, Integer.toString(transmissionPayload.length));
        response.write(this.getHeaderString(payloadHeader).getBytes());
        response.write(transmissionPayload);
    }

    protected String getHeaderString(Properties payloadHeader) {
        StringBuilder header = new StringBuilder(HEADER_PREFIX);
        header.append(PAYLOAD_HEADER_NAME);
        header.append("=");
        header.append(payloadHeader.getProperty(PAYLOAD_HEADER_NAME));
        header.append(" ");
        for (Map.Entry<Object, Object> entry : payloadHeader.entrySet()) {
            if (entry.getKey().equals(PAYLOAD_HEADER_NAME)) continue;
            header.append(entry.getKey());
            header.append("=");
            header.append(entry.getValue());
            header.append(" ");
        }
        header.append("\n");
        return header.toString();
    }

    protected int indexOf(byte[] response, int index, byte b) {
        while (index < response.length) {
            if (response[index] == b) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected boolean isHeaderStart(byte[] response, int index) {
        byte[] pattern = HEADER_PREFIX.getBytes();
        try {
            for (int patternIndex = 0; patternIndex < pattern.length; ++patternIndex) {
                if (pattern[patternIndex] == response[index + patternIndex]) continue;
                return false;
            }
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }

    protected int parsePayload(byte[] response, int index) {
        int headerEnd = this.indexOf(response, index += HEADER_PREFIX.getBytes().length, (byte)10);
        StringTokenizer tokenizer = new StringTokenizer(new String(response, index, headerEnd - index));
        Properties header = new Properties();
        while (tokenizer.hasMoreTokens()) {
            String keyValue = tokenizer.nextToken();
            int delim = keyValue.indexOf(61);
            String key = keyValue.substring(0, delim);
            String value = keyValue.substring(delim + 1);
            header.setProperty(key, value);
        }
        EventPayload eventPayload = new EventPayload();
        eventPayload.setName(header.getProperty(PAYLOAD_HEADER_NAME));
        int size = Integer.parseInt(header.getProperty(PAYLOAD_HEADER_LENGTH));
        byte[] payload = new byte[size];
        System.arraycopy(response, headerEnd + 1, payload, 0, size);
        if (header.containsKey(PAYLOAD_HEADER_COMPRESSION) && header.getProperty(PAYLOAD_HEADER_COMPRESSION).equals(PAYLOAD_HEADER_COMREPSSION_TYPE)) {
            try {
                ByteArrayOutputStream uncompressedPayload = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                GZIPInputStream compressedPayload = new GZIPInputStream(new ByteArrayInputStream(payload));
                int readed = 0;
                while (readed > -1) {
                    readed = compressedPayload.read(buffer);
                    if (readed <= 0) continue;
                    uncompressedPayload.write(buffer, 0, readed);
                }
                payload = uncompressedPayload.toByteArray();
            }
            catch (IOException ex) {
                log.error((Object)"runs during decompress payload into", (Throwable)ex);
                payload = null;
            }
        }
        if (payload != null) {
            eventPayload.setPayload(payload);
            this.payloads.put(eventPayload.getName(), eventPayload);
        }
        return headerEnd + size;
    }

    protected void parsePayloads(byte[] response) {
        for (int index = 0; index < response.length && (index = this.indexOf(response, index, (byte)10)) > -1; ++index) {
            if (!this.isHeaderStart(response, index)) continue;
            index = this.parsePayload(response, index);
        }
    }

    protected byte[] payloadCompression(byte[] payload) throws IOException {
        return payload;
    }

    protected byte[] transparentPayloadCompression(Properties payloadHeader, byte[] payload) {
        try {
            byte[] compressedPayload = this.payloadCompression(payload);
            if (compressedPayload.length < payload.length) {
                payloadHeader.setProperty(PAYLOAD_HEADER_COMPRESSION, PAYLOAD_HEADER_COMREPSSION_TYPE);
                return compressedPayload;
            }
            return payload;
        }
        catch (IOException ex) {
            log.error((Object)"runs during payload compression into", (Throwable)ex);
            return payload;
        }
    }
}

