/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.security;

import de.proveo.util.ByteUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LoginUtil {
    private static final Log log = LogFactory.getLog(LoginUtil.class);
    public static final String DEF_MESSAGE_DIGEST_INSTANCE = "SHA-1";
    public static final String DEF_PASSWORD_REGEXP = "^(?=.*\\d)(?=.*[a-zA-Z])(?!.*[^a-zA-Z0-9]).{6,}$";
    private static final String MESSAGE_DIGEST_KEY = "password.messageDigest";
    private static final String PASSWORD_REGEXP_KEY = "password.regexp";

    private LoginUtil() {
    }

    public static String createMessageDigest(char[] password) {
        ConfigurationClient configuration = new ConfigurationClient();
        String messageDigest = DEF_MESSAGE_DIGEST_INSTANCE;
        try {
            messageDigest = configuration.getParameter(MESSAGE_DIGEST_KEY);
        }
        catch (Exception e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return LoginUtil.createMessageDigest(password, messageDigest);
    }

    public static String createMessageDigest(char[] password, String messageDigest) {
        int i;
        if (log.isTraceEnabled()) {
            log.trace((Object)"createMessageDigest()");
        }
        String passwordHash = null;
        CharArrayReader reader = new CharArrayReader(password);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int ch;
            while ((ch = reader.read()) != -1) {
                baos.write(ch);
            }
            reader.close();
        }
        catch (IOException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        byte[] passwordBytes = baos.toByteArray();
        try {
            MessageDigest md = MessageDigest.getInstance(messageDigest);
            byte[] output = md.digest(passwordBytes);
            passwordHash = ByteUtil.toHexString(output);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new IllegalStateException("No " + messageDigest + " implementation found!");
        }
        for (i = 0; i < password.length; ++i) {
            password[i] = '\u0000';
        }
        for (i = 0; i < passwordBytes.length; ++i) {
            passwordBytes[i] = 0;
        }
        password = null;
        passwordBytes = null;
        return passwordHash;
    }

    public static boolean isValidPassword(String password) {
        boolean valid = false;
        ConfigurationClient configuration = new ConfigurationClient();
        String regexp = DEF_PASSWORD_REGEXP;
        try {
            regexp = configuration.getParameter(PASSWORD_REGEXP_KEY);
        }
        catch (Exception e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        valid = Pattern.matches(regexp, password);
        return valid;
    }
}

