/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.summarizedData.dto.statusDuration;

import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitStateDTOBase;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.StatusDurationDTO;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusDurationsDTO
extends UnitStateDTOBase {
    private static final long serialVersionUID = -6586948090821550443L;
    private long stateModelId;
    private HashMap<Long, Long> stateDurations = new HashMap();
    private HashMap<Long, Double> statePercentages;

    public StatusDurationsDTO(UnitModelValue unitModelValue, UnitIdentityValue unitIdentityValue, UnitTypeIdentityValue unitTypeIdentityValue, long stateModelId, long beginTime) {
        super(unitModelValue, unitIdentityValue, unitTypeIdentityValue);
        this.stateModelId = stateModelId;
        this.beginTime = beginTime;
    }

    public StatusDurationsDTO(UnitDTO unitDTO, long stateModelId, long beginTime) {
        super(unitDTO);
        this.stateModelId = stateModelId;
        this.beginTime = beginTime;
    }

    public void setDuration(long statusId, long duration) {
        this.stateDurations.put(statusId, duration);
    }

    public HashMap<Long, Double> getStatePercentages() {
        if (this.statePercentages == null) {
            this.statePercentages = new HashMap();
            for (Map.Entry<Long, Long> e : this.stateDurations.entrySet()) {
                long duration = e.getValue();
                double percentage = (double)duration * 100.0 / (double)this.getTotalDuration();
                this.statePercentages.put(e.getKey(), percentage);
            }
        }
        return this.statePercentages;
    }

    public long getDuration(long statusId) {
        if (this.stateDurations.containsKey(statusId)) {
            return this.stateDurations.get(statusId);
        }
        return 0L;
    }

    public Set<Long> getStatusIds() {
        return this.stateDurations.keySet();
    }

    public long getStateModelId() {
        return this.stateModelId;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.appendToString(super.toString());
        Set<Long> keys = this.getStatusIds();
        for (Long statusId : keys) {
            toStringBuilder.append(String.valueOf(statusId), this.getDuration(statusId));
        }
        return toStringBuilder.toString();
    }

    public HashMap<Long, Long> getStateDurations() {
        return this.stateDurations;
    }

    public long getTotalDuration() {
        long totalDuration = 0L;
        for (Map.Entry<Long, Long> e : this.stateDurations.entrySet()) {
            totalDuration += e.getValue().longValue();
        }
        return totalDuration;
    }

    public StatusDurationDTO getStatusDurationDTO(long statusId) {
        Long duration = this.getDuration(statusId);
        if (duration != null && duration != 0L) {
            return new StatusDurationDTO(this.unitModelValue, this.unitIdentityValue, this.unitTypeIdentityValue, this.stateModelId, statusId, duration, this.beginTime);
        }
        return null;
    }
}

