/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.security;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocalHome;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeLocalHome;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeUtil;
import de.proveo.wwt.logic.web.admin.permission.UnitPermissionDTO;
import de.proveo.wwt.logic.web.admin.permission.UnitPermissionDTOList;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocal;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocalHome;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeUtil;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SecurityAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PermissionCheckerBean
extends BaseSessionBean
implements SessionBean {
    private AdminUnitFacadeLocalHome adminUnitFacadeLocalHome;
    private CommonDataFacadeLocalHome commonDataFacadeLocalHome;
    private ConfigurationLocalHome configurationLocalHome;
    private static final Log logger = LogFactory.getLog(PermissionCheckerBean.class);
    private static HashMap<String, TreeSet<Long>> unitPermissions = new HashMap();

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.commonDataFacadeLocalHome = CommonDataFacadeUtil.getLocalHome();
            this.adminUnitFacadeLocalHome = AdminUnitFacadeUtil.getLocalHome();
            this.configurationLocalHome = ConfigurationUtil.getLocalHome();
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public HashSet<Long> getUnitPermissions() {
        logger.debug((Object)"getUnitPermissions: entering ...");
        HashSet<Long> permissionList = new HashSet<Long>();
        try {
            AdminUnitFacadeLocal adminUnitFacadeLocal = this.adminUnitFacadeLocalHome.create();
            CommonDataFacadeLocal commonDataFacadeLocal = this.commonDataFacadeLocalHome.create();
            ConfigurationLocal configurationLocal = this.configurationLocalHome.create();
            String jaasUsed = configurationLocal.getParameter("jaasUsed", "false");
            if (jaasUsed.equals("false")) {
                logger.debug((Object)"No JAAS used for unit permissions.");
                permissionList = new HashSet<Long>(commonDataFacadeLocal.getUnitIdsByIsBasic(true));
            } else if (adminUnitFacadeLocal != null) {
                Principal principal = SecurityAssociation.getCallerPrincipal();
                if (principal == null) {
                    if (jaasUsed.equals("optional")) {
                        logger.debug((Object)"getUnitPermissions: leaving with full permissions, Principal was NULL, JAAS optional");
                        return new HashSet<Long>(commonDataFacadeLocal.getUnitIdsByIsBasic(true));
                    }
                    logger.debug((Object)"getUnitPermissions: leaving with no permissions, Principal was NULL");
                    return new HashSet<Long>();
                }
                logger.debug((Object)("getUnitPermissions: CallerPrincipal is: " + this.sessionContext.getCallerPrincipal()));
                String username = principal.getName();
                if (username == null) {
                    logger.debug((Object)"getUnitPermissions: leaving with no permissions, Principal.Name was NULL");
                    return new HashSet<Long>();
                }
                if (this.isSuperAdmin()) {
                    permissionList = new HashSet<Long>(commonDataFacadeLocal.getUnitIdsByIsBasic(true));
                } else {
                    UnitPermissionDTOList unitList = adminUnitFacadeLocal.getAllUnitPermissionDTOsForUsername(username);
                    permissionList = new HashSet<Long>(this.convertDTOListToSet(unitList));
                }
            }
        }
        catch (CreateException e) {
            logger.error((Object)("adminUnitFacadeLocalHome.create() " + (Object)((Object)e)));
        }
        logger.debug((Object)("getUnitPermissions: leaving with permissions for: " + permissionList.toString()));
        return permissionList;
    }

    public boolean isSuperAdmin() {
        boolean retVal = this.sessionContext.isCallerInRole("superadmin");
        logger.debug((Object)("isSuperAdmin returns: " + retVal));
        return retVal;
    }

    public boolean isCallerInRole(String role) {
        boolean retVal = this.sessionContext.isCallerInRole(role);
        logger.debug((Object)("isCallerInRole returns: " + retVal));
        return retVal;
    }

    public Boolean checkDTOList(UnitDTOListBase dtoList) {
        boolean cleanedData = false;
        logger.debug((Object)"checkDTOList called");
        if (dtoList == null) {
            return null;
        }
        int fetchedDataSize = dtoList.size();
        Principal principal = SecurityAssociation.getCallerPrincipal();
        if (this.isSuperAdmin()) {
            logger.debug((Object)"all permissions granted for role=superadmin");
            return true;
        }
        if (principal != null) {
            TreeSet<Long> permissionList;
            String username = principal.getName();
            if (username == null) {
                logger.debug((Object)"username = null (grant access");
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("chekDTO for username: " + username + " entries: " + dtoList.size()));
            }
            if (!unitPermissions.containsKey(username)) {
                this.updateUserPermissions(username);
            }
            if ((permissionList = unitPermissions.get(username)) != null) {
                logger.debug((Object)("unitPermissions size: " + permissionList.size()));
                for (int i = 0; i < dtoList.size(); ++i) {
                    UnitDTO dto = (UnitDTO)dtoList.get(i);
                    if (dto == null || !dto.getUnitModelValue().getBasic() || permissionList.contains(dto.getUnitId())) continue;
                    dtoList.removeUnAuthorizedData(dto);
                    cleanedData = true;
                    logger.debug((Object)("deleted Data for: " + dto.getUnitId()));
                    --i;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("cleaned list entries: " + String.valueOf(fetchedDataSize - dtoList.size())));
        }
        return cleanedData;
    }

    public Boolean checkUnitModelList(List<UnitModelLocal> list) {
        boolean cleanedData = false;
        logger.debug((Object)"checkDTOList called");
        int fetchedDataSize = list.size();
        if (list == null) {
            return null;
        }
        Principal principal = SecurityAssociation.getCallerPrincipal();
        if (this.isSuperAdmin()) {
            logger.debug((Object)"all permissions granted for role=superadmin");
            return true;
        }
        if (principal != null) {
            TreeSet<Long> permissionList;
            String username = principal.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("chekDTO for username: " + username + " entries: " + list.size()));
            }
            if (!unitPermissions.containsKey(username)) {
                this.updateUserPermissions(username);
            }
            if ((permissionList = unitPermissions.get(username)) != null) {
                logger.debug((Object)("unitPermissions size: " + permissionList.size()));
                for (int i = 0; i < list.size(); ++i) {
                    UnitModelLocal unitModel = list.get(i);
                    if (!unitModel.getBasic()) continue;
                    boolean hasPermsissons = false;
                    for (Long unitId : permissionList) {
                        if (!unitId.equals(unitModel.getUnitId())) continue;
                        hasPermsissons = true;
                        break;
                    }
                    if (hasPermsissons) continue;
                    list.remove(i);
                    cleanedData = true;
                    logger.debug((Object)("deleted Data for: " + unitModel.getUnitId()));
                    --i;
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("cleaned list entries: " + String.valueOf(fetchedDataSize - list.size())));
        }
        return cleanedData;
    }

    private TreeSet<Long> convertDTOListToSet(UnitPermissionDTOList list) {
        TreeSet<Long> set = new TreeSet<Long>();
        for (UnitPermissionDTO dto : list) {
            set.add(dto.getUnitId());
        }
        return set;
    }

    public TreeSet<Long> updateUserPermissions(String username) {
        TreeSet<Long> retVal = new TreeSet<Long>();
        try {
            AdminUnitFacadeLocal adminUnitFacadeLocal = this.adminUnitFacadeLocalHome.create();
            UnitPermissionDTOList list = adminUnitFacadeLocal.getAllUnitPermissionDTOsForUsername(username);
            retVal = this.convertDTOListToSet(list);
            unitPermissions.put(username, retVal);
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return retVal;
    }

    public void updateAllUserPermissions() {
        unitPermissions.clear();
    }
}

