/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.historyData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.state.StateModel;
import de.proveo.wwt.logic.app.state.aviation.AviationStateModelFactory;
import de.proveo.wwt.logic.app.state.exception.StateModelNotFoundException;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.history.FisFlightHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.history.FisFlightHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.history.FisFlightHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.history.FisGseHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.history.FisGseHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCachePK;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocalHome;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocal;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocalHome;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupPK;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupUtil;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserPK;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocal;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeUtil;
import de.proveo.wwt.logic.web.data.FastLaneReader;
import de.proveo.wwt.logic.web.historyData.HistoryDataFacade;
import de.proveo.wwt.logic.web.historyData.dto.AccidentReconstructionDTO;
import de.proveo.wwt.logic.web.historyData.dto.AccidentReconstructionDTOList;
import de.proveo.wwt.logic.web.historyData.dto.FlightDTO;
import de.proveo.wwt.logic.web.historyData.dto.FlightRotationDTO;
import de.proveo.wwt.logic.web.historyData.dto.FlightRotationDTOList;
import de.proveo.wwt.logic.web.historyData.dto.GseProductivityDTOList;
import de.proveo.wwt.logic.web.historyData.dto.GseUsageDTO;
import de.proveo.wwt.logic.web.historyData.dto.GseUsageDTOList;
import de.proveo.wwt.logic.web.historyData.dto.KeepAliveDTO;
import de.proveo.wwt.logic.web.historyData.dto.KeepAliveDTOList;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTOList;
import de.proveo.wwt.logic.web.historyData.dto.PeakDTOBeginComparator;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTOList;
import de.proveo.wwt.logic.web.historyData.dto.StateAssignmentDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateAssignmentDTOList;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.historyData.dto.UseComparator;
import de.proveo.wwt.logic.web.historyData.dto.UseDTO;
import de.proveo.wwt.logic.web.historyData.dto.UseDTOList;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocalHome;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import de.proveo.wwt.logic.web.summarizedData.SummarizedDataFacadeLocal;
import de.proveo.wwt.logic.web.summarizedData.SummarizedDataFacadeUtil;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.StatusDurationsDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.StatusDurationsDTOList;
import de.proveo.wwt.logic.web.summarizedData.dto.statusPeak.StatusPeakDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.statusPeak.StatusPeaksDTOList;
import de.proveo.wwt.logic.web.summarizedData.dto.statusPeak.StatusPeaksDTOMap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateMidnight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HistoryDataFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(HistoryDataFacadeBean.class);
    private static final String CONFIG_PARAM_GEO_MPH = "geo.speedUnit.Mph";
    private UnitModelLocalHome unitModelHome;
    private GdataHistoryLocalHome gDataHistoryLocalHome;
    private CurrentStateCacheLocalHome currentStateCacheLocalHome;
    private StateHistoryLocalHome stateHistoryLocalHome;
    private KeepAliveHistoryLocalHome keepAliveHistoryLocalHome;
    private KeepAliveCacheLocalHome keepAliveCacheLocalHome;
    private NotifyHistoryLocalHome notifyHistoryLocalHome;
    private CurrentNotifyCacheLocalHome currentNotifyCacheLocalHome;
    private CurrentGdataCacheLocalHome currentGdataCacheLocalHome;
    private UseUserLocalHome useUserLocalHome;
    private UseGroupLocalHome useGroupLocalHome;
    private PermissionCheckerLocalHome permissionCheckerLocalHome;
    private UseHistoryLocalHome useHistoryLocalHome;
    private UseCacheLocalHome useCacheLocalHome;
    private ConfigurationLocalHome configurationHome;
    private SummarizedDataFacadeLocal summarizedDataHome = null;
    private boolean geoSpeedMph = false;
    private FisFlightCacheLocalHome fisFlightCacheLocalHome;
    private FisGseCacheLocalHome fisGseCacheLocalHome;
    private FisFlightHistoryLocalHome fisFlightHistoryLocalHome;
    private FisGseHistoryLocalHome fisGseHistoryLocalHome;
    private CommonDataFacadeLocal commonData;
    private int gseArrivalSetupStartTime;
    private int gseArrivalSetupEndTimePax;
    private int gseArrivalSetupEndTimeCgo;
    private int gseDepartureSetupStartTime;
    private int gseDepartureSetupEndTime;
    private FastLaneReader fastLaneReader;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.unitModelHome = UnitModelUtil.getLocalHome();
            this.gDataHistoryLocalHome = GdataHistoryUtil.getLocalHome();
            this.stateHistoryLocalHome = StateHistoryUtil.getLocalHome();
            this.currentStateCacheLocalHome = CurrentStateCacheUtil.getLocalHome();
            this.keepAliveHistoryLocalHome = KeepAliveHistoryUtil.getLocalHome();
            this.keepAliveCacheLocalHome = KeepAliveCacheUtil.getLocalHome();
            this.notifyHistoryLocalHome = NotifyHistoryUtil.getLocalHome();
            this.currentNotifyCacheLocalHome = CurrentNotifyCacheUtil.getLocalHome();
            this.currentGdataCacheLocalHome = CurrentGdataCacheUtil.getLocalHome();
            this.useUserLocalHome = UseUserUtil.getLocalHome();
            this.useGroupLocalHome = UseGroupUtil.getLocalHome();
            this.permissionCheckerLocalHome = PermissionCheckerUtil.getLocalHome();
            this.useHistoryLocalHome = UseHistoryUtil.getLocalHome();
            this.useCacheLocalHome = UseCacheUtil.getLocalHome();
            this.configurationHome = ConfigurationUtil.getLocalHome();
            ConfigurationLocal configuration = this.configurationHome.create();
            String param = configuration.getParameter(CONFIG_PARAM_GEO_MPH);
            if (param.length() > 0) {
                this.geoSpeedMph = Boolean.parseBoolean(param);
            }
            this.fisFlightCacheLocalHome = FisFlightCacheUtil.getLocalHome();
            this.fisGseCacheLocalHome = FisGseCacheUtil.getLocalHome();
            this.fisFlightHistoryLocalHome = FisFlightHistoryUtil.getLocalHome();
            this.fisGseHistoryLocalHome = FisGseHistoryUtil.getLocalHome();
            this.commonData = CommonDataFacadeUtil.getLocalHome().create();
            param = configuration.getParameter("gseArrival.SetupStartTime", "15");
            if (param.length() > 0) {
                this.gseArrivalSetupStartTime = Integer.parseInt(param);
            }
            if ((param = configuration.getParameter("gseArrival.SetupEndTimePax", "60")).length() > 0) {
                this.gseArrivalSetupEndTimePax = Integer.parseInt(param);
            }
            if ((param = configuration.getParameter("gseArrival.SetupEndTimeCgo", "90")).length() > 0) {
                this.gseArrivalSetupEndTimeCgo = Integer.parseInt(param);
            }
            if ((param = configuration.getParameter("gseDeparture.SetupStartTime", "15")).length() > 0) {
                this.gseDepartureSetupStartTime = Integer.parseInt(param);
            }
            if ((param = configuration.getParameter("gseDeparture.SetupEndTime", "15")).length() > 0) {
                this.gseDepartureSetupEndTime = Integer.parseInt(param);
            }
            this.fastLaneReader = new FastLaneReader();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    private static long[] getAvailableStateIds(long stateModel) {
        long[] stateIds = null;
        AviationStateModelFactory factory = new AviationStateModelFactory();
        try {
            StateModel model = factory.getStateModel(stateModel, 0L);
            stateIds = model.getPossibleStates();
        }
        catch (StateModelNotFoundException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return stateIds;
    }

    private static long getNewIntervalBegin(long cacheBegin, String interval) {
        DateMidnight newPeriodeBeginDate = null;
        long newPeriodeBegin = 0L;
        if (interval.equals("DAY")) {
            newPeriodeBeginDate = new DateMidnight(cacheBegin).plusDays(1);
            newPeriodeBegin = newPeriodeBeginDate.getMillis();
        } else if (interval.equals("HOUR")) {
            newPeriodeBegin = cacheBegin + 3600000L;
        } else if (interval.equals("WEEK")) {
            newPeriodeBeginDate = new DateMidnight(cacheBegin).plusWeeks(1);
            newPeriodeBegin = newPeriodeBeginDate.getMillis();
        } else if (interval.equals("MONTH")) {
            newPeriodeBeginDate = new DateMidnight(cacheBegin).plusMonths(1);
            newPeriodeBegin = newPeriodeBeginDate.getMillis();
        } else {
            long fixedMillies = Long.parseLong(interval) * 60L * 1000L;
            newPeriodeBegin = fixedMillies > 0L ? cacheBegin + fixedMillies : cacheBegin + 3600000L;
        }
        return newPeriodeBegin;
    }

    public StatusPeaksDTOList getStatusPeakDTOList(Long unitId, long stateModelId, long beginTime, long endTime, String interval) {
        SimpleDateFormat formater = new SimpleDateFormat("HH:mm:ss");
        if (log.isDebugEnabled()) {
            log.debug((Object)("+++++++++++++++++++++++++ start peak +++++++++++ " + formater.format(new Date().getTime())));
        }
        StatusPeaksDTOList statusPeaksDTOList = null;
        long[] states = HistoryDataFacadeBean.getAvailableStateIds(stateModelId);
        UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
        statusPeaksDTOList = new StatusPeaksDTOList(unitBasicModels.getUnitModel(), unitBasicModels.getUnitIdentityValue(), unitBasicModels.getUnitTypeIdentityValue(), stateModelId, beginTime, endTime, interval, states, 0);
        StateDTOList stateHistoryList = this.getStateData(unitId, stateModelId, beginTime, endTime, true, true);
        statusPeaksDTOList.setCountOfUnits(stateHistoryList.getCountOfInvolvedUnits());
        Collections.sort(stateHistoryList, new PeakDTOBeginComparator());
        int maxCountOfPeaksFromInterval = 0;
        long cacheBegin = beginTime;
        long cacheEnd = endTime;
        while (cacheBegin < cacheEnd) {
            long newPeriodeBegin = HistoryDataFacadeBean.getNewIntervalBegin(cacheBegin, interval);
            ArrayList<StateDTO> intervalList = HistoryDataFacadeBean.getDataForInterval(stateHistoryList, cacheBegin, newPeriodeBegin);
            HashMap<Long, Integer> sumMap = new HashMap<Long, Integer>();
            for (int i = 0; i < states.length; ++i) {
                sumMap.put(states[i], 0);
            }
            HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>(sumMap);
            HashMap<Long, Long> timeSumMap = new HashMap<Long, Long>();
            for (int i = 0; i < states.length; ++i) {
                timeSumMap.put(states[i], 0L);
            }
            HashMap timeResultMap = new HashMap(timeSumMap);
            HashMap<Long, List> unitSumMap = new HashMap<Long, List>();
            for (int i = 0; i < states.length; ++i) {
                unitSumMap.put(states[i], new ArrayList());
            }
            HashMap unitResultMap = new HashMap(unitSumMap);
            Iterator<StateDTO> iter = intervalList.iterator();
            while (iter.hasNext()) {
                StateDTO obj;
                StateDTO value = obj = iter.next();
                for (int i = 0; i < 2; ++i) {
                    long time = 0L;
                    if (i == 0) {
                        time = value.getBeginTime();
                        if (cacheBegin > time) {
                            time = cacheBegin;
                        }
                    } else {
                        time = value.getEndTime();
                        if (newPeriodeBegin < time) {
                            time = newPeriodeBegin;
                        }
                    }
                    for (Map.Entry entry : sumMap.entrySet()) {
                        Long stateid = (Long)entry.getKey();
                        Integer intersect = (Integer)entry.getValue();
                        if ((Integer)resultMap.get(stateid) < intersect) {
                            resultMap.put(stateid, intersect);
                            timeResultMap.put(stateid, timeSumMap.get(stateid));
                            unitResultMap.put(stateid, unitSumMap.get(stateid));
                        }
                        entry.setValue(0);
                    }
                    for (Map.Entry entry : timeSumMap.entrySet()) {
                        entry.setValue(0L);
                    }
                    for (Map.Entry entry : unitSumMap.entrySet()) {
                        entry.setValue(new ArrayList());
                    }
                    for (int j = 0; j < intervalList.size(); ++j) {
                        StateDTO stateDTO = intervalList.get(j);
                        long btime = stateDTO.getBeginTime();
                        long etime = stateDTO.getEndTime();
                        if (time > etime || time < btime) continue;
                        if (sumMap.containsKey(stateDTO.getStateId())) {
                            Integer count;
                            Integer n = count = (Integer)sumMap.get(stateDTO.getStateId());
                            Integer n2 = count = Integer.valueOf(count + 1);
                            sumMap.put(stateDTO.getStateId(), count);
                            timeSumMap.put(stateDTO.getStateId(), time);
                        }
                        if (!unitSumMap.containsKey(stateDTO.getStateId())) continue;
                        List units = (List)unitSumMap.get(stateDTO.getStateId());
                        units.add(this.commonData.getUnit(stateDTO.getUnitId()));
                        unitSumMap.put(stateDTO.getStateId(), units);
                    }
                }
            }
            StatusPeaksDTOMap statusPeaksDTOMap = new StatusPeaksDTOMap(cacheBegin);
            for (Map.Entry ent : resultMap.entrySet()) {
                Long stateId = (Long)ent.getKey();
                Integer count = (Integer)ent.getValue();
                StatusPeakDTO statusPeakDTO = new StatusPeakDTO(unitBasicModels.getUnitModel(), unitBasicModels.getUnitIdentityValue(), unitBasicModels.getUnitTypeIdentityValue(), stateModelId, stateId, (Long)timeResultMap.get(stateId), cacheBegin, newPeriodeBegin, count.intValue(), (List)unitResultMap.get(stateId));
                maxCountOfPeaksFromInterval = Math.max(count, maxCountOfPeaksFromInterval);
                statusPeaksDTOMap.getPeakMap().put(stateId, statusPeakDTO);
            }
            statusPeaksDTOList.add(statusPeaksDTOMap);
            cacheBegin = newPeriodeBegin;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("+++++++++++++++++++++++++ ende peak +++++++++++ " + formater.format(new Date().getTime())));
        }
        statusPeaksDTOList.setCountOfUnits(maxCountOfPeaksFromInterval);
        if (log.isDebugEnabled()) {
            log.debug((Object)("+++++++++++++++++++++++++ statusPeaksDTOList peak size() +++++++++++ " + statusPeaksDTOList.size()));
        }
        return statusPeaksDTOList;
    }

    public StatusPeaksDTOList getStackedStatusPeakDTOList(Long unitId, long stateModelId, long beginTime, long endTime, String interval, String peakModelStates) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"+++++++++++++++++++++++++ getStackedStatusPeakDTOList +++++++++++ ");
        }
        StatusPeaksDTOList statusPeaksDTOList = null;
        long[] states = HistoryDataFacadeBean.getAvailableStateIds(stateModelId);
        UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
        statusPeaksDTOList = new StatusPeaksDTOList(unitBasicModels.getUnitModel(), unitBasicModels.getUnitIdentityValue(), unitBasicModels.getUnitTypeIdentityValue(), stateModelId, beginTime, endTime, interval, states, 0);
        StateDTOList stateHistoryList = this.getStateData(unitId, stateModelId, beginTime, endTime, true, true);
        statusPeaksDTOList.setCountOfUnits(stateHistoryList.getCountOfInvolvedUnits());
        int maxCountOfPeaksFromInterval = 0;
        HashMap<Long, Long> basedPeakTimeMap = this.getBasedPeakTimes(stateHistoryList, unitId, stateModelId, beginTime, endTime, interval, peakModelStates);
        long cacheBegin = beginTime;
        long cacheEnd = endTime;
        while (cacheBegin < cacheEnd) {
            long newPeriodeBegin = HistoryDataFacadeBean.getNewIntervalBegin(cacheBegin, interval);
            ArrayList<StateDTO> intervalList = HistoryDataFacadeBean.getDataForInterval(stateHistoryList, cacheBegin, newPeriodeBegin);
            HashMap<Long, Integer> sumMap = new HashMap<Long, Integer>();
            for (int i = 0; i < states.length; ++i) {
                sumMap.put(states[i], 0);
            }
            HashMap<Long, Long> timeSumMap = new HashMap<Long, Long>();
            for (int i = 0; i < states.length; ++i) {
                timeSumMap.put(states[i], 0L);
            }
            HashMap<Long, List> unitSumMap = new HashMap<Long, List>();
            for (int i = 0; i < states.length; ++i) {
                unitSumMap.put(states[i], new ArrayList());
            }
            long time = basedPeakTimeMap.get(cacheBegin);
            for (int j = 0; j < intervalList.size(); ++j) {
                StateDTO listvalue = intervalList.get(j);
                long btime = listvalue.getBeginTime();
                long etime = listvalue.getEndTime();
                if (time >= etime || time < btime) continue;
                if (sumMap.containsKey(listvalue.getStateId())) {
                    Integer count;
                    Integer n = count = (Integer)sumMap.get(listvalue.getStateId());
                    Integer n2 = count = Integer.valueOf(count + 1);
                    sumMap.put(listvalue.getStateId(), count);
                    timeSumMap.put(listvalue.getStateId(), time);
                }
                if (!unitSumMap.containsKey(listvalue.getStateId())) continue;
                List units = (List)unitSumMap.get(listvalue.getStateId());
                units.add(this.commonData.getUnit(listvalue.getUnitId()));
                unitSumMap.put(listvalue.getStateId(), units);
            }
            StatusPeaksDTOMap statusPeaksDTOMap = new StatusPeaksDTOMap(cacheBegin);
            int tmpCountOfPeaksFromInterval = 0;
            for (Map.Entry ent : sumMap.entrySet()) {
                Long stateId = (Long)ent.getKey();
                Integer count = (Integer)ent.getValue();
                tmpCountOfPeaksFromInterval += count.intValue();
                StatusPeakDTO statusPeakDTO = new StatusPeakDTO(unitBasicModels.getUnitModel(), unitBasicModels.getUnitIdentityValue(), unitBasicModels.getUnitTypeIdentityValue(), stateModelId, stateId, (Long)timeSumMap.get(stateId), cacheBegin, newPeriodeBegin, count.intValue(), (List)unitSumMap.get(stateId));
                statusPeaksDTOMap.getPeakMap().put(stateId, statusPeakDTO);
            }
            maxCountOfPeaksFromInterval = Math.max(tmpCountOfPeaksFromInterval, maxCountOfPeaksFromInterval);
            statusPeaksDTOList.add(statusPeaksDTOMap);
            cacheBegin = newPeriodeBegin;
        }
        statusPeaksDTOList.setCountOfUnits(maxCountOfPeaksFromInterval);
        return statusPeaksDTOList;
    }

    private ArrayList<Long> getBasedStates(String basedStateGroup) {
        ArrayList<Long> basedStates = new ArrayList<Long>();
        String[] stateGroup = basedStateGroup.split(",");
        for (int j = 0; j < stateGroup.length; ++j) {
            basedStates.add(Long.parseLong(stateGroup[j]));
        }
        return basedStates;
    }

    public HashMap<Long, Long> getBasedPeakTimes(StateDTOList stateHistoryList, Long unitId, long stateModelId, long beginTime, long endTime, String interval, String stackedStructure) {
        String[] stateGroups = stackedStructure.split(";");
        ArrayList<Object> basedStates = new ArrayList();
        String pattern1 = "dd.MM - HH:mm:ss";
        SimpleDateFormat formater = new SimpleDateFormat(pattern1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("+++++++++++++++++++++++++ start peak +++++++++++ " + formater.format(new Date().getTime())));
        }
        long cacheBegin = beginTime;
        long cacheEnd = endTime;
        long now = System.currentTimeMillis();
        cacheEnd = Math.max(cacheEnd, now);
        HashMap<Long, Long> basedPeakTimeMap = new HashMap<Long, Long>();
        block0: while (cacheBegin < cacheEnd) {
            for (int groupIndex = 0; groupIndex < stateGroups.length; ++groupIndex) {
                basedStates = this.getBasedStates(stateGroups[groupIndex]);
                basedPeakTimeMap.put(cacheBegin, cacheBegin);
                Integer maxPeakCount = 0;
                long newPeriodeBegin = HistoryDataFacadeBean.getNewIntervalBegin(cacheBegin, interval);
                ArrayList<StateDTO> intervalList = HistoryDataFacadeBean.getDataForInterval(stateHistoryList, cacheBegin, newPeriodeBegin);
                Iterator<StateDTO> iter = intervalList.iterator();
                while (iter.hasNext()) {
                    StateDTO obj;
                    StateDTO value = obj = iter.next();
                    for (int i = 0; i < 1; ++i) {
                        Integer actPeakCount = 0;
                        long time = 0L;
                        if (i == 0) {
                            time = value.getBeginTime();
                            if (cacheBegin > time) {
                                time = cacheBegin;
                            }
                        } else {
                            time = value.getEndTime();
                            if (newPeriodeBegin < time) {
                                time = newPeriodeBegin;
                            }
                        }
                        for (int j = 0; j < intervalList.size(); ++j) {
                            StateDTO listvalue = intervalList.get(j);
                            long btime = listvalue.getBeginTime();
                            long etime = listvalue.getEndTime();
                            if (time >= etime || time < btime || !basedStates.contains(listvalue.getStateId())) continue;
                            Integer n = actPeakCount;
                            Integer n2 = actPeakCount = Integer.valueOf(actPeakCount + 1);
                        }
                        if (actPeakCount <= maxPeakCount) continue;
                        maxPeakCount = actPeakCount;
                        basedPeakTimeMap.put(cacheBegin, time);
                    }
                }
                if (maxPeakCount <= 0 && groupIndex != stateGroups.length - 1) continue;
                cacheBegin = newPeriodeBegin;
                continue block0;
            }
        }
        return basedPeakTimeMap;
    }

    private static ArrayList<StateDTO> getDataForInterval(ArrayList<StateDTO> data, long ts, long te) {
        int size = data.size();
        ArrayList<StateDTO> list = new ArrayList<StateDTO>(size);
        for (int i = 0; i < size; ++i) {
            StateDTO value = data.get(i);
            if (value == null || value.getEndTime() < ts || value.getBeginTime() > te) continue;
            list.add(value);
        }
        return list;
    }

    private StateDTOList addStateCurrentCaches(StateDTOList list, UnitModelValue unitModelValue, long stateModelId, long beginTime, long endTime, boolean correctedTimes) {
        log.debug((Object)"addStateCurrentCaches called");
        Collection cacheValues = null;
        try {
            cacheValues = unitModelValue == null ? this.currentStateCacheLocalHome.findAllByStateModelId(stateModelId) : (!unitModelValue.getBasic() ? this.currentStateCacheLocalHome.findByUnitGroupIdStateModelId(unitModelValue.getUnitId(), stateModelId) : this.currentStateCacheLocalHome.findByUnitModelId(unitModelValue.getUnitId(), stateModelId));
        }
        catch (FinderException e) {
            log.warn((Object)"runs into", (Throwable)e);
        }
        if (cacheValues != null && !cacheValues.isEmpty()) {
            CurrentStateCacheLocal[] stateArr = cacheValues.toArray(new CurrentStateCacheLocal[cacheValues.size()]);
            StateDTO stateDTO = null;
            for (int i = 0; i != stateArr.length; ++i) {
                UnitModelLocal unitModel;
                CurrentStateCacheLocal stateCache = stateArr[i];
                CurrentStateCacheValue stateCacheValue = stateCache.getCurrentStateCacheValue();
                long cacheBegin = stateCacheValue.getBeginTime();
                if (cacheBegin >= endTime || (unitModel = stateCache.getUnitModel()) == null) continue;
                StateHistoryValue stateHistoryValue = new StateHistoryValue();
                long duration = 0L;
                if (correctedTimes) {
                    stateHistoryValue.setBeginTime(Math.max(beginTime, cacheBegin));
                    stateHistoryValue.setEndTime(endTime);
                } else {
                    stateHistoryValue.setBeginTime(cacheBegin);
                    stateHistoryValue.setEndTime(0L);
                }
                duration = endTime - stateHistoryValue.getBeginTime();
                stateHistoryValue.setDuration(duration);
                stateHistoryValue.setStateId(stateCacheValue.getState());
                stateHistoryValue.setStateModelId(stateCacheValue.getStateModelId());
                stateHistoryValue.setUnitId(stateCacheValue.getUnitId());
                stateHistoryValue.setBeginReceiveTime(stateCacheValue.getBeginReceiveTime());
                UnitTypeIdentityValue unitTypeIdentityValue = null;
                if (unitModel.getBasic()) {
                    unitTypeIdentityValue = unitModel.getUnitTypeIdentity().getUnitTypeIdentityValue();
                }
                stateDTO = DTOFactory.buildStateDTO(unitModel.getUnitModelValue(), unitModel.getUnitIdentity().getUnitIdentityValue(), unitTypeIdentityValue, stateHistoryValue);
                list.add(stateDTO);
            }
        }
        return list;
    }

    public StateDTOList getStateData(Long unitId, Long stateModelId, long beginTime, long endTime, boolean correctedTimes, boolean useGroupHistory) {
        Stopwatch stopwatch = new Stopwatch(HistoryDataFacade.class, "getStateData");
        stopwatch.start("overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)("getStateData called with stateModelId=" + stateModelId + "  unitId=" + unitId + " beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        StateDTOList list = null;
        UnitModelLocal unitModel = null;
        UnitModelValue unitModelValue = null;
        try {
            if (unitId != null) {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
                unitModelValue = unitModel.getUnitModelValue();
            }
            list = DTOListFactory.buildStateDTOList(unitModel, stateModelId, beginTime, endTime);
            if (endTime <= beginTime) {
                return list;
            }
            long current = System.currentTimeMillis();
            endTime = Math.min(current, endTime);
            log.debug((Object)"stateHistory databaseAccess...");
            stopwatch.start("dataBase access");
            if (unitId == null) {
                this.fastLaneReader.stateHistoryFastLaneRead(list, unitId, false, stateModelId, beginTime, endTime, correctedTimes, false, useGroupHistory);
            } else {
                this.fastLaneReader.stateHistoryFastLaneRead(list, unitId, unitModelValue.getBasic(), stateModelId, beginTime, endTime, correctedTimes, false, useGroupHistory);
            }
            stopwatch.stop("dataBase access", true, list.size());
            log.debug((Object)"building DTOs (stateHistory)...");
            stopwatch.start("building DTO");
            stopwatch.stop("building DTO", true);
            log.debug((Object)"addCurrentCache...");
            stopwatch.start("addCurrentCache");
            int currentStateSize = this.addStateCurrentCaches(list, unitModelValue, stateModelId, beginTime, endTime, correctedTimes).size();
            stopwatch.stop("addCurrentCache", true, currentStateSize);
            UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
            UnitModelLocal[] unModelLocals = unitBasicModels.toArray((UnitModelLocal[])new UnitModelLocal[unitBasicModels.size()]);
            HashSet<Long> involvedUnits = new HashSet<Long>();
            for (int i = 0; i < unModelLocals.length; ++i) {
                involvedUnits.add(unModelLocals[i].getUnitId());
            }
            list.setCountOfInvolvedUnits(involvedUnits.size());
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)"no values could be found");
        }
        catch (FinderException e) {
            log.error((Object)"Finding postion data values failed", (Throwable)e);
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        list.setStopwatch(stopwatch);
        return list;
    }

    public PositionDTOList getPostionData(Long unitId, long beginTime, long endTime, boolean correctedTimes, boolean fetchExtendedData) {
        Stopwatch stopwatch = new Stopwatch(this.getClass(), "getPostionData");
        stopwatch.start("overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)("getPostionData called with unitId=" + unitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        PositionDTOList list = null;
        try {
            UnitModelLocal unitModelLocal = null;
            if (unitId != null) {
                unitModelLocal = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            list = DTOListFactory.buildPostionDTOList(unitModelLocal, beginTime, endTime);
            log.debug((Object)"addCurrentGdataCache...");
            stopwatch.start("addCurrentGdataCache");
            this.addCurrentGdataCache(list, unitModelLocal, beginTime, endTime, correctedTimes);
            stopwatch.stop("addCurrentGdataCache", false, list.size());
            if (unitId == null) {
                this.fastLaneReader.gdataHistoryFastLaneRead(list, unitId, false, beginTime, endTime, correctedTimes, fetchExtendedData);
            } else {
                this.fastLaneReader.gdataHistoryFastLaneRead(list, unitId, unitModelLocal.getBasic(), beginTime, endTime, correctedTimes, fetchExtendedData);
            }
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)"no values could be found");
        }
        catch (FinderException e) {
            log.error((Object)"Finding postion data values failed", (Throwable)e);
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return list;
    }

    private void addCurrentGdataCache(PositionDTOList list, UnitModelLocal unitModelLocal, long beginTime, long endTime, boolean correctedTimes) {
        Collection cacheValues = null;
        try {
            cacheValues = unitModelLocal == null ? this.currentGdataCacheLocalHome.findAllByCreateTime(endTime) : (!unitModelLocal.getBasic() ? this.currentGdataCacheLocalHome.findByUnitGroupIdCreateTime(unitModelLocal.getUnitId(), endTime) : this.currentGdataCacheLocalHome.findByUnitIdCreatedTime(unitModelLocal.getUnitId(), endTime));
        }
        catch (FinderException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        if (log.isDebugEnabled() && cacheValues != null) {
            log.debug((Object)("values found: " + cacheValues.size()));
        }
        if (cacheValues != null && !cacheValues.isEmpty()) {
            for (CurrentGdataCacheLocal gdataCacheLocal : cacheValues) {
                UnitModelLocal cacheUnitModel = gdataCacheLocal.getUnitModel();
                if (cacheUnitModel == null) continue;
                PositionDTO value = DTOFactory.buildPositionDTO(cacheUnitModel, gdataCacheLocal, beginTime, endTime, correctedTimes);
                list.add(value);
            }
        }
    }

    public KeepAliveDTOList getKeepAliveData(Long basicUnitId, long beginTime, long endTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getKeepAliveData called with unitId=" + basicUnitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        KeepAliveDTOList list = null;
        try {
            Collection coll = this.keepAliveHistoryLocalHome.findByUnitAndPeriod(basicUnitId, beginTime, endTime);
            if (coll != null) {
                UnitModelLocal unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(basicUnitId));
                UnitTypeIdentityValue unitTypeIdentityValue = null;
                if (unitModel.getBasic()) {
                    unitTypeIdentityValue = unitModel.getUnitTypeIdentity().getUnitTypeIdentityValue();
                }
                list = new KeepAliveDTOList(unitModel.getUnitModelValue(), unitModel.getUnitIdentity().getUnitIdentityValue(), unitTypeIdentityValue, beginTime, endTime);
                list = this.addKeepAliveCache(list, unitModel, beginTime, endTime);
                for (KeepAliveHistoryLocal keepAlive : coll) {
                    KeepAliveDTO dto = DTOFactory.buildKeepAliveDTO(keepAlive.getUnitModel(), keepAlive.getKeepAliveHistoryValue().getTimeStamp(), null);
                    list.add(dto);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("values found: " + list.size()));
                }
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private KeepAliveDTOList addKeepAliveCache(KeepAliveDTOList list, UnitModelLocal untModelLocal, long beginTime, long endTime) {
        try {
            KeepAliveCacheLocal stateCache = this.keepAliveCacheLocalHome.findByPrimaryKey(new KeepAliveCachePK(untModelLocal.getUnitId()));
            KeepAliveCacheValue keepAliveCacheValue = stateCache.getKeepAliveCacheValue();
            long cacheBegin = keepAliveCacheValue.getTimeStamp();
            if (cacheBegin < endTime && cacheBegin > beginTime) {
                KeepAliveHistoryValue value = new KeepAliveHistoryValue();
                value.setUnitId(keepAliveCacheValue.getUnitId());
                KeepAliveDTO dto = DTOFactory.buildKeepAliveDTO(untModelLocal, keepAliveCacheValue.getTimeStamp(), null);
                list.add(dto);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public NotificationDTOList getNotifications(Long unitId, Long messageId, long beginTime, long endTime) {
        Stopwatch stopwatch = new Stopwatch(HistoryDataFacade.class, "getNotifications");
        stopwatch.start("overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNotifications called with unitId=" + unitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        NotificationDTOList list = null;
        try {
            UnitModelLocal unitModel = null;
            if (unitId != null) {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            list = DTOListFactory.buildNotificationList(unitModel, beginTime, endTime);
            log.debug((Object)"notificationHistory databaseAccess...");
            stopwatch.start("dataBase access");
            ArrayList values = new ArrayList();
            if (unitId == null) {
                this.fastLaneReader.notificationHistoryFastLaneRead(list, unitId, false, messageId, beginTime, endTime);
            } else {
                this.fastLaneReader.notificationHistoryFastLaneRead(list, unitId, unitModel.getUnitModelValue().getBasic(), messageId, beginTime, endTime);
            }
            stopwatch.stop("dataBase access", true, list.size());
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)"no values could be found");
        }
        catch (FinderException e) {
            log.error((Object)"Finding postion data values failed", (Throwable)e);
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("values found: " + list.size()));
        }
        stopwatch.stop("overall", true);
        list.setStopwatch(stopwatch);
        return list;
    }

    private NotificationDTOList addCurrentNotify(Long messageId, NotificationDTOList list, UnitModelLocal unitModel, long beginTime, long endTime, boolean entry) {
        Collection currColl = null;
        try {
            currColl = this.currentNotifyCacheLocalHome.findByUnitIdSorted(unitModel.getUnitId(), beginTime, endTime, entry);
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            return list;
        }
        CurrentNotifyCacheValue cacheValue = null;
        for (CurrentNotifyCacheLocal cacheNotify : currColl) {
            UseUserValue useValue = null;
            UseUserLocal useUserLocal = cacheNotify.getUseUser();
            if (useUserLocal != null) {
                useValue = useUserLocal.getUseUserValue();
            }
            AreaValue areaValue = null;
            AreaLocal areaLocal = cacheNotify.getArea();
            if (areaLocal != null) {
                areaValue = areaLocal.getAreaValue();
            }
            cacheValue = cacheNotify.getCurrentNotifyCacheValue();
            if (messageId != null && messageId.longValue() != cacheValue.getMessageId()) continue;
            NotificationDTO dto = DTOFactory.buildNotificationDTO(cacheNotify.getUnitModel(), cacheValue, useValue, areaValue);
            list = this.addNotifyDTO(list, dto);
        }
        return list;
    }

    private NotificationDTOList addNotifyDTO(NotificationDTOList list, NotificationDTO dto) {
        if (list == null) {
            return null;
        }
        boolean add = true;
        for (NotificationDTO notify : list) {
            if (notify.getUnitId() != dto.getUnitId() || notify.getMessageId() != dto.getMessageId() || notify.getCreateTime() != dto.getCreateTime()) continue;
            add = false;
            break;
        }
        if (add) {
            list.add(dto);
        }
        return list;
    }

    public GseUsageDTOList getGseUsageData(Long unitId, long beginTime, long endTime, long stateModelId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getGseUsageData : " + stateModelId));
        }
        GseUsageDTOList gseList = null;
        UnitModelValue unitModelValue = null;
        UnitIdentityValue unitIdentityValue = null;
        UnitTypeIdentityValue unitTypeIdentityValue = null;
        try {
            GseUsageDTO currentDTO;
            ArrayList caches;
            UnitModelLocal unitModel = null;
            if (unitId != null) {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
                unitModelValue = unitModel.getUnitModelValue();
                unitIdentityValue = unitModel.getUnitIdentity().getUnitIdentityValue();
                if (unitModel.getBasic()) {
                    unitTypeIdentityValue = unitModel.getUnitTypeIdentity().getUnitTypeIdentityValue();
                }
            }
            gseList = DTOListFactory.buildGseUsageDTOList(unitModel, stateModelId, beginTime, endTime);
            Collection cacheValues = new ArrayList();
            cacheValues = unitId == null ? this.currentStateCacheLocalHome.findAllByStateModelId(stateModelId) : (!unitModelValue.getBasic() ? this.currentStateCacheLocalHome.findByUnitGroupIdStateModelId(unitId, stateModelId) : this.currentStateCacheLocalHome.findByUnitModelId(unitId, stateModelId));
            HashMap<Long, ArrayList> cacheHashmap = new HashMap<Long, ArrayList>();
            for (Object obj : cacheValues) {
                ArrayList arr;
                CurrentStateCacheLocal local = (CurrentStateCacheLocal)obj;
                CurrentStateCacheValue value = local.getCurrentStateCacheValue();
                if (cacheHashmap.containsKey(value.getUnitId())) {
                    arr = (ArrayList)cacheHashmap.get(value.getUnitId());
                    arr.add(local);
                    cacheHashmap.put(value.getUnitId(), arr);
                    continue;
                }
                arr = new ArrayList();
                arr.add(local);
                cacheHashmap.put(value.getUnitId(), arr);
            }
            ArrayList list = new ArrayList();
            if (unitId == null) {
                this.fastLaneReader.stateHistoryFastLaneRead(list, unitId, false, stateModelId, beginTime, endTime, true, true, false);
            } else if (!unitModelValue.getBasic()) {
                this.fastLaneReader.stateHistoryFastLaneRead(list, unitId, unitModelValue.getBasic(), stateModelId, beginTime, endTime, true, true, false);
            } else {
                this.fastLaneReader.stateHistoryFastLaneRead(list, unitId, unitModelValue.getBasic(), stateModelId, beginTime, endTime, true, true, false);
            }
            HashMap<Long, ArrayList> unitHashmap = new HashMap<Long, ArrayList>();
            for (int i = 0; i < list.size(); ++i) {
                ArrayList arr;
                GseUsageDTO GseUsageDTO2 = (GseUsageDTO)list.get(i);
                if (unitHashmap.containsKey(GseUsageDTO2.getUnitId())) {
                    arr = (ArrayList)unitHashmap.get(GseUsageDTO2.getUnitId());
                    arr.add(GseUsageDTO2);
                    unitHashmap.put(GseUsageDTO2.getUnitId(), arr);
                    continue;
                }
                arr = new ArrayList();
                arr.add(GseUsageDTO2);
                unitHashmap.put(GseUsageDTO2.getUnitId(), arr);
            }
            for (Map.Entry unitValues : unitHashmap.entrySet()) {
                long basicUnitId = (Long)unitValues.getKey();
                unitModel = null;
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(basicUnitId));
                unitModelValue = unitModel.getUnitModelValue();
                unitIdentityValue = unitModel.getUnitIdentity().getUnitIdentityValue();
                unitTypeIdentityValue = null;
                if (unitModel.getBasic()) {
                    unitTypeIdentityValue = unitModel.getUnitTypeIdentity().getUnitTypeIdentityValue();
                }
                caches = (ArrayList)cacheHashmap.get(basicUnitId);
                currentDTO = this.getCurrentCacheGseUsage(caches, endTime);
                ArrayList states = (ArrayList)unitValues.getValue();
                for (int j = 0; j < states.size(); ++j) {
                    GseUsageDTO gseUsageDTO = (GseUsageDTO)states.get(j);
                    GseUsageDTO nextGseUsageDTO = null;
                    if (j < states.size() - 1) {
                        nextGseUsageDTO = (GseUsageDTO)states.get(j + 1);
                    }
                    if (j == states.size() - 1 && currentDTO != null) {
                        nextGseUsageDTO = currentDTO;
                    }
                    if (nextGseUsageDTO != null) {
                        gseUsageDTO.setAreaValueEnd(nextGseUsageDTO.getAreaValue());
                        gseUsageDTO.setEndTrusted(nextGseUsageDTO.isBeginTrusted());
                    }
                    gseList.add(gseUsageDTO);
                }
                if (currentDTO == null) continue;
                gseList.add(currentDTO);
            }
            for (Map.Entry unitValues : cacheHashmap.entrySet()) {
                long basicUnitId = (Long)unitValues.getKey();
                if (unitHashmap.containsKey(basicUnitId)) continue;
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(basicUnitId));
                caches = (ArrayList)cacheHashmap.get(basicUnitId);
                currentDTO = this.getCurrentCacheGseUsage(caches, endTime);
                if (currentDTO == null) continue;
                gseList.add(currentDTO);
            }
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)"no values could be found");
        }
        catch (FinderException e) {
            log.error((Object)"Finding postion data values failed", (Throwable)e);
        }
        return gseList;
    }

    public GseUsageDTOList getGseUsageDataCompressed(Long unitId, long beginTime, long endTime, long stateModelId, String states) {
        GseUsageDTOList gseListComplete = this.getGseUsageData(unitId, beginTime, endTime, stateModelId);
        GseUsageDTOList gseListCompressed = new GseUsageDTOList(gseListComplete.getUnitModel(), gseListComplete.getUnitIdentityValue(), gseListComplete.getUnitTypeIdentityValue(), stateModelId, gseListComplete.getBeginDate(), gseListComplete.getEndDate());
        if (stateModelId == 2010L) {
            block2: for (int i = 0; i < gseListComplete.size(); ++i) {
                GseUsageDTO dto = (GseUsageDTO)gseListComplete.get(i);
                if (dto.getStateId() == 2011L) continue;
                long basicUnitId = dto.getUnitId();
                for (int j = i + 1; j < gseListComplete.size(); ++j) {
                    GseUsageDTO dtoStop = (GseUsageDTO)gseListComplete.get(j);
                    if (dtoStop.getStateId() != 2011L || basicUnitId != dtoStop.getUnitId()) continue;
                    dto.setEndTrusted(dtoStop.isBeginTrusted());
                    dto.setNewEndTime(dtoStop.getBeginTime());
                    dto.setAreaValueEnd(dtoStop.getAreaValue());
                    gseListCompressed.add(dto);
                    i = j;
                    continue block2;
                }
            }
        }
        if (stateModelId == 2050L) {
            String[] stateArr = states.split(",");
            ArrayList<Long> statesList = new ArrayList<Long>();
            for (int j = 0; j < stateArr.length; ++j) {
                statesList.add(Long.parseLong(stateArr[j]));
            }
            if (statesList.size() == 0) {
                statesList.add(2053L);
                statesList.add(2055L);
            }
            for (int i = 0; i < gseListComplete.size(); ++i) {
                GseUsageDTO dtoStop;
                GseUsageDTO dto = (GseUsageDTO)gseListComplete.get(i);
                if (!statesList.contains(dto.getStateId())) continue;
                long basicUnitId = dto.getUnitId();
                int j = i + 1;
                if (j >= gseListComplete.size() || basicUnitId != (dtoStop = (GseUsageDTO)gseListComplete.get(j)).getUnitId()) continue;
                dto.mergeWithStateDTO(dtoStop);
                gseListCompressed.add(dto);
            }
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(gseListCompressed);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return gseListCompressed;
    }

    public GseUsageDTOList getGseUsageDataUseUserChange(Long unitId, long beginTime, long endTime, long stateModelId) {
        GseUsageDTOList gseListComplete = this.getGseUsageData(unitId, beginTime, endTime, stateModelId);
        GseUsageDTOList gseListCompressed = new GseUsageDTOList(gseListComplete.getUnitModel(), gseListComplete.getUnitIdentityValue(), gseListComplete.getUnitTypeIdentityValue(), stateModelId, gseListComplete.getBeginDate(), gseListComplete.getEndDate());
        if (stateModelId == 2010L) {
            block2: for (int i = 0; i < gseListComplete.size(); ++i) {
                GseUsageDTO dto = (GseUsageDTO)gseListComplete.get(i);
                UseUserValue useUser = dto.getUseUserValue();
                long useUserId = -100L;
                if (useUser != null) {
                    useUserId = useUser.getId();
                }
                long basicUnitId = dto.getUnitId();
                GseUsageDTO newdto = dto;
                for (int j = i + 1; j < gseListComplete.size(); ++j) {
                    long basicUnitIdNext;
                    GseUsageDTO dtoNext = (GseUsageDTO)gseListComplete.get(j);
                    UseUserValue useUserNext = dtoNext.getUseUserValue();
                    long useUserIdNext = -100L;
                    if (useUserNext != null) {
                        useUserIdNext = useUserNext.getId();
                    }
                    if (basicUnitId == (basicUnitIdNext = dtoNext.getUnitId().longValue()) && useUserId == useUserIdNext && j != gseListComplete.size() - 1) continue;
                    i = j - 1;
                    GseUsageDTO dtoBefore = (GseUsageDTO)gseListComplete.get(i);
                    newdto.mergeWithStateDTO(dtoBefore);
                    if (dtoNext.getAreaValueEnd() == null) {
                        newdto.mergeWithStateDTO(dtoNext);
                        newdto.setNewEndTime(System.currentTimeMillis());
                        i = j;
                    }
                    gseListCompressed.add(newdto);
                    continue block2;
                }
            }
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(gseListCompressed);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return gseListCompressed;
    }

    private GseUsageDTO getCurrentCacheGseUsage(ArrayList<CurrentStateCacheLocal> caches, long endTime) {
        CurrentStateCacheLocal gseUsageCacheLocal;
        CurrentStateCacheValue value;
        GseUsageDTO dto = null;
        if (caches != null && caches.size() != 0 && (value = (gseUsageCacheLocal = caches.get(0)).getCurrentStateCacheValue()).getBeginTime() <= endTime) {
            UnitDTO unitDTO = DTOFactory.buildUnitDTO(gseUsageCacheLocal.getUnitModel());
            UseUserLocal userLocal = gseUsageCacheLocal.getUseUser();
            UseUserValue useUserValue = null;
            if (userLocal != null) {
                useUserValue = userLocal.getUseUserValue();
            }
            AreaLocal areaLocal = gseUsageCacheLocal.getArea();
            AreaValue areaValue = null;
            if (areaLocal != null) {
                areaValue = areaLocal.getAreaValue();
            }
            dto = new GseUsageDTO(unitDTO, 0L, 0L, value.getState(), value.getStateModelId(), value.getRemark(), value.getBeginTime(), 0L, value.getBeginReceiveTime(), 0L, value.getAreaTrusted(), areaValue, useUserValue);
        }
        return dto;
    }

    private UseUserValue getUseUserForGSE(long userId) {
        UseUserValue useUserValue = null;
        try {
            UseUserLocal user = this.useUserLocalHome.findByPrimaryKey(new UseUserPK(userId));
            useUserValue = user.getUseUserValue();
        }
        catch (Exception e) {
            log.error((Object)"useUserValue could not be found", (Throwable)e);
        }
        return useUserValue;
    }

    private UseGroupValue getUseGroupForGSE(long useGroupId) {
        UseGroupValue useGroupValue = null;
        try {
            UseGroupLocal useGroup = this.useGroupLocalHome.findByPrimaryKey(new UseGroupPK(useGroupId));
            useGroupValue = useGroup.getUseGroupValue();
        }
        catch (Exception e) {
            log.error((Object)"useGroupValue could not be found", (Throwable)e);
        }
        return useGroupValue;
    }

    public UseDTOList getUseHistoryData(Long unitId, long beginTime, long endTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUseHistoryData called with unitId=" + unitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        UseDTOList list = null;
        try {
            UnitModelLocal unitModelLocal = null;
            if (unitId != null) {
                unitModelLocal = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            list = DTOListFactory.buildUseDTOList(unitModelLocal, beginTime, endTime);
            if (endTime < beginTime) {
                return list;
            }
            Collection cacheValues = new ArrayList();
            cacheValues = unitId == null ? this.useCacheLocalHome.findAll() : (!unitModelLocal.getBasic() ? this.useCacheLocalHome.findByUnitGroupId(unitId) : this.useCacheLocalHome.findByUnitId(unitId));
            long current = System.currentTimeMillis();
            endTime = Math.min(current, endTime);
            Collection useHistoryValues = new ArrayList();
            useHistoryValues = unitId == null ? this.useHistoryLocalHome.findAllByTimeOrderByUnitAndBegin(beginTime, endTime) : (!unitModelLocal.getBasic() ? this.useHistoryLocalHome.findByUnitGroupIdOrderByUnitAndBegin(unitId, beginTime, endTime) : this.useHistoryLocalHome.findByUnitIdOrderByBegin(unitId, beginTime, endTime));
            for (UseHistoryLocal useHistoryLocal : useHistoryValues) {
                UseDTO useDTO = DTOFactory.buildUseDTO(useHistoryLocal);
                useDTO.correctTimes(beginTime, endTime);
                list.add(useDTO);
            }
            this.addUseCaches(list, cacheValues, beginTime, endTime);
            Collections.sort(list, new UseComparator());
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)"no values could be found");
        }
        catch (FinderException e) {
            log.error((Object)"Finding postion data values failed", (Throwable)e);
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private UseDTOList addUseCaches(UseDTOList list, Collection<UseCacheLocal> values, long beginTime, long endTime) {
        for (UseCacheLocal useCache : values) {
            UseCacheValue useCacheValue = useCache.getUseCacheValue();
            long cacheBeginTime = useCacheValue.getBeginTime();
            long cacheEndTime = System.currentTimeMillis();
            cacheEndTime = 0L;
            if (cacheBeginTime >= endTime) continue;
            UseHistoryValue useHistoryValue = new UseHistoryValue();
            useHistoryValue.setBeginTime(cacheBeginTime);
            useHistoryValue.setBeginReceiveTime(useCacheValue.getBeginReceiveTime());
            UnitModelLocal unitModelLocal = useCache.getUnitModel();
            UseUserLocal useUserLocal = useCache.getUseUser();
            UseUserValue useUserValue = null;
            if (useUserLocal != null) {
                useUserValue = useUserLocal.getUseUserValue();
            }
            UseGroupLocal useGroupLocal = useCache.getUseGroup();
            UseGroupValue useGroupValue = null;
            if (useGroupLocal != null) {
                useGroupValue = useGroupLocal.getUseGroupValue();
            }
            AreaValue areaValue = null;
            AreaLocal areaLoacal = useCache.getArea();
            if (areaLoacal != null) {
                areaValue = areaLoacal.getAreaValue();
            }
            list.add(DTOFactory.buildUseDTO(unitModelLocal, useUserValue, useGroupValue, cacheBeginTime, cacheEndTime, 0L, 0L, areaValue, null));
        }
        return list;
    }

    public boolean isGeoSpeedMph() {
        return this.geoSpeedMph;
    }

    public AccidentReconstructionDTOList getAccidentReconstructions(Long unitId, Long messageId, Long assignedModelId, long beginTime, long endTime, boolean totalRuntimes, long beginTimeTotalRuntimes) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AccidentReconstructionDTOList called with unitId=" + unitId + " " + "beginTime=" + beginTime + " (" + new Date(beginTime) + ") endTime=" + endTime + " (" + new Date(endTime) + ")"));
        }
        AccidentReconstructionDTOList list = null;
        try {
            UnitModelLocal unitModel = null;
            if (unitId != null) {
                unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            }
            list = DTOListFactory.buildAccidentReconstructionList(unitModel, beginTime, endTime);
            NotificationDTOList messageList = this.getNotifications(unitId, messageId, beginTime, endTime);
            if (log.isDebugEnabled()) {
                log.debug((Object)("NotificationDTOList messageList " + messageList.size()));
            }
            if (messageList.size() == 0) {
                return list;
            }
            StateDTOList stateList = this.getStateData(unitId, assignedModelId, beginTime, endTime, false, true);
            StateDTOList runtimeList = null;
            if (totalRuntimes) {
                runtimeList = this.getStateData(unitId, 2010L, beginTime, endTime, false, true);
            }
            PositionDTOList positionList = this.getPostionData(unitId, beginTime, endTime, false, true);
            StatusDurationsDTOList summaryList = null;
            if (totalRuntimes && beginTimeTotalRuntimes < beginTime) {
                try {
                    this.summarizedDataHome = SummarizedDataFacadeUtil.getLocalHome().create();
                    summaryList = this.summarizedDataHome.getDurationsSummarized(unitId, 2010L, beginTimeTotalRuntimes, beginTime, true);
                }
                catch (CreateException e) {
                    log.error((Object)"runs into", (Throwable)e);
                    e.printStackTrace();
                }
                catch (NamingException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
            for (int index = 0; index != messageList.size(); ++index) {
                NotificationDTO notification = (NotificationDTO)messageList.get(index);
                long unitModelId = notification.getUnitId();
                long accidentTime = notification.getCreateTime();
                StateDTO state = null;
                for (int i = 0; i < stateList.size() && (accidentTime < (state = (StateDTO)stateList.get(i)).getBeginTime() || accidentTime > state.getEndTime() || state.getUnitId() != unitModelId); ++i) {
                    state = null;
                }
                long totalRuntimeHours = 0L;
                if (totalRuntimes) {
                    for (int i = 0; i < runtimeList.size(); ++i) {
                        StateDTO engineState = (StateDTO)runtimeList.get(i);
                        if (engineState.getUnitId() != unitModelId || engineState.getStateId() != 2012L && engineState.getStateId() != 2013L) continue;
                        if (accidentTime >= engineState.getBeginTime() && accidentTime <= engineState.getEndTime()) {
                            totalRuntimeHours += accidentTime - engineState.getBeginTime();
                            break;
                        }
                        totalRuntimeHours += engineState.getDuration();
                    }
                }
                if (totalRuntimes && summaryList != null) {
                    for (int i = 0; i != summaryList.size(); ++i) {
                        StatusDurationsDTO dtoTotalRuntime = (StatusDurationsDTO)summaryList.get(i);
                        if (dtoTotalRuntime.getUnitId() != unitModelId) continue;
                        UnitModelLocal currentUnitUnitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitModelId));
                        totalRuntimeHours += dtoTotalRuntime.getDuration(2013L) + dtoTotalRuntime.getDuration(2012L) + currentUnitUnitModel.getUnitModelValue().getOperativeTimeOffset();
                        break;
                    }
                }
                totalRuntimeHours /= 3600000L;
                PositionDTO position = null;
                for (int j = 0; j != positionList.size(); ++j) {
                    position = (PositionDTO)positionList.get(j);
                    if (accidentTime >= position.getBeginTime() && accidentTime <= position.getEndTime()) {
                        if (position.getUnitId() != unitModelId) continue;
                        break;
                    }
                    position = null;
                }
                UnitModelLocal unitModelBasic = this.unitModelHome.findByPrimaryKey(new UnitModelPK(notification.getUnitId()));
                AccidentReconstructionDTO dto = DTOFactory.buildAccidentReconstructionDTO(unitModelBasic, notification, state, position, totalRuntimeHours);
                list.add(dto);
            }
        }
        catch (FinderException e) {
            log.error((Object)"Finding AccidentReconstructionDTOList failed", (Throwable)e);
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("values found: " + list.size()));
        }
        return list;
    }

    public GseProductivityDTOList getProductivityDataForFlightRotations(long beginTime, long endTime, FlightRotationDTOList rotations, boolean mustHaveOnblOffbl) {
        GseProductivityDTOList list = DTOListFactory.buildGseProductivityDTOList(null, beginTime, endTime);
        if (rotations == null) {
            rotations = this.getFlightRotationData(beginTime, endTime, mustHaveOnblOffbl);
        }
        for (int j = 0; j < rotations.size(); ++j) {
            FlightRotationDTO rotationDTO = (FlightRotationDTO)rotations.get(j);
            HashMap<Long, StateAssignmentDTOList> unitToAssignment = new HashMap<Long, StateAssignmentDTOList>();
            try {
                Collection hValues = this.stateHistoryLocalHome.findByRotationAssignment(rotationDTO.getRotationKey(), 2120L, 2121L, beginTime, endTime);
                hValues.addAll(this.stateHistoryLocalHome.findByRotationAssignment(rotationDTO.getRotationKey(), 2120L, 2122L, beginTime, endTime));
                StateHistoryLocal[] histArr = hValues.toArray(new StateHistoryLocal[hValues.size()]);
                for (int k = 0; k != histArr.length; ++k) {
                    StateHistoryValue stateValue = histArr[k].getStateHistoryValue();
                    long unitId = stateValue.getUnitId();
                    StateAssignmentDTOList arr = (StateAssignmentDTOList)unitToAssignment.get(unitId);
                    if (arr == null) {
                        arr = DTOListFactory.buildStateAssignmentDTOList(rotationDTO.getRotationStart(), rotationDTO.getRotationEnd());
                    }
                    arr.add(DTOFactory.buildStateAssignmentDTO(rotationDTO, histArr[k]));
                    unitToAssignment.put(unitId, arr);
                }
                try {
                    Collection cValues = this.currentStateCacheLocalHome.findByRotationAssignment(rotationDTO.getRotationKey(), 2120L, 2121L, beginTime, endTime);
                    cValues.addAll(this.currentStateCacheLocalHome.findByRotationAssignment(rotationDTO.getRotationKey(), 2120L, 2122L, beginTime, endTime));
                    CurrentStateCacheLocal[] currArr = cValues.toArray(new CurrentStateCacheLocal[cValues.size()]);
                    for (int k = 0; k != currArr.length; ++k) {
                        CurrentStateCacheValue stateValue = currArr[k].getCurrentStateCacheValue();
                        long unitId = stateValue.getUnitId();
                        StateAssignmentDTOList arr = (StateAssignmentDTOList)unitToAssignment.get(unitId);
                        if (arr == null) {
                            arr = DTOListFactory.buildStateAssignmentDTOList(rotationDTO.getRotationStart(), rotationDTO.getRotationEnd());
                        }
                        arr.add(DTOFactory.buildStateAssignmentDTO(rotationDTO, currArr[k]));
                        unitToAssignment.put(unitId, arr);
                    }
                }
                catch (FinderException e1) {
                    log.debug((Object)"runs into", (Throwable)e1);
                }
                StateAssignmentDTO assignmentDto = null;
                for (Map.Entry e : unitToAssignment.entrySet()) {
                    long unitId = (Long)e.getKey();
                    UnitModelLocal uModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
                    StateAssignmentDTOList unitAssignments = (StateAssignmentDTOList)e.getValue();
                    ArrayList<StateDTOList> arrStateDTOList = new ArrayList<StateDTOList>();
                    long totalDuration2012 = 0L;
                    long totalDuration2013 = 0L;
                    for (int k = 0; k != unitAssignments.size(); ++k) {
                        assignmentDto = (StateAssignmentDTO)unitAssignments.get(k);
                        long st = assignmentDto.getStateDTO().getBeginTime();
                        long et = assignmentDto.getStateDTO().getEndTime();
                        StateDTOList stateList = this.getStateData(unitId, 2010L, st, et, true, true);
                        arrStateDTOList.add(stateList);
                        StateDTO dto = null;
                        for (int l = 0; l < stateList.size(); ++l) {
                            dto = (StateDTO)stateList.get(l);
                            if (dto == null) continue;
                            if (dto.getStateId() == 2012L) {
                                totalDuration2012 += dto.getDuration();
                            }
                            if (dto.getStateId() != 2013L) continue;
                            totalDuration2013 += dto.getDuration();
                        }
                    }
                    list.add(DTOFactory.buildGseProductivityDTO(uModel, rotationDTO, arrStateDTOList, totalDuration2012, totalDuration2013));
                }
                continue;
            }
            catch (FinderException e1) {
                log.debug((Object)"runs into", (Throwable)e1);
            }
        }
        try {
            this.permissionCheckerLocalHome.create().checkDTOList(list);
        }
        catch (CreateException e) {
            log.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public FlightRotationDTOList getFlightRotationData(long beginTime, long endTime, boolean mustHaveOnblOffbl) {
        FlightRotationDTOList list = new FlightRotationDTOList(beginTime, endTime);
        Collection cFlightValues = new ArrayList();
        Collection hFlightValues = new ArrayList();
        HashMap<String, ArrayList<FlightDTO>> rkey = new HashMap<String, ArrayList<FlightDTO>>();
        try {
            String key;
            cFlightValues = this.fisFlightCacheLocalHome.findFlightsByEstimatedAndScheduled(beginTime, endTime);
            FisFlightCacheLocal[] cacheArr = cFlightValues.toArray(new FisFlightCacheLocal[cFlightValues.size()]);
            for (int i = 0; i != cacheArr.length; ++i) {
                FisFlightCacheLocal cFis = cacheArr[i];
                key = cFis.getRotationKey();
                if (key.length() == 0) {
                    key = cFis.getUniqueFlightNumber();
                }
                rkey = this.addFlight(rkey, cFis, key, mustHaveOnblOffbl);
            }
            hFlightValues = this.fisFlightHistoryLocalHome.findFlightsByEstimatedAndScheduled(beginTime, endTime);
            FisFlightHistoryLocal[] histArr = hFlightValues.toArray(new FisFlightHistoryLocal[hFlightValues.size()]);
            for (int i = 0; i != histArr.length; ++i) {
                FisFlightHistoryLocal hFis = histArr[i];
                key = hFis.getRotationKey();
                if (key.length() == 0) {
                    key = hFis.getUniqueFlightNumber();
                }
                rkey = this.addFlight(rkey, hFis, key, mustHaveOnblOffbl);
            }
            for (Map.Entry<String, ArrayList<FlightDTO>> e : rkey.entrySet()) {
                boolean addRotation = true;
                ArrayList<FlightDTO> rotation = e.getValue();
                if (rotation.size() == 1) {
                    FlightDTO value = rotation.get(0);
                    if (value.getAdid().equals("A")) {
                        cFlightValues = this.fisFlightCacheLocalHome.findDepartureFlightForArrival(value.getUrno());
                        hFlightValues = this.fisFlightHistoryLocalHome.findDepartureFlightForArrival(value.getUrno());
                    } else {
                        cFlightValues = this.fisFlightCacheLocalHome.findArrivalFlightForDeparture(value.getRkey());
                        hFlightValues = this.fisFlightHistoryLocalHome.findArrivalFlightForDeparture(value.getRkey());
                    }
                    histArr = hFlightValues.toArray(new FisFlightHistoryLocal[hFlightValues.size()]);
                    cacheArr = cFlightValues.toArray(new FisFlightCacheLocal[cFlightValues.size()]);
                    Object obj = null;
                    if (histArr.length > 0) {
                        obj = histArr[0];
                    } else if (cacheArr.length > 0) {
                        obj = cacheArr[0];
                    }
                    if (obj != null) {
                        if (!mustHaveOnblOffbl) {
                            rotation.add(DTOFactory.buildFlightDTO(obj, this.gseArrivalSetupStartTime, this.gseArrivalSetupEndTimePax, this.gseArrivalSetupEndTimeCgo, this.gseDepartureSetupStartTime, this.gseDepartureSetupEndTime));
                        } else if (this.isFlightOnblOfbl(obj)) {
                            rotation.add(DTOFactory.buildFlightDTO(obj, this.gseArrivalSetupStartTime, this.gseArrivalSetupEndTimePax, this.gseArrivalSetupEndTimeCgo, this.gseDepartureSetupStartTime, this.gseDepartureSetupEndTime));
                        } else {
                            addRotation = false;
                        }
                        if (addRotation) {
                            rkey.put(value.getRkey(), rotation);
                        }
                    }
                }
                if (!addRotation) continue;
                list.add(DTOFactory.buildFlightRotationDTO(rotation));
            }
        }
        catch (FinderException e) {
            log.error((Object)"Finding flightValues failed", (Throwable)e);
        }
        return list;
    }

    private HashMap<String, ArrayList<FlightDTO>> addFlight(HashMap<String, ArrayList<FlightDTO>> rkey, Object flight, String key, boolean mustHaveOnblOffbl) {
        if (mustHaveOnblOffbl && !this.isFlightOnblOfbl(flight)) {
            return rkey;
        }
        ArrayList<FlightDTO> arr = rkey.get(key);
        if (arr == null) {
            arr = new ArrayList();
        }
        arr.add(DTOFactory.buildFlightDTO(flight, this.gseArrivalSetupStartTime, this.gseArrivalSetupEndTimePax, this.gseArrivalSetupEndTimeCgo, this.gseDepartureSetupStartTime, this.gseDepartureSetupEndTime));
        rkey.put(key, arr);
        return rkey;
    }

    private boolean isFlightOnblOfbl(Object flightLocal) {
        FisFlightCacheLocal loc;
        return !(flightLocal instanceof FisFlightCacheLocal ? (loc = (FisFlightCacheLocal)flightLocal).getArrivalDeparture().equals("A") && loc.getOnBlockTime() == 0L || loc.getArrivalDeparture().equals("D") && loc.getOffBlockTime() == 0L : flightLocal instanceof FisFlightHistoryLocal && ((loc = (FisFlightHistoryLocal)flightLocal).getArrivalDeparture().equals("A") && loc.getOnBlockTime() == 0L || loc.getArrivalDeparture().equals("D") && loc.getOffBlockTime() == 0L));
    }
}

