/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data;

import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import de.proveo.wwt.logic.web.historyData.dto.GseUsageDTO;
import de.proveo.wwt.logic.web.historyData.dto.NotificationDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTOList;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastLaneReader {
    private Database database;
    private static final Log log = LogFactory.getLog(FastLaneReader.class);
    private ConfigurationClient configurationClient = new ConfigurationClient();
    private DataSource ds;

    public FastLaneReader() {
        try {
            InitialContext ctx = new InitialContext();
            this.ds = (DataSource)ctx.lookup("java:/wwt");
            DatabaseMetaData metaData = this.ds.getConnection().getMetaData();
            String dataBaseProductName = metaData.getDatabaseProductName();
            log.debug((Object)("DatabaseProductName: " + dataBaseProductName));
            dataBaseProductName = dataBaseProductName.toLowerCase();
            this.database = dataBaseProductName.contains("mysql") ? Database.MySQL : (dataBaseProductName.contains("oracle") ? Database.Oracle : (dataBaseProductName.contains("microsoft sql server") ? Database.MSSQL : Database.Unknown));
            log.debug((Object)("Database SQL Dialect: " + this.database.name()));
        }
        catch (NamingException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    public List stateHistoryFastLaneRead(List list, Long unitId, boolean isBasicUnit, Long stateModelID, long beginTime, long endTime, boolean correctedTimes, boolean isGSEUsageQuery, boolean useGroupHistory) {
        log.debug((Object)"stateHistoryFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "stateHistoryFastLaneRead");
        stopwatch.start("overall");
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection conn = this.ds.getConnection();
            if (conn != null) {
                Statement stmt = conn.createStatement();
                log.debug((Object)"database access fast lane...");
                String sql_opt1 = "";
                String sql_opt2 = "";
                if (this.database.equals((Object)Database.Oracle)) {
                    sql_opt1 = isBasicUnit ? "/*+ index(sh sh_uid_bstamp_estamp) */ " : "/*+ index(sh sh_bstamp_estamp) */ ";
                } else if (this.database.equals((Object)Database.MySQL)) {
                    sql_opt2 = isBasicUnit ? "use index (state_history_idx_unitid_beginstamp_endstamp) " : "use index (state_history_idx_beginstamp_endstamp) ";
                } else if (this.database.equals((Object)Database.MSSQL)) {
                    sql_opt2 = isBasicUnit ? "with (Index (state_history_idx_unitid_beginstamp_endstamp)) " : "with (Index (state_history_idx_beginstamp_endstamp)) ";
                }
                String sql = "SELECT " + sql_opt1 + "sh.STATE_HISTORY_ID, sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.BEGIN_TIME, sh.BEGIN_RECEIVE_TIME, " + "sh.END_TIME, sh.END_RECEIVE_TIME, sh.DURATION, sh.REMARK, sh.AREA_TRUSTED, a.AREA, a.DESCRIPTION as AREA_DESC, " + "ui.NAME, ui.IMAGE_NAME, ut.NAME as TYPE_NAME, ut.IMAGE_NAME as TYPE_IMAGE_NAME, um.BODY_NUMBER, um.REGISTRATION_NUMBER, um.BRAND, um.MODEL_TYPE, um.DELETED, " + " uu.ID as USEUSER_ID, uu.NAME as USEUSER_NAME, uu.PERSONAL_NUMBER, uu.KEY_ID " + "from state_history sh " + sql_opt2 + "LEFT JOIN unit_model um ON sh.UNIT_ID = um.UNIT_ID " + "LEFT JOIN unit_identity ui ON sh.UNIT_ID = ui.UNIT_ID " + "LEFT JOIN unit_typeidentity ut ON um.UNIT_TYPE_ID = ut.ID " + "LEFT JOIN area  a ON sh.AREA = a.AREA " + "LEFT JOIN use_user uu ON sh.USE_USER_ID = uu.ID ";
                String groupSQL = " LEFT JOIN groupHistory gh ON sh.GROUP_HISTORY_ID = gh.GROUP_HISTORY_ID  LEFT JOIN grouphistory_x_unitmodel ghu ON gh.GROUP_HISTORY_ID = ghu.GROUP_HISTORY_ID ";
                String sqlWhereClause = " WHERE sh.STATE_MODEL_ID = " + stateModelID + " AND sh.BEGIN_STAMP <= " + Math.round(Math.ceil(endTime / 86400000L) * 8.64E7) + " AND sh.END_STAMP >= " + Math.round(Math.floor(beginTime / 86400000L) * 8.64E7) + " AND sh.BEGIN_TIME < " + endTime + " AND sh.END_TIME > " + beginTime;
                String sqlStateModelId = " AND sh.STATE_MODEL_ID = " + stateModelID;
                String groupSQLWhereClause = " AND ghu.UNITGROUP_ID = " + unitId;
                String basicUnitSQL = " AND sh.UNIT_ID = " + unitId;
                String orderByBeginTime = " ORDER BY sh.BEGIN_TIME ASC ";
                String orderByUnitIdAndBeginTime = " ORDER BY sh.UNIT_ID ASC, sh.BEGIN_TIME ASC";
                String sqlUnitIdIn = " AND sh." + this.sqlUnitIdInForUnitModelList(unitId);
                if (stateModelID != null) {
                    sqlWhereClause = sqlWhereClause + sqlStateModelId;
                }
                sql = unitId == null ? sql + sqlWhereClause : (isBasicUnit ? sql + sqlWhereClause + basicUnitSQL : (useGroupHistory ? sql + groupSQL + sqlWhereClause + groupSQLWhereClause : sql + sqlWhereClause + sqlUnitIdIn));
                sql = isBasicUnit ? sql + orderByBeginTime : sql + orderByUnitIdAndBeginTime;
                sql = sql.toLowerCase();
                log.debug((Object)("executed SQL: " + sql));
                ResultSet rst = stmt.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("dataBase access", true);
                stopwatch.start("building DTO");
                UnitDTO unitDTO = null;
                UseUserValue useUserValue = null;
                AreaValue areaValue = null;
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (rst.next()) {
                    StateDTO stateDTO;
                    long id = rst.getLong("STATE_HISTORY_ID");
                    long stateUnitId = rst.getLong("UNIT_ID");
                    long stateId = rst.getLong("STATE_ID");
                    long stateModelId = rst.getLong("STATE_MODEL_ID");
                    long shBeginTime = rst.getLong("BEGIN_TIME");
                    long beginReceiveTime = rst.getLong("BEGIN_RECEIVE_TIME");
                    long shEndTime = rst.getLong("END_TIME");
                    long endReceiveTime = rst.getLong("END_RECEIVE_TIME");
                    long duration = rst.getLong("DURATION");
                    String remark = rst.getString("REMARK");
                    if (!(unitDTO != null && isBasicUnit || (unitDTO = (UnitDTO)unitModelMap.get(stateUnitId)) != null)) {
                        unitDTO = this.buildUnitDTO(rst);
                        unitModelMap.put(stateUnitId, unitDTO);
                    }
                    if (isGSEUsageQuery) {
                        boolean areaTrusted = rst.getBoolean("AREA_TRUSTED");
                        areaValue = new AreaValue();
                        areaValue.setArea(rst.getString("AREA"));
                        areaValue.setDescription("AREA_DESC");
                        useUserValue = new UseUserValue();
                        useUserValue.setId(rst.getLong("USEUSER_ID"));
                        useUserValue.setPersonalNumber(rst.getString("PERSONAL_NUMBER"));
                        useUserValue.setName(rst.getString("USEUSER_NAME"));
                        useUserValue.setKey(rst.getString("KEY_ID"));
                        stateDTO = new GseUsageDTO(unitDTO, id, duration, stateId, stateModelId, remark, shBeginTime, shEndTime, beginReceiveTime, endReceiveTime, areaTrusted, areaValue, useUserValue);
                    } else {
                        stateDTO = new StateDTO(unitDTO, id, duration, stateId, stateModelId, remark, shBeginTime, shEndTime, beginReceiveTime, endReceiveTime);
                    }
                    if (correctedTimes) {
                        stateDTO.correctTimes(beginTime, endTime);
                    }
                    list.add(stateDTO);
                    ++dataSize;
                }
                stmt.close();
                rst.close();
                conn.close();
                rst = null;
                stopwatch.stop("building DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return list;
    }

    public PositionDTOList gdataHistoryFastLaneRead(PositionDTOList list, Long unitId, boolean isBasicUnit, long beginTime, long endTime, boolean correctedTimes, boolean fetchExtendedData) {
        log.debug((Object)"gdataHistoryFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "gdataHistoryFastLaneRead");
        stopwatch.start("overall");
        int maxRowsLimit = 0;
        try {
            maxRowsLimit = Integer.parseInt(this.configurationClient.getParameter("maxRowsFetchLimit", "50001"));
        }
        catch (Exception e) {
            log.error((Object)("runs into: " + e));
        }
        log.debug((Object)("maxRowsFetchLimit: " + maxRowsLimit));
        try {
            Connection conn = this.ds.getConnection();
            if (conn != null) {
                Statement stmt = conn.createStatement(1005, 1007);
                log.debug((Object)"database access fast lane...");
                String sql_opt1 = "";
                String sql_opt2 = "";
                if (this.database.equals((Object)Database.Oracle)) {
                    sql_opt1 = isBasicUnit ? "/*+ index(g gh_uid_bstamp_estamp) */ " : "/*+ index(g gh_bstamp_estamp) */ ";
                } else if (this.database.equals((Object)Database.MySQL)) {
                    sql_opt2 = isBasicUnit ? "use index (gdata_history_idx_unitid_beginstamp_endstamp) " : "use index (gdata_history_idx_beginstamp_endstamp) ";
                } else if (this.database.equals((Object)Database.MSSQL)) {
                    sql_opt2 = isBasicUnit ? "with (Index (gdata_history_idx_unitid_beginstamp_endstamp)) " : "with (Index (gdata_history_idx_beginstamp_endstamp)) ";
                }
                String sql = "SELECT " + sql_opt1 + "g.UNIT_ID, g.BEGIN_TIME, g.BEGIN_RECEIVE_TIME, g.END_TIME, g.END_RECEIVE_TIME, " + "g.PK_GDATA_PREVIOUS, g.RMC_REC, g.GGA_REC, g.AREA, g.TRUSTED, g.REASON, g.LONG_MSEC, g.LAT_MSEC, a.DESCRIPTION as AREA_DESCRIPTION, " + "ui.NAME, ui.IMAGE_NAME, ut.NAME as TYPE_NAME, ut.IMAGE_NAME as TYPE_IMAGE_NAME, um.BODY_NUMBER, um.REGISTRATION_NUMBER, um.BRAND, um.MODEL_TYPE, um.DELETED " + "FROM gdata_history g " + sql_opt2 + "LEFT JOIN unit_model um ON g.UNIT_ID = um.UNIT_ID " + "LEFT JOIN unit_identity ui ON g.UNIT_ID = ui.UNIT_ID " + "LEFT JOIN unit_typeidentity ut ON um.UNIT_TYPE_ID = ut.ID " + "LEFT JOIN area  a ON g.AREA = a.AREA ";
                String groupSQL = " LEFT JOIN groupHistory gh ON g.GROUP_HISTORY_ID = gh.GROUP_HISTORY_ID  LEFT JOIN grouphistory_x_unitmodel ghu ON gh.GROUP_HISTORY_ID = ghu.GROUP_HISTORY_ID ";
                String sqlWhereClause = " WHERE g.BEGIN_STAMP <= " + Math.round(Math.ceil(endTime / 86400000L) * 8.64E7) + " AND g.END_STAMP >= " + Math.round(Math.floor(beginTime / 86400000L) * 8.64E7) + " AND g.BEGIN_TIME < " + endTime + " AND g.END_TIME > " + beginTime;
                String groupSQLWhereClause = " AND ghu.UNITGROUP_ID = " + unitId;
                String basicUnitSQL = " AND g.UNIT_ID = " + unitId;
                String limitRowsSQL = "";
                if (this.database.equals((Object)Database.MySQL)) {
                    limitRowsSQL = " LIMIT " + maxRowsLimit;
                } else if (this.database.equals((Object)Database.Oracle)) {
                    limitRowsSQL = " AND ROWNUM <=" + maxRowsLimit;
                }
                sql = unitId == null ? sql + sqlWhereClause : (isBasicUnit ? sql + sqlWhereClause + basicUnitSQL : sql + groupSQL + sqlWhereClause + groupSQLWhereClause);
                if (maxRowsLimit != 0) {
                    sql = sql + limitRowsSQL;
                }
                sql = sql.toLowerCase();
                log.debug((Object)("executed SQL: " + sql));
                stopwatch.start("dataBase access");
                if (this.database.equals((Object)Database.Oracle)) {
                    stmt.setFetchSize(maxRowsLimit);
                }
                ResultSet rst = stmt.executeQuery(sql);
                rst.last();
                int size = rst.getRow();
                rst.beforeFirst();
                stopwatch.stop("dataBase access", true, size);
                if (maxRowsLimit == 0 || size < maxRowsLimit) {
                    PositionDTO positionDTO = null;
                    log.debug((Object)"building DTOs...");
                    stopwatch.start("building DTO");
                    UnitDTO unitDTO = null;
                    long bdataEndTime = 0L;
                    long beginReceiveTime = 0L;
                    long endReceiveTime = 0L;
                    String ggaRec = null;
                    String areaDescr = null;
                    String reason = null;
                    String area = null;
                    String rmcRmcRec = null;
                    int latMSEC = 0;
                    int longMSEC = 0;
                    HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                    while (rst.next()) {
                        area = rst.getString("AREA");
                        long gdataUnitId = rst.getLong("UNIT_ID");
                        areaDescr = rst.getString("AREA_DESCRIPTION");
                        long gdataBeginTime = rst.getLong("BEGIN_TIME");
                        bdataEndTime = rst.getLong("END_TIME");
                        boolean trusted = rst.getBoolean("TRUSTED");
                        beginReceiveTime = rst.getLong("BEGIN_RECEIVE_TIME");
                        endReceiveTime = rst.getLong("END_RECEIVE_TIME");
                        if (fetchExtendedData) {
                            ggaRec = rst.getString("GGA_REC");
                            latMSEC = rst.getInt("LAT_MSEC");
                            longMSEC = rst.getInt("LONG_MSEC");
                            rmcRmcRec = rst.getString("RMC_REC");
                            reason = rst.getString("REASON");
                        }
                        if (!(isBasicUnit && unitDTO != null || (unitDTO = (UnitDTO)unitModelMap.get(gdataUnitId)) != null)) {
                            unitDTO = this.buildUnitDTO(rst);
                            unitModelMap.put(gdataUnitId, unitDTO);
                        }
                        positionDTO = new PositionDTO(unitDTO, gdataBeginTime, bdataEndTime, beginReceiveTime, endReceiveTime, trusted, ggaRec, latMSEC, longMSEC, rmcRmcRec, reason, area, areaDescr);
                        if (correctedTimes) {
                            positionDTO.correctTimes(beginTime, endTime);
                        }
                        list.add(positionDTO);
                    }
                    stmt.close();
                    rst.close();
                    conn.close();
                    rst = null;
                    stopwatch.stop("building DTO", true, size);
                } else {
                    list.setMaxRowsLimit(maxRowsLimit);
                    log.debug((Object)("row limit exceeded: " + maxRowsLimit));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return list;
    }

    private UnitDTO buildUnitDTO(ResultSet rst) {
        UnitDTO unitDTO = null;
        try {
            long shUnitId = rst.getLong("UNIT_ID");
            String unitName = rst.getString("NAME");
            String unitImageName = rst.getString("IMAGE_NAME");
            String typeName = rst.getString("TYPE_NAME");
            String typeImageName = rst.getString("TYPE_IMAGE_NAME");
            String bodyNumber = rst.getString("BODY_NUMBER");
            String regNumber = rst.getString("REGISTRATION_NUMBER");
            String brand = rst.getString("BRAND");
            String modelType = rst.getString("MODEL_TYPE");
            boolean deleted = rst.getBoolean("DELETED");
            UnitModelValue unitModelValue = new UnitModelValue();
            unitModelValue.setUnitId(shUnitId);
            unitModelValue.setBasic(true);
            unitModelValue.setBodyNumber(bodyNumber);
            unitModelValue.setRegistrationNumber(regNumber);
            unitModelValue.setBrand(brand);
            unitModelValue.setModelType(modelType);
            unitModelValue.setDeleted(deleted);
            UnitIdentityValue unitIdentityValue = new UnitIdentityValue();
            unitIdentityValue.setName(unitName);
            unitIdentityValue.setImageName(unitImageName);
            UnitTypeIdentityValue unitTypeIdentity = new UnitTypeIdentityValue();
            unitTypeIdentity.setName(typeName);
            unitTypeIdentity.setImageName(typeImageName);
            unitDTO = new UnitDTO(unitModelValue, unitIdentityValue, unitTypeIdentity);
        }
        catch (SQLException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return unitDTO;
    }

    public List notificationHistoryFastLaneRead(List list, Long unitId, boolean isBasicUnit, Long messageId, long beginTime, long endTime) {
        log.debug((Object)"notificationHistoryFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "notificationHistoryFastLaneRead");
        stopwatch.start("overall");
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection conn = this.ds.getConnection();
            if (conn != null) {
                Statement stmt = conn.createStatement();
                log.debug((Object)"database access fast lane...");
                String sql = "SELECT nh.ID, nh.UNIT_ID, nh.MESSAGE_ID, nh.CREATE_TIME, nh.RECEIVE_TIME,nh.REMARK, a.AREA, a.DESCRIPTION as AREA_DESC, ui.NAME, ui.IMAGE_NAME, ut.NAME as TYPE_NAME, ut.IMAGE_NAME as TYPE_IMAGE_NAME, um.BODY_NUMBER, um.REGISTRATION_NUMBER, um.BRAND, um.MODEL_TYPE, um.DELETED,  uu.ID as USEUSER_ID, uu.NAME as USEUSER_NAME, uu.PERSONAL_NUMBER, uu.KEY_ID from notify_history nh LEFT JOIN unit_model um ON nh.UNIT_ID = um.UNIT_ID LEFT JOIN unit_identity ui ON nh.UNIT_ID = ui.UNIT_ID LEFT JOIN unit_typeidentity ut ON um.UNIT_TYPE_ID = ut.ID LEFT JOIN area  a ON nh.AREA = a.AREA LEFT JOIN use_user uu ON nh.USE_USER_ID = uu.ID ";
                String groupSQL = " LEFT JOIN groupHistory gh ON nh.GROUP_HISTORY_ID = gh.GROUP_HISTORY_ID  LEFT JOIN grouphistory_x_unitmodel ghu ON gh.GROUP_HISTORY_ID = ghu.GROUP_HISTORY_ID ";
                String sqlWhereClause = " WHERE nh.CREATE_TIME < " + endTime + " AND nh.CREATE_TIME > " + beginTime;
                String groupSQLWhereClause = " AND ghu.UNITGROUP_ID = " + unitId;
                String basicUnitSQL = " AND nh.UNIT_ID = " + unitId;
                String orderByBeginTime = " ORDER BY nh.CREATE_TIME ASC ";
                String orderByUnitIdAndBeginTime = " ORDER BY nh.UNIT_ID ASC, nh.CREATE_TIME ASC";
                sql = unitId == null ? sql + sqlWhereClause + orderByBeginTime : (isBasicUnit ? sql + sqlWhereClause + basicUnitSQL : sql + groupSQL + sqlWhereClause + groupSQLWhereClause + orderByBeginTime);
                sql = sql.toLowerCase();
                log.debug((Object)("executed SQL: " + sql));
                ResultSet rst = stmt.executeQuery(sql);
                int dataSize = 0;
                stopwatch.stop("dataBase access", true);
                stopwatch.start("building DTO");
                UnitDTO unitDTO = null;
                UseUserValue useUserValue = null;
                AreaValue areaValue = null;
                HashMap<Long, UnitDTO> unitModelMap = new HashMap<Long, UnitDTO>();
                while (rst.next()) {
                    long id = rst.getLong("ID");
                    long nhUnitId = rst.getLong("UNIT_ID");
                    long nhMessageId = rst.getLong("MESSAGE_ID");
                    long nhCreateTime = rst.getLong("CREATE_TIME");
                    long nhReceiveTime = rst.getLong("RECEIVE_TIME");
                    String remark = rst.getString("REMARK");
                    if (!(unitDTO != null && isBasicUnit || (unitDTO = (UnitDTO)unitModelMap.get(nhUnitId)) != null)) {
                        unitDTO = this.buildUnitDTO(rst);
                        unitModelMap.put(nhUnitId, unitDTO);
                    }
                    areaValue = new AreaValue();
                    areaValue.setArea(rst.getString("AREA"));
                    areaValue.setDescription("AREA_DESC");
                    useUserValue = new UseUserValue();
                    useUserValue.setId(rst.getLong("USEUSER_ID"));
                    useUserValue.setPersonalNumber(rst.getString("PERSONAL_NUMBER"));
                    useUserValue.setName(rst.getString("USEUSER_NAME"));
                    useUserValue.setKey(rst.getString("KEY_ID"));
                    if (messageId != null && messageId != nhMessageId) continue;
                    NotificationDTO notificationDTO = new NotificationDTO(unitDTO, nhMessageId, nhCreateTime, nhReceiveTime, remark, useUserValue, areaValue);
                    list.add(notificationDTO);
                    ++dataSize;
                }
                stmt.close();
                rst.close();
                conn.close();
                rst = null;
                stopwatch.stop("building DTO", true, dataSize);
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return list;
    }

    public Collection<StateSummaryValue> stateSummaryFastLaneRead(Long unitId, boolean isBasicUnit, Long stateModelID, long beginTime, long endTime, int periodType, boolean useGroupHistory) {
        ArrayList<StateSummaryValue> collSummaries = new ArrayList<StateSummaryValue>();
        log.debug((Object)"notificationHistoryFastLaneRead1 called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "notificationHistoryFastLaneRead1");
        stopwatch.start("overall");
        try {
            log.debug((Object)"database access...");
            stopwatch.start("dataBase access");
            Connection conn = this.ds.getConnection();
            if (conn != null) {
                Statement stmt = conn.createStatement();
                log.debug((Object)"database access fast lane...");
                String sql = "SELECT sh.UNIT_ID, sh.STATE_ID, sh.STATE_MODEL_ID, sh.BEGIN_TIME, sh.PERIOD_TYPE, sh.DURATION  from state_summary sh ";
                String sqlTimeframe = " sh.BEGIN_TIME < " + endTime + " AND sh.BEGIN_TIME >= " + beginTime;
                String sqlUnitIdIn = "sh." + this.sqlUnitIdInForUnitModelList(unitId);
                String basicUnitSQL = " sh.UNIT_ID = " + unitId;
                String sqlStateModelId = "";
                if (stateModelID != null) {
                    sqlStateModelId = " AND sh.STATE_MODEL_ID = " + stateModelID;
                }
                String sqlPeriode = " sh.PERIOD_TYPE = " + periodType;
                String orderByBeginTime = " ORDER BY sh.BEGIN_TIME ASC ";
                String orderByUnitIdAndBeginTime = " ORDER BY sh.UNIT_ID ASC, sh.BEGIN_TIME ASC";
                String orderByUnitId = " ORDER BY sh.UNIT_ID ASC";
                String groupHistorySQL = " LEFT JOIN groupHistory gh ON sh.GROUP_HISTORY_ID = gh.GROUP_HISTORY_ID  LEFT JOIN grouphistory_x_unitmodel ghu ON gh.GROUP_HISTORY_ID = ghu.GROUP_HISTORY_ID ";
                String groupHistorySQLWhereClause = " ghu.UNITGROUP_ID = " + unitId;
                sql = unitId == null ? sql + " WHERE " + sqlUnitIdIn + sqlStateModelId + " AND " + sqlPeriode + " AND " + sqlTimeframe + orderByUnitId : (isBasicUnit ? sql + " WHERE " + basicUnitSQL + sqlStateModelId + " AND " + sqlPeriode + " AND " + sqlTimeframe + orderByBeginTime : (useGroupHistory ? sql + groupHistorySQL + " WHERE " + groupHistorySQLWhereClause + sqlStateModelId + " AND " + sqlPeriode + " AND " + sqlTimeframe + orderByUnitId : sql + " WHERE " + sqlUnitIdIn + sqlStateModelId + " AND " + sqlPeriode + " AND " + sqlTimeframe + orderByUnitId));
                sql = sql.toLowerCase();
                log.debug((Object)("executed SQL: " + sql));
                ResultSet rst = stmt.executeQuery(sql);
                stopwatch.stop("dataBase access", true);
                stopwatch.start("building DTO");
                while (rst.next()) {
                    StateSummaryValue value = new StateSummaryValue();
                    long stateUnitId = rst.getLong("UNIT_ID");
                    long stateId = rst.getLong("STATE_ID");
                    long stateModelId = rst.getLong("STATE_MODEL_ID");
                    long shBeginTime = rst.getLong("BEGIN_TIME");
                    long duration = rst.getLong("DURATION");
                    int shPeriode = rst.getInt("PERIOD_TYPE");
                    value.setBeginTime(shBeginTime);
                    value.setStateId(stateId);
                    value.setStateModelId(stateModelId);
                    value.setDuration(duration);
                    value.setPeriodType(shPeriode);
                    value.setUnitId(stateUnitId);
                    collSummaries.add(value);
                }
                stmt.close();
                rst.close();
                conn.close();
                rst = null;
                stopwatch.stop("building DTO", true, collSummaries.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        stopwatch.stop("overall", true);
        return collSummaries;
    }

    private String sqlUnitIdInForUnitModelList(Long unitId) {
        UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
        StringBuilder sb_groupSQLWhereClause = new StringBuilder();
        sb_groupSQLWhereClause.append("UNIT_ID IN (");
        for (int i = 0; i < unitBasicModels.size(); ++i) {
            sb_groupSQLWhereClause.append("'").append(String.valueOf(((UnitModelLocal)unitBasicModels.get(i)).getUnitId())).append("'");
            sb_groupSQLWhereClause.append(i == unitBasicModels.size() - 1 ? ") " : ",");
        }
        return sb_groupSQLWhereClause.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Database {
        MySQL,
        Oracle,
        MSSQL,
        Unknown;

    }
}

