/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.currentData.dto;

import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentAllDTO
extends UnitDTO {
    private static final long serialVersionUID = 1252134622753781528L;
    private CurrentGdataCacheValue position;
    private Long positionDuration;
    private KeepAliveCacheValue keepAliveCacheValue;
    private long keepAliveElapsedtime;
    private CurrentNotifyCacheValue lastNotificaton;
    private boolean timedOut = true;
    private Date createdDate = new Date();
    private HashMap<Long, CurrentNotifyCacheValue> notifications;
    private HashMap<Long, Long> notificationElapsedTime;
    private HashMap<Long, CurrentStateCacheValue> states = new HashMap();
    private HashMap<Long, Long> durations = new HashMap();

    public CurrentAllDTO(UnitModelValue unitModel, UnitIdentityValue unitIdentity, UnitTypeIdentityValue unitTypeIdentityValue) {
        super(unitModel, unitIdentity, unitTypeIdentityValue);
        this.notifications = new HashMap();
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setState(CurrentStateCacheValue state) {
        long stateModelID = state.getStateModelId();
        this.states.put(stateModelID, state);
        this.durations.put(stateModelID, this.createdDate.getTime() - state.getBeginTime());
    }

    public void setPosition(CurrentGdataCacheValue currentGdataCacheValue) {
        this.positionDuration = this.createdDate.getTime() - currentGdataCacheValue.getBeginReceiveTime();
        this.position = currentGdataCacheValue;
    }

    public CurrentGdataCacheValue getPosition() {
        return this.position;
    }

    public Long getPositionDuration() {
        return this.positionDuration;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public KeepAliveCacheValue getKeepAliveCacheValue() {
        return this.keepAliveCacheValue;
    }

    public void setKeepAliveCacheValue(KeepAliveCacheValue keepAliveCacheValue) {
        this.keepAliveElapsedtime = this.createdDate.getTime() - keepAliveCacheValue.getTimeStamp();
        this.keepAliveCacheValue = keepAliveCacheValue;
    }

    public long getKeepAliveDuration() {
        return this.keepAliveElapsedtime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.unitIdentityValue != null) {
            sb.append("Name: ");
            sb.append(this.unitIdentityValue.getName());
            sb.append("\n");
            sb.append("UnitId: ");
            sb.append(this.unitIdentityValue.getUnitId());
            sb.append("\n");
        }
        return sb.toString();
    }

    public CurrentNotifyCacheValue getLastNotificaton() {
        return this.lastNotificaton;
    }

    public void setLastNotificaton(CurrentNotifyCacheValue lastNotificaton) {
        this.lastNotificaton = lastNotificaton;
    }

    public HashMap<Long, Long> getNotificationElapsedTime() {
        return this.notificationElapsedTime;
    }

    public HashMap<Long, Long> getDurations() {
        return this.durations;
    }

    public HashMap<Long, CurrentStateCacheValue> getStates() {
        return this.states;
    }

    public HashMap<Long, CurrentNotifyCacheValue> getNotifications() {
        return this.notifications;
    }

    public CurrentStateCacheValue getOperationStatus() {
        return this.states.get(2050L);
    }

    public Long getOperationStatusDuration() {
        return this.durations.get(2050L);
    }

    public CurrentStateCacheValue getMotorStatus() {
        return this.states.get(2010L);
    }

    public Long getMotorStatusDuration() {
        return this.durations.get(2010L);
    }

    public CurrentStateCacheValue getConnectorStatus() {
        return this.states.get(2020L);
    }

    public CurrentStateCacheValue getAssignedStatus() {
        return this.states.get(2100L);
    }

    public CurrentStateCacheValue getFlag1Status() {
        return this.states.get(2910L);
    }

    public CurrentStateCacheValue getFlag2Status() {
        return this.states.get(2920L);
    }

    public CurrentStateCacheValue getFlag3Status() {
        return this.states.get(2930L);
    }

    public Long getConnectorStatusDuration() {
        return this.durations.get(2020L);
    }

    public CurrentStateCacheValue getServiceStatus() {
        return this.states.get(2090L);
    }

    public Long getServiceStatusDuration() {
        return this.durations.get(2090L);
    }

    public CurrentStateCacheValue getFuelStatus() {
        return this.states.get(2030L);
    }

    public Long getFuelStatusDuration() {
        return this.durations.get(2030L);
    }

    public Long getFlag1StatusDuration() {
        return this.durations.get(2910L);
    }

    public Long getFlag2StatusDuration() {
        return this.durations.get(2920L);
    }

    public Long getFlag3StatusDuration() {
        return this.durations.get(2930L);
    }

    public Long getAssignedSttausDuration() {
        return this.durations.get(2100L);
    }
}

