/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.commonData;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.state.StateModel;
import de.proveo.wwt.logic.app.state.StateModelFactory;
import de.proveo.wwt.logic.app.state.aviation.AviationStateModelConstants;
import de.proveo.wwt.logic.app.state.exception.StateModelNotFoundException;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.commonData.dto.UnitDTOList;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocalHome;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonDataFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = -1747561574171800108L;
    private UnitModelLocalHome unitModelLocalHome;
    private UnitIdentityLocalHome unitIdentityLocalHome;
    private UnitTypeIdentityLocalHome unitTypeIdentityLocalHome;
    private PermissionCheckerLocalHome permissionCheckerLocalHome;
    private AreaLocalHome areaLocalHome;
    private static final Log log = LogFactory.getLog(CommonDataFacadeBean.class);

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.unitModelLocalHome = UnitModelUtil.getLocalHome();
            this.unitIdentityLocalHome = UnitIdentityUtil.getLocalHome();
            this.unitTypeIdentityLocalHome = UnitTypeIdentityUtil.getLocalHome();
            this.areaLocalHome = AreaUtil.getLocalHome();
            this.permissionCheckerLocalHome = PermissionCheckerUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public UnitDTO getUnit(long unitId) {
        UnitDTO unitDTO = null;
        try {
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
            unitDTO = DTOFactory.buildUnitDTO(unitModel);
        }
        catch (FinderException e) {
            log.warn((Object)("Unit/group not found: " + String.valueOf(unitId)));
        }
        return unitDTO;
    }

    public UnitDTO getUnitDTOByCustomerUnitId(String customerUnitId) throws FinderException {
        UnitDTO unitDTO = null;
        Collection col = this.unitModelLocalHome.findByCustomerUnitId(customerUnitId);
        Iterator it = col.iterator();
        if (it.hasNext()) {
            UnitModelLocal unitModel = (UnitModelLocal)it.next();
            unitDTO = DTOFactory.buildUnitDTO(unitModel);
            return unitDTO;
        }
        throw new FinderException("could not find unit with customerUnitId=" + customerUnitId);
    }

    public UnitDTO getUnitDTOByName(String unitName) throws FinderException {
        UnitDTO unitDTO = null;
        Collection col = this.unitIdentityLocalHome.findByName(unitName);
        Iterator it = col.iterator();
        if (it.hasNext()) {
            UnitIdentityLocal unitIdentity = (UnitIdentityLocal)it.next();
            unitDTO = DTOFactory.buildUnitDTO(unitIdentity);
            return unitDTO;
        }
        throw new FinderException("could not find unit with unitName=" + unitName);
    }

    public UnitDTOList getUnitsByIsBasic(Boolean isBasic, boolean filtered) {
        return this.getUnitsByIsBasic(isBasic, true, true);
    }

    public UnitDTOList getUnitsByIsBasic(Boolean isBasic, boolean filtered, boolean filterDeleted) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUnitsByIsBasic isBasic: " + isBasic));
        }
        UnitDTOList list = null;
        try {
            Collection unitModels = filterDeleted ? this.unitModelLocalHome.findyByIsBasic(isBasic) : this.unitModelLocalHome.findyAllByIsBasicAlsoDeleted(isBasic);
            list = new UnitDTOList();
            for (UnitModelLocal unit : unitModels) {
                list.add(DTOFactory.buildUnitDTO(unit));
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        if (filtered) {
            try {
                this.permissionCheckerLocalHome.create().checkDTOList(list);
            }
            catch (CreateException e) {
                log.debug((Object)"runs into", (Throwable)e);
            }
        }
        return list;
    }

    public UnitDTOList getAllDeletedUnits() {
        UnitDTOList list = null;
        try {
            Collection unitModels = this.unitModelLocalHome.findAllDeletedUnits();
            list = new UnitDTOList();
            for (UnitModelLocal unit : unitModels) {
                list.add(DTOFactory.buildUnitDTO(unit));
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<Long> getUnitIdsByIsBasic(boolean isBasic) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getUnitsByIsBasic isBasic: " + isBasic));
        }
        ArrayList<Long> list = null;
        try {
            Collection unitModels = this.unitModelLocalHome.findyByIsBasic(isBasic);
            list = new ArrayList<Long>();
            for (UnitModelLocal unit : unitModels) {
                list.add(unit.getUnitId());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<UnitTypeIdentityValue> getUnitTypeGroups() {
        ArrayList<UnitTypeIdentityValue> list = null;
        try {
            Collection collection = this.unitTypeIdentityLocalHome.findAll();
            list = new ArrayList<UnitTypeIdentityValue>();
            for (UnitTypeIdentityLocal unit : collection) {
                UnitTypeIdentityValue value = unit.getUnitTypeIdentityValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<AreaValue> getAllAreas() {
        log.debug((Object)"getAllAreas called");
        ArrayList<AreaValue> list = null;
        try {
            Collection areas = this.areaLocalHome.findOrderedByPriority();
            list = new ArrayList<AreaValue>();
            for (AreaLocal area : areas) {
                list.add(area.getAreaValue());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public String[] getAllBasicUnitNames() {
        log.debug((Object)"getAllBasicUnitNames");
        TreeSet<String> set = null;
        try {
            Collection unitModels = this.unitModelLocalHome.findyByIsBasic(true);
            set = new TreeSet<String>();
            for (UnitModelLocal unit : unitModels) {
                UnitIdentityValue unitIdentity = unit.getUnitIdentity().getUnitIdentityValue();
                set.add(unitIdentity.getUnitKind());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return set.toArray(new String[set.size()]);
    }

    public HashMap<Long, List<Long>> getAllStates() {
        log.debug((Object)"getAllStates");
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        StateModelFactory s = new StateModelFactory();
        long[] stateModelIDs = AviationStateModelConstants.POSSIBLE_STATES;
        for (int i = 0; i < stateModelIDs.length; ++i) {
            ArrayList<Long> list = new ArrayList<Long>();
            Long stateModelId = stateModelIDs[i];
            try {
                StateModel model = s.getStateModel(stateModelId, 0L);
                long[] stateIds = model.getPossibleStates();
                for (int j = 0; j < stateIds.length; ++j) {
                    list.add(stateIds[j]);
                }
                map.put(stateModelId, list);
                continue;
            }
            catch (StateModelNotFoundException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        return map;
    }

    public List<UnitDTO> getByUnitIdWithGroupId() {
        Collection unitModels = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"getByUnitIdWithGroupId commondataprovider: ");
        }
        ArrayList<UnitDTO> list = null;
        try {
            unitModels = this.unitModelLocalHome.getByUnitIdWithGroupId();
            list = new ArrayList<UnitDTO>();
            for (UnitModelLocal unit : unitModels) {
                list.add(DTOFactory.buildUnitDTO(unit));
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }
}

