/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.helper;

import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitListFactory {
    private static final Log logger = LogFactory.getLog(UnitListFactory.class);
    private static UnitModelLocalHome unitModelLocalHome;

    public static UnitDTOListBase<UnitModelLocal> generateUnitModelList(Long unitId) {
        ArrayList<UnitModelLocal> coll = null;
        UnitModelValue unitModelValue = null;
        UnitIdentityValue unitIdentityValue = null;
        UnitTypeIdentityValue unitTypeIdentityValue = null;
        try {
            if (unitModelLocalHome == null) {
                unitModelLocalHome = UnitModelUtil.getLocalHome();
            }
            if (unitId == null) {
                coll = unitModelLocalHome.findyByIsBasic(true);
            } else {
                coll = new ArrayList<UnitModelLocal>();
                UnitModelLocal unitModel = unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
                UnitListFactory.generateUnitModelList(unitModel, coll);
                unitModelValue = unitModel.getUnitModelValue();
                unitIdentityValue = unitModel.getUnitIdentity().getUnitIdentityValue();
                if (unitModelValue.getBasic()) {
                    unitTypeIdentityValue = unitModel.getUnitTypeIdentity().getUnitTypeIdentityValue();
                }
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        UnitDTOListBase<UnitModelLocal> list = new UnitDTOListBase<UnitModelLocal>(unitModelValue, unitIdentityValue, unitTypeIdentityValue);
        list.addAll(coll);
        return list;
    }

    public static Collection<UnitModelLocal> generateUnitModelList(UnitModelLocal unitModel, Collection<UnitModelLocal> unitModels) {
        boolean isBasic = unitModel.getUnitModelValue().getBasic();
        if (!isBasic) {
            Collection coll = unitModel.getChildUnits();
            for (UnitModelLocal childUnit : coll) {
                UnitListFactory.generateUnitModelList(childUnit, unitModels);
            }
        } else if (!unitModels.contains(unitModel)) {
            unitModels.add(unitModel);
        }
        return unitModels;
    }

    private static List generateUnitModelGroupList(UnitModelLocal unitGroup, List<UnitModelLocal> unitModels) {
        if (!unitGroup.getUnitModelValue().getBasic()) {
            Collection coll = unitGroup.getChildUnits();
            unitModels.add(unitGroup);
            for (UnitModelLocal group : coll) {
                UnitListFactory.generateUnitModelGroupList(group, unitModels);
            }
        }
        return unitModels;
    }

    public static List<UnitModelLocal> generateUnitModelList(UnitModelLocal unitModel, Long filterState, List<UnitModelLocal> unitModels) {
        try {
            if (unitModelLocalHome == null) {
                unitModelLocalHome = UnitModelUtil.getLocalHome();
            }
            List unitGroups = UnitListFactory.generateUnitModelGroupList(unitModel, new ArrayList<UnitModelLocal>());
            for (UnitModelLocal unitModelLocal : unitGroups) {
                UnitModelValue value = unitModelLocal.getUnitModelValue();
                if (!value.getBasic()) {
                    Collection coll = filterState == null ? unitModelLocalHome.findyByParentUnitId(unitModelLocal.getUnitId()) : unitModelLocalHome.findyByParentUnitIdAndFilterStateId(unitModelLocal.getUnitId(), filterState);
                    for (UnitModelLocal childUnit : coll) {
                        if (!childUnit.getUnitModelValue().getBasic()) continue;
                        unitModels.add(childUnit);
                    }
                    continue;
                }
                unitModels.add(unitModelLocal);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return unitModels;
    }

    public static List<UnitModelLocal> generateUnitModelList(UnitModelLocal unitModel, String unitKind, String position, Boolean trusted, List<UnitModelLocal> unitModels) {
        try {
            if (unitModelLocalHome == null) {
                unitModelLocalHome = UnitModelUtil.getLocalHome();
            }
            List unitGroups = UnitListFactory.generateUnitModelGroupList(unitModel, new ArrayList<UnitModelLocal>());
            for (UnitModelLocal unitModelLocal : unitGroups) {
                UnitModelValue value = unitModelLocal.getUnitModelValue();
                if (!value.getBasic()) {
                    Collection coll = unitModelLocalHome.findByParentUnitIdFilterByTypeAndPositionAndTrusted(unitModelLocal.getUnitId(), unitKind, position, trusted);
                    for (UnitModelLocal childUnit : coll) {
                        if (!childUnit.getUnitModelValue().getBasic()) continue;
                        unitModels.add(childUnit);
                    }
                    continue;
                }
                unitModels.add(unitModelLocal);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return unitModels;
    }
}

