/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.admin;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeUtil;
import de.proveo.wwt.logic.ejb.general.infoman.setup.InfomanSetupHistoryValue;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateDescriptionValue;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateLocal;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateLocalHome;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdatePK;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateUtil;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDescriptionValue;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareLocal;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareLocalHome;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwarePK;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.web.admin.CurrentInfomanSetupDTO;
import de.proveo.wwt.logic.web.admin.CurrentInfomanSetupDTOList;
import de.proveo.wwt.logic.web.admin.InfomanSetupHistoryDTO;
import de.proveo.wwt.logic.web.admin.InfomanSetupHistoryDTOList;
import de.proveo.wwt.logic.web.admin.InfomanSoftwareDescriptionDTO;
import de.proveo.wwt.logic.web.admin.InfomanSoftwareDescriptionDTOList;
import de.proveo.wwt.logic.web.admin.ScheduledInfomanUpdateDTO;
import de.proveo.wwt.logic.web.admin.ScheduledInfomanUpdateDTOList;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdminInfomanSetupFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(AdminInfomanSetupFacadeBean.class);
    private UnitModelLocalHome unitModelLocalHome;
    private InfomanSetupFacadeLocal infomanSetupFacade;
    private InfomanSoftwareLocalHome infomanSoftwareHome;
    private ScheduledInfomanUpdateLocalHome scheduledInfomanUpdateHome;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.unitModelLocalHome = UnitModelUtil.getLocalHome();
            this.infomanSetupFacade = InfomanSetupFacadeUtil.getLocalHome().create();
            this.infomanSoftwareHome = InfomanSoftwareUtil.getLocalHome();
            this.scheduledInfomanUpdateHome = ScheduledInfomanUpdateUtil.getLocalHome();
        }
        catch (NamingException ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new EJBException("runs during lookup ejb refs into", (Exception)ex);
        }
    }

    public CurrentInfomanSetupDTOList getCurrentInfomanSetups(Long unitId) {
        UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
        CurrentInfomanSetupDTOList list = new CurrentInfomanSetupDTOList(unitBasicModels.getUnitModel(), unitBasicModels.getUnitIdentityValue(), unitBasicModels.getUnitTypeIdentityValue());
        for (UnitModelLocal childUnitModel : unitBasicModels) {
            if (childUnitModel.getCurrentInfomanSetup() == null) continue;
            CurrentInfomanSetupDTO dto = new CurrentInfomanSetupDTO(childUnitModel.getUnitModelValue(), childUnitModel.getUnitIdentity().getUnitIdentityValue(), childUnitModel.getUnitTypeIdentity().getUnitTypeIdentityValue(), childUnitModel.getCurrentInfomanSetup().getCurrentInfomanSetupValue());
            list.add(dto);
        }
        return list;
    }

    public InfomanSetupHistoryDTOList getConfigurationHistory(Long unitId) throws FinderException {
        UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
        InfomanSetupHistoryDTOList list = new InfomanSetupHistoryDTOList(unitBasicModels.getUnitModel(), unitBasicModels.getUnitIdentityValue(), unitBasicModels.getUnitTypeIdentityValue());
        for (UnitModelLocal childUnitModel : unitBasicModels) {
            List<InfomanSetupHistoryValue> versions = this.infomanSetupFacade.getConfigurationHistory(childUnitModel.getUnitId(), 0L, System.currentTimeMillis());
            Iterator<InfomanSetupHistoryValue> it = versions.iterator();
            while (it.hasNext()) {
                InfomanSetupHistoryDTO dto = new InfomanSetupHistoryDTO(childUnitModel.getUnitModelValue(), childUnitModel.getUnitIdentity().getUnitIdentityValue(), childUnitModel.getUnitTypeIdentity().getUnitTypeIdentityValue(), it.next());
                list.add(dto);
            }
        }
        return list;
    }

    public void resetUpToDateFlag(long unitId) {
        this.infomanSetupFacade.resetUpToDateFlag(unitId);
    }

    public void deleteInfomanSoftware(long softwareId) throws ObjectNotFoundException, RemoveException {
        this.infomanSetupFacade.deleteInfomanSoftware(softwareId);
    }

    public InfomanSoftwareDescriptionDTOList getAvailableInfomanSoftwareDTOs() {
        InfomanSoftwareDescriptionDTOList list = new InfomanSoftwareDescriptionDTOList(null, null, null);
        List<InfomanSoftwareDescriptionValue> infomanSoftware = this.infomanSetupFacade.getAvailableInfomanSoftware();
        Iterator<InfomanSoftwareDescriptionValue> it = infomanSoftware.iterator();
        while (it.hasNext()) {
            InfomanSoftwareDescriptionDTO dto = new InfomanSoftwareDescriptionDTO(it.next());
            list.add(dto);
        }
        return list;
    }

    public Collection<InfomanSoftwareDescriptionValue> getAvailableInfomanSoftware() {
        return this.infomanSetupFacade.getAvailableInfomanSoftware();
    }

    public InfomanSoftwareDescriptionDTO createInfomanSoftware(InfomanSoftwareDescriptionDTO dto) throws CreateException {
        InfomanSoftwareDescriptionValue value = dto.getInfomanSoftwareDescription();
        InfomanSoftwareLocal infomanSoftware = this.infomanSoftwareHome.create(value);
        return new InfomanSoftwareDescriptionDTO(infomanSoftware.getInfomanSoftwareDescriptionValue());
    }

    public void updateInfomanSoftware(InfomanSoftwareDescriptionDTO dto) throws ObjectNotFoundException {
        try {
            InfomanSoftwareLocal infomanSoftware = this.infomanSoftwareHome.findByPrimaryKey(new InfomanSoftwarePK(dto.getInfomanSoftwareDescription().getId()));
            infomanSoftware.setInfomanSoftwareDescriptionValue(dto.getInfomanSoftwareDescription());
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            log.error((Object)"getSoftwareArchive() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public void setSoftwareArchive(long softwareId, byte[] softwareArchive) throws ObjectNotFoundException {
        try {
            InfomanSoftwareLocal infomanSoftware = this.infomanSoftwareHome.findByPrimaryKey(new InfomanSoftwarePK(softwareId));
            infomanSoftware.setSoftware(softwareArchive);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            log.error((Object)"getSoftwareArchive() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public byte[] getSoftwareArchive(long softwareId) throws ObjectNotFoundException {
        try {
            InfomanSoftwareLocal infomanSoftware = this.infomanSoftwareHome.findByPrimaryKey(new InfomanSoftwarePK(softwareId));
            return infomanSoftware.getSoftware();
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            log.error((Object)"getSoftwareArchive() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public ScheduledInfomanUpdateDTOList getScheduledInfomanUpdates(Long unitId) {
        UnitDTOListBase<UnitModelLocal> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
        ScheduledInfomanUpdateDTOList list = new ScheduledInfomanUpdateDTOList(unitBasicModels.getUnitModel(), unitBasicModels.getUnitIdentityValue(), unitBasicModels.getUnitTypeIdentityValue());
        for (UnitModelLocal childUnitModel : unitBasicModels) {
            if (childUnitModel.getScheduledInfomanUpdates() == null) continue;
            for (ScheduledInfomanUpdateLocal infomanUpdate : childUnitModel.getScheduledInfomanUpdates()) {
                InfomanSoftwareLocal isl = infomanUpdate.getInfomanSoftware();
                AccountLocal account = infomanUpdate.getAccount();
                ScheduledInfomanUpdateDTO dto = new ScheduledInfomanUpdateDTO(childUnitModel.getUnitModelValue(), childUnitModel.getUnitIdentity().getUnitIdentityValue(), childUnitModel.getUnitTypeIdentity().getUnitTypeIdentityValue(), infomanUpdate.getScheduledInfomanUpdateDescriptionValue(), isl == null ? null : isl.getInfomanSoftwareDescriptionValue());
                if (account != null) {
                    dto.setAccountValue(account.getAccountValue());
                }
                list.add(dto);
            }
        }
        return list;
    }

    public ScheduledInfomanUpdateDTO createScheduledInfomanUpdate(ScheduledInfomanUpdateDTO dto, long softwareId) throws CreateException, FinderException {
        ScheduledInfomanUpdateDescriptionValue value = dto.getScheduledInfomanUpdateDescriptionValue();
        ScheduledInfomanUpdateLocal update = this.scheduledInfomanUpdateHome.create(value);
        InfomanSoftwareLocal infomanSoftware = this.infomanSoftwareHome.findByPrimaryKey(new InfomanSoftwarePK(softwareId));
        update.setInfomanSoftware(infomanSoftware);
        return new ScheduledInfomanUpdateDTO(null, null, null, update.getScheduledInfomanUpdateDescriptionValue(), update.getInfomanSoftware().getInfomanSoftwareDescriptionValue());
    }

    public void setConfiguration(long updateId, byte[] configuration) throws ObjectNotFoundException {
        try {
            ScheduledInfomanUpdateLocal update = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(updateId));
            update.setConfiguration(configuration);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            log.error((Object)"getSoftwareArchive() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public byte[] getConfiguration(long updateId) throws ObjectNotFoundException {
        try {
            ScheduledInfomanUpdateLocal update = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(updateId));
            return update.getConfiguration();
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            log.error((Object)"getSoftwareArchive() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public void updateScheduledInfomanUpdate(ScheduledInfomanUpdateDTO dto) throws ObjectNotFoundException {
        try {
            ScheduledInfomanUpdateLocal update = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(dto.getScheduledInfomanUpdateDescriptionValue().getId()));
            update.setScheduledInfomanUpdateDescriptionValue(dto.getScheduledInfomanUpdateDescriptionValue());
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            log.error((Object)"getSoftwareArchive() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public void removeScheduledInfomanUpdate(long updateId) throws RemoveException, ObjectNotFoundException {
        try {
            ScheduledInfomanUpdateLocal update = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(updateId));
            update.remove();
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            log.error((Object)"getSoftwareArchive() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }
}

