/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.admin;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryUtil;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditdataLocal;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditdataLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditdataUtil;
import de.proveo.wwt.logic.ejb.dataOut.audit.AuditdataValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.groupanduser.GroupMemberLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.groupanduser.GroupMemberLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.groupanduser.GroupMemberUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.groupanduser.GroupMemberValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RolePK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentAreaValue;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentFacadeLocal;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentFacadeUtil;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocalHome;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterLocalHome;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterPK;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterUtil;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterValue;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageLocal;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageLocalHome;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStoragePK;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageUtil;
import de.proveo.wwt.logic.ejb.general.fileStorage.FileStorageValue;
import de.proveo.wwt.logic.ejb.general.notification.NotificationLocal;
import de.proveo.wwt.logic.ejb.general.notification.NotificationLocalHome;
import de.proveo.wwt.logic.ejb.general.notification.NotificationPK;
import de.proveo.wwt.logic.ejb.general.notification.NotificationUtil;
import de.proveo.wwt.logic.ejb.general.notification.NotificationValue;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportLocal;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportLocalHome;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportPK;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportUtil;
import de.proveo.wwt.logic.ejb.general.scheduledReports.GeneratedReportValue;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportLocal;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportLocalHome;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportPK;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportUtil;
import de.proveo.wwt.logic.ejb.general.scheduledReports.ScheduledReportValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocal;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocalHome;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupPK;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupUtil;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserPK;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.admin.AdminStartpageDTO;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeUtil;
import de.proveo.wwt.logic.web.admin.permission.SectionRoleDTO;
import de.proveo.wwt.logic.web.admin.permission.SectionRoleNode;
import de.proveo.wwt.logic.web.admin.scheduledReports.GeneratedReportDTO;
import de.proveo.wwt.logic.web.admin.scheduledReports.ReportBaseDTO;
import de.proveo.wwt.logic.web.admin.scheduledReports.ReportDTOList;
import de.proveo.wwt.logic.web.common.ApplicationType;
import de.proveo.wwt.logic.web.common.ParameterDetails;
import de.proveo.wwt.logic.web.common.ParameterInputType;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocal;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeUtil;
import de.proveo.wwt.logic.web.commonData.dto.UnitDTOList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdminFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(AdminFacadeBean.class);
    private static final String auditAppl = "RTSWEB";
    private static final String CONFIG_PARAM_AUDIT_TRAIL = "auditdata.activated";
    private static final String FILTER_OUT_SUPERADMIN = "filterOutSuperadmin";
    private static final String RESOURCE_ENTRY_FOR_SECTIONROLES = "section.";
    private boolean auditTrail = false;
    private boolean filterOutSuperadmin = false;
    private AccountLocalHome accountHome = null;
    private AreaLocalHome areaLocalHome = null;
    private GroupIdentLocalHome groupIdentHome = null;
    private UnitModelLocalHome unitModelLocalHome = null;
    private GroupMemberLocalHome groupMemberHome = null;
    private RoleLocalHome roleHome = null;
    private UseGroupLocalHome useGroupHome = null;
    private UseUserLocalHome useUserHome = null;
    private CommonDataFacadeLocal commonData;
    private GrouphistoryLocalHome grouphistoryHome;
    private ScheduledReportLocalHome scheduledReportLocalHome;
    private AuditdataLocalHome auditdataHome = null;
    private ConfigurationLocalHome configurationHome = null;
    private GeneratedReportLocalHome generatedReportLocalHome = null;
    private NotificationLocalHome notificationLocalHome = null;
    private ConfigurationParameterLocalHome configurationParameterLocalHome;
    private ConfigurationLocal configuration;
    private AdjustmentFacadeLocal adjustmentFacadeLocal;
    private FileStorageLocalHome fileStorageLocal;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.accountHome = AccountUtil.getLocalHome();
            this.areaLocalHome = AreaUtil.getLocalHome();
            this.groupIdentHome = GroupIdentUtil.getLocalHome();
            this.groupMemberHome = GroupMemberUtil.getLocalHome();
            this.unitModelLocalHome = UnitModelUtil.getLocalHome();
            this.roleHome = RoleUtil.getLocalHome();
            this.useGroupHome = UseGroupUtil.getLocalHome();
            this.useUserHome = UseUserUtil.getLocalHome();
            this.commonData = CommonDataFacadeUtil.getLocalHome().create();
            this.grouphistoryHome = GrouphistoryUtil.getLocalHome();
            this.scheduledReportLocalHome = ScheduledReportUtil.getLocalHome();
            this.auditdataHome = AuditdataUtil.getLocalHome();
            this.generatedReportLocalHome = GeneratedReportUtil.getLocalHome();
            this.notificationLocalHome = NotificationUtil.getLocalHome();
            this.configurationParameterLocalHome = ConfigurationParameterUtil.getLocalHome();
            this.adjustmentFacadeLocal = AdjustmentFacadeUtil.getLocalHome().create();
            this.fileStorageLocal = FileStorageUtil.getLocalHome();
            this.configurationHome = ConfigurationUtil.getLocalHome();
            this.configuration = this.configurationHome.create();
            try {
                String param = this.configuration.getParameter(CONFIG_PARAM_AUDIT_TRAIL);
                if (param.length() > 0) {
                    this.auditTrail = Boolean.parseBoolean(param);
                }
                if ((param = this.configuration.getParameter(FILTER_OUT_SUPERADMIN)).length() > 0) {
                    this.filterOutSuperadmin = Boolean.parseBoolean(param);
                }
            }
            catch (ConfigurationParameterNotFoundException e) {
                logger.error((Object)"parameter for auditdata missed, changes wont be logged into auditdata");
            }
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public AdminStartpageDTO getAdminStartpageDTO() {
        AdminStartpageDTO adminStartpageDTO = new AdminStartpageDTO();
        adminStartpageDTO.setUserCount(this.getAllUsers().size());
        adminStartpageDTO.setUserGroupCount(this.getAllUserGroups().size());
        adminStartpageDTO.setUseUserGroupCount(this.getAllUseGroups().size());
        adminStartpageDTO.setUseUserCount(this.getAllUseUsers().size());
        adminStartpageDTO.setBasicUnitCount(this.commonData.getUnitsByIsBasic(true, false).size());
        adminStartpageDTO.setNotBasicUnitCount(this.commonData.getUnitsByIsBasic(false, false).size());
        List<RoleValue> list = this.getAllRoles();
        ArrayList<RoleValue> filteredList = new ArrayList<RoleValue>();
        for (RoleValue value : list) {
            if (value.getRolename().startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
            filteredList.add(value);
        }
        adminStartpageDTO.setRoleCount(filteredList.size());
        return adminStartpageDTO;
    }

    public List<UnitModelValue> getUnitsForUseUserId(long useUserId) {
        ArrayList<UnitModelValue> list = null;
        try {
            UseUserLocal useUser = this.useUserHome.findByPrimaryKey(new UseUserPK(useUserId));
            Collection units = useUser.getUnitsForUseUser();
            list = new ArrayList<UnitModelValue>();
            for (Object obj : units) {
                UnitModelLocal local = (UnitModelLocal)obj;
                UnitModelValue value = local.getUnitModelValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public boolean setUnitsByUseUserId(long useUserId, long[] unitIds) {
        boolean success = false;
        try {
            ArrayList<UnitModelLocal> coll = new ArrayList<UnitModelLocal>();
            for (long unitId : unitIds) {
                UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
                coll.add(unitModel);
            }
            UseUserLocal useUser = this.useUserHome.findByPrimaryKey(new UseUserPK(useUserId));
            useUser.setUnitsForUseUser(coll);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public List<UseUserValue> getUseUsersForUnitId(long unitModelId) {
        ArrayList<UseUserValue> list = null;
        try {
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitModelId));
            Collection useUsers = unitModel.getUseUsersForUnit();
            list = new ArrayList<UseUserValue>();
            for (Object obj : useUsers) {
                UseUserLocal local = (UseUserLocal)obj;
                UseUserValue value = local.getUseUserValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public boolean setUseUsersByUnitId(long unitModelId, long[] useUserIds) {
        boolean success = false;
        ArrayList<UseUserLocal> coll = new ArrayList<UseUserLocal>();
        try {
            for (long useUserId : useUserIds) {
                UseUserLocal useUser = this.useUserHome.findByPrimaryKey(new UseUserPK(useUserId));
                coll.add(useUser);
            }
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitModelId));
            unitModel.setUseUsersForUnit(coll);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public List<AccountValue> getAllUsers() {
        ArrayList<AccountValue> list = null;
        try {
            Collection collection = this.accountHome.findAll();
            list = new ArrayList<AccountValue>();
            for (AccountLocal account : collection) {
                AccountValue value = account.getAccountValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public AccountValue getAccount(String username) {
        AccountValue accountValue = null;
        try {
            AccountLocal account = null;
            Collection accountRecords = this.accountHome.findByUsername(username);
            Iterator it = accountRecords.iterator();
            if (it.hasNext()) {
                account = (AccountLocal)it.next();
                accountValue = account.getAccountValue();
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return accountValue;
    }

    public AccountValue getAccount(long accountId) {
        AccountValue accountValue = null;
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            accountValue = account.getAccountValue();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return accountValue;
    }

    public boolean deleteUser(long accountId) {
        boolean success = false;
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getAccountValue().getUsername();
                this.createAuditData(auditAppl, pk, "", account.getAccountValue(), null);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            account.remove();
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public Long insertUser(AccountValue value) throws DuplicateKeyException {
        Long id = null;
        String validation = this.validateUser(value, -1L);
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        AccountLocal accountLocal = null;
        try {
            boolean changePWDAfterFirstLogin = this.configuration.getBoolean("login.passwordChangeAfterFirstLogin");
            if (changePWDAfterFirstLogin) {
                value.setPasswordReset(true);
            } else {
                value.setPasswordReset(false);
            }
            accountLocal = this.accountHome.create(value);
            value.setPrimaryKey((AccountPK)accountLocal.getPrimaryKey());
            id = accountLocal.getAccountValue().getId();
        }
        catch (CreateException ex) {
            this.accountHome.reorganizeSequence();
            try {
                accountLocal = this.accountHome.create(value);
            }
            catch (CreateException e) {
                String msg = "createAccount runs into error leave old ";
                logger.error((Object)msg, (Throwable)e);
                throw new ImplicitRollbackException(msg);
            }
        }
        catch (ConfigurationParameterNotFoundException e) {
            logger.error((Object)"ConfigurationParameter not found: ", (Throwable)e);
        }
        try {
            if (accountLocal != null) {
                String pk = accountLocal.getPrimaryKey().toString() + " " + accountLocal.getAccountValue().getUsername();
                this.createAuditData(auditAppl, pk, "", null, accountLocal.getAccountValue());
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return id;
    }

    public boolean updateUser(AccountValue value) throws DuplicateKeyException {
        boolean success = false;
        String validation = this.validateUser(value, value.getId());
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(value.getId()));
            AccountValue oldAccountValue = account.getAccountValue();
            String userName = value.getUsername();
            if (super.getCallerName().equals(userName)) {
                value.setPasswordReset(false);
            }
            if (oldAccountValue.equals(value)) {
                return true;
            }
            if (value.getPassword() != oldAccountValue.getPassword()) {
                value.setLastPasswordChange(System.currentTimeMillis());
            }
            if (!value.getBlockOut() && oldAccountValue.getBlockOut()) {
                value.setFailedLogins(0);
            }
            account.setAccountValue(value);
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getAccountValue().getUsername();
                this.createAuditData(auditAppl, pk, "", oldAccountValue, value);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean duplicatedUsername(String userName, long accountId) {
        boolean duplicated = false;
        List<AccountValue> collection = this.getAllUsers();
        for (AccountValue account : collection) {
            if (account.getId() == accountId || !account.getUsername().equals(userName)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public boolean duplicatedUserPersonalNumber(String personalNumber, long id) {
        boolean duplicated = false;
        if (personalNumber == null) {
            return duplicated;
        }
        List<AccountValue> collection = this.getAllUsers();
        for (AccountValue value : collection) {
            String valuePersonalNumber;
            if (value.getId() == id || (valuePersonalNumber = value.getPersonalNumber()) == null || personalNumber.equals("") || !valuePersonalNumber.equals(personalNumber)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public String validateUser(AccountValue value, long id) {
        if (this.duplicatedUserPersonalNumber(value.getPersonalNumber(), id)) {
            return "personalNumber";
        }
        if (this.duplicatedUsername(value.getUsername(), id)) {
            return "username";
        }
        if (this.internalUsername(value.getUsername())) {
            return "internalUsername";
        }
        return null;
    }

    public boolean internalUsername(String userName) {
        boolean internal = false;
        if (userName.equals("proveoadmin") || userName.equals("nobody")) {
            internal = true;
        }
        return internal;
    }

    public List<AccountValue> getAccountsByUsername(long groupId) {
        ArrayList<AccountValue> list = null;
        try {
            GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
            Collection accounts = groupIdent.getUser();
            list = new ArrayList<AccountValue>();
            for (Object obj : accounts) {
                AccountLocal local = (AccountLocal)obj;
                AccountValue value = local.getAccountValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<GroupIdentValue> getGroupsByUsername(String seletedUsername) {
        ArrayList<GroupIdentValue> list = new ArrayList<GroupIdentValue>();
        try {
            Collection accountRecords = this.accountHome.findByUsername(seletedUsername);
            AccountLocal account = null;
            Iterator it = accountRecords.iterator();
            if (it.hasNext()) {
                account = (AccountLocal)it.next();
                Collection groups = account.getUserGroups();
                GroupIdentLocal[] groupArr = groups.toArray(new GroupIdentLocal[0]);
                for (int i = 0; i != groupArr.length; ++i) {
                    list.add(groupArr[i].getGroupIdentValue());
                }
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<GroupIdentValue> getGroupsByUserId(long accountId) {
        ArrayList<GroupIdentValue> list = new ArrayList<GroupIdentValue>();
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            Collection groups = account.getUserGroups();
            for (Object obj : groups) {
                GroupIdentLocal local = (GroupIdentLocal)obj;
                GroupIdentValue value = local.getGroupIdentValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<RoleValue> getRolesByUserId(long accountId) {
        ArrayList<RoleValue> list = null;
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            Collection roles = account.getRoles();
            list = new ArrayList<RoleValue>();
            for (Object obj : roles) {
                RoleLocal local = (RoleLocal)obj;
                RoleValue value = local.getRoleValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<RoleValue> getRolesByTypes(Object customer, boolean removeSections, boolean removeNotSections) {
        List<RoleValue> list = null;
        Collection roles = null;
        try {
            if (customer instanceof AccountValue) {
                AccountValue value = (AccountValue)customer;
                long customerId = value.getId();
                AccountLocal local = this.accountHome.findByPrimaryKey(new AccountPK(customerId));
                roles = local.getRoles();
            } else if (customer instanceof GroupIdentValue) {
                GroupIdentValue value = (GroupIdentValue)customer;
                long customerId = value.getID();
                GroupIdentLocal local = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(customerId));
                roles = local.getRoles();
            } else if (customer instanceof RoleValue) {
                RoleValue value = (RoleValue)customer;
                long customerId = value.getId();
                RoleLocal local = this.roleHome.findByPrimaryKey(new RolePK(customerId));
                roles = local.getSectionRoles();
            } else {
                return null;
            }
            list = this.removeRoles(roles, removeSections, removeNotSections);
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<RoleValue> removeRoles(Collection list, boolean removeSections, boolean removeNotSections) {
        ArrayList<RoleValue> roles = new ArrayList<RoleValue>();
        for (Object obj : list) {
            RoleLocal local = (RoleLocal)obj;
            RoleValue role = local.getRoleValue();
            if (removeSections && role.getRolename().startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES) || removeNotSections && !role.getRolename().startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
            roles.add(role);
        }
        return roles;
    }

    public SectionRoleNode getSectionRoleNodeTree(String sectionIdentifier) {
        SectionRoleDTO dto = this.getSectionRoleData(sectionIdentifier);
        SectionRoleNode rootNode = dto.getRoot();
        return rootNode;
    }

    public SectionRoleDTO getSectionRoleData(String sectionIdentifier) {
        RoleValue sectionRole = new RoleValue();
        sectionRole.setRolename(sectionIdentifier);
        SectionRoleDTO dto = new SectionRoleDTO(sectionRole);
        SectionRoleNode rootNode = dto.getRoot();
        this.iterateSectionNodes(sectionRole, rootNode, true);
        return dto;
    }

    private void iterateSectionNodes(RoleValue role, SectionRoleNode node, boolean test) {
        List<RoleValue> roles = this.getAllRoles();
        ArrayList<RoleValue> childs = new ArrayList<RoleValue>();
        for (RoleValue value : roles) {
            if (!value.getRolename().startsWith(role.getRolename()) || value.getRolename().split("[.]").length != role.getRolename().split("[.]").length + 1) continue;
            childs.add(value);
        }
        for (RoleValue roleValue : childs) {
            try {
                SectionRoleNode roleNode = node.insertChildNode(roleValue);
                if (!test) continue;
                this.iterateSectionNodes(roleValue, roleNode, true);
            }
            catch (Exception e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public boolean setUsernamesByGroupId(long groupId, String[] usernames) {
        boolean success = false;
        try {
            AccountLocal account = null;
            GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
            ArrayList<AccountLocal> newUsers = new ArrayList<AccountLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (String username : usernames) {
                Collection accountRecords = this.accountHome.findByUsername(username);
                Iterator it = accountRecords.iterator();
                if (!it.hasNext()) continue;
                account = (AccountLocal)it.next();
                newUsers.add(account);
                newAssignment.add(account.getAccountValue().getUsername());
            }
            Collection oldUsers = groupIdent.getUser();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : oldUsers) {
                account = (AccountLocal)obj;
                oldAssignment.add(account.getAccountValue().getUsername());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            groupIdent.setUser(newUsers);
            try {
                String pk = groupIdent.getPrimaryKey().toString() + " " + groupIdent.getGroupname();
                this.createAuditData(auditAppl, pk, "RelationUserGroupToUser", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean setGroupsByUsername(String username, long[] groupnames) {
        boolean success = false;
        try {
            AccountLocal account;
            Collection accountRecords = this.accountHome.findByUsername(username);
            Iterator it = accountRecords.iterator();
            if (it.hasNext() && (account = (AccountLocal)it.next()) != null) {
                success = this.setGroupsByUserId(account.getAccountValue().getId(), groupnames);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean setGroupsByUserId(long accountId, long[] groupnames) {
        boolean success = false;
        try {
            GroupIdentLocal groupIdent = null;
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            ArrayList<GroupIdentLocal> newGroups = new ArrayList<GroupIdentLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (long groupId : groupnames) {
                groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
                newGroups.add(groupIdent);
                newAssignment.add(groupIdent.getGroupname());
            }
            Collection oldGroups = account.getUserGroups();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : oldGroups) {
                groupIdent = (GroupIdentLocal)obj;
                oldAssignment.add(groupIdent.getGroupname());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            account.setUserGroups(newGroups);
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getAccountValue().getUsername();
                this.createAuditData(auditAppl, pk, "RelationUserToUserGroup", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public boolean setRoleIdsByUserId(long accountId, long[] roleIds) {
        boolean success = false;
        try {
            RoleLocal roleLocal = null;
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            ArrayList<RoleLocal> newRoles = new ArrayList<RoleLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (long roleId : roleIds) {
                roleLocal = this.roleHome.findByPrimaryKey(new RolePK(roleId));
                newRoles.add(roleLocal);
                newAssignment.add(roleLocal.getRoleValue().getRolename());
            }
            Collection actRoles = account.getRoles();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : actRoles) {
                roleLocal = (RoleLocal)obj;
                oldAssignment.add(roleLocal.getRoleValue().getRolename());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            account.setRoles(newRoles);
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getAccountValue().getUsername();
                this.createAuditData(auditAppl, pk, "RelationUserToRole", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public boolean setRoleIdsByGroupId(long userGroupId, long[] roleIds) {
        boolean success = false;
        try {
            RoleLocal roleLocal = null;
            GroupIdentLocal account = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(userGroupId));
            ArrayList<RoleLocal> newRoles = new ArrayList<RoleLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (long roleId : roleIds) {
                roleLocal = this.roleHome.findByPrimaryKey(new RolePK(roleId));
                newRoles.add(roleLocal);
                newAssignment.add(roleLocal.getRoleValue().getRolename());
            }
            Collection actRoles = account.getRoles();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : actRoles) {
                roleLocal = (RoleLocal)obj;
                oldAssignment.add(roleLocal.getRoleValue().getRolename());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            account.setRoles(newRoles);
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getGroupname();
                this.createAuditData(auditAppl, pk, "RelationUserGroupToRole", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public boolean setRolesByUserId(long accountId, ArrayList<RoleValue> roles) {
        boolean success = false;
        ArrayList<RoleLocal> coll = new ArrayList<RoleLocal>();
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(accountId));
            String newRoles = "";
            for (RoleValue role : roles) {
                RoleLocal roleLocal = this.roleHome.findByPrimaryKey(new RolePK(role.getId()));
                coll.add(roleLocal);
                String newSectionRole = roleLocal.getRoleValue().getRolename();
                if (!newSectionRole.startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
                newRoles = newRoles + newSectionRole + ",";
            }
            Collection actRoles = account.getRoles();
            String oldRoles = "";
            for (Object obj : actRoles) {
                RoleLocal local = (RoleLocal)obj;
                String oldSectionRole = local.getRoleValue().getRolename();
                if (!oldSectionRole.startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
                oldRoles = oldRoles + oldSectionRole + ",";
            }
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getAccountValue().getUsername();
                this.createAuditData(auditAppl, pk, "RelationUserToAccess", oldRoles, newRoles);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            account.setRoles(coll);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public boolean setRolesByGroupId(long userGroupId, ArrayList<RoleValue> roles) {
        boolean success = false;
        ArrayList<RoleLocal> coll = new ArrayList<RoleLocal>();
        try {
            GroupIdentLocal account = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(userGroupId));
            String newRoles = "";
            for (RoleValue role : roles) {
                RoleLocal roleLocal = this.roleHome.findByPrimaryKey(new RolePK(role.getId()));
                coll.add(roleLocal);
                String newSectionRole = roleLocal.getRoleValue().getRolename();
                if (!newSectionRole.startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
                newRoles = newRoles + newSectionRole + ",";
            }
            Collection actRoles = account.getRoles();
            String oldRoles = "";
            for (Object obj : actRoles) {
                RoleLocal local = (RoleLocal)obj;
                String oldSectionRole = local.getRoleValue().getRolename();
                if (!oldSectionRole.startsWith(RESOURCE_ENTRY_FOR_SECTIONROLES)) continue;
                oldRoles = oldRoles + oldSectionRole + ",";
            }
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getGroupname();
                this.createAuditData(auditAppl, pk, "RelationUserGroupToAccess", oldRoles, newRoles);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            account.setRoles(coll);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public boolean setRolesByRoleId(long parentRoleId, long[] roles) {
        boolean success = false;
        try {
            RoleLocal roleLocal2 = null;
            RoleLocal parentRole = this.roleHome.findByPrimaryKey(new RolePK(parentRoleId));
            ArrayList<RoleLocal> newRoleCollection = new ArrayList<RoleLocal>(roles.length);
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (int i = 0; i != roles.length; ++i) {
                roleLocal2 = this.roleHome.findByPrimaryKey(new RolePK(roles[i]));
                newRoleCollection.add(roleLocal2);
                newAssignment.add(roleLocal2.getRoleValue().getRolename());
            }
            ArrayList<String> oldAssignment = new ArrayList<String>();
            Collection oldRolesCollection = parentRole.getSectionRoles();
            for (RoleLocal roleLocal2 : oldRolesCollection) {
                oldAssignment.add(roleLocal2.getRoleValue().getRolename());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            parentRole.setSectionRoles(newRoleCollection);
            try {
                String pk = parentRole.getPrimaryKey().toString() + " " + parentRole.getRoleValue().getRolename();
                this.createAuditData(auditAppl, pk, "RelationRoleToAccess", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into ", (Throwable)e);
        }
        return success;
    }

    public Collection<GroupMemberValue> getAllGroupMembers() {
        assert (false);
        ArrayList<GroupMemberValue> list = null;
        try {
            Collection collection = this.groupMemberHome.findAll();
            list = new ArrayList<GroupMemberValue>();
            for (GroupMemberLocal account : collection) {
                GroupMemberValue value = account.getGroupMemberValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public Long insertUseGroup(UseGroupValue value) throws CreateException, DuplicateKeyException {
        Long id = null;
        UseGroupLocal local = null;
        String validation = this.validateUseGroup(value, -99L);
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            local = this.useGroupHome.create(value);
            id = local.getUseGroupValue().getId();
            try {
                String pk = local.getPrimaryKey().toString() + " " + local.getUseGroupValue().getName();
                this.createAuditData(auditAppl, pk, "", null, local.getUseGroupValue());
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
            throw new CreateException("No creation possible, Usergroup already exists");
        }
        return id;
    }

    public boolean updateUseGroup(UseGroupValue value) throws DuplicateKeyException {
        boolean success = false;
        String validation = this.validateUseGroup(value, value.getId());
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            UseGroupLocal account = this.useGroupHome.findByPrimaryKey(new UseGroupPK(value.getId()));
            UseGroupValue oldValue = account.getUseGroupValue();
            if (oldValue.equals(value)) {
                return true;
            }
            account.setUseGroupValue(value);
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getUseGroupValue().getName();
                this.createAuditData(auditAppl, pk, "", account.getUseGroupValue(), value);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public String duplicatedUseGroupName(String name, long id) {
        boolean duplicated = false;
        List<UseGroupValue> collection = this.getAllUseGroupsIncludeDeleted();
        for (UseGroupValue value : collection) {
            String valueName;
            if (value.getId() == id || (valueName = value.getName()) == null || name.equals("") || !valueName.equals(name)) continue;
            duplicated = true;
            if (value.getDeleted()) {
                return "nameDeleted";
            }
            return "name";
        }
        return null;
    }

    public String validateUseGroup(UseGroupValue value, long id) {
        String validation = "";
        validation = this.duplicatedUseGroupName(value.getName(), id);
        if (validation != null) {
            return validation;
        }
        return null;
    }

    public boolean deleteUseGroup(long id) {
        boolean success = false;
        try {
            this.removeUseGroupToUseUser(id);
            UseGroupLocal account = this.useGroupHome.findByPrimaryKey(new UseGroupPK(id));
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getUseGroupValue().getName();
                this.createAuditData(auditAppl, pk, "", account.getUseGroupValue(), "Marked as deleted");
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            UseGroupValue value = account.getUseGroupValue();
            value.setDeleted(true);
            account.setUseGroupValue(value);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public String duplicatedUseUserKeyAndName(String key, String name, long id) {
        boolean duplicated = false;
        List<UseUserValue> collection = this.getAllDeletedUseUsers();
        for (UseUserValue value : collection) {
            if (value.getId() == id) continue;
            String valueKey = value.getKey();
            String valueKeyName = value.getKey() + "#" + value.getName();
            if (!value.getDeleted() || valueKey == null || key.equals("") || !valueKeyName.equals(key + "#" + name)) continue;
            duplicated = true;
            if (value.getDeleted()) {
                return "keyNameDeleted";
            }
            return "keyName";
        }
        return null;
    }

    public String duplicatedUseUserKey(String key, long id) {
        boolean duplicated = false;
        List<UseUserValue> collection = this.getAllUseUsers();
        for (UseUserValue value : collection) {
            String valueKey;
            if (value.getId() == id || (valueKey = value.getKey()) == null || key.equals("") || !valueKey.equals(key)) continue;
            duplicated = true;
            if (value.getDeleted()) {
                return "keyDeleted";
            }
            return "key";
        }
        return null;
    }

    public String duplicatedUseUserPersonalNumber(String personalNumber, long id) {
        boolean duplicated = false;
        List<UseUserValue> collection = this.getAllUseUsersIncludeDeleted();
        for (UseUserValue value : collection) {
            String valuePersonalNumber;
            if (value.getId() == id || (valuePersonalNumber = value.getPersonalNumber()) == null || personalNumber.equals("") || !valuePersonalNumber.equals(personalNumber)) continue;
            duplicated = true;
            if (value.getDeleted()) {
                return "personalNumberDeleted";
            }
            return "personalNumber";
        }
        return null;
    }

    public String validateUseUser(UseUserValue value, long id) {
        String validation = "";
        validation = this.duplicatedUseUserPersonalNumber(value.getPersonalNumber(), id);
        if (validation != null) {
            return validation;
        }
        validation = this.duplicatedUseUserKey(value.getKey(), id);
        if (validation != null) {
            return validation;
        }
        validation = this.duplicatedUseUserKeyAndName(value.getKey(), value.getName(), id);
        if (validation != null) {
            return validation;
        }
        return null;
    }

    public Long insertUseUser(UseUserValue value) throws DuplicateKeyException, CreateException {
        UseUserLocal local = null;
        String validation = this.validateUseUser(value, -1L);
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            local = this.useUserHome.create(value);
            AdminUnitFacadeLocal adminUnitFacade = null;
            try {
                adminUnitFacade = AdminUnitFacadeUtil.getLocalHome().create();
                adminUnitFacade.updateUnitUserRefreshForUseGroup(value.getGroupId());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + value.getGroupId()));
                }
            }
            catch (CreateException e1) {
                logger.error((Object)"runs into", (Throwable)e1);
            }
            catch (NamingException e1) {
                logger.error((Object)"runs into", (Throwable)e1);
            }
        }
        catch (CreateException ex) {
            this.useUserHome.reorganizeSequence();
            local = this.useUserHome.create(value);
        }
        try {
            String pk = local.getPrimaryKey().toString() + " " + local.getUseUserValue().getName();
            this.createAuditData(auditAppl, pk, "", null, local.getUseUserValue());
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        if (local != null) {
            return local.getUseUserValue().getId();
        }
        return null;
    }

    public boolean updateUseUser(UseUserValue value) throws DuplicateKeyException {
        boolean success = false;
        String validation = this.validateUseUser(value, value.getId());
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            UseUserLocal account = this.useUserHome.findByPrimaryKey(new UseUserPK(value.getId()));
            UseUserValue oldValue = account.getUseUserValue();
            long oldGroupId = oldValue.getGroupId();
            if (oldValue.equals(value)) {
                return true;
            }
            account.setUseUserValue(value);
            if (oldValue.getGroupId() != value.getGroupId() || oldValue.getKey() != value.getKey()) {
                AdminUnitFacadeLocal adminUnitFacade = null;
                try {
                    adminUnitFacade = AdminUnitFacadeUtil.getLocalHome().create();
                    if (oldValue.getGroupId() != value.getGroupId()) {
                        adminUnitFacade.updateUnitUserRefreshForUseGroup(value.getGroupId());
                        adminUnitFacade.updateUnitUserRefreshForUseGroup(oldGroupId);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + value.getGroupId()));
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + oldGroupId));
                        }
                    }
                    if (!oldValue.getKey().equals(value.getKey())) {
                        adminUnitFacade.updateUnitUserRefreshForUseUser(value.getId());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(" ---- unituserrefresh for key change : " + value.getKey()));
                        }
                    }
                }
                catch (CreateException e1) {
                    logger.error((Object)"runs into", (Throwable)e1);
                }
                catch (NamingException e1) {
                    logger.error((Object)"runs into", (Throwable)e1);
                }
            }
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getUseUserValue().getName();
                this.createAuditData(auditAppl, pk, "", account.getUseUserValue(), value);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean deleteUseUser(long id) {
        boolean success = false;
        try {
            UseUserLocal account = this.useUserHome.findByPrimaryKey(new UseUserPK(id));
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getUseUserValue().getName();
                this.createAuditData(auditAppl, pk, "", account.getUseUserValue(), "Marked as deleted");
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            UseUserValue value = account.getUseUserValue();
            value.setDeleted(true);
            account.setUseUserValue(value);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public List<UseUserValue> getAllUseUsers() {
        ArrayList<UseUserValue> list = null;
        try {
            Collection collection = this.useUserHome.findAll();
            list = new ArrayList<UseUserValue>();
            for (UseUserLocal account : collection) {
                UseUserValue value = account.getUseUserValue();
                if (this.filterOutUnknown(value)) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<UseUserValue> getAllDeletedUseUsers() {
        ArrayList<UseUserValue> list = null;
        try {
            Collection collection = this.useUserHome.findAllDeleted();
            list = new ArrayList<UseUserValue>();
            for (UseUserLocal account : collection) {
                UseUserValue value = account.getUseUserValue();
                if (this.filterOutUnknown(value)) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private boolean filterOutUnknown(UseUserValue value) {
        return !this.sessionContext.isCallerInRole("superadmin") && (value.getName().equals("unknown") || value.getKey().equals("0000000000000000"));
    }

    public List<UseUserValue> getAllUseUsersIncludeDeleted() {
        ArrayList<UseUserValue> list = null;
        try {
            Collection collection = this.useUserHome.findAllIncludeDeleted();
            list = new ArrayList<UseUserValue>();
            for (UseUserLocal account : collection) {
                UseUserValue value = account.getUseUserValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<UseGroupValue> getAllUseGroups() {
        ArrayList<UseGroupValue> list = null;
        try {
            Collection collection = this.useGroupHome.findAll();
            list = new ArrayList<UseGroupValue>();
            for (UseGroupLocal account : collection) {
                UseGroupValue value = account.getUseGroupValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<UseGroupValue> getAllUseGroupsIncludeDeleted() {
        ArrayList<UseGroupValue> list = null;
        try {
            Collection collection = this.useGroupHome.findAllIncludeDeleted();
            list = new ArrayList<UseGroupValue>();
            for (UseGroupLocal account : collection) {
                UseGroupValue value = account.getUseGroupValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<UseUserValue> getUseUsersByUseGroupId(long groupId) {
        ArrayList<UseUserValue> list = null;
        try {
            Collection collection = this.useUserHome.findByGroupId(groupId);
            list = new ArrayList<UseUserValue>();
            for (UseUserLocal account : collection) {
                UseUserValue value = account.getUseUserValue();
                if (this.filterOutUnknown(value)) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private void removeUseGroupToUseUser(long groupId) {
        List<UseUserValue> list = this.getUseUsersByUseGroupId(groupId);
        long[] useUsers = new long[list.size()];
        int i = 0;
        for (UseUserValue value : list) {
            useUsers[i] = value.getId();
            ++i;
        }
        for (long userId : useUsers) {
            try {
                UseUserLocal account = this.useUserHome.findByPrimaryKey(new UseUserPK(userId));
                UseUserValue value = account.getUseUserValue();
                value.setGroupId(-1L);
                account.setUseUserValue(value);
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public boolean setUseUsersByUseGroupId(long groupId, long[] userIds) {
        boolean success = false;
        UseGroupLocal useGroup = null;
        try {
            useGroup = this.useGroupHome.findByPrimaryKey(new UseGroupPK(groupId));
        }
        catch (FinderException e1) {
            logger.error((Object)"runs into", (Throwable)e1);
        }
        List<UseUserValue> useUsers = this.getUseUsersByUseGroupId(groupId);
        ArrayList<String> oldAssignment = new ArrayList<String>();
        for (int i = 0; i != useUsers.size(); ++i) {
            oldAssignment.add(useUsers.get(i).getName());
        }
        this.removeUseGroupToUseUser(groupId);
        HashSet<Long> permOfUseGroups = new HashSet<Long>();
        permOfUseGroups.add(groupId);
        ArrayList<String> newAssignment = new ArrayList<String>();
        for (long userId : userIds) {
            try {
                UseUserLocal account = this.useUserHome.findByPrimaryKey(new UseUserPK(userId));
                UseUserValue value = account.getUseUserValue();
                long oldGroupId = value.getGroupId();
                if (oldGroupId != -1L) {
                    permOfUseGroups.add(oldGroupId);
                }
                value.setGroupId(groupId);
                newAssignment.add(value.getName());
                account.setUseUserValue(value);
                success = true;
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        Collections.sort(oldAssignment);
        Collections.sort(newAssignment);
        if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
            return true;
        }
        AdminUnitFacadeLocal adminUnitFacade = null;
        try {
            adminUnitFacade = AdminUnitFacadeUtil.getLocalHome().create();
            for (Long permOfUseGroup : permOfUseGroups) {
                adminUnitFacade.updateUnitUserRefreshForUseGroup(permOfUseGroup);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(" ---- unituserrefresh for operatorgroup : " + permOfUseGroup));
            }
        }
        catch (CreateException e1) {
            logger.error((Object)"runs into", (Throwable)e1);
        }
        catch (NamingException e1) {
            logger.error((Object)"runs into", (Throwable)e1);
        }
        try {
            String pk = useGroup.getPrimaryKey().toString() + " " + useGroup.getUseGroupValue().getName();
            this.createAuditData(auditAppl, pk, "RelationUseGroupToUseUser", oldAssignment, newAssignment);
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public List<GroupIdentValue> getAllUserGroups() {
        ArrayList<GroupIdentValue> list = null;
        try {
            Collection collection = this.groupIdentHome.findAll();
            list = new ArrayList<GroupIdentValue>();
            for (GroupIdentLocal account : collection) {
                GroupIdentValue value = account.getGroupIdentValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public GroupIdentValue getGroupIdent(long seletedGroupIdent) {
        GroupIdentValue accountValue = null;
        try {
            GroupIdentLocal account = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(seletedGroupIdent));
            accountValue = account.getGroupIdentValue();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return accountValue;
    }

    public boolean deleteUserGroup(long groupIdent) {
        boolean success = false;
        try {
            GroupIdentLocal account = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupIdent));
            try {
                String pk = account.getPrimaryKey().toString() + " " + account.getGroupname();
                this.createAuditData(auditAppl, pk, "", account.getGroupIdentValue(), null);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            account.remove();
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean duplicatedUserGroupName(String name, long Id) {
        boolean duplicated = false;
        List<GroupIdentValue> collection = this.getAllUserGroups();
        for (GroupIdentValue account : collection) {
            if (account.getID() == Id || !account.getGroupname().equals(name)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public Long insertUserGroup(GroupIdentValue value) throws CreateException {
        Long id = null;
        try {
            if (this.duplicatedUserGroupName(value.getGroupname(), -1L)) {
                throw new CreateException("No creation possible, Usergroup already exists");
            }
            GroupIdentLocal local = this.groupIdentHome.create(value);
            id = local.getGroupIdentValue().getID();
            try {
                String pk = local.getPrimaryKey().toString() + " " + local.getGroupname();
                this.createAuditData(auditAppl, pk, "", null, local.getGroupIdentValue());
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
            throw new CreateException("No creation possible, Usergroup already exists");
        }
        return id;
    }

    public boolean updateUserGroup(GroupIdentValue value) {
        boolean success;
        block6: {
            success = false;
            try {
                if (this.duplicatedUserGroupName(value.getGroupname(), value.getID())) {
                    success = false;
                    break block6;
                }
                GroupIdentLocal account = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(value.getID()));
                GroupIdentValue oldValue = account.getGroupIdentValue();
                if (oldValue.equals(value)) {
                    return true;
                }
                account.setGroupIdentValue(value);
                try {
                    String pk = account.getPrimaryKey().toString() + " " + oldValue.getGroupname();
                    this.createAuditData(auditAppl, pk, "", oldValue, value);
                }
                catch (CreateException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
                success = true;
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        return success;
    }

    public void insertOrUpdateUserGroup(GroupIdentValue value) {
    }

    public Long insertRole(RoleValue value) throws CreateException {
        Long id = null;
        try {
            if (this.duplicatedRolename(value.getRolename(), -1L)) {
                throw new CreateException("No creation possible, rolename already exists");
            }
            RoleLocal local = null;
            try {
                local = this.roleHome.create(value);
                value.setPrimaryKey((RolePK)local.getPrimaryKey());
                id = local.getRoleValue().getId();
            }
            catch (CreateException ex) {
                this.roleHome.reorganizeSequence();
                try {
                    local = this.roleHome.create(value);
                }
                catch (CreateException e) {
                    String msg = "createRole runs into error leave old ";
                    logger.error((Object)msg, (Throwable)e);
                    throw new ImplicitRollbackException(msg);
                }
            }
            try {
                String pk = local.getPrimaryKey().toString() + " " + local.getRoleValue().getRolename();
                this.createAuditData(auditAppl, pk, "", null, local.getRoleValue());
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
            throw new CreateException("No creation possible, role already exists");
        }
        return id;
    }

    public boolean duplicatedRolename(String roleName, long roleId) {
        boolean duplicated = false;
        List<RoleValue> collection = this.getAllRoles();
        for (RoleValue account : collection) {
            if (account.getId() == roleId || !account.getRolename().equals(roleName)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public boolean deleteRole(long roleId) {
        boolean success = false;
        try {
            RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(roleId));
            try {
                String pk = role.getPrimaryKey().toString() + " " + role.getRoleValue().getRolename();
                this.createAuditData(auditAppl, pk, "", role.getRoleValue(), null);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            role.remove();
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public RoleValue getRoleById(long roleId) {
        RoleValue roleValue = null;
        try {
            RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(roleId));
            roleValue = role.getRoleValue();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return roleValue;
    }

    public boolean updateRole(RoleValue value) {
        boolean success;
        block6: {
            success = false;
            try {
                if (this.duplicatedRolename(value.getRolename(), value.getId())) {
                    success = false;
                    break block6;
                }
                RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(value.getId()));
                RoleValue oldRoleValue = role.getRoleValue();
                if (oldRoleValue.equals(value)) {
                    return true;
                }
                role.setRoleValue(value);
                try {
                    String pk = role.getPrimaryKey().toString() + " " + oldRoleValue.getRolename();
                    this.createAuditData(auditAppl, pk, "", oldRoleValue, value);
                }
                catch (CreateException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
                success = true;
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        return success;
    }

    public ArrayList<RoleValue> getAllRolesStartsWith(String rolenameStartsWith) {
        ArrayList list = null;
        try {
            Collection collection = this.roleHome.findByStartsWith(rolenameStartsWith);
            list = new ArrayList();
            list.addAll(collection);
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public RoleValue getRoleByName(String rolename) {
        RoleValue roleValue = null;
        try {
            RoleLocal role = null;
            Collection records = this.roleHome.findByRolename(rolename);
            Iterator it = records.iterator();
            if (it.hasNext()) {
                role = (RoleLocal)it.next();
                roleValue = role.getRoleValue();
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return roleValue;
    }

    public List<RoleValue> getAllRoles() {
        ArrayList<RoleValue> list = null;
        try {
            Collection collection = this.roleHome.findAll();
            list = new ArrayList<RoleValue>();
            for (RoleLocal account : collection) {
                RoleValue value = account.getRoleValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<RoleValue> getAllRoleTypes(boolean removeSections, boolean removeNotSections) {
        List<RoleValue> list = null;
        try {
            Collection collection = this.roleHome.findAll();
            list = this.removeRoles(collection, removeSections, removeNotSections);
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<AccountValue> getUsernamesByRoleId(long roleId) {
        ArrayList<AccountValue> list = null;
        try {
            RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(roleId));
            Collection accounts = role.getUser();
            list = new ArrayList<AccountValue>();
            for (Object obj : accounts) {
                AccountLocal local = (AccountLocal)obj;
                AccountValue value = local.getAccountValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public boolean setUsernamesByRoleId(long roleId, String[] usernames) {
        boolean success = false;
        try {
            AccountLocal account = null;
            RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(roleId));
            ArrayList<AccountLocal> newUsers = new ArrayList<AccountLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (String username : usernames) {
                Collection accountRecords = this.accountHome.findByUsername(username);
                Iterator it = accountRecords.iterator();
                if (!it.hasNext()) continue;
                account = (AccountLocal)it.next();
                newUsers.add(account);
                newAssignment.add(account.getAccountValue().getUsername());
            }
            Collection users = role.getUser();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : users) {
                account = (AccountLocal)obj;
                oldAssignment.add(account.getAccountValue().getUsername());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            role.setUser(newUsers);
            try {
                String pk = role.getPrimaryKey().toString() + " " + role.getRoleValue().getRolename();
                this.createAuditData(auditAppl, pk, "RelationRoleToUser", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean setGroupsByRoleId(long roleId, long[] groupnames) {
        boolean success = false;
        try {
            GroupIdentLocal groupIdent = null;
            RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(roleId));
            ArrayList<GroupIdentLocal> newGroups = new ArrayList<GroupIdentLocal>();
            ArrayList<String> newAssignment = new ArrayList<String>();
            for (long groupId : groupnames) {
                groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
                newGroups.add(groupIdent);
                newAssignment.add(groupIdent.getGroupname());
            }
            Collection oldGroups = role.getUserGroups();
            ArrayList<String> oldAssignment = new ArrayList<String>();
            for (Object obj : oldGroups) {
                groupIdent = (GroupIdentLocal)obj;
                oldAssignment.add(groupIdent.getGroupname());
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            role.setUserGroups(newGroups);
            try {
                String pk = role.getPrimaryKey().toString() + " " + role.getRoleValue().getRolename();
                this.createAuditData(auditAppl, pk, "RelationRoleToUserGroup", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public List<GroupIdentValue> getGroupsByRoleId(long roleId) {
        ArrayList<GroupIdentValue> list = null;
        try {
            RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(roleId));
            Collection groups = role.getUserGroups();
            list = new ArrayList<GroupIdentValue>();
            for (Object obj : groups) {
                GroupIdentLocal local = (GroupIdentLocal)obj;
                GroupIdentValue value = local.getGroupIdentValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<RoleValue> getRolesByUsername(String username) {
        ArrayList<RoleValue> list = null;
        try {
            Collection accountRecords = this.accountHome.findByUsername(username);
            Iterator it = accountRecords.iterator();
            AccountLocal account = null;
            if (it.hasNext()) {
                account = (AccountLocal)it.next();
                Collection roles = account.getRoles();
                list = new ArrayList<RoleValue>();
                for (Object obj : roles) {
                    RoleLocal local = (RoleLocal)obj;
                    RoleValue value = local.getRoleValue();
                    list.add(value);
                }
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<RoleValue> getRolesByGroupId(long groupId) {
        ArrayList<RoleValue> list = new ArrayList<RoleValue>();
        try {
            GroupIdentLocal group = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
            Collection roles = group.getRoles();
            for (Object obj : roles) {
                RoleLocal local = (RoleLocal)obj;
                RoleValue value = local.getRoleValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public List<RoleValue> getRolesByRoleId(long roleId) {
        ArrayList<RoleValue> list = null;
        try {
            RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(roleId));
            Collection roles = role.getSectionRoles();
            list = new ArrayList<RoleValue>();
            for (Object obj : roles) {
                RoleLocal local = (RoleLocal)obj;
                RoleValue value = local.getRoleValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public long getGrouphistoryIdForUnit(long unitId, long timeStamp) throws FinderException {
        return this.getGrouphistoryLocalForUnit(unitId, timeStamp).getGroupHistoryId();
    }

    public GrouphistoryLocal getGrouphistoryLocalForUnit(long unitId, long timeStamp) throws FinderException {
        return this.grouphistoryHome.getGrouphistoryForUnit(unitId, timeStamp);
    }

    public ReportDTOList getScheduledReports() {
        ReportDTOList list = new ReportDTOList();
        try {
            Collection coll = this.scheduledReportLocalHome.findNotDeleted();
            for (ScheduledReportLocal report : coll) {
                ScheduledReportValue value = report.getScheduledReportValue();
                list.add(DTOFactory.buildScheduledReportDTO(report));
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public Long saveReport(ReportBaseDTO reportDTO) {
        Long id = null;
        ScheduledReportValue value = new ScheduledReportValue();
        value.setEmails(reportDTO.getEmails());
        value.setLocale(reportDTO.getLocale().toString());
        value.setOutputFormat(reportDTO.getOutputFormat().name());
        if (reportDTO.getPageFormat() != null) {
            value.setPageFormat(reportDTO.getPageFormat().name());
        }
        value.setReportDesign(reportDTO.getReportDesign());
        value.setReportName(reportDTO.getReportName());
        value.setCreateTime(reportDTO.getCreateTime());
        value.setReportType(reportDTO.getReportType());
        String parameterString = "";
        for (Map.Entry<String, String> e : reportDTO.getReportParameters().entrySet()) {
            if (!parameterString.equals("")) {
                parameterString = parameterString + ";";
            }
            String paramKey = e.getKey();
            String paramValue = e.getValue();
            parameterString = parameterString + paramKey + "=" + paramValue;
        }
        value.setReportParameters(parameterString);
        value.setTimeInterval(reportDTO.getInterval().name());
        try {
            ScheduledReportLocal reportLocal;
            if (reportDTO.getId() != null) {
                value.setId(reportDTO.getId());
                reportLocal = this.scheduledReportLocalHome.findByPrimaryKey(new ScheduledReportPK(reportDTO.getId()));
                reportLocal.setScheduledReportValue(value);
                id = reportLocal.getId();
            } else {
                reportLocal = this.scheduledReportLocalHome.create(value);
                id = reportLocal.getId();
            }
            ArrayList<AccountLocal> coll = new ArrayList<AccountLocal>();
            if (reportDTO.getAccounts() != null) {
                for (AccountValue accountValue : reportDTO.getAccounts()) {
                    AccountLocal accountLocal = this.accountHome.findByPrimaryKey(new AccountPK(accountValue.getId()));
                    coll.add(accountLocal);
                }
                reportLocal.setAccounts(coll);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return id;
    }

    public void deleteReport(ReportBaseDTO reportDTO) {
        try {
            ScheduledReportLocal reportLocal = this.scheduledReportLocalHome.findByPrimaryKey(new ScheduledReportPK(reportDTO.getId()));
            reportLocal.setDeleted(true);
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (EJBException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public Long createAuditData(String application, String primaryKey, String entity, Object oldValue, Object newValue) throws CreateException {
        Long id = null;
        if (!this.auditTrail) {
            return id;
        }
        AuditdataLocal local = null;
        AuditdataValue value = new AuditdataValue();
        String oldString = "";
        String newString = "";
        if (oldValue != null) {
            oldString = oldValue.toString();
            if (entity == null || entity.length() == 0) {
                entity = oldValue.getClass().getSimpleName();
            }
        }
        if (newValue != null) {
            newString = newValue.toString();
            if (entity == null || entity.length() == 0) {
                entity = newValue.getClass().getSimpleName();
            }
        }
        try {
            value.setOldValue(oldString.getBytes());
            value.setNewValue(newString.getBytes());
            String action = "Update";
            if (oldString.length() == 0) {
                action = "Insert";
            } else if (newString.length() == 0 || newString.equals("Marked as deleted")) {
                action = "Delete";
            }
            value.setAction(action);
            value.setModifiedEntity(entity);
            value.setPkModifiedRecord(primaryKey);
            value.setTimestamp(System.currentTimeMillis());
            value.setUsername(this.getCallerName());
            value.setApplicationName(application);
            local = this.auditdataHome.create(value);
        }
        catch (CreateException ex) {
            this.auditdataHome.reorganizeSequence();
            try {
                local = this.auditdataHome.create(value);
            }
            catch (CreateException e) {
                String msg = "auditData runs into error ";
                logger.error((Object)msg, (Throwable)e);
                throw new ImplicitRollbackException(msg);
            }
        }
        if (local != null) {
            id = local.getAuditdataValue().getAuditId();
        }
        return id;
    }

    public List<AuditdataValue> getAuditdata(long begin, long end) {
        ArrayList<AuditdataValue> list = null;
        try {
            Collection collection = this.auditdataHome.findByTimeframe(begin, end, "AccessToSystem");
            AuditdataLocal[] arr = collection.toArray(new AuditdataLocal[collection.size()]);
            list = new ArrayList<AuditdataValue>();
            for (int i = 0; i != arr.length; ++i) {
                AuditdataValue value = arr[i].getAuditdataValue();
                if (this.filterOutSuperadmin && !this.sessionContext.isCallerInRole("superadmin") && value.getUsername().equals("proveoadmin")) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public String getAuditApplicationName() {
        return auditAppl;
    }

    public void saveGeneratedReport(ReportBaseDTO reportDTO, byte[] reportFile, long createTime, int dataSize, long processDuration) {
        logger.debug((Object)("generated Report saved" + reportDTO.getReportName()));
        GeneratedReportValue generatedReportValue = new GeneratedReportValue();
        generatedReportValue.setScheduledReportId(reportDTO.getId());
        generatedReportValue.setReport(reportFile);
        generatedReportValue.setCreateTime(createTime);
        generatedReportValue.setDataSize(dataSize);
        generatedReportValue.setProcessDuration(processDuration);
        try {
            this.generatedReportLocalHome.create(generatedReportValue);
        }
        catch (CreateException e) {
            logger.debug((Object)"runs inot", (Throwable)e);
        }
    }

    public List<GeneratedReportDTO> getGeneratedReports(Long scheduledReportId) {
        ArrayList<GeneratedReportDTO> list = new ArrayList<GeneratedReportDTO>();
        try {
            Collection coll = this.generatedReportLocalHome.findAll();
            for (GeneratedReportLocal report : coll) {
                GeneratedReportValue generatedReportValue = report.getGeneratedReportValue();
                ScheduledReportLocal scheduledReportLocal = this.scheduledReportLocalHome.findByPrimaryKey(new ScheduledReportPK(generatedReportValue.getScheduledReportId()));
                ScheduledReportValue scheduledReportValue = scheduledReportLocal.getScheduledReportValue();
                if (scheduledReportId != null && scheduledReportValue.getId() != scheduledReportId.longValue()) continue;
                list.add(new GeneratedReportDTO(generatedReportValue, scheduledReportValue));
            }
        }
        catch (FinderException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public void deleteGeneratedReport(GeneratedReportDTO reportDTO) {
        try {
            this.generatedReportLocalHome.remove(new GeneratedReportPK(reportDTO.getGeneratedReportValue().getId()));
        }
        catch (EJBException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public List<NotificationValue> getAllNotifications() {
        ArrayList<NotificationValue> list = null;
        try {
            Collection coll = this.notificationLocalHome.findAll();
            NotificationLocal[] arr = coll.toArray(new NotificationLocal[0]);
            list = new ArrayList<NotificationValue>(arr.length);
            for (int i = 0; i != arr.length; ++i) {
                list.add(arr[i].getNotificationValue());
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public NotificationValue getNotificationById(long id) {
        NotificationValue value = null;
        try {
            value = this.notificationLocalHome.findByPrimaryKey(new NotificationPK(id)).getNotificationValue();
        }
        catch (FinderException e) {
            logger.error((Object)("no notify message found for notifyMessageID: " + id));
        }
        return value;
    }

    public boolean saveNotification(NotificationValue value) throws DuplicateKeyException {
        try {
            this.notificationLocalHome.create(value);
            return true;
        }
        catch (CreateException e) {
            if (e instanceof DuplicateKeyException) {
                throw (DuplicateKeyException)e;
            }
            return false;
        }
    }

    public boolean updateNotification(NotificationValue value) {
        try {
            NotificationLocal notifyLocal = this.notificationLocalHome.findByPrimaryKey(new NotificationPK(value.getId()));
            notifyLocal.setNotificationValue(value);
            return true;
        }
        catch (FinderException e) {
            logger.debug((Object)"runs into", (Throwable)e);
            return false;
        }
    }

    public boolean deleteNotification(long notificationId) {
        try {
            this.notificationLocalHome.remove(new NotificationPK(notificationId));
            return true;
        }
        catch (EJBException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    public List<ConfigurationParameterValue> getAllConfigurationParameters() {
        ArrayList<ConfigurationParameterValue> list = new ArrayList<ConfigurationParameterValue>();
        Properties props = this.configuration.getProperties();
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            String value = (String)props.get(string);
            ConfigurationParameterValue configValue = new ConfigurationParameterValue(string, value);
            list.add(configValue);
        }
        return list;
    }

    public String getConfigurationParameter(String key) {
        String value = null;
        try {
            value = this.configuration.getParameter(key);
        }
        catch (ConfigurationParameterNotFoundException ex) {
            logger.error((Object)"runs into", (Throwable)ex);
        }
        return value;
    }

    public void saveParameter(ConfigurationParameterValue value) {
        this.configuration.setParameter(value.getKey(), value.getValue());
    }

    public boolean deleteConfigurationParameter(ConfigurationParameterValue value) {
        try {
            this.configurationParameterLocalHome.remove(new ConfigurationParameterPK(value.getKey()));
            return true;
        }
        catch (EJBException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.debug((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    public int incrementFailedLogins(String username) {
        int failedLogins = 0;
        long overallFailedLogins = 0L;
        try {
            Collection coll = this.accountHome.findByUsername(username);
            Iterator iter = coll.iterator();
            if (iter.hasNext()) {
                AccountLocal accountLocal = (AccountLocal)iter.next();
                AccountValue accountValue = accountLocal.getAccountValue();
                failedLogins = accountValue.getFailedLogins() == null ? 0 : accountValue.getFailedLogins();
                overallFailedLogins = accountValue.getOverallFailedLogins() == null ? 0L : accountValue.getOverallFailedLogins();
                accountValue.setOverallFailedLogins(++overallFailedLogins);
                accountValue.setFailedLogins(++failedLogins);
                accountValue.setLastFailedLogin(System.currentTimeMillis());
                int failedLoginLimit = Integer.parseInt(this.configuration.getParameter("login.failedLoginLimit"));
                if (failedLoginLimit != 0 && failedLogins >= failedLoginLimit) {
                    accountValue.setBlockOut(true);
                }
                accountLocal.setAccountValue(accountValue);
            }
        }
        catch (FinderException e) {
            logger.debug((Object)("no username found: " + username));
        }
        catch (ConfigurationParameterNotFoundException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return failedLogins;
    }

    public void setLoginSuccessful(String username) {
        try {
            Collection coll = this.accountHome.findByUsername(username);
            Iterator iter = coll.iterator();
            if (iter.hasNext()) {
                AccountLocal accountLocal = (AccountLocal)iter.next();
                AccountValue accountValue = accountLocal.getAccountValue();
                Integer logins = accountValue.getLogins();
                if (logins == null) {
                    logins = 0;
                }
                accountValue.setLogins(logins + 1);
                accountValue.setFailedLogins(0);
                accountLocal.setAccountValue(accountValue);
            }
        }
        catch (FinderException e) {
            logger.error((Object)("no username found: " + username));
        }
    }

    public String getNotifyRuleParameterValue(String key, String parameter) {
        String value;
        block15: {
            value = "unknown";
            if ("warning".equals(key)) {
                try {
                    int intParam = Integer.parseInt(parameter);
                    NotificationValue notificationValue = this.getNotificationById(intParam);
                    if (notificationValue != null) {
                        value = notificationValue.getDefaultName();
                        break block15;
                    }
                    value = key + "." + parameter;
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)("Integer.parseInt(parameter) runs into" + e.getMessage()));
                    value = key + "." + parameter;
                }
            } else if ("unit".equals(key)) {
                try {
                    int unitId = Integer.parseInt(parameter);
                    UnitDTO unitDTO = this.commonData.getUnit(unitId);
                    if (unitDTO != null) {
                        value = unitDTO.getUnitName();
                        break block15;
                    }
                    value = key + "." + parameter;
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)("Integer.parseInt(parameter) runs into" + e.getMessage()));
                    value = key + "." + parameter;
                }
            } else if ("unitGroup".equals(key)) {
                try {
                    int unitId = Integer.parseInt(parameter);
                    UnitDTO unitDTO = this.commonData.getUnit(unitId);
                    if (unitDTO != null) {
                        value = unitDTO.getUnitName();
                        break block15;
                    }
                    value = key + "." + parameter;
                }
                catch (NumberFormatException e) {
                    logger.debug((Object)("Integer.parseInt(parameter) runs into" + e.getMessage()));
                    value = key + "." + parameter;
                }
            } else {
                logger.warn((Object)("unknown key: '" + key + "'"));
                value = key + "." + parameter;
            }
        }
        return value;
    }

    public ParameterDetails getNotifyParameterDetails(String key) {
        ParameterDetails parameterDetails = new ParameterDetails();
        if ("warning".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            List<NotificationValue> notificationValues = this.getAllNotifications();
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>(notificationValues.size());
            for (int i = 0; i < notificationValues.size(); ++i) {
                NotificationValue notificationValue = notificationValues.get(i);
                defaultValueMap.put(notificationValue.getDefaultName(), notificationValue.getId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
        } else if ("unit".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            UnitDTOList unitDTOList = this.commonData.getUnitsByIsBasic(true, true);
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
            for (int i = 0; i < unitDTOList.size(); ++i) {
                UnitDTO unitDTO = (UnitDTO)unitDTOList.get(i);
                defaultValueMap.put(unitDTO.getUnitName(), unitDTO.getUnitId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
        } else if ("unitGroup".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.DROPDOWN);
            UnitDTOList unitDTOList = this.commonData.getUnitsByIsBasic(false, true);
            HashMap<String, Object> defaultValueMap = new HashMap<String, Object>();
            for (int i = 0; i < unitDTOList.size(); ++i) {
                UnitDTO unitDTO = (UnitDTO)unitDTOList.get(i);
                defaultValueMap.put(unitDTO.getUnitName(), unitDTO.getUnitId());
            }
            parameterDetails.setDefaultValueMap(defaultValueMap);
            parameterDetails.setUsesDefaultValueMap(true);
        } else if ("email".equals(key)) {
            parameterDetails.setParameterInputType(ParameterInputType.TEXTBOX);
            parameterDetails.setUsesDefaultValue(true);
        } else {
            logger.debug((Object)("unknown key: '" + key + "'"));
            parameterDetails.setParameterInputType(ParameterInputType.TEXTBOX);
            parameterDetails.setUsesDefaultValue(true);
        }
        return parameterDetails;
    }

    public Long createAuditDataLoginLogout(ApplicationType application, boolean login, String username) {
        Long id = null;
        if (!this.auditTrail) {
            return id;
        }
        AuditdataLocal local = null;
        AuditdataValue value = new AuditdataValue();
        String string = "";
        try {
            String action = "Login";
            if (!login) {
                action = "Logout";
            }
            value.setOldValue(string.getBytes());
            value.setNewValue(action.getBytes());
            value.setAction(action);
            value.setModifiedEntity("AccessToSystem");
            value.setPkModifiedRecord("");
            value.setTimestamp(System.currentTimeMillis());
            if (username == null) {
                value.setUsername(this.getCallerName());
            } else {
                value.setUsername(username);
            }
            value.setApplicationName(application.toString());
            local = this.auditdataHome.create(value);
        }
        catch (CreateException ex) {
            logger.error((Object)"createAuditDataLoginLogout runs into error ", (Throwable)ex);
        }
        if (local != null) {
            id = local.getAuditdataValue().getAuditId();
        }
        return id;
    }

    public Long createAuditDataFailedLogin(ApplicationType application, String username, String password) {
        Long id = null;
        if (!this.auditTrail) {
            return id;
        }
        AuditdataLocal local = null;
        AuditdataValue value = new AuditdataValue();
        String string = "";
        try {
            String action = "Failed Login";
            value.setOldValue(string.getBytes());
            value.setNewValue(string.getBytes());
            value.setAction(action);
            value.setModifiedEntity("AccessToSystem");
            value.setPkModifiedRecord(password);
            value.setTimestamp(System.currentTimeMillis());
            value.setApplicationName(application.toString());
            if (username == null) {
                value.setUsername(this.getCallerName());
            } else {
                value.setUsername(username);
            }
            local = this.auditdataHome.create(value);
        }
        catch (CreateException ex) {
            logger.error((Object)"createAuditDataFailedLogin runs into error ", (Throwable)ex);
        }
        if (local != null) {
            id = local.getAuditdataValue().getAuditId();
        }
        return id;
    }

    public List<AuditdataValue> getAuditdataLoginLogout(long begin, long end) {
        ArrayList<AuditdataValue> list = null;
        try {
            Collection collection = this.auditdataHome.findFailedLoginByTimeframe(begin, end, "AccessToSystem");
            AuditdataLocal[] arr = collection.toArray(new AuditdataLocal[collection.size()]);
            list = new ArrayList<AuditdataValue>();
            for (int i = 0; i != arr.length; ++i) {
                AuditdataValue value = arr[i].getAuditdataValue();
                if (value.getUsername() == null || value.getUsername().equals("nobody") || this.filterOutSuperadmin && !this.sessionContext.isCallerInRole("superadmin") && value.getUsername().equals("proveoadmin")) continue;
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public boolean isPasswordChangeRequired(String username) {
        try {
            Long lastPwdChange;
            AccountValue account = this.getAccount(username);
            if (account != null && account.getPasswordReset()) {
                return true;
            }
            int days = this.configuration.getInteger("login.passwordChangeDays");
            if (account != null && days > 0 && (lastPwdChange = account.getLastPasswordChange()) != null) {
                long millis = days * 86400000;
                millis = lastPwdChange + millis;
                long current = System.currentTimeMillis();
                if (current < millis) {
                    return true;
                }
            }
        }
        catch (ConfigurationParameterNotFoundException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    public ArrayList<AreaValue> getAreas() {
        ArrayList<AreaValue> list = null;
        try {
            Collection coll = this.areaLocalHome.findAll();
            Iterator it = coll.iterator();
            list = new ArrayList<AreaValue>(coll.size());
            while (it.hasNext()) {
                AreaLocal local = (AreaLocal)it.next();
                list.add(local.getAreaValue());
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public AdjustmentAreaValue getAdjustmentAreaById(int id) {
        AdjustmentAreaValue value = null;
        try {
            value = this.adjustmentFacadeLocal.getAdjustmentArea(id);
        }
        catch (FinderException e) {
            logger.error((Object)("no adjustment area found for ID: " + id));
        }
        return value;
    }

    public List<AdjustmentAreaValue> getAdjustmentAreas() {
        ArrayList<AdjustmentAreaValue> list = null;
        try {
            Collection<AdjustmentAreaValue> coll = this.adjustmentFacadeLocal.getAdjustmentAreas();
            Iterator<AdjustmentAreaValue> it = coll.iterator();
            list = new ArrayList<AdjustmentAreaValue>(coll.size());
            while (it.hasNext()) {
                list.add(it.next());
            }
        }
        catch (Exception e) {
            logger.error((Object)"runs into ", (Throwable)e);
        }
        return list;
    }

    public boolean createAdjustmentArea(AdjustmentAreaValue value) throws DuplicateKeyException {
        try {
            this.adjustmentFacadeLocal.createAdjustmentArea(value);
            return true;
        }
        catch (CreateException e) {
            if (e instanceof DuplicateKeyException) {
                throw (DuplicateKeyException)e;
            }
            return false;
        }
    }

    public boolean updateAdjustmentArea(AdjustmentAreaValue value) {
        try {
            this.adjustmentFacadeLocal.updateAdjustmentArea(value);
            return true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
            return false;
        }
    }

    public boolean deleteAdjustmentArea(int adjustmentAreaId) throws RemoveException, ObjectNotFoundException {
        try {
            this.adjustmentFacadeLocal.deleteAdjustmentArea(adjustmentAreaId);
            return true;
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)"runs into ", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return false;
    }

    public boolean adjust(long unitId, int adjustmentAreaId) throws ObjectNotFoundException {
        try {
            this.adjustmentFacadeLocal.adjust(unitId, adjustmentAreaId);
            return true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into ", (Throwable)e);
            return false;
        }
    }

    public boolean saveFileStorage(FileStorageValue fileStorageValue) {
        try {
            fileStorageValue.setCreateTime(System.currentTimeMillis());
            fileStorageValue.setUploadedBy(super.getCallerName());
            FileStoragePK pk = fileStorageValue.getPrimaryKey();
            if (pk != null) {
                try {
                    FileStorageLocal fsl = this.fileStorageLocal.findByPrimaryKey(pk);
                    fsl.setFileStorageValue(fileStorageValue);
                }
                catch (FinderException e) {
                    this.fileStorageLocal.create(fileStorageValue);
                }
            } else {
                this.fileStorageLocal.create(fileStorageValue);
            }
            return true;
        }
        catch (CreateException e) {
            logger.debug((Object)"Runs into", (Throwable)e);
            return false;
        }
    }

    public boolean deleteFileStorage(long fileStorageId) {
        try {
            this.fileStorageLocal.remove(new FileStoragePK(fileStorageId));
            return true;
        }
        catch (RemoveException e) {
            logger.debug((Object)"Runs into", (Throwable)e);
            return false;
        }
    }

    public List<FileStorageValue> getAllStoredFiles(String category) {
        ArrayList<FileStorageValue> list = new ArrayList<FileStorageValue>();
        try {
            Collection coll = category == null ? this.fileStorageLocal.findAll() : this.fileStorageLocal.findByCategory(category);
            FileStorageLocal[] arr = coll.toArray(new FileStorageLocal[coll.size()]);
            for (int i = 0; i < arr.length; ++i) {
                list.add(arr[i].getFileStorageValue());
            }
        }
        catch (FinderException e) {
            logger.debug((Object)"Runs into", (Throwable)e);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnitChildren {
        ONLYNOTBASIC,
        ONLYBASIC,
        ALL;

    }
}

