/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.infoman;

import de.proveo.infoman.config.InfomanConfiguraiton;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationTemplateLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationUpdateException;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupLocal;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateDescriptionValue;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateLocal;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateLocalHome;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateUtil;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfomanConfigurationUpdateBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(InfomanConfigurationUpdateBean.class);
    private AdminUnitFacadeLocal adminUnitFacade;
    private ScheduledInfomanUpdateLocalHome scheduledInfomanUpdateHome;
    private UnitModelLocalHome unitModelHome;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.adminUnitFacade = AdminUnitFacadeUtil.getLocalHome().create();
            this.scheduledInfomanUpdateHome = ScheduledInfomanUpdateUtil.getLocalHome();
            this.unitModelHome = UnitModelUtil.getLocalHome();
        }
        catch (NamingException ex) {
            throw new EJBException("runs during lookup other ejbs into", (Exception)ex);
        }
    }

    public ScheduledInfomanUpdateDescriptionValue createUpdate(long unitId, long time, String description, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException, ObjectNotFoundException, CreateException {
        UnitModelLocal unit;
        if (!this.adminUnitFacade.hasAccesRightPermissionForUnit(unitId)) {
            // empty if block
        }
        try {
            unit = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        ScheduledInfomanUpdateLocal update = this.createUpdate(unit, time, description, force, updatedKeys, keysToRemove);
        return update.getScheduledInfomanUpdateDescriptionValue();
    }

    public Map<Long, ScheduledInfomanUpdateDescriptionValue> createUpdatesRemote(Collection<Long> units, long time, String description, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException, CreateException, ObjectNotFoundException {
        HashMap<Long, ScheduledInfomanUpdateDescriptionValue> createdUpdates = new HashMap<Long, ScheduledInfomanUpdateDescriptionValue>();
        for (long unitId : units) {
            ScheduledInfomanUpdateDescriptionValue update = this.createUpdate(unitId, time, description, force, updatedKeys, keysToRemove);
            createdUpdates.put(unitId, update);
        }
        return createdUpdates;
    }

    public Map<Long, ScheduledInfomanUpdateLocal> createUpdates(Collection<UnitModelLocal> units, long time, String description, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException, CreateException {
        HashMap<Long, ScheduledInfomanUpdateLocal> createdUpdates = new HashMap<Long, ScheduledInfomanUpdateLocal>();
        for (UnitModelLocal unit : units) {
            ScheduledInfomanUpdateLocal update = this.createUpdate(unit, time, description, force, updatedKeys, keysToRemove);
            createdUpdates.put(unit.getUnitId(), update);
        }
        return createdUpdates;
    }

    public ScheduledInfomanUpdateLocal createUpdate(UnitModelLocal unit, long time, String description, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException, CreateException {
        ScheduledInfomanUpdateLocal update;
        byte[] updatedConfiguration = this.updateConfiguration(unit, force, updatedKeys, keysToRemove);
        CurrentInfomanSetupLocal currentSetup = unit.getCurrentInfomanSetup();
        ScheduledInfomanUpdateValue updateValue = new ScheduledInfomanUpdateValue();
        updateValue.setScheduledTime(time);
        updateValue.setConfiguration(updatedConfiguration);
        updateValue.setConfigurationName(currentSetup.getConfigurationName());
        try {
            update = this.scheduledInfomanUpdateHome.create(updateValue);
        }
        catch (DuplicateKeyException ex) {
            this.scheduledInfomanUpdateHome.reorganizeSequence();
            update = this.scheduledInfomanUpdateHome.create(updateValue);
        }
        update.setUnitModel(unit);
        return update;
    }

    public Properties parseKeysToUpdate(byte[] templateContent) {
        Properties properties = new Properties();
        if (templateContent != null) {
            try {
                properties.load(new ByteArrayInputStream(templateContent));
            }
            catch (IOException ex) {
                throw new EJBException((Exception)ex);
            }
        }
        return properties;
    }

    public Set<String> parseKeysToRemove(byte[] templateContent) {
        Properties properties = this.parseKeysToUpdate(templateContent);
        HashSet<String> keySet = new HashSet<String>();
        Iterator<Object> it = properties.keySet().iterator();
        while (it.hasNext()) {
            keySet.add((String)it.next());
        }
        return keySet;
    }

    public Set<String> parseKeysToRemove(InfomanConfigurationTemplateLocal template) {
        return this.parseKeysToRemove(template.getKeysToRemove());
    }

    public Properties parseKeysToUpdate(InfomanConfigurationTemplateLocal template) {
        return this.parseKeysToUpdate(template.getConfiguration());
    }

    public byte[] updateConfiguration(UnitModelLocal unit, boolean force, Properties updatedKeys, Set<String> keysToRemove) throws InfomanConfigurationUpdateException {
        CurrentInfomanSetupLocal currentSetup = unit.getCurrentInfomanSetup();
        if (currentSetup == null) {
            throw new InfomanConfigurationUpdateException("setup not found");
        }
        if (!force && !currentSetup.getConfigurationUpToDate()) {
            throw new InfomanConfigurationUpdateException("configuration is not up to date");
        }
        byte[] rawConfiguration = currentSetup.getConfiguration();
        if (rawConfiguration == null || rawConfiguration.length == 0) {
            throw new InfomanConfigurationUpdateException("configuration is not available");
        }
        InfomanConfiguraiton configuration = new InfomanConfiguraiton();
        configuration.setConfiguration(rawConfiguration);
        configuration.merge(updatedKeys, keysToRemove);
        return configuration.getConfiguration();
    }
}

