/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.infoman;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeUtil;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupValue;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateLocal;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateLocalHome;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdatePK;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateUtil;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateValue;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDescriptionValue;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareLocal;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareLocalHome;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwarePK;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfomanConfigurationClientFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(InfomanConfigurationClientFacadeBean.class);
    private InfomanSetupFacadeLocal infomanSetupFacade;
    private ScheduledInfomanUpdateLocalHome scheduledInfomanUpdateHome;
    private InfomanSoftwareLocalHome infomanSoftwareLocalHome;
    private UnitModelLocalHome unitModelLocalHome;
    private AdminUnitFacadeLocal adminUnitFacadeLocal;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.infomanSetupFacade = InfomanSetupFacadeUtil.getLocalHome().create();
            this.scheduledInfomanUpdateHome = ScheduledInfomanUpdateUtil.getLocalHome();
            this.infomanSoftwareLocalHome = InfomanSoftwareUtil.getLocalHome();
            this.unitModelLocalHome = UnitModelUtil.getLocalHome();
            this.adminUnitFacadeLocal = AdminUnitFacadeUtil.getLocalHome().create();
        }
        catch (NamingException ex) {
            throw new EJBException("runs during lookup other ejbs into", (Exception)ex);
        }
    }

    public CurrentInfomanSetupValue getCurrentInfomanSetup(long unitId) throws ObjectNotFoundException, SecurityException {
        if (!this.adminUnitFacadeLocal.hasAccesRightPermissionForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        CurrentInfomanSetupValue setupValue = null;
        try {
            setupValue = this.infomanSetupFacade.getCurrentInfomanSetup(unitId);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        return setupValue;
    }

    public void setInfomanSoftwareForPlanedUpdate(long planedUpdateId, long infomanSoftwareId) throws ObjectNotFoundException {
        try {
            ScheduledInfomanUpdateLocal update = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(planedUpdateId));
            InfomanSoftwareLocal software = this.infomanSoftwareLocalHome.findByPrimaryKey(new InfomanSoftwarePK(infomanSoftwareId));
            update.setInfomanSoftware(software);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public InfomanSoftwareDescriptionValue getInfomanSoftwareForPlanedUpdate(long planedUpdateId) throws ObjectNotFoundException {
        try {
            ScheduledInfomanUpdateLocal update = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(planedUpdateId));
            InfomanSoftwareLocal software = update.getInfomanSoftware();
            if (software != null) {
                return software.getInfomanSoftwareDescriptionValue();
            }
            return null;
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public void removeInfomanSoftwareFromPlanedUpdate(long planedUpdateId) throws ObjectNotFoundException {
        try {
            ScheduledInfomanUpdateLocal update = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(planedUpdateId));
            update.setInfomanSoftware(null);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public ScheduledInfomanUpdateValue createPlanedInfomanUpdate(long unitId, ScheduledInfomanUpdateValue updateValue) throws CreateException, ObjectNotFoundException, SecurityException {
        ScheduledInfomanUpdateLocal update;
        if (!this.adminUnitFacadeLocal.hasAccesRightPermissionForUnit(unitId)) {
            throw new SecurityException("Current user has no permissions for this unit: " + unitId);
        }
        try {
            update = this.scheduledInfomanUpdateHome.create(updateValue);
        }
        catch (DuplicateKeyException ex) {
            this.scheduledInfomanUpdateHome.reorganizeSequence();
            update = this.scheduledInfomanUpdateHome.create(updateValue);
        }
        try {
            update.setUnitModel(this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId)));
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        return update.getScheduledInfomanUpdateValue();
    }

    public Collection<ScheduledInfomanUpdateValue> getPlannedInfomanRemoteUpdates(long unitId) throws ObjectNotFoundException, SecurityException {
        try {
            this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
            if (!this.adminUnitFacadeLocal.hasAccesRightPermissionForUnit(unitId)) {
                throw new SecurityException("Current user has no permissions for this unit: " + unitId);
            }
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        Collection coll = null;
        try {
            coll = this.scheduledInfomanUpdateHome.findPlanedUpdates(unitId);
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        ArrayList<ScheduledInfomanUpdateValue> ret = new ArrayList<ScheduledInfomanUpdateValue>();
        Iterator ite = coll.iterator();
        while (ite.hasNext()) {
            ScheduledInfomanUpdateValue siuv = ((ScheduledInfomanUpdateLocal)ite.next()).getScheduledInfomanUpdateValue();
            ret.add(siuv);
        }
        return ret;
    }

    public void addConfigurationToInfomanRemoteUpdate(long updateId, long unitId, byte[] oldConfiguration, byte[] newConfiguration) throws ObjectNotFoundException, SecurityException {
        try {
            this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
            if (!this.adminUnitFacadeLocal.hasAccesRightPermissionForUnit(unitId)) {
                throw new SecurityException("Current user has no permissions for this unit: " + unitId);
            }
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        log.debug((Object)("addConfigurationToInfomanRemoteUpdate(" + updateId + "," + unitId + "," + oldConfiguration + "," + newConfiguration + ") called. Not yet implemented. Do nothing!"));
    }

    public long beginInfomanUpdate(long unitId, byte[] oldConfiguration, byte[] newConfiguration) throws ObjectNotFoundException, SecurityException {
        try {
            this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
            if (!this.adminUnitFacadeLocal.hasAccesRightPermissionForUnit(unitId)) {
                throw new SecurityException("Current user has no permissions for this unit: " + unitId);
            }
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        log.debug((Object)("beginInfomanUpdate(" + unitId + "," + oldConfiguration + "," + newConfiguration + ") called. Not yet implemented. Returning 0!"));
        return 0L;
    }

    public void infomanUpdateDone(boolean successful, long updateId) throws ObjectNotFoundException {
        log.debug((Object)("infomanUpdateDone(" + successful + "," + updateId + ") called. Not yet implemented. Do nothing!"));
    }

    public void updateScheduledInfomanUpdate(ScheduledInfomanUpdateValue value) throws ObjectNotFoundException {
        try {
            ScheduledInfomanUpdateLocal update = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(value.getId()));
            update.setScheduledInfomanUpdateValue(value);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }
}

