/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.area;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.area.Area;
import de.proveo.wwt.logic.ejb.general.area.AreaData;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaPoints;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsPK;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsValue;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AreaInFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(AreaInFacadeBean.class);
    private AreaLocalHome areaHome;
    private AreaPointsLocalHome areaPointsHome;

    public void setAreaData(AreaData areaData) throws FinderException, CreateException {
        ArrayList cc = areaData.getAreaPointDatas();
        Iterator it = cc.iterator();
        if (cc.size() == 0) {
            throw new EJBException("cannot create an area with an empty point list");
        }
        AreaPointsValue areaPointsStruct = null;
        int i = 1;
        while (it.hasNext()) {
            areaPointsStruct = (AreaPointsValue)it.next();
            areaPointsStruct.setArea(areaData.getName());
            areaPointsStruct.setPoint(i);
            log.debug((Object)("Point :" + areaPointsStruct.getPoint()));
            ++i;
        }
        int minLong = 0;
        int maxLong = 0;
        int minLat = 0;
        int maxLat = 0;
        it = cc.iterator();
        log.debug((Object)("cc size: " + cc.size()));
        if (it.hasNext()) {
            areaPointsStruct = (AreaPointsValue)it.next();
            minLong = areaPointsStruct.getLongMsec();
            maxLong = areaPointsStruct.getLongMsec();
            minLat = areaPointsStruct.getLatMsec();
            maxLat = areaPointsStruct.getLatMsec();
        }
        while (it.hasNext()) {
            areaPointsStruct = (AreaPointsValue)it.next();
            if (areaPointsStruct.getLongMsec() < minLong) {
                minLong = areaPointsStruct.getLongMsec();
            }
            if (areaPointsStruct.getLongMsec() > maxLong) {
                maxLong = areaPointsStruct.getLongMsec();
            }
            if (areaPointsStruct.getLatMsec() < minLat) {
                minLat = areaPointsStruct.getLatMsec();
            }
            if (areaPointsStruct.getLatMsec() <= maxLat) continue;
            maxLat = areaPointsStruct.getLatMsec();
        }
        areaData.setMaxLong(maxLong);
        areaData.setMinLong(minLong);
        areaData.setMaxLat(maxLat);
        areaData.setMinLat(minLat);
        if (log.isDebugEnabled()) {
            log.debug((Object)("MaxLong Value: " + areaData.getMaxLong()));
            log.debug((Object)("MinLong Value: " + areaData.getMinLong()));
            log.debug((Object)("MaxLat Value:  " + areaData.getMaxLat()));
            log.debug((Object)("MinLat Value:  " + areaData.getMinLat()));
            if (areaPointsStruct != null) {
                log.debug((Object)("GetLatitude Value:  " + areaPointsStruct.getLatMsec()));
            }
        }
        try {
            this.saveAreaDatas(areaData);
        }
        catch (RemoteException ex) {
            log.error((Object)"runs during saveAreaDatas into", (Throwable)ex);
            throw new EJBException("runs during saveAreaDatas into " + ex.getMessage());
        }
    }

    public AreaData getAreaData(String name) {
        try {
            AreaLocal area = this.areaHome.findByPrimaryKey(new AreaPK(name));
            AreaValue areaValue = area.getAreaValue();
            AreaData areaData = new AreaData(areaValue);
            areaData.setAreaPointDatas(area.getPoints());
            return areaData;
        }
        catch (Exception ex) {
            log.error((Object)("runs during getAreaData('" + name + "') into"), (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    public String getAreaDescription(String name) {
        try {
            AreaLocal area = this.areaHome.findByPrimaryKey(new AreaPK(name));
            AreaValue areaValue = area.getAreaValue();
            return areaValue.getDescription();
        }
        catch (Exception ex) {
            log.error((Object)("runs during getAreaData('" + name + "') into"), (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    public Collection getAreaListData() {
        log.debug((Object)"getAreaListData() begin");
        ArrayList<AreaData> areaDatas = null;
        try {
            Collection remotes = this.areaHome.findAll();
            Iterator it = remotes.iterator();
            areaDatas = new ArrayList<AreaData>(remotes.size());
            while (it.hasNext()) {
                Area area = (Area)PortableRemoteObject.narrow(it.next(), Area.class);
                AreaValue areaValue = area.getAreaValue();
                AreaData areaData = new AreaData(areaValue);
                areaData.setAreaPointDatas(area.getPoints());
                areaDatas.add(areaData);
            }
        }
        catch (Exception ex) {
            log.error((Object)"getAreaListData() runs into", (Throwable)ex);
            throw new EJBException("getAreaListData() runs into " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        return areaDatas;
    }

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.areaHome = AreaUtil.getLocalHome();
            this.areaPointsHome = AreaPointsUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
            throw new CreateException("ejbCreate during ejb ref lookup into " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public Collection getAreaList() {
        ArrayList<AreaValue> structs = null;
        try {
            Collection remotes = this.areaHome.findAll();
            Iterator it = remotes.iterator();
            structs = new ArrayList<AreaValue>(remotes.size());
            while (it.hasNext()) {
                Area remote = (Area)PortableRemoteObject.narrow(it.next(), Area.class);
                structs.add(remote.getAreaValue());
            }
        }
        catch (Exception ex) {
            log.error((Object)"getAreaList() runs into", (Throwable)ex);
            throw new EJBException("getAreaList() runs into " + ex.getClass().getName() + ": " + ex.getMessage());
        }
        return structs;
    }

    public void point(AreaData areaData) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("point('" + areaData + "')"));
        }
        try {
            Object areaPoint;
            AreaPointsValue areaPointsStruct = null;
            this.areaPointsHome = AreaPointsUtil.getLocalHome();
            ArrayList cc = areaData.getAreaPointDatas();
            Iterator it = cc.iterator();
            log.debug((Object)("Size of collection  :" + cc.size()));
            while (it.hasNext()) {
                log.debug((Object)"Coming into while() :");
                areaPointsStruct = (AreaPointsValue)it.next();
                try {
                    areaPoint = this.areaPointsHome.findByPrimaryKey(new AreaPointsPK(areaData.getName(), areaPointsStruct.getPoint()));
                    areaPoint.setAreaPointsValue(areaPointsStruct);
                }
                catch (FinderException ex) {
                    log.debug((Object)"AreaPoints instance not found, create a new one");
                    AreaPointsLocal areaPoint2 = this.areaPointsHome.create(areaPointsStruct);
                }
            }
            areaPoint = this.areaPointsHome.findByAreaMissingPoints(areaData.getName(), areaPointsStruct.getPoint());
            it = areaPoint.iterator();
            while (it.hasNext()) {
                AreaPoints areaPoints = (AreaPoints)PortableRemoteObject.narrow(it.next(), AreaPoints.class);
                areaPoints.remove();
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs during point into", (Throwable)ex);
            throw new EJBException("runs during point into " + ex.getMessage());
        }
    }

    public void removeAllAreas() throws FinderException, RemoveException {
        log.info((Object)"removing all areas");
        for (AreaLocal area : this.areaHome.findAll()) {
            log.debug((Object)("removing area " + area.getArea() + " (" + area.getDescription() + ") ..."));
            area.remove();
            log.debug((Object)"... removed");
        }
    }

    public void remove(String areaName) throws FinderException, RemoveException {
        try {
            Collection points = this.areaPointsHome.findByArea(areaName);
            Iterator it = points.iterator();
            while (it.hasNext()) {
                AreaPoints point = (AreaPoints)PortableRemoteObject.narrow(it.next(), AreaPoints.class);
                point.remove();
            }
            AreaLocal area = this.areaHome.findByPrimaryKey(new AreaPK(areaName));
            area.remove();
        }
        catch (RemoteException ex) {
            throw new EJBException((Exception)ex);
        }
        log.debug((Object)("area " + areaName + " and matching points removed"));
    }

    public void saveAreaDatas(AreaData areaData) throws RemoteException, CreateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("saveAreaDatas('" + areaData + "')"));
        }
        AreaValue value = areaData.getAreaValue();
        try {
            block7: {
                AreaLocalHome areaHome = AreaUtil.getLocalHome();
                try {
                    AreaLocal area = areaHome.findByPrimaryKey(new AreaPK(areaData.getName()));
                    area.setAreaValue(value);
                }
                catch (FinderException ex) {
                    log.debug((Object)"area does't exist, create a new one");
                    AreaLocal area = areaHome.create(value);
                    if (!log.isDebugEnabled()) break block7;
                    AreaValue areaDataDebug = area.getAreaValue();
                    log.debug((Object)("created: " + areaDataDebug));
                }
            }
            log.debug((Object)"area saved, try to update point list");
            try {
                this.point(areaData);
            }
            catch (Exception e) {
                throw new CreateException("Runs into :" + e.getMessage());
            }
        }
        catch (NamingException ex) {
            log.error((Object)"runs during saveAreaDatas into", (Throwable)ex);
            throw new EJBException("runs during saveAreaDatas into " + ex.getMessage());
        }
    }

    public void createArea(String areaId, String areaDescription, int prio) {
        AreaData areaData = new AreaData(areaId, areaDescription);
        areaData.setPriority(prio);
        try {
            AreaLocal area = this.areaHome.create(areaData.getAreaValue());
        }
        catch (CreateException ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
    }

    protected void calculateMinMax(AreaData areaData) {
        ArrayList cc = areaData.getAreaPointDatas();
    }

    public void updateAllAreas(Collection<AreaData> newAreas) {
        boolean errorsHappenedWhileUpdating = false;
        try {
            this.removeAllAreas();
            log.info((Object)"Write new areas to database...");
            if (newAreas != null) {
                for (AreaData area : newAreas) {
                    try {
                        this.setAreaData(area);
                    }
                    catch (Exception ex) {
                        errorsHappenedWhileUpdating = true;
                        String areaName = "UNKNOWN";
                        if (area != null) {
                            areaName = area.getName();
                        }
                        log.error((Object)("Error while updating area: " + areaName), (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new EJBException("Error while updating areas", ex);
        }
        if (!errorsHappenedWhileUpdating) {
            log.info((Object)"New areas succussfully written to database.");
        }
    }
}

