/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.useuser.UseUserFacadeData;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocal;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocalHome;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupPK;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserPK;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UseUserFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(UseUserFacadeBean.class);
    private UseGroupLocalHome useGroupHome;
    private UseUserLocalHome useUserHome;

    public UseUserFacadeData getDataForUseUser(long id) {
        UseUserFacadeData data = new UseUserFacadeData();
        try {
            UseUserLocal useUser = this.useUserHome.findByPrimaryKey(new UseUserPK(data.getId()));
            data.setId(useUser.getId());
            data.setKey(useUser.getKey());
            data.setGroupId(useUser.getUseUserValue().getGroupId());
            data.setName(useUser.getUseUserValue().getName());
            data.setDescription(useUser.getUseUserValue().getDescription());
            UseGroupLocal useGroup = this.useGroupHome.findByPrimaryKey(new UseGroupPK(data.getGroupId()));
            data.setGroupName(useGroup.getUseGroupValue().getName());
        }
        catch (Exception ex) {
            log.error((Object)"getDataForUnitBasicGroup runs into", (Throwable)ex);
            throw new EJBException("getDataForUnitBasicGroup runs into " + ex.getMessage());
        }
        return data;
    }

    public Collection getDatas() {
        try {
            Collection col = this.useUserHome.findAll();
            return this.getFacadeStructFromUseUserRemotes(col);
        }
        catch (Exception e) {
            log.error((Object)"getDatas runs into", (Throwable)e);
            throw new EJBException("getDatas runs into " + e.getMessage());
        }
    }

    public Collection getUserDatasOfGroup(long groupId) {
        try {
            Collection col = this.useUserHome.findByGroupId(groupId);
            return this.getFacadeStructFromUseUserRemotes(col);
        }
        catch (Exception e) {
            log.error((Object)"getDatas runs into", (Throwable)e);
            throw new EJBException("getDatas runs into " + e.getMessage());
        }
    }

    public void ejbCreate() throws CreateException {
        try {
            this.useUserHome = UseUserUtil.getLocalHome();
            this.useGroupHome = UseGroupUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during ejb lookup into", (Throwable)ex);
            throw new CreateException("runs during ejb lookup into " + ex.getMessage());
        }
    }

    protected Collection getFacadeStructFromUseUserRemotes(Collection remotes) {
        try {
            ArrayList<UseUserFacadeData> structs = new ArrayList<UseUserFacadeData>(remotes.size());
            Iterator it = remotes.iterator();
            while (it.hasNext()) {
                UseUserFacadeData data = new UseUserFacadeData();
                UseUserLocal useUser = (UseUserLocal)it.next();
                UseUserValue useUserStruct = useUser.getUseUserValue();
                data.setId(useUserStruct.getId());
                data.setKey(useUserStruct.getKey());
                data.setGroupId(useUserStruct.getGroupId());
                data.setName(useUserStruct.getName());
                data.setDescription(useUserStruct.getDescription());
                UseGroupLocal useGroup = this.useGroupHome.findByPrimaryKey(new UseGroupPK(data.getGroupId()));
                data.setGroupName(useGroup.getUseGroupValue().getName());
                structs.add(data);
            }
            return structs;
        }
        catch (Exception ex) {
            log.error((Object)"getFacadeStructFromUseUserRemotes() runs into", (Throwable)ex);
            throw new EJBException("getFacadeStructFromUseUserRemotes() runs into " + ex.getMessage());
        }
    }
}

