/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.state;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.state.exception.NoStateFoundException;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCachePK;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryPK;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.dataOut.raw.StateStamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StateOutFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(StateOutFacadeBean.class);
    private CurrentStateCacheLocalHome stateCacheHome;
    private StateHistoryLocalHome stateHistoryHome;

    public void ejbCreate() throws CreateException {
        try {
            this.stateCacheHome = CurrentStateCacheUtil.getLocalHome();
            this.stateHistoryHome = StateHistoryUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public Set getUnitEvents(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoStateFoundException {
        HashSet<StateStamp> allStamps = new HashSet<StateStamp>();
        HashSet cacheStamps = this.getUnitEventsFromCache(basicUnitId, requestedBeginTime, requestedEndTime);
        for (StateStamp cacheStamp : cacheStamps) {
            if (cacheStamp.getBegin() > requestedEndTime) continue;
            allStamps.add(cacheStamp);
        }
        HashSet historyStamps = this.getUnitEventsFromHistory(basicUnitId, requestedBeginTime, requestedEndTime);
        allStamps.addAll(historyStamps);
        if (allStamps.size() < 1) {
            log.debug((Object)("nothing found in cache and history for unit '" + basicUnitId + "'."));
        }
        return allStamps;
    }

    public Set getUnitEvents(long basicUnitId, long stateModelId, long requestedBeginTime, long requestedEndTime) throws NoStateFoundException {
        HashSet<StateStamp> allStamps;
        String sMethodName;
        block8: {
            block7: {
                sMethodName = "getUnitEvents()";
                allStamps = new HashSet<StateStamp>();
                try {
                    StateStamp cacheStamp = this.getUnitEventFromCache(basicUnitId, stateModelId, requestedBeginTime, requestedEndTime);
                    if (cacheStamp.getBegin() <= requestedEndTime) {
                        allStamps.add(cacheStamp);
                    }
                    if (cacheStamp.getBegin() <= requestedBeginTime) {
                        return allStamps;
                    }
                }
                catch (NoStateFoundException ex) {
                    if (!ex.isError()) break block7;
                    throw ex;
                }
            }
            try {
                HashSet historyStamps = this.getUnitEventsFromHistory(basicUnitId, stateModelId, requestedBeginTime, requestedEndTime);
                allStamps.addAll(historyStamps);
            }
            catch (NoStateFoundException e) {
                if (!e.isError()) break block8;
                throw e;
            }
        }
        if (allStamps.size() < 1) {
            log.debug((Object)(sMethodName + ": nothing found in cache and history for unit '" + basicUnitId + "', state model '" + stateModelId + "'."));
        }
        return allStamps;
    }

    public ArrayList getAllUnitEventsFromCacheSortedByPreviousPk() {
        ArrayList<CurrentStateCacheValue> values = new ArrayList<CurrentStateCacheValue>();
        try {
            Collection col = this.stateCacheHome.findAllSortedByPk();
            for (CurrentStateCacheLocal cache : col) {
                CurrentStateCacheValue value = cache.getCurrentStateCacheValue();
                values.add(value);
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return values;
    }

    public StateHistoryValue getStateHistoryValue(StateHistoryPK pk) {
        try {
            return StateHistoryUtil.getLocalHome().findByPrimaryKey(pk).getStateHistoryValue();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return null;
    }

    protected StateStamp getUnitEventFromCache(long basicUnitId, long stateModelId, long requestedBeginTime, long requestedEndTime) throws NoStateFoundException {
        long endTime;
        CurrentStateCacheValue cv;
        try {
            CurrentStateCacheLocal stateCache = this.stateCacheHome.findByPrimaryKey(new CurrentStateCachePK(basicUnitId, stateModelId));
            cv = stateCache.getCurrentStateCacheValue();
        }
        catch (FinderException ex) {
            throw new NoStateFoundException(basicUnitId, stateModelId, "nothing found in cache");
        }
        long beginTime = cv.getBeginTime();
        if (beginTime < requestedBeginTime) {
            beginTime = requestedBeginTime;
        }
        if ((endTime = System.currentTimeMillis()) > requestedEndTime) {
            endTime = requestedEndTime;
        }
        return new StateStamp(cv.getStateModelId(), cv.getState(), beginTime, endTime, endTime - cv.getBeginTime(), cv.getBeginReceiveTime(), 0L, cv.getBeginReceiveTime() - cv.getBeginTime(), 0L, cv.getStateIdPrevious(), 0L, cv.getRemark());
    }

    protected HashSet getUnitEventsFromCache(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoStateFoundException {
        Collection cacheEntries;
        try {
            cacheEntries = this.stateCacheHome.findByUnitId(basicUnitId);
        }
        catch (FinderException ex) {
            throw new NoStateFoundException(basicUnitId, "nothing found in cache", (Exception)((Object)ex));
        }
        return this.getCacheStateStamps(cacheEntries, requestedBeginTime, requestedEndTime);
    }

    protected HashSet getUnitEventsFromHistory(long basicUnitId, long stateModelId, long requestedBeginTime, long requestedEndTime) throws NoStateFoundException {
        Collection historyEntries;
        try {
            historyEntries = this.stateHistoryHome.findByUnitStateModel(basicUnitId, stateModelId, requestedBeginTime, requestedEndTime);
        }
        catch (FinderException ex) {
            throw new NoStateFoundException(basicUnitId, stateModelId, "nothing found");
        }
        return this.getHistoryStateStamps(historyEntries, requestedBeginTime, requestedEndTime);
    }

    protected HashSet getUnitEventsFromHistory(long basicUnitId, long requestedBeginTime, long requestedEndTime) throws NoStateFoundException {
        Collection historyEntries;
        try {
            historyEntries = this.stateHistoryHome.findByUnitPeriod(basicUnitId, requestedBeginTime, requestedEndTime);
        }
        catch (FinderException ex) {
            throw new NoStateFoundException(basicUnitId, "nothing found", (Exception)((Object)ex));
        }
        return this.getHistoryStateStamps(historyEntries, requestedBeginTime, requestedEndTime);
    }

    private HashSet getHistoryStateStamps(Collection historyEntries, long requestedBeginTime, long requestedEndTime) {
        HashSet<StateStamp> stateStamps = new HashSet<StateStamp>();
        Iterator it = historyEntries.iterator();
        while (it.hasNext()) {
            long endTime;
            StateHistoryLocal stateHistory = (StateHistoryLocal)PortableRemoteObject.narrow(it.next(), StateHistoryLocal.class);
            StateHistoryValue shv = stateHistory.getStateHistoryValue();
            long beginTime = shv.getBeginTime();
            if (beginTime < requestedBeginTime) {
                beginTime = requestedBeginTime;
            }
            if ((endTime = shv.getEndTime()) > requestedEndTime) {
                endTime = requestedEndTime;
            }
            StateStamp stamp = new StateStamp(shv.getStateModelId(), shv.getStateId(), beginTime, endTime, shv.getEndTime() - shv.getBeginTime(), shv.getBeginReceiveTime(), shv.getEndReceiveTime(), shv.getBeginReceiveTime() - shv.getBeginTime(), shv.getEndReceiveTime() - shv.getEndTime(), shv.getStateIdPrevious(), shv.getStateIdAfter(), shv.getRemark());
            stateStamps.add(stamp);
        }
        return stateStamps;
    }

    private HashSet getCacheStateStamps(Collection cacheEntries, long requestedBeginTime, long requestedEndTime) {
        HashSet<StateStamp> stateStamps = new HashSet<StateStamp>();
        for (Object obj : cacheEntries) {
            long endTime;
            CurrentStateCacheLocal stateCache = (CurrentStateCacheLocal)PortableRemoteObject.narrow(obj, CurrentStateCacheLocal.class);
            CurrentStateCacheValue cv = stateCache.getCurrentStateCacheValue();
            long beginTime = cv.getBeginTime();
            if (beginTime < requestedBeginTime) {
                beginTime = requestedBeginTime;
            }
            if ((endTime = System.currentTimeMillis()) > requestedEndTime) {
                endTime = requestedEndTime;
            }
            stateStamps.add(new StateStamp(cv.getStateModelId(), cv.getState(), beginTime, endTime, endTime - cv.getBeginTime(), cv.getBeginReceiveTime(), 0L, cv.getBeginReceiveTime() - cv.getBeginTime(), 0L, cv.getStateIdPrevious(), 0L, cv.getRemark()));
        }
        return stateStamps;
    }
}

