/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.mapclient;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacade;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationClientFacadeLocal;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanConfigurationClientFacadeUtil;
import de.proveo.wwt.logic.ejb.general.notification.NotificationValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.general.use.user.UserNotFoundException;
import de.proveo.wwt.logic.web.admin.AdminFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminFacadeUtil;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocal;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeUtil;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocalHome;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapClientFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(MapClientFacadeBean.class);
    private AdminFacadeLocal adminFacade;
    private AreaLocalHome areaHome;
    private CurrentGdataCacheLocalHome currentGdataCacheHome;
    private KeepAliveCacheLocalHome keepAliveCacheHome;
    private CurrentStateCacheLocalHome currentStateCacheHome;
    private CommonDataFacadeLocal commonDataHome;
    private UnitIdentityLocalHome unitIdentityHome;
    private ScanmanMsgFacadeLocal scanmanMsgFacade;
    private NotifyHistoryLocalHome notifyFacadeLocalHome;
    private UseCacheLocalHome useCacheLocalHome;
    private long infomanKeepaliveTimeout = 0L;
    private PermissionCheckerLocalHome permissionCheckerLocalHome;
    private PermissionCheckerLocal permissionChecker;
    private HashSet<Long> unitPermissions;
    private UseFacade useFacade;
    private InfomanConfigurationClientFacadeLocal infomanConfigurationClientFacade;
    private LoginContextUtil lcu;
    private boolean oldMap = false;

    public HashSet<Long> getUnitPermissions() {
        if (this.unitPermissions != null) {
            return this.unitPermissions;
        }
        try {
            this.permissionChecker = this.permissionCheckerLocalHome.create();
        }
        catch (CreateException e) {
            e.printStackTrace();
        }
        this.unitPermissions = this.permissionChecker.getUnitPermissions();
        return this.unitPermissions;
    }

    public Set getOnlineMapData(boolean scanmanMessagesNeeded, boolean notifyMessagesNeeded, boolean useMessagesNeeded, String username, String password) {
        String sMethodName = "getOnlineMapData(): ";
        HashSet<Map> allStamps = new HashSet<Map>();
        Map currentGdatas = this.getAllCurrentGdataCache();
        Map areas = this.getAllAreas();
        Map unitIdentities = this.getAllUnitIdentities();
        if (username == null && password == null) {
            this.oldMap = true;
        } else {
            try {
                this.lcu = new LoginContextUtil(username, password);
            }
            catch (Exception ex) {
                log.error((Object)"LoginContextUtil runs into: ", (Throwable)ex);
            }
        }
        Map notifyEvents = new HashMap();
        if (notifyMessagesNeeded) {
            notifyEvents = this.getAllNotifyEvents();
        }
        Map currentKeepAlives = this.getAllKeepAliveCache();
        Map currentUseEvents = new HashMap();
        if (useMessagesNeeded) {
            currentUseEvents = this.getAllUseCache();
        }
        try {
            this.permissionChecker = this.permissionCheckerLocalHome.create();
        }
        catch (CreateException e) {
            e.printStackTrace();
        }
        HashSet<Long> unitPermissions = this.permissionChecker.getUnitPermissions();
        Collection col = this.getCurrentStates();
        Iterator it = col.iterator();
        int i = 0;
        long lastUnitId = -1L;
        Map mapClientStamp = null;
        long currentTime = System.currentTimeMillis();
        while (it.hasNext()) {
            CurrentStateCacheLocal remote = (CurrentStateCacheLocal)it.next();
            CurrentStateCacheValue state = remote.getCurrentStateCacheValue();
            long unitId = state.getUnitId();
            if (!unitPermissions.contains(unitId)) continue;
            if (unitId != lastUnitId) {
                if (mapClientStamp != null) {
                    allStamps.add(mapClientStamp);
                }
                mapClientStamp = this.getNewMapClientStamp(unitId, unitIdentities, notifyEvents, currentUseEvents, areas, currentGdatas, currentKeepAlives, currentTime, scanmanMessagesNeeded, notifyMessagesNeeded, useMessagesNeeded);
                lastUnitId = unitId;
            }
            if (mapClientStamp != null) {
                this.addState(mapClientStamp, state);
            }
            ++i;
        }
        if (mapClientStamp != null) {
            allStamps.add(mapClientStamp);
        }
        return allStamps;
    }

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.adminFacade = AdminFacadeUtil.getLocalHome().create();
            this.currentGdataCacheHome = CurrentGdataCacheUtil.getLocalHome();
            this.keepAliveCacheHome = KeepAliveCacheUtil.getLocalHome();
            this.currentStateCacheHome = CurrentStateCacheUtil.getLocalHome();
            this.areaHome = AreaUtil.getLocalHome();
            this.commonDataHome = CommonDataFacadeUtil.getLocalHome().create();
            this.unitIdentityHome = UnitIdentityUtil.getLocalHome();
            this.scanmanMsgFacade = ScanmanMsgFacadeUtil.getLocalHome().create();
            this.notifyFacadeLocalHome = NotifyHistoryUtil.getLocalHome();
            this.permissionCheckerLocalHome = PermissionCheckerUtil.getLocalHome();
            this.useCacheLocalHome = UseCacheUtil.getLocalHome();
            this.useFacade = UseFacadeUtil.getHome().create();
            this.infomanConfigurationClientFacade = InfomanConfigurationClientFacadeUtil.getLocalHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
        long DEFAULT = 300L;
        long value = 300L;
        String key = "infoman.keepalive.timeout";
        ConfigurationClient cc = new ConfigurationClient();
        try {
            String para = cc.getParameter(key, Long.toString(300L));
            value = Long.parseLong(para);
        }
        catch (RemoteException ex) {
            log.error((Object)("ConfigurationClient.getParameter() runs into RemoteException, use DEFAULT 300 for '" + key + "'."));
        }
        this.infomanKeepaliveTimeout = value * 60L * 1000L;
    }

    protected Collection getCurrentStates() {
        Collection states = new HashSet();
        try {
            states = this.currentStateCacheHome.findAllForAirportmap();
        }
        catch (FinderException ex) {
            log.error((Object)"getCurrentStates() Finder Problem", (Throwable)ex);
        }
        return states;
    }

    protected Map getAllCurrentGdataCache() {
        Collection col = new HashSet();
        try {
            col = this.currentGdataCacheHome.findAllForAirportmap();
        }
        catch (FinderException ex) {
            log.error((Object)"getAllCurrentGdataCache() Finder Problem", (Throwable)ex);
        }
        HashMap<Long, CurrentGdataCacheValue> gdatas = new HashMap<Long, CurrentGdataCacheValue>();
        for (CurrentGdataCacheLocal remote : col) {
            CurrentGdataCacheValue value = remote.getCurrentGdataCacheValue();
            gdatas.put(new Long(value.getUnitId()), value);
        }
        return gdatas;
    }

    protected Map getAllUseCache() {
        Collection allUseCacheCol = new HashSet();
        try {
            allUseCacheCol = this.useCacheLocalHome.findAll();
        }
        catch (FinderException e) {
            log.error((Object)"getAllUseCache runs into FinderException: ", (Throwable)e);
        }
        HashMap<Long, UseCacheValue> useEvents = new HashMap<Long, UseCacheValue>();
        Iterator it = allUseCacheCol.iterator();
        while (it.hasNext()) {
            UseCacheValue value = ((UseCacheLocal)it.next()).getUseCacheValue();
            Long unitId = new Long(value.getUnitId());
            useEvents.put(unitId, value);
        }
        return useEvents;
    }

    protected Map getAllKeepAliveCache() {
        String method = "getAllKeepAliveCache(): ";
        Collection col = new HashSet();
        try {
            col = this.keepAliveCacheHome.findAllForAirportmap();
        }
        catch (FinderException ex) {
            log.error((Object)(method + "Finder Problem"), (Throwable)ex);
        }
        HashMap<Long, KeepAliveCacheValue> alives = new HashMap<Long, KeepAliveCacheValue>();
        for (KeepAliveCacheLocal remote : col) {
            KeepAliveCacheValue value = remote.getKeepAliveCacheValue();
            alives.put(new Long(value.getUnitId()), value);
        }
        return alives;
    }

    protected Map getAllAreas() {
        String method = "getAllAreas(): ";
        Collection col = new HashSet();
        try {
            col = this.areaHome.findAll();
        }
        catch (FinderException ex) {
            log.error((Object)(method + "Finder Problem"), (Throwable)ex);
        }
        HashMap<String, AreaValue> areas = new HashMap<String, AreaValue>();
        for (AreaLocal remote : col) {
            AreaValue value = remote.getAreaValue();
            areas.put(value.getArea(), value);
        }
        return areas;
    }

    protected Map getAllUnitIdentities() {
        String method = "getAllUnitIdentities(): ";
        Collection col = new HashSet();
        try {
            col = this.unitIdentityHome.findAllForAirportmap();
        }
        catch (FinderException ex) {
            log.error((Object)(method + "Finder Problem"), (Throwable)ex);
        }
        HashMap<Long, UnitIdentityValue> identities = new HashMap<Long, UnitIdentityValue>();
        for (UnitIdentityLocal remote : col) {
            UnitIdentityValue value = remote.getUnitIdentityValue();
            identities.put(new Long(value.getUnitId()), value);
        }
        return identities;
    }

    protected ScanmanMsgHistoryValue getLastScanmanMessage(long unitId, int type) {
        String method = "getLastScanmanMessage(unitId=" + unitId + ", type=" + type + "): ";
        ScanmanMsgHistoryValue value = this.scanmanMsgFacade.getLastMessage(type, unitId);
        return value;
    }

    protected Map getAllNotifyEvents() {
        String method = "getAllNotifyEvents(): ";
        Collection col = new HashSet();
        long startTime = System.currentTimeMillis() - 86400000L;
        try {
            col = this.notifyFacadeLocalHome.findAllOlderThanGivenTimestamp(startTime);
        }
        catch (FinderException ex) {
            log.error((Object)(method + "Finder Problem"), (Throwable)ex);
        }
        HashMap notifys = new HashMap();
        Iterator it = col.iterator();
        long endTime = System.currentTimeMillis();
        while (it.hasNext()) {
            NotifyHistoryValue value = ((NotifyHistoryLocal)it.next()).getNotifyHistoryValue();
            Long unitId = new Long(value.getUnitId());
            Vector<NotifyHistoryValue> collection = null;
            if (this.notifyEventAndUnitHasPermission(unitId)) {
                collection = (Vector<NotifyHistoryValue>)notifys.get(unitId);
            }
            if (collection == null) {
                collection = new Vector<NotifyHistoryValue>();
            }
            collection.add(value);
            notifys.put(unitId, collection);
        }
        return notifys;
    }

    private boolean notifyEventAndUnitHasPermission(Long unitId) {
        if (this.oldMap) {
            return true;
        }
        if (this.lcu == null) {
            return false;
        }
        if (this.lcu.isSuperAdmin()) {
            return true;
        }
        if (!this.lcu.isUserInRole("section.airportmap.notification")) {
            return false;
        }
        if (this.unitPermissions == null) {
            this.unitPermissions = this.getUnitPermissions();
        }
        return this.unitPermissions.contains(unitId);
    }

    private Map getNewMapClientStamp(long uid, Map unitIdentities, Map notifyEvents, Map currentUseEvents, Map areas, Map currentGdatas, Map currentKeepAlives, long now, boolean scanmanMessagesNeeded, boolean notifyMessagesNeeded, boolean useMessagesNeeded) {
        String method = "getNewMapClientStamp(): ";
        Long unitId = new Long(uid);
        UnitIdentityValue unitIdentity = (UnitIdentityValue)unitIdentities.get(unitId);
        if (unitIdentity == null) {
            log.error((Object)(method + "no UnitIdentity found for unitId " + uid));
            return null;
        }
        CurrentGdataCacheValue currentGdata = (CurrentGdataCacheValue)currentGdatas.get(unitId);
        if (currentGdata == null) {
            log.error((Object)(method + "no CurrentGdataCache found for unitId " + uid));
            return null;
        }
        String area = currentGdata.getArea();
        AreaValue areaValue = (AreaValue)areas.get(area);
        if (areaValue == null) {
            if (area == null || area.length() < 1) {
                log.debug((Object)(method + "empty area in CURRENT_GDATA_CACHE for unitId " + uid + ", seems like GSE is out of airport"));
            } else {
                log.error((Object)(method + "no AREA record found for area '" + area + "' in CURRENT_GDATA_CACHE"));
            }
            areaValue = new AreaValue();
            areaValue.setArea("-");
            areaValue.setDescription("(not defined)");
            areaValue.setPriority(0);
        }
        KeepAliveCacheValue currentKeepAlive = (KeepAliveCacheValue)currentKeepAlives.get(unitId);
        boolean currentKeepAliveTimeout = false;
        if (currentKeepAlive == null) {
            currentKeepAlive = new KeepAliveCacheValue();
            currentKeepAlive.setUnitId(uid);
            currentKeepAlive.setTimeStamp(0L);
            currentKeepAliveTimeout = false;
        } else if (now - currentKeepAlive.getTimeStamp() > this.infomanKeepaliveTimeout) {
            currentKeepAliveTimeout = true;
        }
        String unitKind = unitIdentity.getUnitKind();
        try {
            String tmp = this.commonDataHome.getUnit(unitId).getUnitTypeIdentityValue().getAirportMapType();
            if (tmp.trim().length() > 0) {
                unitKind = tmp;
            }
        }
        catch (Throwable ex) {
            unitKind = unitIdentity.getUnitKind();
        }
        String unitType = unitKind;
        try {
            String tmp = this.commonDataHome.getUnit(unitId).getUnitTypeIdentityValue().getName();
            if (tmp.trim().length() > 0) {
                unitType = tmp;
            }
        }
        catch (Throwable ex) {
            unitType = unitKind;
        }
        HashMap<String, Object> mapClientStamp = new HashMap<String, Object>();
        mapClientStamp.put("UnitId", unitId);
        mapClientStamp.put("UnitKind", unitKind);
        mapClientStamp.put("UnitType", unitType);
        mapClientStamp.put("UnitName", unitIdentity.getName());
        mapClientStamp.put("GpsGga", currentGdata.getGgaRec());
        mapClientStamp.put("GpsRmc", currentGdata.getRmcRec());
        mapClientStamp.put("GpsTrusted", new Boolean(currentGdata.getTrusted()));
        mapClientStamp.put("GeoBegin", new Long(currentGdata.getCreateTime()));
        mapClientStamp.put("Area", areaValue.getArea());
        mapClientStamp.put("AreaName", areaValue.getDescription());
        mapClientStamp.put("KeepaliveTimestamp", new Long(currentKeepAlive.getTimeStamp()));
        mapClientStamp.put("KeepaliveTimeout", new Boolean(currentKeepAliveTimeout));
        if (scanmanMessagesNeeded) {
            ScanmanMsgHistoryValue lastIPMessage = null;
            ScanmanMsgHistoryValue lastBootMessage = null;
            ScanmanMsgHistoryValue lastErrorMessage = null;
            lastErrorMessage = this.getLastScanmanMessage(unitId, 9);
            lastIPMessage = this.getLastScanmanMessage(unitId, 10);
            lastBootMessage = this.getLastScanmanMessage(unitId, 25);
            if (lastBootMessage != null) {
                mapClientStamp.put("SmBootTimestamp", lastBootMessage.getCreateTime());
                mapClientStamp.put("SmBootMessage", lastBootMessage.getMsgToString());
            }
            if (lastIPMessage != null) {
                mapClientStamp.put("SmIpTimestamp", lastIPMessage.getCreateTime());
                mapClientStamp.put("SmIpMessage", lastIPMessage.getMsgToString());
            }
            if (lastErrorMessage != null) {
                mapClientStamp.put("SmErrorTimestamp", lastErrorMessage.getCreateTime());
                mapClientStamp.put("SmErrorMessage", lastErrorMessage.getMsgToString());
            }
        }
        if (notifyMessagesNeeded) {
            TreeMap notifyMap = null;
            Collection notifys = (Collection)notifyEvents.get(unitId);
            if (notifys == null) {
                log.debug((Object)(method + "no notifyEvents found for unitId " + uid));
            } else {
                notifyMap = new TreeMap();
                for (NotifyHistoryValue nhv : notifys) {
                    long timestamp = nhv.getCreateTime();
                    long messageId = nhv.getMessageId();
                    NotificationValue value = this.adminFacade.getNotificationById(messageId);
                    String message = "";
                    if (value != null) {
                        message = value.getDefaultName();
                    }
                    HashMap<String, Object> valueMap = new HashMap<String, Object>();
                    valueMap.put("UnitId", new Long(nhv.getUnitId()));
                    valueMap.put("NotifyMessageID", new Long(messageId));
                    valueMap.put("NotifyMessage", message);
                    valueMap.put("NotifyEntry", new Boolean(nhv.getEntry()));
                    valueMap.put("NotifyTimestamp", new Long(timestamp));
                    valueMap.put("NotifyReceiveTime", new Long(nhv.getReceiveTime()));
                    notifyMap.put(timestamp + "_" + messageId, valueMap);
                }
            }
            mapClientStamp.put("NotifyEvents", notifyMap);
        }
        if (useMessagesNeeded) {
            UseCacheValue useEvent = (UseCacheValue)currentUseEvents.get(unitId);
            if (useEvent == null) {
                log.debug((Object)(method + "no useEvents found for unitId " + uid));
            } else {
                long userId = useEvent.getUserId();
                try {
                    UseUserValue useUserValue = this.useFacade.getUser(userId);
                    mapClientStamp.put("UseEventTimestamp", useEvent.getBeginTime());
                    mapClientStamp.put("UseEventUserGroupId", useEvent.getGroupId());
                    mapClientStamp.put("UseEventLogin", true);
                    mapClientStamp.put("UseEventReceiveTime", useEvent.getBeginReceiveTime());
                    mapClientStamp.put("UseEventUserKey", useUserValue.getKey());
                    mapClientStamp.put("UseEventDriverName", useUserValue.getName());
                    mapClientStamp.put("UseEventPersonalNumber", useUserValue.getPersonalNumber());
                }
                catch (RemoteException e) {
                    log.error((Object)"getNewMapClientStamp runs into RemoteException: ", (Throwable)e);
                }
                catch (UserNotFoundException e) {
                    log.error((Object)"getNewMapClientStamp runs into UserNotFoundException: ", (Throwable)e);
                }
            }
        }
        return mapClientStamp;
    }

    private void addState(Map mapClientStamp, CurrentStateCacheValue state) {
        String methodName = "addState(): ";
        long stateModel = state.getStateModelId();
        if (stateModel == 2010L) {
            mapClientStamp.put("MotorState", new Long(state.getState()));
            mapClientStamp.put("MotorStateBegin", new Long(state.getBeginTime()));
        } else if (stateModel == 2050L) {
            mapClientStamp.put("OperationState", new Long(state.getState()));
            mapClientStamp.put("OperationStateBegin", new Long(state.getBeginTime()));
        } else if (stateModel == 2090L) {
            mapClientStamp.put("ServiceState", new Long(state.getState()));
            mapClientStamp.put("ServiceStateBegin", new Long(state.getBeginTime()));
            mapClientStamp.put("ServiceStateRemark", state.getRemark());
        } else if (stateModel == 2100L) {
            mapClientStamp.put("AssignedState", new Long(state.getState()));
            mapClientStamp.put("AssignedStateBegin", new Long(state.getBeginTime()));
            mapClientStamp.put("AssignedStateRemark", state.getRemark());
        } else if (stateModel == 2110L) {
            mapClientStamp.put("InfomanOnlineState", new Long(state.getState()));
            mapClientStamp.put("InfomanOnlineStateBegin", new Long(state.getBeginTime()));
        } else if (stateModel == 2030L) {
            mapClientStamp.put("FuelState", new Long(state.getState()));
            mapClientStamp.put("FuelStateBegin", new Long(state.getBeginTime()));
        } else if (stateModel == 2020L) {
            mapClientStamp.put("ConnectorState", new Long(state.getState()));
            mapClientStamp.put("ConnectorStateBegin", new Long(state.getBeginTime()));
        } else if (stateModel == 2910L) {
            mapClientStamp.put("Flag1State", new Long(state.getState()));
            mapClientStamp.put("Flag1StateBegin", new Long(state.getBeginTime()));
        } else if (stateModel == 2920L) {
            mapClientStamp.put("Flag2State", new Long(state.getState()));
            mapClientStamp.put("Flag2StateBegin", new Long(state.getBeginTime()));
        } else if (stateModel == 2930L) {
            mapClientStamp.put("Flag3State", new Long(state.getState()));
            mapClientStamp.put("Flag3StateBegin", new Long(state.getBeginTime()));
        } else if (stateModel == 2120L) {
            mapClientStamp.put("GseAssignmentState", new Long(state.getState()));
            mapClientStamp.put("GseAssignmentStateBegin", new Long(state.getBeginTime()));
        } else {
            log.warn((Object)(methodName + "state model '" + stateModel + "' not implemented!"));
        }
    }
}

