/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.use;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.use.event.UseEvent;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCachePK;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.error.UseErrorHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.error.UseErrorHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.error.UseErrorHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.use.exception.UseWriteException;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.use.group.GroupNotFoundException;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocal;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocalHome;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupPK;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupUtil;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupValue;
import de.proveo.wwt.logic.ejb.general.use.unituser.UnitUserLocal;
import de.proveo.wwt.logic.ejb.general.use.unituser.UnitUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.unituser.UnitUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.general.use.user.UserNotFoundException;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.admin.AdminFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminFacadeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UseFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(UseFacadeBean.class);
    private UseCacheLocalHome useCacheHome;
    private UseHistoryLocalHome useHistoryHome;
    private UseUserLocalHome useUserHome;
    private UseGroupLocalHome useGroupHome;
    private UnitUserLocalHome unitUserHome;
    private UseErrorHistoryLocalHome useErrorHistoryHome;
    private UnitUserLocal unitUserBean;
    private AdminFacadeLocal adminFacade;
    private AreaLocalHome areaHome;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.useCacheHome = UseCacheUtil.getLocalHome();
            this.useHistoryHome = UseHistoryUtil.getLocalHome();
            this.useUserHome = UseUserUtil.getLocalHome();
            this.useGroupHome = UseGroupUtil.getLocalHome();
            this.unitUserHome = UnitUserUtil.getLocalHome();
            this.unitUserBean = this.unitUserHome.create();
            this.useErrorHistoryHome = UseErrorHistoryUtil.getLocalHome();
            this.adminFacade = AdminFacadeUtil.getLocalHome().create();
            this.areaHome = AreaUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public void event(Properties rawEvent, UseEvent event, String area) throws ImplicitRollbackException {
        block8: {
            try {
                UseUserValue user = this.getUser(event.getUserKey());
                UseGroupValue group = this.getGroup(event.getUserGroupId());
                long userId = user.getId();
                if (event.isLogin()) {
                    try {
                        this.handleLogin(userId, event, rawEvent, area);
                        break block8;
                    }
                    catch (UseWriteException e) {
                        throw new ImplicitRollbackException();
                    }
                }
                try {
                    this.handleLogoff(userId, event, rawEvent, area);
                }
                catch (UseWriteException e) {
                    throw new ImplicitRollbackException();
                }
            }
            catch (UserNotFoundException ex) {
                log.error((Object)("handleLogin() cannot find user " + event.getUserKey() + ". Move event to error history."));
                UseErrorHistoryValue err = new UseErrorHistoryValue();
                err.setUnitId(event.getUnitId());
                err.setTime(event.getTimestamp());
                err.setReceiveTime(event.getReceiveTime());
                err.setLogin(event.isLogin());
                err.setUserIdNotFit(true);
                err.setErrorMessage("unkown user key '" + event.getUserKey() + "'");
                this.writeErrorMessage(err);
            }
            catch (GroupNotFoundException ex) {
                log.warn((Object)("handleLogin() cannot find group " + event.getUserGroupId() + ". Move event to error history."));
                UseErrorHistoryValue err = new UseErrorHistoryValue();
                err.setUnitId(event.getUnitId());
                err.setTime(event.getTimestamp());
                err.setReceiveTime(event.getReceiveTime());
                err.setLogin(event.isLogin());
                err.setUserIdNotFit(true);
                err.setErrorMessage("unkown groupId '" + event.getUserGroupId() + "'");
                this.writeErrorMessage(err);
            }
        }
    }

    protected void handleLogin(long userId, UseEvent event, Properties rawEvent, String area) throws UseWriteException {
        UseCacheValue cacheEntry = new UseCacheValue();
        cacheEntry.setUserId(userId);
        cacheEntry.setGroupId(event.getUserGroupId());
        cacheEntry.setUnitId(event.getUnitId());
        cacheEntry.setBeginTime(event.getTimestamp());
        cacheEntry.setBeginReceiveTime(event.getReceiveTime());
        try {
            UseCacheLocal cachedLogin = this.useCacheHome.findByPrimaryKey(new UseCachePK(event.getUnitId()));
            if (cachedLogin.getBeginTime() > event.getTimestamp()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("incoming event '" + event + "' is older then current login"));
                }
                return;
            }
            if (event.isTakeOver()) {
                cachedLogin.setGroupId(event.getUserGroupId());
                cachedLogin.setUserId(userId);
                this.setArea(cachedLogin, area);
                return;
            }
            if (cachedLogin.getUserId() == userId) {
                return;
            }
            this.handleLogoff(cachedLogin.getUserId(), event, rawEvent, area);
        }
        catch (ObjectNotFoundException ex) {
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        try {
            UseCacheLocal cache = this.useCacheHome.create(cacheEntry);
            cache.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(cacheEntry.getUnitId(), cacheEntry.getBeginTime()));
            this.setArea(cache, area);
        }
        catch (Exception ex) {
            log.error((Object)"handleLogin runs into ", (Throwable)ex);
            throw new UseWriteException(event.getUnitId(), "handleLogin runs into ", ex);
        }
    }

    protected void setArea(UseCacheLocal cache, String area) {
        if (area != null) {
            try {
                cache.setArea(this.areaHome.findByPrimaryKey(new AreaPK(area)));
            }
            catch (FinderException ex) {
                log.error((Object)"runs during update use cache into", (Throwable)ex);
            }
        }
    }

    protected void setEndArea(UseHistoryLocal history, String area) {
        if (area != null) {
            try {
                history.setEndArea(this.areaHome.findByPrimaryKey(new AreaPK(area)));
            }
            catch (FinderException ex) {
                log.error((Object)"runs during update use cache into", (Throwable)ex);
            }
        }
    }

    protected void handleLogoff(long userId, UseEvent event, Properties rawEvent, String area) throws UseWriteException {
        block8: {
            try {
                UseCacheLocal dirtyCache = this.useCacheHome.findByPrimaryKey(new UseCachePK(event.getUnitId()));
                GrouphistoryLocal grouphistory = dirtyCache.getGroupHistoryId();
                AreaLocal beginArea = dirtyCache.getArea();
                UseCacheValue cacheEntry = dirtyCache.getUseCacheValue();
                try {
                    dirtyCache.remove();
                }
                catch (Exception ex) {
                    log.error((Object)"handleLogoff runs into", (Throwable)ex);
                    throw new UseWriteException(event.getUnitId(), "handlelogoff runs into ", ex);
                }
                if (cacheEntry.getUserId() == userId) {
                    UseHistoryLocal useHistoryLocal;
                    UseHistoryValue historyEntry = new UseHistoryValue();
                    historyEntry.setUserId(userId);
                    historyEntry.setGroupId(event.getUserGroupId());
                    historyEntry.setUnitId(event.getUnitId());
                    historyEntry.setBeginTime(cacheEntry.getBeginTime());
                    historyEntry.setBeginReceiveTime(cacheEntry.getBeginReceiveTime());
                    historyEntry.setEndTime(event.getTimestamp());
                    historyEntry.setEndReceiveTime(event.getReceiveTime());
                    try {
                        useHistoryLocal = this.useHistoryHome.create(historyEntry);
                    }
                    catch (DuplicateKeyException ex) {
                        this.useHistoryHome.reorganizeSequence();
                        useHistoryLocal = this.useHistoryHome.create(historyEntry);
                    }
                    useHistoryLocal.setGroupHistoryId(grouphistory);
                    useHistoryLocal.setBeginArea(beginArea);
                    this.setEndArea(useHistoryLocal, area);
                    break block8;
                }
                log.error((Object)("logoff don't fit to login. dismiss user seesion. move event to error history. login: " + cacheEntry.toString() + " logoff: " + event.toString()));
                UseErrorHistoryValue errorEvent = new UseErrorHistoryValue();
                errorEvent.setUserId(userId);
                errorEvent.setGroupId(event.getUserGroupId());
                errorEvent.setUnitId(event.getUnitId());
                errorEvent.setTime(event.getTimestamp());
                errorEvent.setLogin(false);
                errorEvent.setUserIdNotFit(true);
                errorEvent.setErrorMessage("logoff don't fit to login. dismiss user seesion. move event to error history.");
                this.writeErrorMessage(errorEvent);
            }
            catch (FinderException finderEx) {
                log.debug((Object)"infoman send logoff but there's was no user loged into the infoman. It seems to be an infoman restart");
            }
            catch (CreateException ex) {
                log.error((Object)("handlelogoff runs into " + event.toString()), (Throwable)ex);
                throw new UseWriteException(event.getUnitId(), "handlelogoff runs into " + event.toString(), (Exception)((Object)ex));
            }
        }
    }

    public UseGroupValue getGroup(long groupId) throws GroupNotFoundException {
        UseGroupPK pk = new UseGroupPK(groupId);
        try {
            UseGroupLocal group = this.useGroupHome.findByPrimaryKey(pk);
            return group.getUseGroupValue();
        }
        catch (Exception ex) {
            throw new GroupNotFoundException("getGroup for " + groupId + " runs into " + ex.getMessage());
        }
    }

    public void addGroup(String name, String description) throws CreateException {
        try {
            Collection col = this.useGroupHome.findByName(name);
            if (col.size() != 0) {
                throw new CreateException();
            }
            UseGroupValue value = new UseGroupValue();
            value.setName(name);
            value.setDescription(description);
            this.useGroupHome.create(value);
        }
        catch (FinderException e) {
            UseGroupValue value = new UseGroupValue();
            value.setName(name);
            value.setDescription(description);
            this.useGroupHome.create(value);
        }
    }

    public void updateGroup(String name, String newName, String description) throws GroupNotFoundException {
        try {
            UseGroupValue value;
            UseGroupLocal group;
            Collection col = this.useGroupHome.findByName(name);
            if (col.size() == 1) {
                Iterator it = col.iterator();
                group = (UseGroupLocal)it.next();
                value = group.getUseGroupValue();
                if (newName != null) {
                    value.setName(newName);
                }
                if (description != null) {
                    value.setDescription(description);
                }
            } else {
                throw new GroupNotFoundException();
            }
            group.setUseGroupValue(value);
        }
        catch (FinderException e) {
            throw new GroupNotFoundException();
        }
    }

    public void removeGroup(String name) throws RemoveException, GroupNotFoundException {
        try {
            Collection col = this.useGroupHome.findByName(name);
            Iterator it = col.iterator();
            if (!it.hasNext()) {
                log.info((Object)("No Group found with name: " + name));
                throw new GroupNotFoundException();
            }
            UseGroupLocal group = (UseGroupLocal)it.next();
            group.remove();
        }
        catch (FinderException e) {
            log.error((Object)"runs into ", (Throwable)e);
            throw new GroupNotFoundException();
        }
    }

    public ArrayList<UseGroupValue> getAllGroups() {
        try {
            ArrayList<UseGroupValue> list = new ArrayList<UseGroupValue>();
            Collection col = this.useGroupHome.findAll();
            for (UseGroupLocal group : col) {
                list.add(group.getUseGroupValue());
            }
            return list;
        }
        catch (FinderException e) {
            return new ArrayList<UseGroupValue>();
        }
    }

    public UseUserValue getDeletedUser(String key) throws UserNotFoundException {
        try {
            Collection users = this.useUserHome.findDeletedByKey(key);
            Iterator it = users.iterator();
            if (it.hasNext()) {
                UseUserLocal user = (UseUserLocal)it.next();
                return user.getUseUserValue();
            }
            throw new UserNotFoundException("no user found for key " + key);
        }
        catch (Exception ex) {
            throw new UserNotFoundException("getUser for " + key + " runs into " + ex.getMessage());
        }
    }

    public UseUserValue getUser(String key) throws UserNotFoundException {
        try {
            Collection users = this.useUserHome.findByKey(key);
            Iterator it = users.iterator();
            if (it.hasNext()) {
                UseUserLocal user = (UseUserLocal)it.next();
                return user.getUseUserValue();
            }
            throw new UserNotFoundException("no user found for key " + key);
        }
        catch (Exception ex) {
            throw new UserNotFoundException("getUser for " + key + " runs into " + ex.getMessage());
        }
    }

    public UseUserValue getUser(long userId) throws UserNotFoundException {
        try {
            Collection users = this.useUserHome.findById(userId);
            Iterator it = users.iterator();
            if (it.hasNext()) {
                UseUserLocal user = (UseUserLocal)it.next();
                return user.getUseUserValue();
            }
            throw new UserNotFoundException("no user found for userId " + userId);
        }
        catch (Exception ex) {
            throw new UserNotFoundException("getUser for " + userId + " runs into " + ex.getMessage());
        }
    }

    private long getGroupId(String name) throws GroupNotFoundException {
        try {
            Collection col = this.useGroupHome.findByName(name);
            Iterator it = col.iterator();
            if (col.size() == 1) {
                UseGroupLocal useGroup = (UseGroupLocal)it.next();
                return useGroup.getUseGroupValue().getId();
            }
            throw new GroupNotFoundException();
        }
        catch (FinderException e) {
            throw new GroupNotFoundException();
        }
    }

    public String getGroupName(long groupId) throws GroupNotFoundException {
        try {
            UseGroupLocal useGroup = this.useGroupHome.findByPrimaryKey(new UseGroupPK(groupId));
            return useGroup.getUseGroupValue().getName();
        }
        catch (FinderException e) {
            throw new GroupNotFoundException();
        }
    }

    public void addUser(String name, String description, String groupName, String identificationNo, String versionNo) throws CreateException, GroupNotFoundException {
        try {
            UseUserValue value;
            Collection col = this.useUserHome.findLikeKey(identificationNo + "%");
            if (col.size() == 0) {
                value = new UseUserValue();
                value.setName(name);
                value.setDescription(description);
                value.setGroupId(this.getGroupId(groupName));
                if (versionNo == null) {
                    versionNo = "1";
                }
            } else {
                throw new CreateException();
            }
            value.setKey(identificationNo + versionNo);
            this.useUserHome.create(value);
        }
        catch (FinderException e) {
            UseUserValue value = new UseUserValue();
            value.setName(name);
            value.setDescription(description);
            value.setGroupId(this.getGroupId(groupName));
            if (versionNo == null) {
                versionNo = "1";
            }
            value.setKey(identificationNo + versionNo);
            this.useUserHome.create(value);
        }
    }

    public void updateUser(String name, String description, String groupName, String identificationNo, String versionNo) throws UserNotFoundException, GroupNotFoundException {
        try {
            UseUserValue userValue;
            UseUserLocal user;
            Collection col = this.useUserHome.findLikeKey(identificationNo + "%");
            Iterator it = col.iterator();
            if (col.size() == 1) {
                user = (UseUserLocal)it.next();
                userValue = user.getUseUserValue();
                if (name != null) {
                    userValue.setName(name);
                }
                if (description != null) {
                    userValue.setDescription(description);
                }
                if (groupName != null) {
                    long oldGroupId = userValue.getGroupId();
                    long newGroupId = this.getGroupId(groupName);
                    if (newGroupId != oldGroupId) {
                        userValue.setGroupId(newGroupId);
                    }
                }
                if (versionNo != null) {
                    String oldKey = userValue.getKey();
                    String newKey = oldKey.substring(0, oldKey.length() - 1) + versionNo;
                    userValue.setKey(newKey);
                }
            } else {
                throw new UserNotFoundException();
            }
            user.setUseUserValue(userValue);
        }
        catch (FinderException e) {
            throw new UserNotFoundException();
        }
    }

    public void removeUser(String identificationNo) throws RemoveException, UserNotFoundException {
        try {
            Collection col = this.useUserHome.findLikeKey(identificationNo + "%");
            if (col.size() == 0) {
                throw new UserNotFoundException();
            }
            for (UseUserLocal user : col) {
                this.adminFacade.deleteUseUser(user.getId());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new UserNotFoundException();
        }
    }

    public ArrayList<UseUserValue> getUsers(String groupName) throws GroupNotFoundException {
        try {
            ArrayList<UseUserValue> list = new ArrayList<UseUserValue>();
            long groupId = this.getGroupId(groupName);
            Collection col = this.useUserHome.findByGroupId(groupId);
            for (UseUserLocal user : col) {
                list.add(user.getUseUserValue());
            }
            return list;
        }
        catch (FinderException e) {
            throw new GroupNotFoundException();
        }
    }

    public void removeUsersFromGroup(String groupName) throws GroupNotFoundException {
        try {
            long groupId = this.getGroupId(groupName);
            Collection col = this.useUserHome.findByGroupId(groupId);
            for (UseUserLocal user : col) {
                String identificationNo = user.getUseUserValue().getKey().substring(0, 6);
                try {
                    this.removeUser(identificationNo);
                }
                catch (UserNotFoundException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            throw new GroupNotFoundException();
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public long getUserIdByKey(String key) throws UserNotFoundException {
        UseUserValue userValue = this.getUser(key);
        long userId = userValue.getId();
        return userId;
    }

    public long getUserIdForUnit(long unitId) throws FinderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get userId for unit " + unitId));
        }
        try {
            Collection col = UseCacheUtil.getLocalHome().findByUnitId(unitId);
            if (col.size() == 1) {
                Iterator it = col.iterator();
                if (it.hasNext()) {
                    UseCacheLocal useCache = (UseCacheLocal)it.next();
                    if (useCache != null) {
                        long userId = useCache.getUserId();
                        return userId;
                    }
                    throw new FinderException();
                }
                throw new FinderException();
            }
            throw new FinderException();
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new FinderException();
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new FinderException();
        }
    }

    public long getUserIdByKeyLike(String identificationNo) throws UserNotFoundException {
        String key = identificationNo + this.getCurrentVersionNo(identificationNo);
        UseUserValue userValue = this.getUser(key);
        long userId = userValue.getId();
        return userId;
    }

    private int getCurrentVersionNo(String identificationNo) throws UserNotFoundException {
        try {
            Collection col = this.useUserHome.findLikeKey(identificationNo + "%");
            Iterator it = col.iterator();
            if (it.hasNext()) {
                UseUserLocal user = (UseUserLocal)it.next();
                UseUserValue userValue = user.getUseUserValue();
                String key = userValue.getKey();
                int versionNo = Integer.parseInt(Character.toString(key.charAt(key.length() - 1)));
                return versionNo;
            }
            throw new UserNotFoundException();
        }
        catch (FinderException e) {
            log.error((Object)"getCurrentVersionNo runs into ", (Throwable)e);
            throw new UserNotFoundException();
        }
    }

    protected void writeErrorMessage(UseErrorHistoryValue errorStruct) {
    }

    public boolean moveCacheDataToHistoryForDeletedUnit(UnitModelLocal unitModel) {
        long timeNow = System.currentTimeMillis();
        try {
            Collection useCacheCol = this.useCacheHome.findByUnitId(unitModel.getUnitId());
            if (useCacheCol.size() == 0) {
                return true;
            }
            for (Object obj : useCacheCol) {
                UseUserLocal useUser;
                AreaLocal area;
                UseHistoryLocal useHistoryLocal;
                UseCacheLocal useCache = (UseCacheLocal)obj;
                if (useCache == null) continue;
                UseCacheValue cacheValue = useCache.getUseCacheValue();
                UseHistoryValue historyEntry = new UseHistoryValue();
                historyEntry.setUserId(cacheValue.getUserId());
                historyEntry.setGroupId(cacheValue.getGroupId());
                historyEntry.setUnitId(cacheValue.getUnitId());
                historyEntry.setBeginTime(cacheValue.getBeginTime());
                historyEntry.setBeginReceiveTime(cacheValue.getBeginReceiveTime());
                historyEntry.setEndTime(timeNow);
                historyEntry.setEndReceiveTime(timeNow);
                try {
                    useHistoryLocal = this.useHistoryHome.create(historyEntry);
                }
                catch (DuplicateKeyException ex) {
                    this.useHistoryHome.reorganizeSequence();
                    useHistoryLocal = this.useHistoryHome.create(historyEntry);
                }
                GrouphistoryLocal ghLocal = useCache.getGroupHistoryId();
                if (ghLocal != null) {
                    useHistoryLocal.setGroupHistoryId(ghLocal);
                }
                if ((area = useCache.getArea()) != null) {
                    useHistoryLocal.setBeginArea(area);
                    useHistoryLocal.setEndArea(area);
                }
                if ((useUser = useCache.getUseUser()) != null) {
                    useHistoryLocal.setUseUser(useUser);
                }
                historyEntry = useHistoryLocal.getUseHistoryValue();
                try {
                    if (useCache == null) continue;
                    useCache.remove();
                }
                catch (EJBException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
                catch (RemoveException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException finderEx) {
            log.debug((Object)"runs into", (Throwable)finderEx);
        }
        catch (CreateException ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
        return true;
    }
}

