/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.statepersist;

import de.proveo.util.ejb.BaseEntityBean;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryPK;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.pkgen.SequenceProxy;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StateHistoryBean
extends BaseEntityBean
implements EntityBean {
    private static final Log log = LogFactory.getLog(StateHistoryBean.class);
    private transient SequenceProxy pkGenerator;

    public StateHistoryPK ejbCreate(StateHistoryValue value) throws CreateException {
        value.setDuration(value.getEndTime() - value.getBeginTime());
        value.setBeginStamp(Math.round(Math.floor(value.getBeginTime() / 86400000L) * 8.64E7));
        value.setEndStamp(Math.round(Math.ceil(value.getEndTime() / 86400000L) * 8.64E7));
        this.setStateHistoryValue(value);
        try {
            this.initSequenceProxy();
            this.setStateHistoryId(this.pkGenerator.getNext());
        }
        catch (Exception ex) {
            throw new CreateException("Exception during PrimaryKey generation " + ex.getMessage());
        }
        return null;
    }

    private void initSequenceProxy() throws Exception {
        if (this.pkGenerator == null) {
            this.pkGenerator = new SequenceProxy(108001L, 1);
        }
    }

    public void ejbPostCreate(StateHistoryValue value) throws CreateException {
    }

    public void ejbHomeReorganizeSequence() {
        log.debug((Object)"ejbHomeReorganizeSequence()");
        try {
            this.initSequenceProxy();
            long maxHistoryId = this.ejbSelectMaxHistoryId();
            this.pkGenerator.setNextId(maxHistoryId);
        }
        catch (Exception ex) {
            log.error((Object)"ejbHomeReorganizeSequence() runs into", (Throwable)ex);
            throw new EJBException(ex);
        }
        log.debug((Object)"ejbHomeReorganizeSequence() - end");
    }

    public abstract long ejbSelectMaxHistoryId() throws FinderException;

    public long ejbHomeGetMaxHistoryId() {
        try {
            return this.ejbSelectMaxHistoryId();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            return -1L;
        }
    }

    public abstract void setStateHistoryValue(StateHistoryValue var1);

    public abstract StateHistoryValue getStateHistoryValue();

    public abstract long getStateHistoryId();

    public abstract void setStateHistoryId(long var1);

    public abstract long getUnitId();

    public abstract void setUnitId(long var1);

    public abstract long getStateModelId();

    public abstract void setStateModelId(long var1);

    public abstract long getStateId();

    public abstract void setStateId(long var1);

    public abstract long getBeginTime();

    public abstract void setBeginTime(long var1);

    public abstract long getEndTime();

    public abstract void setEndTime(long var1);

    public abstract long getBeginStamp();

    public abstract void setBeginStamp(long var1);

    public abstract long getEndStamp();

    public abstract void setEndStamp(long var1);

    public abstract long getStateIdPrevious();

    public abstract void setStateIdPrevious(long var1);

    public abstract long getStateIdAfter();

    public abstract void setStateIdAfter(long var1);

    public abstract long getPkStatePrevious();

    public abstract void setPkStatePrevious(long var1);

    public abstract long getBeginReceiveTime();

    public abstract void setBeginReceiveTime(long var1);

    public abstract long getEndReceiveTime();

    public abstract void setEndReceiveTime(long var1);

    public abstract long getDuration();

    public abstract void setDuration(long var1);

    public abstract String getRemark();

    public abstract void setRemark(String var1);

    public abstract long ejbSelectFirstEntryBeginTime() throws FinderException;

    public long ejbHomeGetFirstEntryBeginTime() {
        try {
            return this.ejbSelectFirstEntryBeginTime();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            return 0L;
        }
    }

    public abstract long ejbSelectDuration(long var1, long var3, long var5, long var7) throws FinderException;

    public long ejbHomeGetDuration(long unitId, long stateId, long beginTime, long endTime) {
        long summarizedDuration = 0L;
        try {
            summarizedDuration = this.ejbSelectDuration(unitId, stateId, beginTime, endTime);
        }
        catch (Exception e) {
            log.error((Object)("no max beginTime found for Unit: " + unitId + ", beginTime: " + beginTime + "endTime " + endTime));
        }
        return summarizedDuration;
    }

    public abstract UnitModelLocal getUnitModel();

    public abstract void setUnitModel(UnitModelLocal var1);

    public abstract GrouphistoryLocal getGroupHistoryId();

    public abstract void setGroupHistoryId(GrouphistoryLocal var1);

    public abstract AreaLocal getArea();

    public abstract void setArea(AreaLocal var1);

    public abstract UseUserLocal getUseUser();

    public abstract void setUseUser(UseUserLocal var1);

    public abstract boolean getAreaTrusted();

    public abstract void setAreaTrusted(boolean var1);
}

