/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.state.init;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.state.StateModel;
import de.proveo.wwt.logic.app.state.StateModelFactory;
import de.proveo.wwt.logic.app.state.exception.StateModelNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.state.init.StateModelInitException;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCachePK;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InitStateModelBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(InitStateModelBean.class);
    private final StateModelFactory stateModelFactory = new StateModelFactory();
    private UnitModelLocalHome unitModelHome;
    private CurrentStateCacheLocalHome currentStateCacheHome;

    public void ejbCreate() throws CreateException {
        try {
            this.unitModelHome = UnitModelUtil.getLocalHome();
            this.currentStateCacheHome = CurrentStateCacheUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"error during lookup ejb references", (Throwable)ex);
            throw new CreateException("error during lookup ejb references " + ex.getMessage());
        }
    }

    public void initializeAll() {
        try {
            Collection units = this.unitModelHome.findyByIsBasic(true);
            for (UnitModelLocal unitModel : units) {
                this.initializeAllStateModels(unitModel.getUnitId());
            }
        }
        catch (FinderException ex) {
            log.debug((Object)"initializeAll(): no basic units found", (Throwable)ex);
        }
    }

    public void initializeAllStateModels(long unitId) {
        try {
            this.initializeSilent(unitId, 2030L);
            this.initializeSilent(unitId, 2010L);
            this.initializeSilent(unitId, 2050L);
            this.initializeSilent(unitId, 2090L);
            this.initializeSilent(unitId, 2020L);
            this.initializeSilent(unitId, 2910L);
            this.initializeSilent(unitId, 2920L);
            this.initializeSilent(unitId, 2930L);
            this.initializeSilent(unitId, 2100L);
        }
        catch (StateModelNotFoundException ex) {
            log.error((Object)"unknown state model", (Throwable)ex);
            throw new EJBException("unknown state model " + ex.getMessage());
        }
    }

    protected void initializeSilent(long unitId, long stateModelId) throws StateModelNotFoundException {
        try {
            this.initialize(unitId, stateModelId);
        }
        catch (StateModelInitException ex) {
            log.debug((Object)"initializeSilent() runs into", (Throwable)ex);
        }
    }

    public void initialize(long unitId, long stateModelId) throws StateModelInitException, StateModelNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("initialize(unitId=" + unitId + ",stateModelId=" + stateModelId + ")"));
        }
        log.debug((Object)"stateModelFactory.getStateModel()");
        StateModel stateModel = this.stateModelFactory.getStateModel(stateModelId, unitId);
        if (stateModel.isPersistent()) {
            throw new StateModelInitException(0, unitId, stateModelId);
        }
        this.removeExistingCacheEntry(unitId, stateModelId);
        CurrentStateCacheValue cacheEntry = new CurrentStateCacheValue();
        cacheEntry.setUnitId(unitId);
        cacheEntry.setStateModelId(stateModelId);
        cacheEntry.setState(stateModel.getCurrentStateId());
        cacheEntry.setBeginTime(System.currentTimeMillis());
        cacheEntry.setDontValidateNext(true);
        try {
            this.currentStateCacheHome.create(cacheEntry);
        }
        catch (Exception ex) {
            throw new EJBException("runs during create cache entry into " + ex.getMessage());
        }
    }

    private void removeExistingCacheEntry(long unitId, long stateModelId) {
        CurrentStateCacheLocal currentStateCache = null;
        if (this.currentStateCacheHome != null) {
            try {
                currentStateCache = this.currentStateCacheHome.findByPrimaryKey(new CurrentStateCachePK(unitId, stateModelId));
                if (currentStateCache != null) {
                    currentStateCache.remove();
                }
            }
            catch (FinderException e) {
            }
            catch (RemoveException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        } else {
            log.warn((Object)"currentStateCacheHome is null");
        }
    }

    public void forceInitialize(long unitId, long stateModelId) throws StateModelNotFoundException {
        StateModel stateModel = this.stateModelFactory.getStateModel(stateModelId, unitId);
        try {
            CurrentStateCacheLocal cacheEntry = this.currentStateCacheHome.findByPrimaryKey(new CurrentStateCachePK(unitId, stateModelId));
            cacheEntry.remove();
            this.initialize(unitId, stateModelId);
        }
        catch (FinderException finderEx) {
            try {
                this.initialize(unitId, stateModelId);
            }
            catch (Exception ex) {
                log.error((Object)"runs during forceInitialize into", (Throwable)ex);
                throw new EJBException("runs during forceInitialize into " + ex.getMessage());
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs during forceInitialize into", (Throwable)ex);
            throw new EJBException("runs during forceInitialize into " + ex.getMessage());
        }
    }
}

