/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.stands;

import de.proveo.wwt.logic.ejb.dataIn.stands.GSRealTimeConnector;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GSRealTimeObjectServerConnectorFacadeBean
extends GSRealTimeConnector
implements SessionBean {
    private static final long serialVersionUID = -3242927788408992728L;
    private static final String GETTER_XML = "getAllPublishedAllocations.xml";
    private static final Log log = LogFactory.getLog(GSRealTimeObjectServerConnectorFacadeBean.class);
    private String _fileData;

    public void ejbCreate() {
        this._fileData = this.readFile();
    }

    public String readDataFromGSRealTimeSystem() throws UnknownHostException, IOException {
        try {
            GSRealTimeConnector.PORT = this.configurationBean.getInteger("observable.stands.fis.objectServer.port");
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"startEventManager() runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
            this.informantFacadeLocal.notify("startEventManager() runs into ConfigurationParameterNotFoundException: " + e, "StandErrorEvent");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("FIS (ObjectServer): " + this.fisHost + "(IP) : " + GSRealTimeConnector.PORT + " (Port)"));
        }
        super.establishSocketConnection();
        if (this.connectionEstablished) {
            boolean isErrorOccurredPart1 = super.writeSocketData(this.getLengthOfText(this._fileData));
            boolean isErrorOccurredPart2 = super.writeSocketData(this._fileData);
            while (isErrorOccurredPart1 || isErrorOccurredPart2) {
                super.establishSocketConnection();
                isErrorOccurredPart1 = super.writeSocketData(this.getLengthOfText(this._fileData));
                isErrorOccurredPart2 = super.writeSocketData(this._fileData);
            }
            return super.readSocketData(true);
        }
        log.error((Object)"No connection established! Can't read data from GSRealTimeSystem!");
        this.informantFacadeLocal.notify("No connection established! Can't read data from GSRealTimeSystem!", "StandErrorEvent");
        return null;
    }

    private String readFile() {
        log.debug((Object)"Reading getter-XML file...");
        String file = "";
        String getterXMLPath = "/de/proveo/util/stands/ressource/getter/";
        InputStream inputStream = GSRealTimeObjectServerConnectorFacadeBean.class.getResourceAsStream("/de/proveo/util/stands/ressource/getter/getAllPublishedAllocations.xml");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String line = "";
        try {
            while ((line = bufferedReader.readLine()) != null) {
                file = file + line;
            }
        }
        catch (IOException e) {
            log.error((Object)"readFile runs into IOException: ", (Throwable)e);
            this.informantFacadeLocal.notify("readFile runs into IOException: " + e, "StandErrorEvent");
        }
        log.debug((Object)"File read!");
        return file;
    }
}

