/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.stands;

import de.proveo.wwt.logic.ejb.dataIn.stands.GSRealTimeConnector;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GSRealTimeEventManagerConnectorFacadeBean
extends GSRealTimeConnector
implements SessionBean {
    private static final long serialVersionUID = -3885398149761444098L;
    protected static final Log log = LogFactory.getLog(GSRealTimeEventManagerConnectorFacadeBean.class);

    public void ejbCreate() {
    }

    public void startEventManager() throws UnknownHostException, IOException {
        try {
            GSRealTimeConnector.PORT = this.configurationBean.getInteger("observable.stands.fis.eventManager.port");
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"startEventManager() runs into ConfigurationParameterNotFoundException: ", (Throwable)e);
            this.informantFacadeLocal.notify("startEventManager() runs into ConfigurationParameterNotFoundException: " + e, "StandErrorEvent");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("FIS (EventManager): " + this.fisHost + "(IP) : " + GSRealTimeConnector.PORT + " (Port)"));
        }
        super.establishSocketConnection();
    }

    public String getNextEvents() {
        log.debug((Object)"Waiting for new incoming events...");
        String event = super.readEvent();
        super.sendACK();
        if (this.isKeepAliveEvent(event)) {
            return "KeepAlive";
        }
        if (this.isStandAllocationEvent(event)) {
            return event;
        }
        if (this.isFlightEvent(event)) {
            return "Flight";
        }
        if (this.isTaskEvent(event)) {
            return "Task";
        }
        if (this.isAirportEvent(event)) {
            return "Airport";
        }
        if (this.isAirlineEvent(event)) {
            return "Airline";
        }
        if (this.isHandlingType2Event(event)) {
            return "HandlingType2";
        }
        if (this.isResourceEvent(event)) {
            return "Resource";
        }
        if (this.isShiftEvent(event)) {
            return "Shift";
        }
        if (this.isLocationEvent(event)) {
            return "Location";
        }
        if (this.isContractEvent(event)) {
            return "Contract";
        }
        if (this.isSitaMessageEvent(event)) {
            return "SitaMessage";
        }
        return "UnknownEvent";
    }

    private boolean isKeepAliveEvent(String event) {
        return event.indexOf("N=\"KeepAlive\"") != -1;
    }

    private boolean isTaskEvent(String event) {
        return event.indexOf("N=\"Task\"") != -1;
    }

    private boolean isAirportEvent(String event) {
        return event.indexOf("N=\"Airport\"") != -1;
    }

    private boolean isAirlineEvent(String event) {
        return event.indexOf("N=\"Airline\"") != -1;
    }

    private boolean isHandlingType2Event(String event) {
        return event.indexOf("N=\"HandlingType2\"") != -1;
    }

    private boolean isResourceEvent(String event) {
        return event.indexOf("N=\"Resource\"") != -1;
    }

    private boolean isShiftEvent(String event) {
        return event.indexOf("N=\"Shift\"") != -1;
    }

    private boolean isLocationEvent(String event) {
        return event.indexOf("N=\"Location\"") != -1;
    }

    private boolean isContractEvent(String event) {
        return event.indexOf("N=\"Contract\"") != -1;
    }

    private boolean isSitaMessageEvent(String event) {
        return event.indexOf("N=\"SitaMessage\"") != -1;
    }

    private boolean isFlightEvent(String event) {
        return event.indexOf("N=\"Flight\"") != -1;
    }

    private boolean isStandAllocationEvent(String event) {
        return event.indexOf("N=\"StandAllocation\"") != -1;
    }
}

