/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.observable;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import java.io.Serializable;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObservableJMSSender {
    private static final Log log = LogFactory.getLog(ObservableJMSSender.class);
    private TopicConnection connection = null;
    private TopicSession session = null;
    private TopicPublisher sender = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws Exception {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            TopicConnectionFactory factory = (TopicConnectionFactory)ctx.lookup("ConnectionFactory");
            this.connection = factory.createTopicConnection();
            this.connection.setExceptionListener((ExceptionListener)new ExceptionListenerImpl());
            this.session = this.connection.createTopicSession(false, 2);
            Topic topic = null;
            try {
                topic = (Topic)ctx.lookup("topic/proveoDataProviderTopic");
            }
            catch (NameNotFoundException ex) {
                topic = this.session.createTopic("topic/proveoDataProviderTopic");
                ctx.bind("topic/proveoDataProviderTopic", (Object)topic);
            }
            this.sender = this.session.createPublisher(topic);
            this.sender.setTimeToLive(300000L);
            this.connection.start();
        }
        catch (Exception e) {
            log.error((Object)("initialize runs into " + e));
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
            }
            finally {
                ctx.close();
            }
            throw e;
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendMessage(SerializableEventWrapper wrapper, String kindOfEvent) {
        try {
            ObjectMessage message = this.session.createObjectMessage((Serializable)wrapper);
            message.setStringProperty("TypeOfInterest", kindOfEvent);
            this.sender.publish((Message)message);
            log.debug((Object)"Message to topic sent!");
        }
        catch (Exception e) {
            log.error((Object)"runs into Exception ", (Throwable)e);
            this.closeConnection();
            try {
                this.initialize();
                ObjectMessage message = this.session.createObjectMessage((Serializable)wrapper);
                message.setStringProperty("TypeOfInterest", kindOfEvent);
                this.sender.publish((Message)message);
                log.debug((Object)"Message to topic sent!");
            }
            catch (Exception e2) {
                log.error((Object)("notifyClients 2nd try ends in Exception: " + e2));
            }
        }
    }

    private class ExceptionListenerImpl
    implements ExceptionListener {
        public static final int NUM_RETRIES = 3;

        private ExceptionListenerImpl() {
        }

        public void onException(JMSException e) {
            for (int i = 0; i < 3; ++i) {
                log.warn((Object)("Connection has problems, trying to re-create it, attempt " + (i + 1) + " ..."));
                ObservableJMSSender.this.closeConnection();
                try {
                    ObservableJMSSender.this.initialize();
                    log.info((Object)"Connection re-established");
                    return;
                }
                catch (Exception e2) {
                    log.warn((Object)"Re-creating connection failed, retrying ...");
                    continue;
                }
            }
            log.error((Object)"Cannot re-establish connection, giving up ...");
        }
    }
}

