/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.keepalive;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.KeepAliveMessage;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCachePK;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.admin.AdminFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminFacadeUtil;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class KeepAliveInFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(KeepAliveInFacadeBean.class);
    private KeepAliveCacheLocalHome cacheHome;
    private KeepAliveHistoryLocalHome historyHome;
    private AdminFacadeLocal adminFacade;

    public void ejbCreate() throws CreateException {
        try {
            this.cacheHome = KeepAliveCacheUtil.getLocalHome();
            this.historyHome = KeepAliveHistoryUtil.getLocalHome();
            this.adminFacade = AdminFacadeUtil.getLocalHome().create();
        }
        catch (NamingException ex) {
            log.error((Object)"Cannot find KeepAlive Entity Bean", (Throwable)ex);
            throw new EJBException("Can not find KeepAlive Entity Bean: " + ex.getMessage());
        }
    }

    public void insertMessage(long unitId) throws ImplicitRollbackException {
        log.debug((Object)("insertMessage() for unitId " + unitId));
        try {
            try {
                KeepAliveCacheLocal cache = this.copyCacheToHistory(unitId);
                cache.setTimeStamp(System.currentTimeMillis());
                cache.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(unitId, cache.getTimeStamp()));
            }
            catch (FinderException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot find cache entry for unitId: " + unitId));
                }
                KeepAliveMessage message = new KeepAliveMessage(unitId);
                message.setTimeStamp(System.currentTimeMillis());
                KeepAliveCacheLocal cache = this.cacheHome.create(message);
                cache.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(unitId, cache.getTimeStamp()));
            }
        }
        catch (CreateException ex) {
            log.error((Object)("insertMessage(unitId: " + unitId + ") cannot create cache entry"), (Throwable)ex);
            throw new ImplicitRollbackException(ex.toString());
        }
        catch (Exception ex) {
            log.error((Object)"insertMessage() runs into", (Throwable)ex);
            throw new ImplicitRollbackException(ex.toString());
        }
    }

    protected KeepAliveCacheLocal copyCacheToHistory(long unitId) throws FinderException {
        KeepAliveCachePK pk = new KeepAliveCachePK(unitId);
        try {
            KeepAliveCacheLocal cache = this.cacheHome.findByPrimaryKey(pk);
            try {
                KeepAliveHistoryLocal history = this.historyHome.create(cache.getStruct());
                history.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(unitId, history.getTimeStamp()));
                return cache;
            }
            catch (DuplicateKeyException ex) {
                this.historyHome.reorganizeSequence();
                KeepAliveHistoryLocal history = this.historyHome.create(cache.getStruct());
                history.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(unitId, history.getTimeStamp()));
                return cache;
            }
        }
        catch (CreateException ex) {
            log.error((Object)("copyCacheToHistory(unitId: " + unitId + ") cannot create history entry"), (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public boolean moveCacheDataToHistoryForDeletedUnit(UnitModelLocal unitModel) {
        KeepAliveCacheLocal keepAliveCacheLocal = unitModel.getKeepAliveCache();
        if (keepAliveCacheLocal == null) {
            return true;
        }
        KeepAliveCacheValue keepAliveCache = keepAliveCacheLocal.getKeepAliveCacheValue();
        KeepAliveHistoryValue keepAliveHistoryValue = new KeepAliveHistoryValue();
        KeepAliveMessage mess = new KeepAliveMessage(unitModel.getUnitId());
        mess.setTimeStamp(keepAliveCache.getTimeStamp());
        KeepAliveHistoryLocal keepAliveHistoryLocal = null;
        try {
            try {
                keepAliveHistoryLocal = this.historyHome.create(mess);
            }
            catch (DuplicateKeyException ex) {
                this.historyHome.reorganizeSequence();
                keepAliveHistoryLocal = this.historyHome.create(mess);
            }
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        keepAliveHistoryLocal.setGroupHistoryId(keepAliveCacheLocal.getGroupHistoryId());
        try {
            if (keepAliveCacheLocal != null) {
                keepAliveCacheLocal.remove();
            }
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return true;
    }
}

