/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.geo.history;

import de.proveo.util.ejb.BaseEntityBean;
import de.proveo.wwt.logic.app.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryPK;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.pkgen.SequenceProxy;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GdataHistoryBean
extends BaseEntityBean
implements EntityBean {
    private static final Log log = LogFactory.getLog(GdataHistoryBean.class);
    private SequenceProxy pkGenerator;

    public GdataHistoryPK ejbCreate(GeoStruct struct) throws CreateException {
        try {
            this.initSequenceProxy();
            this.setGDataHistoryId(this.pkGenerator.getNext());
        }
        catch (Exception ex) {
            throw new CreateException("Exception during PrimaryKey generation " + ex.getMessage());
        }
        this.setStruct(struct);
        return null;
    }

    private void initSequenceProxy() throws Exception {
        if (this.pkGenerator == null) {
            this.pkGenerator = new SequenceProxy(110001L, 1);
        }
    }

    public void ejbPostCreate(GeoStruct struct) throws CreateException {
    }

    public void ejbHomeReorganizeSequence() {
        log.debug((Object)"ejbHomeReorganizeSequence()");
        try {
            this.initSequenceProxy();
            long maxHistoryId = this.ejbSelectMaxHistoryId();
            this.pkGenerator.setNextId(maxHistoryId);
        }
        catch (Exception ex) {
            log.error((Object)"ejbHomeReorganizeSequence() runs into", (Throwable)ex);
            throw new EJBException(ex);
        }
        log.debug((Object)"ejbHomeReorganizeSequence() - end");
    }

    public abstract long ejbSelectMaxHistoryId() throws FinderException;

    public long ejbHomeGetMaxHistoryId() {
        try {
            return this.ejbSelectMaxHistoryId();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            return -1L;
        }
    }

    public abstract long ejbSelectMaxPkPrevious() throws FinderException;

    public long ejbHomeGetMaxPkPrevious() {
        try {
            return this.ejbSelectMaxPkPrevious();
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
            return -1L;
        }
    }

    public void setStruct(GeoStruct struct) {
        this.setUnitId(struct.getUnitId());
        this.setBeginTime(struct.getBeginTime());
        this.setBeginReceiveTime(struct.getBeginReceiveTime());
        this.setEndTime(struct.getEndTime());
        this.setEndReceiveTime(struct.getEndReceiveTime());
        this.setPkGdataPrevious(struct.getPkGdataPrevious());
        this.setRmcRec(struct.getRmcRec());
        this.setGgaRec(struct.getGgaRec());
        this.setArea(struct.getArea());
        this.setTrusted(struct.isTrusted());
        this.setReason(struct.getReason());
        this.setLongMSEC(struct.getLongMSEC());
        this.setLatMSEC(struct.getLatMSEC());
        this.setBeginStamp(Math.round(Math.floor(struct.getBeginTime() / 86400000L) * 8.64E7));
        this.setEndStamp(Math.round(Math.ceil(struct.getEndTime() / 86400000L) * 8.64E7));
    }

    public GeoStruct getStruct() {
        String areaDesc = "";
        AreaLocal areaLocal = this.getAreaLocal();
        if (areaLocal != null && (areaDesc = areaLocal.getDescription()) == null) {
            areaDesc = "";
        }
        return new GeoStruct(this.getUnitId(), this.getBeginTime(), this.getBeginReceiveTime(), this.getEndTime(), this.getEndReceiveTime(), this.getPkGdataPrevious(), this.getRmcRec(), this.getGgaRec(), this.getArea(), areaDesc, this.getTrusted(), this.getReason(), this.getLongMSEC(), this.getLatMSEC());
    }

    public abstract GdataHistoryValue getGdataHistoryValue();

    public abstract long getGDataHistoryId();

    public abstract void setGDataHistoryId(long var1);

    public abstract long getUnitId();

    public abstract void setUnitId(long var1);

    public abstract long getBeginTime();

    public abstract void setBeginTime(long var1);

    public abstract long getEndTime();

    public abstract void setEndTime(long var1);

    public abstract long getBeginStamp();

    public abstract void setBeginStamp(long var1);

    public abstract long getEndStamp();

    protected abstract void setEndStamp(long var1);

    public abstract long getBeginReceiveTime();

    public abstract void setBeginReceiveTime(long var1);

    public abstract long getEndReceiveTime();

    public abstract void setEndReceiveTime(long var1);

    public abstract long getPkGdataPrevious();

    public abstract void setPkGdataPrevious(long var1);

    public abstract String getArea();

    public abstract void setArea(String var1);

    public abstract String getRmcRec();

    public abstract void setRmcRec(String var1);

    public abstract String getGgaRec();

    public abstract void setGgaRec(String var1);

    public abstract boolean getTrusted();

    public abstract void setTrusted(boolean var1);

    public abstract String getReason();

    public abstract void setReason(String var1);

    public abstract int getLongMSEC();

    public abstract void setLongMSEC(int var1);

    public abstract int getLatMSEC();

    public abstract void setLatMSEC(int var1);

    public abstract GrouphistoryLocal getGroupHistoryId();

    public abstract void setGroupHistoryId(GrouphistoryLocal var1);

    public abstract UnitModelLocal getUnitModel();

    public abstract void setUnitModel(UnitModelLocal var1);

    public abstract AreaLocal getAreaLocal();

    public abstract void setAreaLocal(AreaLocal var1);
}

