/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.geo.cache;

import de.proveo.util.ejb.BaseEntityBean;
import de.proveo.util.geo.GPSPosition;
import de.proveo.util.math.PointImpl;
import de.proveo.util.math.Polygon;
import de.proveo.wwt.logic.app.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCachePK;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CurrentGdataCacheBean
extends BaseEntityBean
implements EntityBean {
    private static final Log log = LogFactory.getLog(CurrentGdataCacheBean.class);
    private AreaLocalHome areaHome;

    public CurrentGdataCachePK ejbCreate(GeoStruct struct, long pkGdataHistoryPre) throws CreateException {
        this.setUnitId(struct.getUnitId());
        this.setStruct(struct, pkGdataHistoryPre, false);
        return null;
    }

    public void ejbPostCreate(GeoStruct struct, long pkGdataHistoryPre) throws CreateException {
        this.computeArea();
    }

    public abstract void setCurrentGdataCacheValue(CurrentGdataCacheValue var1);

    public abstract CurrentGdataCacheValue getCurrentGdataCacheValue();

    public void setStruct(GeoStruct struct, long pkPrev) {
        this.setStruct(struct, pkPrev, true);
    }

    public void setStruct(GeoStruct struct, long pkPrev, boolean updateArea) {
        this.setCreateTime(struct.getBeginTime());
        this.setBeginReceiveTime(struct.getBeginReceiveTime());
        this.setRmcRec(struct.getRmcRec());
        this.setGgaRec(struct.getGgaRec());
        this.setTrusted(struct.isTrusted());
        if (updateArea) {
            int latMSEC = struct.getLatMSEC();
            int longMSEC = struct.getLongMSEC();
            if (latMSEC != -1 && longMSEC != -1) {
                this.computeArea(longMSEC, latMSEC);
            } else {
                this.computeArea();
            }
        }
        this.setReason(struct.getReason());
        this.setPkGdataPrevious(pkPrev);
    }

    public GeoStruct getStruct() {
        String areaDesc = "";
        AreaLocal areaLocal = this.getAreaLocal();
        if (areaLocal != null && (areaDesc = areaLocal.getDescription()) == null) {
            areaDesc = "";
        }
        return new GeoStruct(this.getUnitId(), this.getCreateTime(), this.getBeginReceiveTime(), 0L, 0L, this.getPkGdataPrevious(), this.getRmcRec(), this.getGgaRec(), this.getArea(), areaDesc, this.getTrusted(), this.getReason(), this.getLongMSEC(), this.getLatMSEC());
    }

    private void computeArea() {
        GPSPosition gps = new GPSPosition(this.getRmcRec(), this.getGgaRec(), this.getTrusted());
        int positionLongMsec = gps.getLongitudeMSec();
        int positionLatMsec = gps.getLatitudeMSec();
        this.computeArea(positionLongMsec, positionLatMsec);
    }

    private void computeArea(int positionLongMsec, int positionLatMsec) {
        String sMethodName = "computeArea()";
        ArrayList areas = new ArrayList();
        int i = 0;
        boolean debug = false;
        this.setLongMSEC(positionLongMsec);
        this.setLatMSEC(positionLatMsec);
        try {
            AreaLocalHome home = this.getAreaHomeInterface();
            if (debug) {
                log.debug((Object)(sMethodName + "   try to areas by extremal values for position " + positionLongMsec + "/" + positionLatMsec + " (longitude/latitude)."));
            }
            Collection col = home.findByVicinity(positionLongMsec, positionLatMsec);
            Iterator it = col.iterator();
            this.setArea(null);
            int sa = col.size();
            if (sa < 1) {
                log.warn((Object)(sMethodName + "   found no suitable area for given position by extremal values!"));
                return;
            }
            if (debug) {
                log.debug((Object)(sMethodName + "   found " + sa + " suitable areas for given position."));
            }
            while (it.hasNext()) {
                ArrayList points;
                ++i;
                AreaLocal areaLocal = (AreaLocal)it.next();
                AreaValue struct = areaLocal.getAreaValue();
                String area = struct.getArea();
                if (debug) {
                    log.debug((Object)(sMethodName + "   found, that area '" + area + "/" + struct.getDescription() + "' is suitable for final AREA algorithm ..."));
                }
                if ((points = areaLocal.getPoints()).size() < 3) {
                    log.error((Object)(sMethodName + "   this area has " + points.size() + " points only ! (or JDBC bug) Check it !!"));
                    continue;
                }
                Polygon p = new Polygon(points);
                if (p.isPointInside(new PointImpl(positionLongMsec, positionLatMsec))) {
                    if (debug) {
                        log.debug((Object)(sMethodName + "   area '" + area + "' has the point inside. Priority is " + struct.getPriority() + ". Break."));
                    }
                    this.setAreaLocal(areaLocal);
                    break;
                }
                if (!debug) continue;
                log.debug((Object)(sMethodName + "   area '" + area + "' doesn't has the point inside."));
            }
        }
        catch (FinderException fe) {
            log.error((Object)(sMethodName + " runs into FinderException"));
            return;
        }
        if (this.getAreaLocal() == null) {
            log.warn((Object)(sMethodName + " END, " + i + " suitable areas found, but none of them has the point inside!"));
        } else if (debug) {
            log.debug((Object)(sMethodName + " END, " + i + " suitable areas found, position lies inside area '" + this.getAreaLocal().getArea() + "'."));
        }
    }

    private AreaLocalHome getAreaHomeInterface() {
        try {
            if (this.areaHome == null) {
                this.areaHome = AreaUtil.getLocalHome();
            }
            return this.areaHome;
        }
        catch (NamingException ex) {
            log.error((Object)"getAreaHomeInterface() runs into", (Throwable)ex);
            throw new EJBException((Exception)ex);
        }
    }

    public abstract long getUnitId();

    public abstract void setUnitId(long var1);

    public abstract long getCreateTime();

    public abstract void setCreateTime(long var1);

    public abstract long getBeginReceiveTime();

    public abstract void setBeginReceiveTime(long var1);

    public abstract long getPkGdataPrevious();

    public abstract void setPkGdataPrevious(long var1);

    public abstract String getArea();

    public abstract void setArea(String var1);

    public abstract String getRmcRec();

    public abstract void setRmcRec(String var1);

    public abstract String getGgaRec();

    public abstract void setGgaRec(String var1);

    public abstract boolean getTrusted();

    public abstract void setTrusted(boolean var1);

    public abstract String getReason();

    public abstract void setReason(String var1);

    public abstract GrouphistoryLocal getGroupHistoryId();

    public abstract UnitModelLocal getUnitModel();

    public abstract void setUnitModel(UnitModelLocal var1);

    public abstract int getLongMSEC();

    public abstract void setLongMSEC(int var1);

    public abstract int getLatMSEC();

    public abstract void setLatMSEC(int var1);

    public abstract void setGroupHistoryId(GrouphistoryLocal var1);

    public abstract AreaLocal getAreaLocal();

    public abstract void setAreaLocal(AreaLocal var1);
}

