/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.app.state.event;

import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import java.io.Serializable;

public class StateEvent
implements Serializable {
    private static final long serialVersionUID = -6306463440169172160L;
    private long receiveTime;
    private long stateId;
    private long stateModelId;
    private long timestamp;
    private long unitId;
    private long beginStamp;
    private long endStamp;
    private String remark;
    private String area;
    private UseUserValue user;
    private boolean areaTrusted;

    public StateEvent(long unitId, long stateModelId, long stateId, long timestamp, long receiveTime) {
        this(unitId, stateModelId, stateId, timestamp, receiveTime, null);
    }

    public StateEvent(long unitId, long stateModelId, long stateId, long timestamp, long receiveTime, String remark) {
        this.unitId = unitId;
        this.stateModelId = stateModelId;
        this.stateId = stateId;
        this.timestamp = timestamp;
        this.receiveTime = receiveTime;
        this.remark = remark;
        this.beginStamp = Math.round(Math.floor(timestamp / 86400000L) * 8.64E7);
        this.endStamp = Math.round(Math.ceil(receiveTime / 86400000L) * 8.64E7);
    }

    public StateEvent() {
    }

    public long getEventDelay() {
        return this.receiveTime - this.timestamp;
    }

    public long getReceiveTime() {
        return this.receiveTime;
    }

    public long getStateId() {
        return this.stateId;
    }

    public long getStateModelId() {
        return this.stateModelId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getUnitId() {
        return this.unitId;
    }

    public String toString() {
        String dump = StateEvent.class.getName() + " (\n";
        dump = dump + "unitId: '" + this.unitId + "' \n";
        dump = dump + "stateModelId: '" + this.stateModelId + "' \n";
        dump = dump + "stateId: '" + this.stateId + "' \n";
        dump = dump + "timestamp: '" + this.timestamp + "' \n";
        dump = dump + "receiveTime: '" + this.receiveTime + "' \n";
        return dump;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public UseUserValue getUser() {
        return this.user;
    }

    public void setUser(UseUserValue user) {
        this.user = user;
    }

    public boolean isAreaTrusted() {
        return this.areaTrusted;
    }

    public void setAreaTrusted(boolean areaTrusted) {
        this.areaTrusted = areaTrusted;
    }

    public long getBeginStamp() {
        return this.beginStamp;
    }

    public long getEndStamp() {
        return this.endStamp;
    }
}

