/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class TempFileUtil {
    public static File createTempDir(String name) throws IOException {
        String tmpDir = TempFileUtil.getTmpDir();
        File tmpSubDir = new File(tmpDir, name + "-" + System.currentTimeMillis());
        FileUtils.forceMkdir((File)tmpSubDir);
        tmpSubDir.deleteOnExit();
        return tmpSubDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFile(String name, InputStream in) throws IOException {
        File tmpFile = TempFileUtil.createTempFile(name);
        FileOutputStream out = new FileOutputStream(tmpFile);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
        return tmpFile;
    }

    public static File createTempFile(String name) throws IOException {
        String tmpDir = TempFileUtil.getTmpDir();
        File tmpFile = new File(tmpDir, TempFileUtil.createTempFileName(name));
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public static String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    protected static String createTempFileName(String name) {
        int index = name.lastIndexOf(".");
        String prefix = name.substring(0, index);
        String suffix = name.substring(index);
        return prefix + "-" + System.currentTimeMillis() + suffix;
    }
}

