/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ArchiveUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractArchive(File archive, File directory) throws Exception {
        if (archive == null || !archive.isFile()) {
            throw new IllegalArgumentException((archive != null ? archive.getAbsolutePath() : "null") + " is not a file!");
        }
        if (directory == null || !directory.isDirectory()) {
            throw new IllegalArgumentException((directory != null ? directory.getAbsolutePath() : "null") + " is not a directory!");
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ArchiveInputStream ais = null;
        try {
            fis = new FileInputStream(archive);
            bis = new BufferedInputStream(fis);
            ais = new ArchiveStreamFactory().createArchiveInputStream((InputStream)bis);
            if (ais == null) {
                throw new UnsupportedOperationException("Extraction of archive " + archive.getAbsolutePath() + " is not supported!");
            }
            ArchiveEntry entry = null;
            do {
                if ((entry = ais.getNextEntry()) == null) continue;
                File entryFile = new File(directory.getAbsolutePath(), entry.getName());
                if (entry.isDirectory()) {
                    FileUtils.forceMkdir((File)entryFile);
                    continue;
                }
                File parent = entryFile.getParentFile();
                if (!parent.exists()) {
                    FileUtils.forceMkdir((File)parent);
                }
                FileOutputStream fout = new FileOutputStream(entryFile);
                try {
                    IOUtils.copy((InputStream)ais, (OutputStream)fout);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)fout);
                }
            } while (entry != null);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ais);
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly((InputStream)fis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)ais);
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)fis);
    }
}

