/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.uboot;

import de.proveo.infoman.remote.chat.Chat;
import de.proveo.infoman.remote.chat.ExpectPattern;
import de.proveo.infoman.remote.chat.RegexPattern;
import de.proveo.infoman.remote.chat.ResultObject;
import de.proveo.infoman.remote.chat.StringPattern;
import de.proveo.infoman.remote.uboot.SerialInterfaceInfo;
import de.proveo.infoman.remote.uboot.UBootEnvironment;
import de.proveo.infoman.remote.uboot.UBootEvent;
import de.proveo.infoman.remote.uboot.UBootFacade;
import de.proveo.infoman.remote.uboot.UBootObserver;
import de.proveo.infoman.remote.uboot.exceptions.DownloadTimeoutException;
import de.proveo.infoman.remote.uboot.exceptions.FlashNotErasedException;
import de.proveo.infoman.remote.uboot.exceptions.NoGatewayException;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UBootUtil
implements UBootFacade {
    protected static final String START_ADDRESS = "a1000000";
    protected static final String KERNEL_ERASE_START_SECTOR = "00040000";
    protected static final String KERNEL_ERASE_END_SECTOR = "0023ffff";
    protected static final String USERSPACE_ERASE_START_SECTOR = "00240000";
    protected static final String USERSPACE_ERASE_END_SECTOR = "02000000";
    private static final Log log = LogFactory.getLog(UBootUtil.class);
    protected static final String UBOOT_PROMPT = "pcm027>";
    protected static final String ASH_PROMPT = "/ #";
    protected static final String DOWNLOAD_CHAR = "#";
    protected static final String TIMEOUT_CHAR = "T ";
    protected static final String COPY_TO_FLASH = "Copy to Flash";
    protected static final String ERASE_SECTOR = "Erasing sector";
    protected static final String DONE = "done";
    protected static final String UNKNOWN_COMMAND = "Unknown command";
    protected static final ExpectPattern DOWNLOAD_IMAGE = new StringPattern("#");
    protected static final ExpectPattern DOWNLOAD_TIMEOUT = new StringPattern("T ");
    protected static final ExpectPattern UBOOT_SHELL = new StringPattern("pcm027>");
    protected static final ExpectPattern ASH_SHELL = new StringPattern("/ #");
    protected static final ExpectPattern COPY_TO_FLASH_PATTERN = new StringPattern("Copy to Flash");
    protected static final ExpectPattern ERASE_PROGRESS_PATTERN = new StringPattern("Erasing sector");
    protected static final ExpectPattern COPY_DONE_PATTERN = new StringPattern("done");
    protected static final ExpectPattern UNKNOWN_COMMAND_PATTERN = new StringPattern("Unknown command");
    protected static final ExpectPattern ANY_PATTERN = new RegexPattern(".*");
    protected static final int DEFAULT_DOWNLOAD_TIMEOUT = 5;
    protected static final String INFOMAN_IP_VAR = "ipaddr";
    protected static final String SERVER_IP_VAR = "serverip";
    protected static final String BOOTLOADER_ERASE_START_SECTOR = "00000000";
    protected static final String BOOTLOADER_ERASE_END_SECTOR = "0003FFFF";
    protected static final int DEFAULT_LONG_EXPECT_TIMEOUT = 90000;
    protected static final int DEFAULT_EXPECT_TIMEOUT = 20000;
    protected static final String INFOMAN_GATEWAY_IP_VAR = "gatewayip";
    protected static final String INFOMAN_NETMASK_VAR = "netmask";
    protected static final int DOWNLOAD_DIVISOR = 4510;
    protected Chat chat;
    protected int expectTimeout = 20000;
    private ArrayList<UBootObserver> observer = new ArrayList();
    private ArrayList<ExpectPattern> patterns = new ArrayList();
    private File bootloaderImage;
    private File kernelImage;
    private File userspaceImage;
    private InputStream in;
    private OutputStream out;
    private ResultObject result;
    private SerialPort port;
    private String serverIp;
    private UBootEvent event;
    private int sector = 0;
    private long additionalTimeout = 0L;
    private long copyTimeout = 0L;
    private long imageSizeInWords = 0L;

    @Override
    public void addObserver(UBootObserver observer) {
        this.observer.add(observer);
    }

    @Override
    public void boot() throws Exception {
        this.runPreCommand();
        log.debug((Object)"boot");
        try {
            this.chat.send("reset\n");
            this.expectMessage(90000, new StringPattern("BusyBox v"));
            this.expectMessage(90000, ASH_SHELL);
        }
        catch (TimeoutException ex) {
            throw new TimeoutException("Boot message sent but unable to determine if Infoman is already running" + this.result.getBufferContent());
        }
    }

    public void closeSession() throws Exception {
        if (this.chat != null) {
            this.chat.stop();
        }
        IOUtils.closeQuietly((InputStream)this.in);
        IOUtils.closeQuietly((OutputStream)this.out);
        if (this.port != null) {
            this.port.close();
            this.port = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Session closed");
        }
    }

    public static long getCopyCount(long size) {
        return size / 4L;
    }

    @Override
    public void downloadBootloaderImage() throws Exception {
        this.downloadImage(ImageType.BOOTLOADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadImage(ImageType type) throws Exception {
        String file = null;
        switch (type) {
            case BOOTLOADER: {
                file = this.bootloaderImage.getName();
                this.event = UBootEvent.BOOTLOADER_UPDATE;
                break;
            }
            case KERNEL: {
                file = this.kernelImage.getName();
                this.event = UBootEvent.KERNEL_UDPATE;
                break;
            }
            case USERSPACE: {
                file = this.userspaceImage.getName();
                this.event = UBootEvent.USERSPACE_UPDATE;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type for image. Image type: " + (Object)((Object)type));
            }
        }
        String command = String.format("tftp a1000000 %s\n", file);
        if (log.isDebugEnabled()) {
            log.debug((Object)command);
        }
        this.runPreCommand();
        this.chat.send(command);
        this.notifyObserver();
        String resultString = null;
        int timeouts = 0;
        try {
            String noGatewayMsg = "Warning: gatewayip needed but not set";
            StringPattern noGateway = new StringPattern(noGatewayMsg);
            do {
                this.result = this.expectMessage(90000, UNKNOWN_COMMAND_PATTERN, UBOOT_SHELL, noGateway, DOWNLOAD_IMAGE, DOWNLOAD_TIMEOUT);
                resultString = this.result.getMatchingPattern().getComparePattern();
                if (resultString.equals(TIMEOUT_CHAR)) {
                    ++timeouts;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Timeout while downloading " + file + ". Counter: " + timeouts));
                    continue;
                }
                timeouts = 0;
            } while (timeouts != 5 && !resultString.equals(UBOOT_PROMPT) && !resultString.equals(UNKNOWN_COMMAND) && !resultString.equals(noGatewayMsg));
            if (resultString.equals(noGatewayMsg)) {
                throw new NoGatewayException("Gateway required");
            }
            if (timeouts >= 5) {
                throw new DownloadTimeoutException("Failed to download image with tftp - command: " + command);
            }
            if (resultString.equals(UNKNOWN_COMMAND)) {
                throw new IllegalArgumentException("UBoot reports unknown command. Command is possibly truncated: " + this.result.getBufferContent());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished downloading " + file));
            }
        }
        finally {
            if (timeouts >= 5) {
                this.sendCancelCommand();
            }
        }
    }

    @Override
    public void downloadKernelImage() throws Exception {
        this.downloadImage(ImageType.KERNEL);
    }

    @Override
    public void downloadUserspaceImage() throws Exception {
        this.downloadImage(ImageType.USERSPACE);
    }

    public void enterBootLoader() throws Exception {
        this.expectMessage(-1, new StringPattern("Hit any key to stop autoboot:"));
        this.chat.send("\n");
        this.expectMessage(UBOOT_SHELL);
    }

    public synchronized int getCurrentSector() {
        return this.sector;
    }

    public UBootEnvironment getEnvironmentSettings() throws Exception {
        this.runPreCommand();
        this.chat.send("printenv\n");
        ResultObject match = this.expectMessage(new StringPattern(" bytes"));
        String env = match.getBufferContent();
        return UBootUtil.parseEnv(env);
    }

    public int getExpectTimeout() {
        return this.expectTimeout;
    }

    @Override
    public String getOSEthernetIP() throws Exception {
        this.runPreCommand();
        this.chat.send("ifconfig eth0\n");
        this.result = this.expectMessage(new StringPattern("RX packets"));
        return this.parseIfConfig(this.result);
    }

    @Override
    public String getUBootVersion() throws Exception {
        this.runPreCommand();
        this.chat.send("version\n");
        ResultObject match = this.expectMessage(UBOOT_SHELL);
        String content = match.getBufferContent();
        int prompt = content.indexOf(UBOOT_PROMPT);
        if (prompt != -1) {
            return content.substring(0, prompt);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installBootloaderImage() throws Exception {
        try {
            this.protectBootloaderSectors(false);
            this.installImage(ImageType.BOOTLOADER);
        }
        finally {
            this.protectBootloaderSectors(true);
        }
    }

    @Override
    public void installKernelImage() throws Exception {
        this.installImage(ImageType.KERNEL);
    }

    @Override
    public void installUserspaceImage() throws Exception {
        this.installImage(ImageType.USERSPACE);
    }

    public boolean isInBootloader() throws Exception {
        this.runPreCommand();
        this.chat.send("\n");
        do {
            this.result = this.expectMessage(UBOOT_SHELL, ASH_SHELL, ANY_PATTERN);
        } while (this.result.getMatchingPattern() instanceof RegexPattern);
        String prompt = this.result.getMatchingPattern().getComparePattern();
        return prompt.equals(UBOOT_PROMPT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UBootEnvironment load(File file) throws IOException {
        Properties properties = null;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            properties = new Properties();
            properties.load(reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return properties != null ? new UBootEnvironment(properties) : null;
    }

    @Override
    public void notifyObserver() {
        for (UBootObserver o : this.observer) {
            o.uBootEventNotify(this.event);
        }
    }

    public void openSession(SerialInterfaceInfo connection) throws Exception {
        this.runPreCommand();
        if (log.isDebugEnabled() && connection != null) {
            log.debug((Object)("Opening serial port " + connection.getSerialInterface() + " with this settings:"));
            log.debug((Object)("Baudrate: " + connection.getBaudrate()));
            log.debug((Object)("Data bits: " + connection.getDatabits()));
            log.debug((Object)("Stop bits: " + connection.getStopbits()));
            log.debug((Object)("Parity: " + connection.getParity()));
        }
        CommPort commPort = null;
        CommPortIdentifier identifier = CommPortIdentifier.getPortIdentifier((String)connection.getSerialInterface());
        commPort = identifier.open(this.getClass().getName(), 2000);
        if (commPort instanceof SerialPort) {
            this.port = (SerialPort)commPort;
            this.port.setSerialPortParams(connection.getBaudrate(), connection.getDatabits(), connection.getStopbits(), connection.getParity());
            this.port.enableReceiveTimeout(1000);
            if (!this.port.isReceiveTimeoutEnabled()) {
                this.port.close();
                throw new IllegalStateException("Receive timeout not supported by SerialPort!");
            }
        } else {
            commPort.close();
            throw new Exception("Port " + connection.getSerialInterface() + " is not a serial port!");
        }
        this.in = this.port.getInputStream();
        this.out = this.port.getOutputStream();
        this.additionalTimeout = 0L;
        this.chat = new Chat(this.in, this.out);
        this.chat.start();
    }

    @Override
    public boolean ping(String ip) throws Exception {
        boolean isAvailable = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pinging " + ip));
        }
        this.runPreCommand();
        this.chat.send(String.format("ping %s\n", ip));
        String success = String.format("host %s is alive", ip);
        String fail = "ping failed;";
        StringPattern pingFail = new StringPattern(fail);
        StringPattern pingSuccess = new StringPattern(success);
        ResultObject rObj = this.expectMessage(90000, pingSuccess, pingFail);
        String resultStr = rObj.getMatchingPattern().getComparePattern();
        if (resultStr.equals(success)) {
            isAvailable = true;
        } else if (resultStr.equals(fail)) {
            isAvailable = false;
        }
        if (log.isDebugEnabled()) {
            String message = ip + " is " + (isAvailable ? "available" : "unavailable");
            log.debug((Object)message);
        }
        return isAvailable;
    }

    @Override
    public boolean pingServer() throws Exception {
        return this.ping(this.serverIp);
    }

    @Override
    public void protectBootloaderSectors(boolean protect) throws Exception {
        this.runPreCommand();
        StringBuilder builder = new StringBuilder();
        builder.append("protect ");
        builder.append(protect ? "on" : "off");
        builder.append(String.format(" %s %s\n", BOOTLOADER_ERASE_START_SECTOR, BOOTLOADER_ERASE_END_SECTOR));
        if (log.isDebugEnabled()) {
            log.debug((Object)((protect ? "P" : "Un-P") + "rotect bootloader sectors"));
        }
        this.chat.send(builder.toString());
        builder.delete(0, builder.length());
        if (!protect) {
            builder.append("Un-");
        }
        builder.append("Protected 1 sectors");
        this.expectMessage(new StringPattern(builder.toString()));
    }

    @Override
    public void removeObserver(UBootObserver observer) {
        this.observer.remove(observer);
    }

    public static void save(UBootEnvironment env, File file) throws IOException {
        Properties properties = env.getSettings();
        FileWriter writer = new FileWriter(file);
        properties.store(writer, null);
        writer.close();
    }

    @Override
    public File getBootloaderImageFile() {
        return this.bootloaderImage;
    }

    @Override
    public File getKernelImageFile() {
        return this.kernelImage;
    }

    @Override
    public File getUserspaceImageFile() {
        return this.userspaceImage;
    }

    @Override
    public void saveEnvironment() throws Exception {
        this.runPreCommand();
        this.chat.send("saveenv\n");
        this.expectMessage(10000, UBOOT_SHELL);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Environment variables saved!");
        }
    }

    public void sendCancelCommand() throws Exception {
        String cancelStr = new String(new byte[]{3});
        this.runPreCommand();
        this.chat.send(cancelStr + ";echo cancelling last command\n");
    }

    @Override
    public void setBootloaderImageFile(File bootloaderImage) {
        this.bootloaderImage = bootloaderImage;
    }

    @Override
    public void setEnvironmentSettings(UBootEnvironment newEnv) throws Exception {
        Properties oldProperties = this.getEnvironmentSettings().getSettings();
        Properties newProperties = newEnv.getSettings();
        Properties modifiedProperties = new Properties();
        Enumeration<Object> keys = newProperties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String newValue = newProperties.getProperty(key);
            if (oldProperties.containsKey(key)) {
                if (oldProperties.get(key).equals(newValue)) continue;
                modifiedProperties.put(key, newValue);
                continue;
            }
            modifiedProperties.put(key, newValue);
        }
        this.applyEnvironmentSettings(modifiedProperties);
    }

    @Override
    public void setEnvironmentVariable(String variable, String value) throws Exception {
        if (variable == null || variable.length() == 0) {
            throw new IllegalArgumentException("Variable name is missing");
        }
        String command = null;
        if (value != null) {
            if (value.contains(" ")) {
                value = String.format("\"%s\"", value);
            }
            command = String.format("setenv %s %s\n", variable.trim(), value.trim());
        } else {
            command = String.format("setenv %s\n", variable.trim());
        }
        this.runPreCommand();
        this.chat.send(command);
        this.expectMessage(5000, UBOOT_SHELL);
    }

    public void setExpectTimeout(int expectTimeout) {
        this.expectTimeout = expectTimeout;
    }

    @Override
    public void setGateway(String gatewayIp) throws Exception {
        this.setEnvironmentVariable(INFOMAN_GATEWAY_IP_VAR, gatewayIp);
    }

    @Override
    public void setInfomanIp(String infomanIp) throws Exception {
        this.setEnvironmentVariable(INFOMAN_IP_VAR, infomanIp);
    }

    @Override
    public void setKernelImageFile(File kernelImage) {
        this.kernelImage = kernelImage;
    }

    @Override
    public void setNetmask(String netmask) throws Exception {
        this.setEnvironmentVariable(INFOMAN_NETMASK_VAR, netmask);
    }

    @Override
    public void setServerIp(String serverIp) throws Exception {
        this.serverIp = serverIp;
        this.setEnvironmentVariable(SERVER_IP_VAR, serverIp);
    }

    @Override
    public void setUserspaceImageFile(File userspace) {
        this.userspaceImage = userspace;
    }

    protected static UBootEnvironment parseEnv(String env) throws IOException {
        Properties properties = new Properties();
        properties.load(new StringReader(env));
        properties.remove("printenv");
        String envSize = (String)properties.remove("Environment");
        envSize = envSize.substring("size: ".length(), envSize.indexOf(" bytes"));
        String[] parts = envSize.split("/");
        return new UBootEnvironment(properties, Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    protected void applyEnvironmentSettings(Properties settings) throws Exception {
        Enumeration<Object> keys = settings.keys();
        StringBuilder builder = new StringBuilder();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)settings.get(key);
            if (value.contains(" ")) {
                value = String.format("\"%s\"", value);
            }
            builder.append(String.format("setenv %s %s;", key, value));
        }
        builder.append("\n");
        this.runPreCommand();
        this.chat.send(builder.toString());
        this.expectMessage(UBOOT_SHELL);
    }

    protected void copy(String source, String target, String count) throws Exception {
        this.runPreCommand();
        String command = String.format("cp %s %s %s\n", source, target, count);
        if (log.isDebugEnabled()) {
            log.debug((Object)command);
        }
        this.chat.send(command);
        String flashErrorMessage = "Copy to Flash... Flash not Erased";
        StringPattern error = new StringPattern(flashErrorMessage);
        this.result = this.expectMessage(COPY_TO_FLASH_PATTERN, UNKNOWN_COMMAND_PATTERN, error);
        if (this.result.getMatchingPattern().getComparePattern().equals(UNKNOWN_COMMAND)) {
            throw new IllegalArgumentException("UBoot reports unknown command. Command is possibly truncated: " + this.result.getBufferContent());
        }
        if (this.result.getMatchingPattern().getComparePattern().equals(flashErrorMessage)) {
            throw new FlashNotErasedException(this.result.getBufferContent());
        }
        this.event = UBootEvent.COPY_TO_FLASH;
        this.notifyObserver();
        this.result = this.expectMessage((int)this.copyTimeout, COPY_DONE_PATTERN);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Copied image to flash");
        }
    }

    protected void eraseSectors(String fromSector, String toSector, ImageType type) throws Exception {
        this.runPreCommand();
        String command = String.format("erase %s %s\n", fromSector, toSector);
        String resultString = null;
        String conditionString = ERASE_SECTOR;
        this.chat.send(command);
        if (log.isDebugEnabled()) {
            log.debug((Object)command);
        }
        do {
            this.result = this.expectMessage(ERASE_PROGRESS_PATTERN, UBOOT_SHELL, UNKNOWN_COMMAND_PATTERN);
            resultString = this.result.getMatchingPattern().getComparePattern();
            if (!resultString.equals(ERASE_SECTOR)) continue;
            ++this.sector;
            switch (type) {
                case BOOTLOADER: {
                    this.event = UBootEvent.BOOTLOADER_ERASE_SECTOR;
                    break;
                }
                case KERNEL: {
                    this.event = UBootEvent.KERNEL_ERASE_SECTOR;
                    break;
                }
                case USERSPACE: {
                    this.event = UBootEvent.USERSPACE_ERASE_SECTOR;
                }
            }
            this.notifyObserver();
        } while (conditionString.equals(resultString));
        if (resultString.equals(UNKNOWN_COMMAND)) {
            throw new IllegalArgumentException("UBoot reports unknown command. Command is possibly truncated: " + this.result.getBufferContent());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Sectors deleted");
        }
    }

    protected String getSectorAmountAsHex(File file) {
        this.imageSizeInWords = UBootUtil.getCopyCount(file.length());
        return Long.toHexString(this.imageSizeInWords);
    }

    protected void installImage(ImageType image) throws Exception {
        String target = null;
        String sectorCount = null;
        switch (image) {
            case BOOTLOADER: {
                target = BOOTLOADER_ERASE_START_SECTOR;
                sectorCount = BOOTLOADER_ERASE_END_SECTOR;
                this.event = UBootEvent.BOOTLOADER_UPDATE;
                this.additionalTimeout = 10000L;
                this.imageSizeInWords = UBootUtil.getCopyCount(this.bootloaderImage.length());
                this.copyTimeout = (long)this.calculateTimeout(this.imageSizeInWords) + this.additionalTimeout;
                break;
            }
            case KERNEL: {
                target = KERNEL_ERASE_START_SECTOR;
                sectorCount = KERNEL_ERASE_END_SECTOR;
                this.event = UBootEvent.KERNEL_UDPATE;
                this.additionalTimeout = 30000L;
                this.imageSizeInWords = UBootUtil.getCopyCount(this.kernelImage.length());
                this.copyTimeout = (long)this.calculateTimeout(this.imageSizeInWords) + this.additionalTimeout;
                break;
            }
            case USERSPACE: {
                target = USERSPACE_ERASE_START_SECTOR;
                sectorCount = USERSPACE_ERASE_END_SECTOR;
                this.event = UBootEvent.USERSPACE_UPDATE;
                this.imageSizeInWords = UBootUtil.getCopyCount(this.userspaceImage.length());
                this.copyTimeout = this.calculateTimeout(this.imageSizeInWords) * 3;
            }
        }
        this.notifyObserver();
        this.sector = 0;
        this.eraseSectors(target, sectorCount, image);
        switch (image) {
            case BOOTLOADER: {
                sectorCount = this.getSectorAmountAsHex(this.bootloaderImage);
                break;
            }
            case KERNEL: {
                sectorCount = this.getSectorAmountAsHex(this.kernelImage);
                break;
            }
            case USERSPACE: {
                sectorCount = this.getSectorAmountAsHex(this.userspaceImage);
            }
        }
        this.copy(START_ADDRESS, target, sectorCount);
        this.runPreCommand();
        this.event = UBootEvent.DONE;
        this.notifyObserver();
    }

    protected String parseIfConfig(ResultObject result) {
        String ethCfg = result.getBufferContent();
        String ipCfg = ethCfg.substring(ethCfg.indexOf("inet addr:"), ethCfg.indexOf("Bcast:"));
        String[] ip = ipCfg.split("inet addr:");
        return ip[1].trim();
    }

    protected void runPreCommand() throws Exception {
        Thread.sleep(100L);
    }

    private int calculateTimeout(long amountOfSectors) {
        return (int)((double)(amountOfSectors / 43291L) * 1.3 * 1000.0);
    }

    private ResultObject expectMessage(int timeout, ExpectPattern ... expect) throws Exception {
        this.patterns.clear();
        this.patterns.addAll(Arrays.asList(expect));
        if (timeout >= 0) {
            return this.chat.expect(this.patterns, timeout);
        }
        return this.chat.expect(this.patterns);
    }

    private ResultObject expectMessage(ExpectPattern ... expect) throws Exception {
        return this.expectMessage(this.getExpectTimeout(), expect);
    }

    public static enum ImageType {
        KERNEL,
        USERSPACE,
        BOOTLOADER;

    }
}

