/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.uboot;

import de.proveo.infoman.remote.uboot.SerialInterfaceInfo;
import de.proveo.infoman.remote.uboot.UBootEvent;
import de.proveo.infoman.remote.uboot.UBootObserver;
import de.proveo.infoman.remote.uboot.UBootUtil;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

class UBootTest
implements UBootObserver {
    UBootTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        System.out.println("start");
        final UBootUtil uboot = new UBootUtil();
        try {
            UBootTest test = new UBootTest(){

                @Override
                public void uBootEventNotify(UBootEvent event) {
                    switch (event) {
                        case KERNEL_ERASE_SECTOR: 
                        case USERSPACE_ERASE_SECTOR: {
                            System.out.println((Object)((Object)event) + " sector " + uboot.getCurrentSector());
                            break;
                        }
                        case COPY_TO_FLASH: {
                            System.out.println("Copy to flash");
                            break;
                        }
                        case DONE: {
                            System.out.println("Installation complete");
                        }
                    }
                }
            };
            File kernel = new File("/var/tftp/infoman_kernel/infoman-kernel.img");
            File userspace = new File("/var/tftp/infoman_kernel/infoman-userspace.img");
            File bootloader = new File("/var/tftp/infoman_kernel/u-boot.bin");
            SerialInterfaceInfo info = new SerialInterfaceInfo("/dev/ttyUSB0", 115200, 8, 1, 0);
            uboot.addObserver(test);
            uboot.setKernelImageFile(kernel);
            uboot.setUserspaceImageFile(userspace);
            uboot.setBootloaderImageFile(bootloader);
            uboot.openSession(info);
            uboot.enterBootLoader();
            String version = uboot.getUBootVersion();
            System.out.println("The version " + version);
            return;
        }
        catch (Exception ex) {
            Logger.getLogger(UBootTest.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            try {
                uboot.closeSession();
            }
            catch (Exception ex) {
                Logger.getLogger(UBootTest.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                System.exit(0);
            }
        }
    }

    @Override
    public void uBootEventNotify(UBootEvent event) {
    }
}

