/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.pm;

import de.proveo.infoman.remote.InfomanRAS;
import de.proveo.infoman.remote.ShellWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PMFirmwareUpdateUtil {
    private static final String PM_UPDATE_SCRIPT = "updatePMfirmware.sh";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File compressFirmware(File pmFirmware) throws IOException {
        File gzipFile = File.createTempFile(pmFirmware.getName(), "-tmp.gz");
        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(gzipFile));
        byte[] tmp = FileUtils.readFileToByteArray((File)pmFirmware);
        try {
            out.write(tmp);
        }
        finally {
            out.close();
        }
        return gzipFile;
    }

    public static File createSHA1ChecksumFile(File pmFirmware) throws IOException {
        return PMFirmwareUpdateUtil.createSHA1ChecksumForFiles(new File[]{pmFirmware});
    }

    public static String getSHA1Checksum(File file) {
        try {
            byte[] digest = PMFirmwareUpdateUtil.createSHA1Digest(file);
            return PMFirmwareUpdateUtil.getSHA1Checksum(digest);
        }
        catch (IOException ex) {
            Logger.getLogger(PMFirmwareUpdateUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static File[] getUpdateFiles() throws IOException {
        InputStream in = PMFirmwareUpdateUtil.class.getResourceAsStream("updateResources.lst");
        List lines = IOUtils.readLines((InputStream)in);
        File[] files = new File[lines.size()];
        in.close();
        for (int i = 0; i < files.length; ++i) {
            files[i] = FileUtils.toFile((URL)PMFirmwareUpdateUtil.class.getResource((String)lines.get(i)));
        }
        return files;
    }

    public void executeFirmwareUpdate(InputStream stdOut, OutputStream stdIn, String remoteFile) throws Exception {
        String executable = "updatePMfirmware.sh " + remoteFile;
        PrintStream stdInPrint = new PrintStream(stdIn);
        stdInPrint.println(executable);
        this.waitFor(stdOut, "decompress...");
        this.waitFor(stdOut, "checking checksum...");
        this.waitFor(stdOut, "stopping infoman...");
        this.waitFor(stdOut, "start triggering watchdog...");
        this.waitFor(stdOut, "run IAP update...");
        this.waitFor(stdOut, "Calculating CRCs...");
        this.waitFor(stdOut, "Checking state of device...");
        this.waitFor(stdOut, "Sending DATA...");
        this.waitFor(stdOut, "stopping watchdog triggering...");
        this.waitFor(stdOut, "starting infoman...");
    }

    public static void main(String[] args) throws Exception {
        InfomanRAS infomanRAS = new InfomanRAS();
        infomanRAS.setURL("root:root@10.0.0.30:22");
        infomanRAS.connect();
        PipedInputStream remoteStdIn = new PipedInputStream();
        PrintStream stdIn = new PrintStream(new PipedOutputStream(remoteStdIn));
        PipedInputStream stdOut = new PipedInputStream();
        PipedOutputStream remoteStdOut = new PipedOutputStream(stdOut);
        ShellWrapper shell = infomanRAS.openShell(remoteStdIn, remoteStdOut);
        new PMFirmwareUpdateUtil().executeFirmwareUpdate(stdOut, stdIn, "/tmp/pm.hex.gz");
        shell.disconnect();
        infomanRAS.disconnect();
        System.out.println("--------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static File createSHA1ChecksumForFiles(File[] files) throws IOException {
        PrintWriter writer = null;
        File csFile = File.createTempFile("~sha1", "-tmp.sha1");
        try {
            writer = new PrintWriter(csFile);
            for (File f : files) {
                byte[] digest = PMFirmwareUpdateUtil.createSHA1Digest(f);
                String checksum = PMFirmwareUpdateUtil.getSHA1Checksum(digest);
                writer.format("%1s  %2s\n", checksum, f.getName());
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return csFile;
    }

    protected static byte[] createSHA1Digest(File file) throws IOException {
        try {
            MessageDigest algorithm = MessageDigest.getInstance("SHA1");
            byte[] pmHex = FileUtils.readFileToByteArray((File)file);
            algorithm.update(pmHex);
            return algorithm.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex);
        }
    }

    protected static String getSHA1Checksum(byte[] bytes) {
        BigInteger checksum = new BigInteger(1, bytes);
        return checksum.toString(16);
    }

    protected void waitFor(InputStream in, String str) throws Exception {
        StringBuilder buffer = new StringBuilder();
        boolean stop = false;
        do {
            int c = in.read();
            buffer.append((char)c);
            System.out.print((char)c);
            if (buffer.indexOf(str) <= -1) continue;
            System.out.println("got: " + str);
            stop = true;
        } while (!stop);
    }
}

