/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.chat;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReaderThread
extends Thread {
    private static final Log log = LogFactory.getLog(ReaderThread.class);
    final InputStream in;
    final StringBuilder buffer;
    private volatile boolean isRunning;

    public ReaderThread(InputStream in, StringBuilder buffer) {
        super("ChatReader");
        this.in = in;
        this.buffer = buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        Object object = this;
        synchronized (object) {
            this.notify();
        }
        log.debug((Object)"run() started");
        try {
            do {
                int c = this.in.read();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("run() read: " + c + " char:" + (char)c));
                }
                if (c <= -1 || this.buffer == null) continue;
                log.trace((Object)"run() before synchronized buffer");
                object = this.buffer;
                synchronized (object) {
                    log.trace((Object)"run() after synchronized buffer");
                    this.buffer.append((char)c);
                    this.buffer.notifyAll();
                    log.trace((Object)"run() notify all");
                }
            } while (this.isRunning);
        }
        catch (IOException ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
        if (log.isInfoEnabled()) {
            log.debug((Object)"run() stopped");
        }
    }

    public void stopReading() {
        this.isRunning = false;
    }
}

