/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.chat;

import de.proveo.infoman.remote.chat.ExpectPattern;
import de.proveo.infoman.remote.chat.ReaderThread;
import de.proveo.infoman.remote.chat.ResultObject;
import de.proveo.infoman.remote.chat.StringPattern;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Chat {
    private static final Log log = LogFactory.getLog(Chat.class);
    final OutputStream out;
    final ReaderThread reader;
    final StringBuilder buffer = new StringBuilder();
    boolean canceled;
    private int nextIndexPosition = 0;
    private int oldBufferLength = 0;

    public Chat(InputStream in, OutputStream out) {
        this.out = out;
        this.reader = new ReaderThread(in, this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            this.canceled = true;
            this.buffer.notifyAll();
        }
    }

    public synchronized ResultObject expect(String pattern) throws IllegalStateException {
        try {
            return this.expect(pattern, -1);
        }
        catch (TimeoutException ex) {
            Logger.getLogger(Chat.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public synchronized ResultObject expect(String pattern, int timeout) throws TimeoutException, IllegalStateException {
        StringPattern strPattern = new StringPattern(pattern);
        ArrayList<ExpectPattern> list = new ArrayList<ExpectPattern>();
        list.add(strPattern);
        return this.expect(list, timeout);
    }

    public synchronized ResultObject expect(Collection<ExpectPattern> patterns) throws TimeoutException, IllegalStateException {
        return this.expect(patterns, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultObject expect(Collection<ExpectPattern> patterns, int timeout) throws TimeoutException, IllegalStateException {
        ResultObject result = null;
        if (log.isDebugEnabled()) {
            StringBuilder str = new StringBuilder("expect: timeout=");
            str.append(timeout);
            str.append('\n');
            for (ExpectPattern pattern : patterns) {
                str.append("expect: '");
                str.append(pattern);
                str.append("'\n");
                str.append("buffer: '\n");
                str.append((CharSequence)this.buffer);
                str.append("'\n");
            }
            log.debug((Object)str.toString());
        }
        try {
            long startTime = System.currentTimeMillis();
            do {
                log.trace((Object)"expect() before buffer");
                StringBuilder stringBuilder = this.buffer;
                synchronized (stringBuilder) {
                    log.trace((Object)"expect() in buffer");
                    if (this.canceled) {
                        throw new CancellationException();
                    }
                    boolean bufferChanged = this.isBufferChangedSinceLastExpect();
                    int bufferLength = this.buffer.length();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("expect() buffer Changed: " + bufferChanged + " bufferLength:" + bufferLength + " nextIndexPosition:" + this.nextIndexPosition));
                    }
                    if (bufferChanged || this.nextIndexPosition < bufferLength) {
                        String extract = this.getBufferContentSinceLastExpect();
                        result = this.find(patterns, extract);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)(" expect() extract:" + extract + " result:" + result));
                        }
                    }
                    if (timeout > 0 && result == null) {
                        long current = System.currentTimeMillis();
                        long delay = current - startTime;
                        if (delay >= (long)timeout) {
                            log.warn((Object)"expect() timeout reached");
                            if (log.isDebugEnabled()) {
                                StringBuilder strBuilder = new StringBuilder("timeout! buffer:\n");
                                strBuilder.append((CharSequence)this.buffer);
                                log.debug((Object)strBuilder.toString());
                            }
                            String extract = this.getBufferContentSinceLastExpect();
                            result = this.find(patterns, extract);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)("expect() timout extract:" + extract + " result:" + result));
                            }
                            if (result == null) {
                                log.error((Object)"TimeOutException");
                                throw new TimeoutException("Timeout reached");
                            }
                            this.oldBufferLength = this.buffer.length();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("expect()  got (after timeout) " + result));
                            }
                            return result;
                        }
                        long waitTime = (long)timeout - delay;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("expect() waitTime before:" + waitTime));
                        }
                        this.buffer.wait(waitTime);
                        log.trace((Object)"expect() wait after");
                    }
                    this.oldBufferLength = this.buffer.length();
                }
            } while (result == null);
        }
        catch (InterruptedException ex) {
            log.error((Object)"runs into", (Throwable)ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("got " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(String msg) throws IOException {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            this.buffer.delete(0, this.buffer.length());
            this.nextIndexPosition = 0;
            this.out.write(msg.getBytes());
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ReaderThread readerThread = this.reader;
        synchronized (readerThread) {
            try {
                this.reader.start();
                this.reader.wait();
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Chat.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void stop() {
        this.cancel();
        this.reader.stopReading();
    }

    protected ResultObject find(Collection<ExpectPattern> patterns, String bufferExtract) {
        boolean matchFound = false;
        Iterator<ExpectPattern> i = patterns.iterator();
        ResultObject result = null;
        while (!matchFound && i.hasNext()) {
            ExpectPattern pattern = i.next();
            matchFound = pattern.compare(bufferExtract);
            if (!matchFound) continue;
            String str = this.buffer.toString();
            result = new ResultObject(pattern, str);
            this.nextIndexPosition = this.getNextIndexPosition(str, bufferExtract, pattern.getComparePattern());
        }
        return result;
    }

    protected String getBufferContentSinceLastExpect() {
        if (this.nextIndexPosition != 0) {
            return this.buffer.substring(this.nextIndexPosition);
        }
        return this.buffer.toString();
    }

    protected int getCurrentIndexPosition() {
        return this.nextIndexPosition;
    }

    protected int getNextIndexPosition(String bufferContent, String extract, String pattern) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(extract);
        m.find();
        return bufferContent.indexOf(extract, this.nextIndexPosition) + m.end();
    }

    protected boolean isBufferChangedSinceLastExpect() {
        return this.oldBufferLength != this.buffer.length();
    }
}

