/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.backup;

import com.jcraft.jsch.Session;
import de.proveo.infoman.remote.CommandResponse;
import de.proveo.infoman.remote.InfomanRAS;
import de.proveo.infoman.remote.ScpClient;
import de.proveo.infoman.remote.backup.ConfigurationBackup;
import de.proveo.infoman.remote.util.TempFileUtil;
import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationBackupUtil {
    private static final Log log = LogFactory.getLog(ConfigurationBackupUtil.class);
    public static final String BACKUP_SCRIPT_NAME = "restoreBackup.sh";
    final InfomanRAS infoman;

    public ConfigurationBackupUtil(InfomanRAS infoman) {
        this.infoman = infoman;
    }

    public ConfigurationBackup createConfigBackup(final Observer observer) throws Exception {
        ScpClient scpClient = this.infoman.getScpClient();
        class InfomanBackupObserver
        implements Observer {
            boolean secondStage;

            InfomanBackupObserver() {
            }

            @Override
            public void update(Observable o, Object arg) {
                int value = (Integer)arg;
                value /= 2;
                if (this.secondStage) {
                    value += 50;
                }
                observer.update(o, value);
            }
        }
        InfomanBackupObserver scpObserver = new InfomanBackupObserver();
        scpClient.addObserver(scpObserver);
        Session session = this.infoman.getCurrentSession();
        File backupScript = TempFileUtil.createTempFile("backupConfiguration.sh", InfomanRAS.class.getResourceAsStream("backupConfiguration.sh"));
        scpClient.scpTo(backupScript.getAbsolutePath(), "/tmp/", session);
        this.infoman.executeCommand("chmod a+x /tmp//" + backupScript.getName());
        this.infoman.executeCommand("/tmp/" + backupScript.getName());
        scpObserver.secondStage = true;
        scpClient.scpFrom("/tmp//config.backup.tgz", TempFileUtil.getTmpDir(), session);
        return ConfigurationBackup.create(new File(TempFileUtil.getTmpDir(), "config.backup.tgz"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreBackup(ConfigurationBackup backup) throws Exception {
        try {
            this.infoman.executeCommandWithResponse("rm -rf /home/infoman/events*");
        }
        catch (Exception ex) {
            log.warn((Object)"Could not remove previous generated events", (Throwable)ex);
        }
        Session session = this.infoman.getCurrentSession();
        ScpClient scpClient = this.infoman.getScpClient();
        scpClient.scpTo(backup.getArchive().getAbsolutePath(), "/tmp/", session);
        File backupScript = TempFileUtil.createTempFile(BACKUP_SCRIPT_NAME, InfomanRAS.class.getResourceAsStream(BACKUP_SCRIPT_NAME));
        Properties properties = backup.getDescription();
        if (properties != null) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(backupScript, true);
                Enumeration<Object> en = properties.keys();
                if (en.hasMoreElements()) {
                    writer.write("cd /home/infoman\n");
                    while (en.hasMoreElements()) {
                        String linkName = (String)en.nextElement();
                        String configFile = properties.getProperty(linkName);
                        if (configFile == null || configFile.length() <= 0) continue;
                        writer.write(String.format("ln -s %s %s\n", configFile, linkName));
                    }
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        if (backupScript != null) {
            scpClient.scpTo(backupScript.getAbsolutePath(), "/tmp/", session);
            String scriptName = backupScript.getName();
            CommandResponse resp = this.infoman.executeCommandWithResponse(String.format("cd /tmp;chmod u+x %1$s; ./%1$s", scriptName));
            if (resp.getExitStatus() != 0) {
                throw new Exception("Could not execute backup script. " + resp.getError());
            }
        }
    }
}

