/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote.backup;

import de.proveo.infoman.remote.util.CompressionUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class ConfigurationBackup {
    public static final String DESCRIPTION_FILE = "tmp/configBackup/desc.properties";
    final File archive;
    final Properties description;

    protected ConfigurationBackup(Properties description, File archive) {
        this.description = description;
        this.archive = archive;
    }

    public static ConfigurationBackup create(File archive) throws Exception {
        Properties properties = ConfigurationBackup.parseDescription(CompressionUtil.decompress(archive));
        return new ConfigurationBackup(properties, archive);
    }

    public File getArchive() {
        return this.archive;
    }

    public Properties getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties parseDescription(byte[] decompressedArchive) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(decompressedArchive);
        TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)in);
        TarArchiveEntry entry = null;
        Properties description = null;
        try {
            while ((entry = tarIn.getNextTarEntry()) != null) {
                if (!entry.getName().equals(DESCRIPTION_FILE)) continue;
                byte[] content = new byte[(int)entry.getSize()];
                tarIn.read(content, 0, content.length);
                ByteArrayInputStream prop = new ByteArrayInputStream(content);
                description = new Properties();
                description.load(prop);
                prop.close();
            }
        }
        finally {
            tarIn.close();
            in.close();
        }
        return description;
    }
}

