/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.remote;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import de.proveo.infoman.remote.CommandResponse;
import de.proveo.infoman.remote.InfomanRAS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tail {
    private static final Log log = LogFactory.getLog(Tail.class);
    private final Object restartLock = new Object();
    private final Object restartingLock = new Object();
    private volatile boolean restarting = false;
    private volatile long lastReadTimestamp = -1L;
    private TailFileInodeWatcher iNodeWatcher = null;
    private InputStream in = null;
    private InputStreamReader inr = null;
    private BufferedReader br = null;
    private String command = null;
    private Session session = null;
    private ChannelExec channel = null;
    private int connectionTimeout = -1;
    private InfomanRAS ras;
    private String filename;
    private int n;

    public Tail(InfomanRAS ras, String filename, int n) {
        this.ras = ras;
        this.filename = filename;
        this.n = n;
        this.session = this.ras.getCurrentSession();
        this.connectionTimeout = this.ras.getConnectingTimeout();
        if (this.n < 0) {
            this.n = 10;
        }
        this.command = "tail -n " + this.n + " -f " + this.filename;
    }

    public void start() throws IllegalStateException, IOException {
        this.ras.isConnectedCheck();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Execute command: " + this.command));
            }
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.channel.setCommand(this.command);
            this.channel.setErrStream(null);
            this.channel.setInputStream(null);
            this.channel.setOutputStream(null);
            this.channel.setExtOutputStream(null);
            this.channel.connect(this.connectionTimeout);
        }
        catch (JSchException ex) {
            throw new IOException("Error while executing command: " + this.command, ex);
        }
        this.in = this.channel.getInputStream();
        this.inr = new InputStreamReader(this.in);
        this.br = new BufferedReader(this.inr);
        if (this.iNodeWatcher == null) {
            this.iNodeWatcher = new TailFileInodeWatcher();
            this.iNodeWatcher.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() throws IllegalStateException, IOException {
        if (this.isRestarting()) {
            log.debug((Object)"Already restarting tail, please wait ...");
            return;
        }
        Object object = this.restartingLock;
        synchronized (object) {
            this.restarting = true;
        }
        try {
            log.debug((Object)"Stopping tail ...");
            this._stop();
            log.debug((Object)"Tail stopped.");
            log.debug((Object)"Starting tail again ...");
            this.start();
            log.debug((Object)"Tail started.");
        }
        finally {
            object = this.restartingLock;
            synchronized (object) {
                this.restarting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRestarting() {
        Object object = this.restartingLock;
        synchronized (object) {
            return this.restarting;
        }
    }

    public void stop() {
        if (this.iNodeWatcher != null) {
            this.iNodeWatcher.cancel();
            this.iNodeWatcher = null;
        }
        this._stop();
    }

    private void _stop() {
        if (this.channel != null) {
            log.debug((Object)"Closing channel ...");
            this.channel.disconnect();
            this.channel = null;
            log.debug((Object)"Channel closed.");
        }
        log.debug((Object)"Closing streams ...");
        IOUtils.closeQuietly((Reader)this.br);
        IOUtils.closeQuietly((Reader)this.inr);
        IOUtils.closeQuietly((InputStream)this.in);
        this.br = null;
        this.inr = null;
        this.in = null;
        log.debug((Object)"Streams closed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        if (this.session == null || !this.session.isConnected()) {
            throw new IOException("Not connected!");
        }
        if (this.iNodeWatcher == null || !this.iNodeWatcher.isAlive() || this.iNodeWatcher.isInterrupted()) {
            throw new IOException("Tail has stopped!");
        }
        String line = null;
        try {
            line = this.br.readLine();
            this.lastReadTimestamp = System.currentTimeMillis();
        }
        catch (Exception ex) {
            if (this.isRestarting()) {
                log.debug((Object)"Cannot read from tail, because of restarting ...");
                while (this.isRestarting()) {
                    Object object = this.restartLock;
                    synchronized (object) {
                        try {
                            this.restartLock.wait(100L);
                        }
                        catch (InterruptedException e) {
                            log.debug((Object)"wait() runs into", (Throwable)e);
                        }
                    }
                }
                if (this.iNodeWatcher == null || !this.iNodeWatcher.isAlive() || this.iNodeWatcher.isInterrupted()) {
                    log.info((Object)"Restart failed.");
                } else {
                    log.info((Object)"Restart finished.");
                }
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }
        if (line == null) {
            line = "";
        }
        return line;
    }

    private class TailFileInodeWatcher
    extends Thread {
        private static final long TIMEOUT = 15000L;
        private final Object lock;
        private volatile boolean run;
        private volatile String lastInode;
        private volatile long lastReadCheck;

        public TailFileInodeWatcher() {
            super("TailFileInodeWatcher");
            this.lock = new Object();
            this.run = true;
            this.lastInode = null;
            this.lastReadCheck = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.lastInode = this.getTailFileInode();
            if (this.lastInode == null) {
                log.debug((Object)"Could not get inode, will not start watching for inode of tailing file ...");
                Tail.this.stop();
                return;
            }
            while (this.run) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(500L);
                    }
                    catch (Exception ex) {
                        log.debug((Object)"wait() runs into", (Throwable)ex);
                    }
                }
                if (Tail.this.session == null || !Tail.this.session.isConnected()) {
                    log.debug((Object)"Infoman isn't connected anymore, stop watching for inode.");
                    Tail.this.stop();
                    return;
                }
                long offset = System.currentTimeMillis() - Tail.this.lastReadTimestamp;
                if (Tail.this.lastReadTimestamp == -1L || offset <= 15000L || this.lastReadCheck != -1L && System.currentTimeMillis() - this.lastReadCheck <= 15000L) continue;
                this.lastReadCheck = System.currentTimeMillis();
                boolean restart = true;
                log.debug((Object)("Didn't read anything for " + offset + "ms, checking inode of tailing file ..."));
                String inode = this.getTailFileInode();
                if (inode == null) {
                    log.debug((Object)"Could not get inode, will cancel inode watching for tail ...");
                    Tail.this.stop();
                    return;
                }
                if (ObjectUtils.equals((Object)this.lastInode, (Object)inode)) {
                    restart = false;
                    log.debug((Object)("No need to restart, inode still the same: " + inode));
                } else {
                    log.debug((Object)("Will restart tail, because inode change: previous=" + this.lastInode + " current=" + inode));
                }
                this.lastInode = inode;
                if (!restart) continue;
                try {
                    Tail.this.restart();
                    log.info((Object)"Tail restarted.");
                }
                catch (Exception ex) {
                    log.warn((Object)"Could not restart tail", (Throwable)ex);
                    Tail.this.stop();
                    return;
                }
            }
        }

        private String getTailFileInode() {
            try {
                CommandResponse resp = Tail.this.ras.executeCommandWithResponse("stat " + Tail.this.filename + " | grep \"Inode:\" | awk '{print $4}'");
                if (resp.getExitStatus() == 0) {
                    String inode = resp.getResponse();
                    log.debug((Object)("Got inode for file '" + Tail.this.filename + "': " + inode));
                    return inode;
                }
                throw new IllegalStateException("Return code was " + resp.getExitStatus());
            }
            catch (Exception ex) {
                log.debug((Object)("Could not get inode of file " + Tail.this.filename), (Throwable)ex);
                return null;
            }
        }

        public void cancel() {
            this.run = false;
        }
    }
}

