/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.infoman.config.impl.validation;

import de.proveo.infoman.config.definition.Enum;
import de.proveo.infoman.config.definition.Property;
import de.proveo.infoman.config.impl.validation.ValidationError;
import de.proveo.infoman.config.impl.validation.ValidationErrorImpl;
import de.proveo.infoman.config.impl.validation.ValidationHelper;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EnumValidationHelper
implements ValidationHelper {
    Enum en;

    public EnumValidationHelper(Enum en) {
        this.en = en;
    }

    @Override
    public void validate(List<ValidationError> validationErrors, Property property, String value) {
        List<String> possibleValues = this.en.getValue();
        if (this.en.isMulti() != null && this.en.isMulti().booleanValue()) {
            String[] elements;
            for (String element : elements = StringUtils.split((String)value)) {
                if (possibleValues.contains(element)) continue;
                validationErrors.add(new ValidationErrorImpl(property.getKey(), element, "notInEnum"));
            }
        } else if (!possibleValues.contains(value)) {
            validationErrors.add(new ValidationErrorImpl(property.getKey(), value, "notInEnum"));
        }
    }
}

