/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl.nav.resourceselect;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationNodeFactoryManager;
import de.proveo.idm.software.archive.api.InfomanResourceNavigationItem;
import de.proveo.idm.software.archive.api.Resource;
import de.proveo.idm.software.archive.impl.ResourceImpl;
import de.proveo.idm.software.archive.impl.nav.BundleGroupItem;
import de.proveo.idm.software.archive.impl.nav.InfomanResourceNode;
import de.proveo.idm.software.archive.impl.nav.SoftwareBundleNavigationManager;
import de.proveo.idm.software.archive.impl.nav.resourceselect.MouseEventBeanTreeView;
import de.proveo.idm.software.archive.util.FileUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ResourceSelectorPanel
extends JPanel
implements ExplorerManager.Provider {
    private static final Logger log = Logger.getLogger(ResourceSelectorPanel.class.getName());
    private final ExplorerManager em = new ExplorerManager();
    private final Device.DeviceType deviceType;
    private final Resource.ResourceType[] acceptedTypes;
    private FileChecker fileChecker = null;
    private Node rootNode = null;
    private JLabel fileLbl;
    private JTextField fileTF;
    private JButton openBtn;
    private JLabel selectLbl;
    private JScrollPane treePane;

    public ResourceSelectorPanel(Device.DeviceType deviceType, Resource.ResourceType ... acceptedTypes) {
        this.deviceType = deviceType;
        this.acceptedTypes = acceptedTypes;
        this.initComponents();
        this.fileChecker = new FileChecker(this, this.fileTF, this.deviceType, this.acceptedTypes);
        this.fileTF.getDocument().addDocumentListener(this.fileChecker);
        BeanTreeView beanTreeView = (BeanTreeView)this.treePane;
        beanTreeView.setSelectionMode(1);
        SoftwareBundleNavigationManager navigationItemManager = (SoftwareBundleNavigationManager)Lookup.getDefault().lookup(SoftwareBundleNavigationManager.class);
        BundleGroupItem rootItem = navigationItemManager.getRootItem(this.deviceType, acceptedTypes);
        NavigationNodeFactoryManager navigationNodeFactory = (NavigationNodeFactoryManager)Lookup.getDefault().lookup(NavigationNodeFactoryManager.class);
        this.rootNode = navigationNodeFactory.createNode((NavigationItem)rootItem);
        if (this.rootNode != null) {
            this.em.setRootContext(this.rootNode);
        }
    }

    public static boolean checkFile(Device.DeviceType deviceType, Resource.ResourceType[] acceptedTypes, File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists() || !file.canRead()) {
            return false;
        }
        ArrayList<FileFilter> fileFilters = new ArrayList<FileFilter>();
        for (Resource.ResourceType t : acceptedTypes) {
            for (FileFilter fileFilter : FileUtil.getFileFilters(deviceType, t)) {
                fileFilters.add(fileFilter);
            }
        }
        if (fileFilters.isEmpty()) {
            return true;
        }
        for (FileFilter filter : fileFilters) {
            if (!filter.accept(file)) continue;
            return true;
        }
        return false;
    }

    public Resource getSelectedResource() {
        Node[] selectedNodes = this.em.getSelectedNodes();
        if (selectedNodes.length == 1) {
            InfomanResourceNavigationItem navItem = (InfomanResourceNavigationItem)((Object)selectedNodes[0].getLookup().lookup(InfomanResourceNavigationItem.class));
            return navItem != null ? navItem.getInfomanResource() : null;
        }
        if (this.fileTF.getText().trim().length() != 0) {
            try {
                return new ResourceImpl(new File(this.fileTF.getText()), null, this.acceptedTypes[0], null);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public void setSelectedResource(Resource infomanResource) {
        try {
            InfomanResourceNode selection = this.findNodeByResource(this.rootNode, infomanResource);
            if (selection != null) {
                this.em.setExploredContextAndSelection((Node)selection, new Node[]{selection});
            }
        }
        catch (Exception ex) {
            this.fileTF.setText(infomanResource.getAsFile().getAbsolutePath());
        }
    }

    public Resource findResourceByFile(File file) {
        NavigationItem navItem;
        ResourceImpl res;
        try {
            res = new ResourceImpl(file, null, null, null);
        }
        catch (Exception ex) {
            return null;
        }
        Resource ret = null;
        InfomanResourceNode node = this.findNodeByResource(this.rootNode, res);
        if (node != null && (navItem = node.getNavigationItem()) != null && navItem instanceof InfomanResourceNavigationItem) {
            InfomanResourceNavigationItem resNavItem = (InfomanResourceNavigationItem)navItem;
            ret = resNavItem.getInfomanResource();
        }
        return ret;
    }

    private InfomanResourceNode findNodeByResource(Node node, Resource resource) {
        InfomanResourceNavigationItem resNavItem;
        Resource res;
        InfomanResourceNode resNode;
        NavigationItem navItem;
        if (node == null) {
            return null;
        }
        if (node instanceof InfomanResourceNode && (navItem = (resNode = (InfomanResourceNode)node).getNavigationItem()) != null && navItem instanceof InfomanResourceNavigationItem && (res = (resNavItem = (InfomanResourceNavigationItem)navItem).getInfomanResource()) != null && res.equals(resource)) {
            return resNode;
        }
        Children children = node.getChildren();
        for (int i = 0; i < children.getNodesCount(); ++i) {
            Node n = children.getNodeAt(i);
            InfomanResourceNode resNode2 = this.findNodeByResource(n, resource);
            if (resNode2 == null) continue;
            return resNode2;
        }
        return null;
    }

    public ExplorerManager getExplorerManager() {
        return this.em;
    }

    public void addMouseListenerToBeanTreeView(MouseListener l) {
        ((MouseEventBeanTreeView)((Object)this.treePane)).addMouseListener(l);
    }

    public void removeMouseListenerFromBeanTreeView(MouseListener l) {
        ((MouseEventBeanTreeView)((Object)this.treePane)).removeMouseListener(l);
    }

    private void initComponents() {
        this.selectLbl = new JLabel();
        this.treePane = new MouseEventBeanTreeView();
        this.fileLbl = new JLabel();
        this.openBtn = new JButton();
        this.fileTF = new JTextField();
        this.selectLbl.setText(NbBundle.getMessage(ResourceSelectorPanel.class, (String)"ResourceSelectorPanel.selectLbl.text"));
        this.fileLbl.setText(NbBundle.getMessage(ResourceSelectorPanel.class, (String)"ResourceSelectorPanel.fileLbl.text"));
        this.openBtn.setText(NbBundle.getMessage(ResourceSelectorPanel.class, (String)"ResourceSelectorPanel.openBtn.text"));
        this.openBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResourceSelectorPanel.this.openBtnActionPerformed(evt);
            }
        });
        this.fileTF.setText(NbBundle.getMessage(ResourceSelectorPanel.class, (String)"ResourceSelectorPanel.fileTF.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.treePane, GroupLayout.Alignment.LEADING, -1, 378, Short.MAX_VALUE).addComponent(this.selectLbl, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.fileLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileTF, -1, 242, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openBtn))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.selectLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.treePane, -1, 301, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLbl).addComponent(this.openBtn).addComponent(this.fileTF, -2, -1, -2)).addContainerGap()));
    }

    private void openBtnActionPerformed(ActionEvent evt) {
        File file = FileUtil.showFileOpenDialog(this, this.deviceType, this.acceptedTypes);
        if (file != null) {
            try {
                this.em.setSelectedNodes(new Node[0]);
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Could not remove selection from resources tree", ex);
            }
            this.fileTF.setText(file.getAbsolutePath());
        }
    }

    public static class FileChecker
    implements DocumentListener {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private JComponent comp;
        private JTextField textField;
        private Device.DeviceType deviceType;
        private Resource.ResourceType[] acceptedTypes;

        public FileChecker(JComponent comp, JTextField textField, Device.DeviceType deviceType, Resource.ResourceType ... acceptedTypes) {
            this.comp = comp;
            this.textField = textField;
            this.deviceType = deviceType;
            this.acceptedTypes = acceptedTypes;
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(propertyName, listener);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleChange(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleChange(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleChange(e);
        }

        private void handleChange(DocumentEvent e) {
            if (this.comp != null && !this.comp.isEnabled()) {
                return;
            }
            boolean valid = this.checkInput();
            File file = null;
            String text = this.textField.getText();
            if (text != null && (text = text.trim()).length() != 0) {
                file = new File(text);
            }
            if (valid) {
                this.textField.setForeground(Color.BLACK);
            } else {
                this.textField.setForeground(Color.RED);
            }
            this.pcs.firePropertyChange("fileChanged", null, file);
            this.pcs.firePropertyChange("fileValid", !valid, valid);
        }

        private boolean checkInput() {
            File file = null;
            String text = this.textField.getText();
            if (text != null && (text = text.trim()).length() != 0) {
                file = new File(text);
            }
            return ResourceSelectorPanel.checkFile(this.deviceType, this.acceptedTypes, file);
        }
    }
}

