/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl.nav;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.NavigationItemManager;
import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.software.archive.api.AbstractSoftwareBundle;
import de.proveo.idm.software.archive.api.InfomanSoftwareArchiveManager;
import de.proveo.idm.software.archive.api.Resource;
import de.proveo.idm.software.archive.impl.nav.BundleGroupItem;
import de.proveo.idm.software.archive.impl.nav.BundleNavigationItem;
import java.util.ArrayList;
import java.util.Collection;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SoftwareBundleNavigationManager {
    private static final Object rootItemLock = new Object();
    final NavigationItemManager navigationItemManager = (NavigationItemManager)Lookup.getDefault().lookup(NavigationItemManager.class);
    final InfomanSoftwareArchiveManager infomanSoftwareArchiveManager = (InfomanSoftwareArchiveManager)Lookup.getDefault().lookup(InfomanSoftwareArchiveManager.class);
    private BundleGroupItem currentRootItem = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = rootItemLock;
        synchronized (object) {
            if (this.currentRootItem == null) {
                this.currentRootItem = this.getRootItem(Device.DeviceType.ANY, new Resource.ResourceType[0]);
                if (this.currentRootItem != null) {
                    this.navigationItemManager.addTopLevel((NavigationItem)this.currentRootItem);
                }
            }
        }
    }

    public BundleGroupItem getRootItem(Device.DeviceType deviceType, Resource.ResourceType ... acceptedTypes) {
        BundleGroupItem bundleArchiveItem = new BundleGroupItem(NbBundle.getMessage(SoftwareBundleNavigationManager.class, (String)"SoftwareBundleNavigationManager.rootNode.name"));
        this.updateTree(bundleArchiveItem, deviceType, acceptedTypes);
        if (bundleArchiveItem.getChildren().isEmpty()) {
            bundleArchiveItem = null;
        }
        return bundleArchiveItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = rootItemLock;
        synchronized (object) {
            if (this.currentRootItem == null) {
                this.init();
            }
            if (this.currentRootItem != null) {
                ArrayList children = new ArrayList(this.currentRootItem.getChildren());
                for (NavigationItem child : children) {
                    this.currentRootItem.removeChild(child);
                }
                this.updateTree(this.currentRootItem, Device.DeviceType.ANY, new Resource.ResourceType[0]);
            }
        }
    }

    protected void updateTree(BundleGroupItem bundleArchiveItem, Device.DeviceType deviceType, Resource.ResourceType ... acceptedTypes) {
        BundleNavigationItem bundleNavItem;
        BundleGroupItem item;
        Collection<AbstractSoftwareBundle> bundles;
        SoftwareBundle.Type[] types = SoftwareBundle.Type.values();
        if (this.infomanSoftwareArchiveManager.hasInfomanBundles() && (Device.DeviceType.INFOMAN.equals((Object)deviceType) || Device.DeviceType.ANY.equals((Object)deviceType) || Device.DeviceType.UNKNOWN.equals((Object)deviceType))) {
            BundleGroupItem infomanBundlesRootItem = new BundleGroupItem(NbBundle.getMessage(SoftwareBundleNavigationManager.class, (String)"SoftwareBundleNavigationManager.infomanRootNode.name"), (NavigationItem)bundleArchiveItem);
            for (SoftwareBundle.Type type : types) {
                bundles = this.infomanSoftwareArchiveManager.getInfomanBundles(type);
                if (bundles.isEmpty()) continue;
                item = new BundleGroupItem(type.toString(), (NavigationItem)infomanBundlesRootItem);
                for (AbstractSoftwareBundle bundle : bundles) {
                    bundleNavItem = bundle.getBundleNavigation(acceptedTypes);
                    bundleNavItem.setParent((NavigationItem)item);
                }
            }
        }
        if (this.infomanSoftwareArchiveManager.hasInfomanEFMBundles() && (Device.DeviceType.INFOMAN_EFM.equals((Object)deviceType) || Device.DeviceType.ANY.equals((Object)deviceType) || Device.DeviceType.UNKNOWN.equals((Object)deviceType))) {
            BundleGroupItem infomanEFMBundlesRootItem = new BundleGroupItem(NbBundle.getMessage(SoftwareBundleNavigationManager.class, (String)"SoftwareBundleNavigationManager.infomanEFMRootNode.name"), (NavigationItem)bundleArchiveItem);
            for (SoftwareBundle.Type type : types) {
                bundles = this.infomanSoftwareArchiveManager.getInfomanEFMBundles(type);
                if (bundles.isEmpty()) continue;
                item = new BundleGroupItem(type.toString(), (NavigationItem)infomanEFMBundlesRootItem);
                for (AbstractSoftwareBundle bundle : bundles) {
                    bundleNavItem = bundle.getBundleNavigation(acceptedTypes);
                    bundleNavItem.setParent((NavigationItem)item);
                }
            }
        }
        if (this.infomanSoftwareArchiveManager.hasNoMoBundles() && (Device.DeviceType.NOMO.equals((Object)deviceType) || Device.DeviceType.ANY.equals((Object)deviceType) || Device.DeviceType.UNKNOWN.equals((Object)deviceType))) {
            BundleGroupItem nomoBundlesRootItem = new BundleGroupItem(NbBundle.getMessage(SoftwareBundleNavigationManager.class, (String)"SoftwareBundleNavigationManager.nomoRootNode.name"), (NavigationItem)bundleArchiveItem);
            for (SoftwareBundle.Type type : types) {
                bundles = this.infomanSoftwareArchiveManager.getNoMoBundles(type);
                if (bundles.isEmpty()) continue;
                item = new BundleGroupItem(type.toString(), (NavigationItem)nomoBundlesRootItem);
                for (AbstractSoftwareBundle bundle : bundles) {
                    bundleNavItem = bundle.getBundleNavigation(acceptedTypes);
                    bundleNavItem.setParent((NavigationItem)item);
                }
            }
        }
    }
}

