/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl.config;

import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.software.archive.api.ConfigurationUpdate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class KeyReplacementUpdate
implements ConfigurationUpdate {
    @Override
    public void updateConfiguration(SoftwareBundle infomanSoftwareBundle, Properties configuration) {
        Properties keyReplacements = this.loadKeyReplacements(infomanSoftwareBundle);
        if (keyReplacements != null) {
            for (Object key : keyReplacements.keySet()) {
                String value = configuration.getProperty((String)key);
                if (value == null) continue;
                configuration.remove(key);
                String newKey = keyReplacements.getProperty((String)key);
                configuration.setProperty(newKey, value);
            }
        }
    }

    protected Properties loadKeyReplacements(SoftwareBundle infomanSoftwareBundle) {
        InputStream in = null;
        try {
            in = infomanSoftwareBundle.getResource("updateKeyReplace.properties");
            if (in != null) {
                Properties keyReplacements = new Properties();
                keyReplacements.load(in);
                Properties properties = keyReplacements;
                return properties;
            }
            Properties keyReplacements = null;
            return keyReplacements;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }
}

