/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.impl;

import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.core.gui.util.NotificationUtil;
import de.proveo.idm.software.archive.impl.BundleExtractor;
import de.proveo.idm.software.archive.impl.nav.SoftwareBundleNavigationManager;
import de.proveo.idm.software.archive.util.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BundleDownloader
extends SwingWorker<File, Void>
implements Cancellable {
    public static final String FOLDER_SOFTWARE_ARCHIVES = "SoftwareArchive";
    private static final Logger log = Logger.getLogger(BundleDownloader.class.getName());
    private static final int MAX_BUFFER_SIZE = 1024;
    private final String handleName = NbBundle.getMessage(BundleDownloader.class, (String)"BundleDownloader.progress.fetching");
    private final String handleProgressName = NbBundle.getMessage(BundleDownloader.class, (String)"BundleDownloader.progress.downloading");
    private ProgressHandle handle = null;
    private BundleExtractor extractor = null;
    private Exception pendingException = null;
    private String bundleName = null;
    private File extractTo = null;
    private File downloadTo = null;
    private boolean cancel = false;
    private SoftwareBundle bundle;

    public BundleDownloader(SoftwareBundle bundle) {
        this.bundle = bundle;
        this.bundleName = this.bundle.getFilename();
        String tmpArchiveFilenamePrefix = "infomanBundle-";
        String[] bundleNameSplitted = StringUtils.split((String)this.bundleName, (String)"-");
        if (bundleNameSplitted.length != 0) {
            tmpArchiveFilenamePrefix = bundleNameSplitted[0] + "-";
        }
        this.downloadTo = new File(FileUtil.getResourcesDirectoryPath(), FOLDER_SOFTWARE_ARCHIVES + File.separator + this.bundleName);
        this.extractTo = new File(FileUtil.getResourcesDirectoryPath(), FOLDER_SOFTWARE_ARCHIVES + File.separator + tmpArchiveFilenamePrefix + this.bundle.getVersion());
        this.handle = ProgressHandleFactory.createHandle((String)(this.handleName + " " + this.bundleName + " ..."), (Cancellable)this);
        this.handle.start();
        this.handle.switchToIndeterminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        this.cancel = true;
        boolean ret = false;
        boolean startedExtraction = false;
        try {
            if (this.extractor != null) {
                startedExtraction = true;
                boolean bl = this.cancel = !this.extractor.isFinished();
                if (this.cancel) {
                    this.extractor.cancel();
                }
            }
            if (this.cancel) {
                ret = super.cancel(false);
                NotificationUtil.notifyWarn((String)NbBundle.getMessage(BundleExtractor.class, (String)"BundleDownloader.canceled.title", (Object)this.bundleName), (String)NbBundle.getMessage(BundleExtractor.class, (String)"BundleDownloader.canceled.message", (Object)this.bundleName));
            }
        }
        finally {
            if (this.cancel) {
                if (this.downloadTo != null && this.downloadTo.exists()) {
                    try {
                        FileUtils.forceDelete((File)this.downloadTo);
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "Could not delete file {0}", this.downloadTo.getAbsolutePath());
                    }
                }
                if (startedExtraction && this.extractTo != null && this.extractTo.exists()) {
                    try {
                        FileUtils.forceDelete((File)this.extractTo);
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "Could not delete file {0}", this.extractTo.getAbsolutePath());
                    }
                }
                this.handle.finish();
            }
        }
        return ret;
    }

    @Override
    protected File doInBackground() {
        try {
            File downloaded;
            if (this.downloadTo.exists()) {
                try {
                    if (this.checkChecksum(this.downloadTo, this.bundle.getBundleArchiveMD5Sum())) {
                        log.log(Level.INFO, "{0}: checksum still the same, no need to reload the bundle again", this.bundleName);
                        return this.downloadTo;
                    }
                    log.log(Level.WARNING, "{0}: checksum wrong, reload the bundle again ...", this.bundleName);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                try {
                    FileUtils.forceDelete((File)this.downloadTo);
                }
                catch (IOException ex) {
                    log.log(Level.WARNING, "Could not delete previous temporary file: {0}", this.downloadTo.getAbsolutePath());
                }
            } else {
                log.log(Level.WARNING, "{0}: bundle file not found ({1}), download ...", new Object[]{this.bundleName, this.downloadTo.getAbsolutePath()});
            }
            FileUtils.forceMkdir((File)this.downloadTo.getParentFile());
            if (!this.downloadTo.createNewFile()) {
                log.log(Level.WARNING, "Could not create temporary file ''{0}'', file will be overwritten ...", this.downloadTo.getAbsolutePath());
            }
            if ((downloaded = this.downloadBundle(this.downloadTo)) != null && !this.cancel) {
                if (!this.checkChecksum(downloaded, this.bundle.getBundleArchiveMD5Sum())) {
                    log.log(Level.SEVERE, "{0}: download failed, checksum wrong!", this.bundleName);
                    this.showDownloadFailedMsg();
                    return null;
                }
            } else {
                if (this.cancel) {
                    return null;
                }
                this.showDownloadFailedMsg();
                return null;
            }
            if (this.extractTo != null && this.extractTo.exists()) {
                try {
                    FileUtils.forceDelete((File)this.extractTo);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Could not delete bundle extraction folder: {0}", this.extractTo.getAbsolutePath());
                }
            }
            return downloaded;
        }
        catch (Exception ex) {
            this.pendingException = ex;
            this.showDownloadFailedMsg();
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private File downloadBundle(File downloadTo) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkChecksum(File checkFile, File md5sumFile) throws Exception {
        boolean ret;
        if (checkFile == null || md5sumFile == null) {
            return false;
        }
        String md5sum = this.getMD5Checksum(checkFile);
        String orgMd5sum = FileUtils.readFileToString((File)md5sumFile).trim();
        String[] orgMd5sumParts = StringUtils.split((String)orgMd5sum);
        if (orgMd5sumParts.length > 0) {
            orgMd5sum = orgMd5sumParts[0];
        }
        if (!(ret = orgMd5sum.equals(md5sum))) {
            log.log(Level.INFO, "Checksum mismatch: bundled MD5={0} calculated MD5={1}", new Object[]{orgMd5sum, md5sum});
        }
        return ret;
    }

    private void showDownloadFailedMsg() {
        NotificationUtil.notifyError((String)NbBundle.getMessage(BundleDownloader.class, (String)"BundleDownloader.download.failed.title", (Object)this.bundle.getVersion()), (String)NbBundle.getMessage(BundleDownloader.class, (String)"BundleDownloader.download.failed", (Object)this.bundle.getVersion()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        block9: {
            if (this.pendingException != null) {
                this.handle.finish();
                Exceptions.printStackTrace((Throwable)this.pendingException);
            } else {
                try {
                    File downloadedArchive = (File)this.get();
                    if (downloadedArchive != null) {
                        this.extractor = new BundleExtractor(this.handle, this.bundle, downloadedArchive, this.extractTo);
                        Thread thread = new Thread((Runnable)this.extractor, "BundleExtractor");
                        thread.start();
                        break block9;
                    }
                    try {
                        this.bundle.setExtractedDirectory(this.extractTo);
                    }
                    finally {
                        this.handle.finish();
                    }
                    this.updateTree();
                }
                catch (CancellationException ex) {
                    this.updateTree();
                }
                catch (Exception ex) {
                    this.updateTree();
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void updateTree() {
        SoftwareBundleNavigationManager navigationItemManager = (SoftwareBundleNavigationManager)Lookup.getDefault().lookup(SoftwareBundleNavigationManager.class);
        navigationItemManager.update();
    }

    private URLConnection getConnection(String bundleUrl) throws Exception {
        int start = 0;
        int end = StringUtils.indexOf((String)bundleUrl, (String)"://");
        String protocol = StringUtils.substring((String)bundleUrl, (int)start, (int)end);
        start = end + 3;
        end = StringUtils.indexOf((String)bundleUrl, (String)"/", (int)start);
        String host = StringUtils.substring((String)bundleUrl, (int)start, (int)end);
        int port = 80;
        if (protocol.equalsIgnoreCase("https")) {
            port = 443;
        }
        if (StringUtils.indexOf((String)bundleUrl, (String)":", (int)start) != -1) {
            end = StringUtils.indexOf((String)bundleUrl, (String)":", (int)start);
            host = StringUtils.substring((String)bundleUrl, (int)start, (int)end);
            start = end + 1;
            end = StringUtils.indexOf((String)bundleUrl, (String)"/", (int)start);
            String portString = StringUtils.substring((String)bundleUrl, (int)start, (int)end);
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException ex) {
                log.log(Level.SEVERE, "Found port '" + portString + "' in bundle url but could not be parsed to int?!", ex);
            }
        }
        start = end;
        String path = StringUtils.substring((String)bundleUrl, (int)start);
        URL url = new URL(protocol, host, port, path);
        return url.openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createChecksum(File file) throws Exception {
        RandomAccessFile raf = null;
        FileChannel roChannel = null;
        MessageDigest md = MessageDigest.getInstance("MD5");
        try {
            raf = new RandomAccessFile(file, "r");
            roChannel = raf.getChannel();
            MappedByteBuffer roBuf = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
            md.update(roBuf);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(roChannel);
            IOUtils.closeQuietly((Closeable)raf);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)roChannel);
        IOUtils.closeQuietly((Closeable)raf);
        return md.digest();
    }

    private String getMD5Checksum(File file) throws Exception {
        String result = "";
        byte[] b = this.createChecksum(file);
        if (b != null) {
            for (int i = 0; i < b.length; ++i) {
                result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            }
        }
        return result;
    }
}

