/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.api.gui;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.software.archive.api.Resource;
import de.proveo.idm.software.archive.impl.ResourceImpl;
import de.proveo.idm.software.archive.impl.nav.resourceselect.ResourceSelectorPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JButton;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ResourceSelectorDialog
extends MouseAdapter {
    public static final String FILE_CHANGED = "fileChanged";
    public static final String FILE_VALID = "fileValid";
    private JButton okButton = null;
    private JButton cancelButton = null;
    private ResourceSelectorPanel panel = null;
    private DialogDescriptor dd = null;
    private boolean canceled = false;
    private Device.DeviceType deviceType;
    private Resource.ResourceType[] acceptedTypes;

    public ResourceSelectorDialog(Device.DeviceType deviceType, Resource.ResourceType ... acceptedTypes) {
        this.deviceType = deviceType;
        this.acceptedTypes = acceptedTypes;
        this.okButton = new JButton(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.button.ok"));
        this.cancelButton = new JButton(NbBundle.getMessage(ResourceSelectorDialog.class, (String)"ResourceSelector.button.cancel"));
        this.panel = new ResourceSelectorPanel(this.deviceType, this.acceptedTypes);
        this.panel.addMouseListenerToBeanTreeView(this);
        String title = NbBundle.getMessage(ResourceSelectorDialog.class, (String)"Title_ResourceSelectorDialog");
        Object[] options = new Object[]{this.okButton, this.cancelButton};
        this.dd = DialogUtil.createDialogDescriptor((Object)this.panel, (String)title, (boolean)true, (int)-1, (Object[])options);
        this.dd.setHelpCtx(HelpCtx.DEFAULT_HELP);
        this.dd.setClosingOptions(options);
    }

    public Resource selectResource(File currentSelected) {
        Object result;
        this.canceled = false;
        if (currentSelected != null && currentSelected.exists()) {
            ResourceImpl resource = new ResourceImpl(currentSelected, null, this.acceptedTypes[0], null);
            this.panel.setSelectedResource(resource);
        }
        if (this.okButton.equals(result = DialogUtil.showDialogDescriptor((DialogDescriptor)this.dd))) {
            return this.panel.getSelectedResource();
        }
        this.canceled = true;
        return null;
    }

    public Resource findResourceByFile(File file) {
        return this.panel.findResourceByFile(file);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.panel.getSelectedResource() != null) {
            this.okButton.doClick();
        }
    }
}

