/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive.api;

import de.proveo.idm.core.gui.navigation.api.InfomanConfigurationSyntax;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.software.archive.api.AbstractSoftwareBundle;
import de.proveo.idm.software.archive.api.InfomanResourceNavigationItem;
import de.proveo.idm.software.archive.api.Resource;
import de.proveo.idm.software.archive.impl.ResourceImpl;
import de.proveo.idm.software.archive.impl.nav.BundleGroupItem;
import java.io.File;
import java.util.MissingResourceException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class AbstractNoMoSoftwareBundle
extends AbstractSoftwareBundle {
    public AbstractNoMoSoftwareBundle(Class clazz) {
        super(clazz);
    }

    @Override
    protected BundleGroupItem buildNavigationForSubfolder(File folder, Resource.ResourceType ... allowedResourceTypes) {
        Resource.ResourceType resType;
        if (allowedResourceTypes == null || allowedResourceTypes.length == 0) {
            allowedResourceTypes = Resource.ResourceType.values();
        }
        String name = folder.getName();
        String description = "";
        try {
            resType = Resource.ResourceType.valueOf(folder.getName());
        }
        catch (Exception ex) {
            resType = null;
        }
        if (resType != null) {
            try {
                name = NbBundle.getMessage(AbstractSoftwareBundle.class, (String)("AbstractSoftwareBundle.node." + resType.toString() + ".name"));
            }
            catch (MissingResourceException ex) {
                name = resType.toString();
            }
            try {
                description = NbBundle.getMessage(AbstractSoftwareBundle.class, (String)("AbstractSoftwareBundle.node." + resType.toString() + ".description"));
            }
            catch (MissingResourceException ex) {
                description = "";
            }
        }
        BundleGroupItem typeItem = new BundleGroupItem(name, description, null);
        File[] files = folder.listFiles(this.getFileFilter(resType));
        if (files != null) {
            for (File file : files) {
                BundleGroupItem childGroupItem;
                if (!file.isDirectory() && resType != null && ArrayUtils.contains((Object[])allowedResourceTypes, (Object)((Object)resType))) {
                    File newFile = this.getOverriddenFile(file, resType.toString());
                    if (newFile == null) {
                        newFile = file;
                    }
                    ResourceImpl resource = new ResourceImpl(newFile, this, resType, this.getVersion());
                    InfomanResourceNavigationItem item = new InfomanResourceNavigationItem(resource, (NavigationItem)typeItem);
                    if (Resource.ResourceType.NOMO_FIRMWARE.equals((Object)resType)) {
                        item.setActionPath("Actions/Bundle/Resources/NoMoFirmware");
                    }
                    item.setIconBaseWithExtension(this.getIconBaseWithExtension(resType));
                    continue;
                }
                if (!file.isDirectory() || (childGroupItem = this.buildNavigationForSubfolder(file, allowedResourceTypes)) == null) continue;
                typeItem.addChild((NavigationItem)childGroupItem);
            }
        }
        if (typeItem.getChildren().isEmpty()) {
            typeItem = null;
        }
        return typeItem;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx("de.proveo.nomo.version" + StringUtils.replace((String)this.getVersion(), (String)".", (String)"_") + ".about");
    }

    public InfomanConfigurationSyntax getConfigurationSyntax() {
        return new AbstractSoftwareBundle.InfomanConfigurationSyntaxImpl(this, this, null, "de.proveo.nomo.version");
    }
}

