/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.software.archive;

import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationNodeFactory;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationNodeFactoryManager;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.software.archive.api.InfomanResourceNavigationItem;
import de.proveo.idm.software.archive.api.InfomanSoftwareArchiveManager;
import de.proveo.idm.software.archive.impl.nav.BundleNavigationItem;
import de.proveo.idm.software.archive.impl.nav.InfomanBundleNodeFactory;
import de.proveo.idm.software.archive.impl.nav.SoftwareBundleNavigationManager;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.Icon;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.netbeans.core.ProxySettings;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.NetworkSettings;

public class Installer
extends ModuleInstall {
    private static final Logger log = Logger.getLogger(Installer.class.getName());

    public void restored() {
        Installer.disableCertificateValidation();
        NavigationNodeFactoryManager nodeFactoryManager = (NavigationNodeFactoryManager)Lookup.getDefault().lookup(NavigationNodeFactoryManager.class);
        InfomanBundleNodeFactory nodeFactory = new InfomanBundleNodeFactory();
        nodeFactoryManager.register(BundleNavigationItem.class, (NavigationNodeFactory)nodeFactory);
        nodeFactoryManager.register(InfomanResourceNavigationItem.class, (NavigationNodeFactory)nodeFactory);
        InfomanSoftwareArchiveManager archiveManager = (InfomanSoftwareArchiveManager)Lookup.getDefault().lookup(InfomanSoftwareArchiveManager.class);
        archiveManager.update();
        SoftwareBundleNavigationManager navigationItemManager = (SoftwareBundleNavigationManager)Lookup.getDefault().lookup(SoftwareBundleNavigationManager.class);
        navigationItemManager.init();
        super.restored();
    }

    public void uninstalled() {
        super.uninstalled();
        NavigationNodeFactoryManager nodeFactoryManager = (NavigationNodeFactoryManager)Lookup.getDefault().lookup(NavigationNodeFactoryManager.class);
        nodeFactoryManager.deregister(BundleNavigationItem.class);
        nodeFactoryManager.deregister(InfomanResourceNavigationItem.class);
    }

    private static void disableCertificateValidation() {
        Authenticator.setDefault(new IDMAuthenticator());
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            log.info("Installed the all-trusting trust manager");
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private static class IDMAuthenticator
    extends Authenticator {
        private static final long TIMEOUT = 3000L;
        private static long lastTry = 0L;

        private IDMAuthenticator() {
        }

        private PasswordAuthentication getAuthenticationFromURL() {
            String auth;
            URL u = this.getRequestingURL();
            if (u != null && (auth = u.getUserInfo()) != null) {
                int i = auth.indexOf(58);
                String user = i == -1 ? auth : auth.substring(0, i);
                String pwd = i == -1 ? "" : auth.substring(i + 1);
                return new PasswordAuthentication(user, pwd.toCharArray());
            }
            return null;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            if (Authenticator.RequestorType.PROXY == this.getRequestorType() && ProxySettings.useAuthentication()) {
                Logger.getLogger(IDMAuthenticator.class.getName()).log(Level.FINER, "Username set to {0} while request {1}", new Object[]{ProxySettings.getAuthenticationUsername(), this.getRequestingURL()});
                return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
            }
            if (System.currentTimeMillis() - lastTry > 3000L) {
                Credentials cred;
                if (this.getRequestingProtocol().startsWith("SOCKS") && ProxySettings.getAuthenticationUsername().length() > 0) {
                    return new PasswordAuthentication(ProxySettings.getAuthenticationUsername(), ProxySettings.getAuthenticationPassword());
                }
                if (NetworkSettings.isAuthenticationDialogSuppressed()) {
                    return null;
                }
                PasswordAuthentication auth = this.getAuthenticationFromURL();
                if (auth != null) {
                    return auth;
                }
                Preferences prefs = NbPreferences.forModule(IDMAuthenticator.class);
                String propKey = this.getRequestingProtocol() + ".auth." + this.getRequestingHost() + ":" + this.getRequestingPort();
                String username = prefs.get(propKey + ".username", "");
                String title = NbBundle.getMessage(IDMAuthenticator.class, (String)"Installer.login.title");
                if (Authenticator.RequestorType.PROXY.equals((Object)this.getRequestorType())) {
                    title = NbBundle.getMessage(IDMAuthenticator.class, (String)"Installer.login.title.proxy") + " " + StringUtils.lowerCase((String)title);
                }
                if ((cred = DialogUtil.showLoginDialog((String)this.getRequestingPrompt(), (String)title, (String)(propKey + ".%s"), (String)username, (Icon)DialogUtil.DEFAULT_LOGIN_IMAGE_LEFT, (Icon)DialogUtil.DEFAULT_LOGIN_IMAGE_RIGHT)) != null) {
                    prefs.put(propKey + ".username", cred.getUsername());
                    try {
                        prefs.flush();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(IDMAuthenticator.class.getName()).log(Level.WARNING, "Could not save username for host " + this.getRequestingProtocol() + "://" + this.getRequestingHost() + ":" + this.getRequestingPort(), ex);
                    }
                    lastTry = 0L;
                    return new PasswordAuthentication(cred.getUsername(), ArrayUtils.clone((char[])cred.getPassword()));
                }
                lastTry = System.currentTimeMillis();
            }
            Logger.getLogger(IDMAuthenticator.class.getName()).log(Level.WARNING, "No authentication set while requesting {0}", this.getRequestingURL());
            return null;
        }
    }
}

